/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.GUI;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HelpGUI {
    private JPanel pref;
    private int gridy = 0;

    protected void setPanel(JPanel pref_) {
        this.pref = pref_;
    }

    protected void setHelpTitle(String title) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = this.gridy++;
        c.gridwidth = 2;
        this.pref.add((Component)new JLabel("<html><h1> " + title + " </h1></html>"), c);
    }

    protected void createArticle(String link) {
        if (link == null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = this.gridy++;
        c.anchor = 10;
        this.pref.add((Component)new JLabel("<html>Article: </html>"), c);
        c.gridx = 1;
        c.anchor = 17;
        JButton button = this.createLinkButton("<html><font color=\"blue\">click here</font></hmtl>", link);
        this.pref.add((Component)button, c);
    }

    protected void createTutorial(String link) {
        if (link == null) {
            return;
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = this.gridy++;
        c.gridwidth = 1;
        this.pref.add((Component)new JLabel("<html>Tutorial: </html>"), c);
        c.gridx = 1;
        c.anchor = 17;
        JButton button = this.createLinkButton("<html><font color=\"blue\">click here</font></hmtl>", link);
        this.pref.add((Component)button, c);
    }

    protected void createSection(String sc, String link) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = this.gridy;
        if (link == null) {
            c.gridwidth = 2;
            this.pref.add((Component)new JLabel("<html><h1> " + sc + " </h1>"), c);
        } else {
            c.gridwidth = 1;
            this.pref.add((Component)new JLabel("<html><h1> " + sc + " </h1>"), c);
            c.gridx = 1;
            JButton button = this.createLinkButton("<html><font color=\"blue\">more info</font></hmtl>", link);
            this.pref.add((Component)button, c);
        }
        ++this.gridy;
    }

    protected void createField(String fld, String desc, String link) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = this.gridy++;
        c.gridwidth = 2;
        this.pref.add((Component)new JLabel("<html><h2> <font color=\"red\"> " + fld + " </font></h2><div style=\"width:400px\">" + desc + "</div>"), c);
        if (link != null) {
            c.gridx = 0;
            c.gridy = this.gridy;
            c.gridwidth = 2;
            JButton button = this.createLinkButton("<html><font color=\"blue\">more info</font></hmtl>", link);
            this.pref.add((Component)button, c);
        }
        ++this.gridy;
    }

    private JButton createLinkButton(String buttonStr, final String link) {
        JButton button = new JButton(buttonStr);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setBackground(Color.GRAY);
        button.setToolTipText(link);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                HelpGUI.open(link);
            }
        });
        return button;
    }

    protected static void open(String aUriString) {
        try {
            HelpGUI.open(new URI(aUriString));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

