/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.cluster;

import ij.IJ;
import ij.Macro;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import mosaic.core.cluster.ClusterProfile;
import mosaic.core.cluster.ClusterSession;
import mosaic.core.cluster.FileClusterProfile;
import mosaic.core.cluster.JenkinsTestProfile;
import mosaic.core.cluster.MadMaxProfile;
import mosaic.core.utils.MosaicUtils;
import mosaic.core.utils.ShellCommand;
import mosaic.utils.SysOps;

public class ClusterGUI
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPane;
    ClusterProfile cp_sel;
    protected ClusterSession cl;
    protected final JTextField tx_u;
    protected final JPasswordField tx_p;
    private final JTextField tx_e;
    ClusterProfile[] cp = null;
    private final float estimated_time = 0.0f;

    public ClusterGUI() {
        this.setBounds(100, 100, 350, 150);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new GridLayout(0, 2, 0, 0));
        JLabel lblNewLabel = new JLabel("Cluster profile: ");
        this.contentPane.add(lblNewLabel);
        String dir = IJ.getDirectory((String)"home");
        dir = dir + File.separator + ".MosaicToolSuite" + File.separator + "clusterProfile";
        File[] cpf = new File(dir).listFiles();
        if (cpf != null) {
            this.cp = new ClusterProfile[cpf.length + 2];
            int cnt = 0;
            for (File tcpf : cpf) {
                this.cp[cnt] = new FileClusterProfile(tcpf);
                ++cnt;
            }
        } else {
            this.cp = new ClusterProfile[2];
        }
        this.cp[this.cp.length - 2] = new MadMaxProfile();
        this.cp[this.cp.length - 1] = new JenkinsTestProfile();
        this.cp_sel = this.cp[this.cp.length - 1];
        String[] CBcp = new String[this.cp.length];
        for (int i = 0; i < this.cp.length; ++i) {
            CBcp[i] = new String(this.cp[i].getProfileName());
        }
        final JComboBox<String> comboBox_1 = new JComboBox<String>(CBcp);
        comboBox_1.setSelectedIndex(this.cp.length - 1);
        comboBox_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getSource() == comboBox_1) {
                    ClusterGUI.this.cp_sel = ClusterGUI.this.cp[comboBox_1.getSelectedIndex()];
                }
            }
        });
        this.contentPane.add(comboBox_1);
        JLabel lblNewLabel_2 = new JLabel("Username");
        this.contentPane.add(lblNewLabel_2);
        this.tx_u = new JTextField(SysOps.getSystemUsername());
        this.contentPane.add(this.tx_u);
        lblNewLabel_2 = new JLabel("Password");
        this.contentPane.add(lblNewLabel_2);
        this.tx_p = new JPasswordField();
        this.contentPane.add(this.tx_p);
        lblNewLabel_2 = new JLabel("Estimated time (minutes)");
        this.contentPane.add(lblNewLabel_2);
        this.tx_e = new JTextField("0.0");
        this.contentPane.add(this.tx_e);
        JButton btnOKButton = new JButton("OK");
        this.contentPane.add(btnOKButton);
        btnOKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ClusterGUI.this.cp_sel.setPassword(new String(ClusterGUI.this.tx_p.getPassword()));
                ClusterGUI.this.cp_sel.setUsername(new String(ClusterGUI.this.tx_u.getText()));
                ClusterGUI.this.cl = new ClusterSession(ClusterGUI.this.cp_sel);
                ClusterGUI.this.dispose();
            }
        });
        JButton btnCancelButton = new JButton("Cancel");
        btnCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ClusterGUI.this.cl = null;
                ClusterGUI.this.dispose();
            }
        });
        this.contentPane.add(btnCancelButton);
        String test_set = MosaicUtils.parseString("username", Macro.getOptions());
        if (test_set != null && test_set.length() != 0) {
            this.cp_sel.setUsername(MosaicUtils.parseString("username", Macro.getOptions()));
            this.cp_sel.setPassword(MosaicUtils.parseString("password", Macro.getOptions()));
            this.cl = new ClusterSession(this.cp_sel);
            this.dispose();
        } else {
            this.setModal(true);
            this.setVisible(true);
        }
    }

    float getEstimatedTime() {
        return 0.0f;
    }

    public ClusterSession getClusterSession() {
        return this.cl;
    }

    public static ClusterProfile[] getClusterProfiles() {
        return ClusterGUI.getClusterProfiles(0);
    }

    private static ClusterProfile[] getClusterProfiles(int s) {
        String dir = ClusterGUI.getClusterProfileDir();
        File[] cpf = new File(dir).listFiles();
        if (cpf == null) {
            return new ClusterProfile[s];
        }
        ClusterProfile[] cp = new ClusterProfile[cpf.length + s];
        int cnt = 0;
        for (File tcpf : cpf) {
            cp[cnt] = new FileClusterProfile(tcpf);
            ++cnt;
        }
        return cp;
    }

    public static void createClusterProfileDir() {
        if (new File(ClusterGUI.getClusterProfileDir()).exists()) {
            return;
        }
        String dir = IJ.getDirectory((String)"home") + File.separator + ".MosaicToolSuite";
        try {
            ShellCommand.exeCmd("mkdir " + dir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        dir = dir + File.separator + "clusterProfile";
        try {
            ShellCommand.exeCmd("mkdir " + dir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String getClusterProfileDir() {
        String dir = IJ.getDirectory((String)"home");
        dir = dir + File.separator + ".MosaicToolSuite" + File.separator + "clusterProfile";
        return dir;
    }
}

