/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.cluster;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ij.io.Opener;
import ij.process.StackStatistics;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mosaic.core.GUI.ProgressBarWin;
import mosaic.core.cluster.BatchInterface;
import mosaic.core.cluster.ClusterGUI;
import mosaic.core.cluster.ClusterProfile;
import mosaic.core.cluster.ClusterStatusStack;
import mosaic.core.cluster.JobStatus;
import mosaic.core.cluster.SecureShellSession;
import mosaic.core.utils.ChooseGUI;
import mosaic.core.utils.MosaicUtils;
import mosaic.core.utils.ShellCommand;
import mosaic.utils.SysOps;
import org.apache.log4j.Logger;

public class ClusterSession {
    private static final Logger logger = Logger.getLogger(ClusterSession.class);
    public static final String DefaultInputParameterName = "input";
    public static final String DefaultSettingsFileName = SysOps.getTmpPath() + "settings.dat";
    public static final String DefaultJsonSettingsFileName = SysOps.getTmpPath() + "settings.json";
    private int nImages;
    private final ClusterProfile cp;
    private SecureShellSession ss;
    private int ns_pp = ns_pp_preferred;
    private static int ns_pp_preferred = 1;
    private String iInputParameterName = "input";

    ClusterSession(ClusterProfile cp_) {
        this.cp = cp_;
    }

    public static void setPreferredSlotPerProcess(int ns_pp) {
        ns_pp_preferred = ns_pp;
    }

    public void setSlotPerProcess(int ns_pp) {
        this.ns_pp = ns_pp;
    }

    public void setInputParameterName(String aInputParamName) {
        this.iInputParameterName = aInputParamName;
    }

    public String getInputParameterName() {
        return this.iInputParameterName;
    }

    private void CleanUp() {
    }

    public boolean splitAndUpload(ImagePlus img, File dir, ProgressBarWin wp) {
        if (this.ss == null) {
            this.ss = new SecureShellSession(this.cp);
        }
        if (img == null) {
            this.nImages = 0;
            return true;
        }
        boolean dispose = false;
        if (wp == null) {
            wp = new ProgressBarWin();
            dispose = true;
        }
        this.nImages = img.getNFrames();
        String tmp_dir = IJ.getDirectory((String)"temp");
        wp.SetStatusMessage("Preparing data...");
        ImageStack stk = img.getStack();
        int stack_size = stk.getSize() / this.nImages;
        for (int i = 0; i < this.nImages; ++i) {
            ImageStack tmp_stk = new ImageStack(img.getWidth(), img.getHeight());
            for (int j = 0; j < stack_size; ++j) {
                tmp_stk.addSlice("st" + j, stk.getProcessor(i * stack_size + j + 1));
            }
            ImagePlus ip = new ImagePlus("tmp", tmp_stk);
            IJ.saveAs((ImagePlus)ip, (String)"Tiff", (String)(tmp_dir + "tmp_" + (i + 1)));
            wp.SetProgress(100 * i / this.nImages);
        }
        BatchInterface bc = this.cp.getBatchSystem();
        this.ss.setShellProcessOutput(bc);
        File[] fl = new File[this.nImages];
        for (int i = 0; i < this.nImages; ++i) {
            fl[i] = new File(tmp_dir + "tmp_" + (i + 1) + ".tif");
        }
        wp.SetProgress(0);
        wp.SetStatusMessage("Uploading...");
        if (!this.ss.upload(fl, dir, wp, this.cp)) {
            this.CleanUp();
            return false;
        }
        if (dispose) {
            wp.dispose();
        }
        return true;
    }

    private boolean createJobArrayFromImage(ImagePlus img, String command, String options, SecureShellSession ss, double Ext, ProgressBarWin wp) {
        if (img == null) {
            this.nImages = 0;
            return true;
        }
        if (!this.splitAndUpload(img, null, wp)) {
            return false;
        }
        BatchInterface bc = this.cp.getBatchSystem();
        String tmp_dir = SysOps.getTmpPath();
        boolean hasAllThingsInstalled = this.isAllSoftwareInstalled(ss, this.cp);
        if (!hasAllThingsInstalled) {
            wp.SetStatusMessage("Installing Fiji on cluster... ");
            ss.runCommands(new String[]{"rm -rf Fiji.app"});
            ss.runCommands(new String[]{"cd " + this.cp.getRunningDir(), "wget mosaic.mpi-cbg.de/Downloads/fiji-linux64.tar.gz", "tar -xf fiji-linux64.tar.gz", "cd Fiji.app", "cd plugins", "mkdir Mosaic_ToolSuite", "cd Mosaic_ToolSuite", "wget mosaic.mpi-cbg.de/Downloads/Mosaic_ToolSuite_for_cluster.jar"});
            do {
                try {
                    System.out.println("Expected directory: [" + this.cp.getRunningDir() + "Fiji.app]");
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("Checking Fiji installation");
            } while (!this.isAllSoftwareInstalled(ss, this.cp));
        }
        wp.SetStatusMessage("Interfacing with batch system...");
        File configFile = new File(DefaultJsonSettingsFileName).exists() ? new File(DefaultJsonSettingsFileName) : new File(DefaultSettingsFileName);
        String macro = new String("job_id = getArgument();\nif (job_id == \"\" )\n   exit(\"No job id\");\n\nrun(\"" + command + "\",\"config=" + ss.getTransfertDir() + configFile.getName() + " " + this.iInputParameterName + "=" + ss.getTransfertDir() + "tmp_\"+ job_id + \".tif " + options + " \" );\n");
        String run_s = this.cp.getRunningDir() + ss.getSession_id() + "/" + ss.getSession_id() + ".ijm";
        String scr = bc.getScript(run_s, ss.getSession_id(), Ext, this.nImages, this.ns_pp);
        if (scr != null) {
            try {
                PrintWriter out = new PrintWriter(tmp_dir + ss.getSession_id());
                out.println(scr);
                out.close();
                out = new PrintWriter(tmp_dir + ss.getSession_id() + ".ijm");
                out.println(macro);
                out.close();
                File[] fll = new File[]{new File(tmp_dir + ss.getSession_id()), configFile, new File(tmp_dir + ss.getSession_id() + ".ijm")};
                ss.upload(fll, null, null);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        wp.SetProgress(0);
        wp.SetStatusMessage("Running...");
        String[] commands = new String[]{new String("cd " + ss.getTransfertDir()), bc.runCommand(ss.getTransfertDir())};
        bc.setJobID(0);
        ss.runCommands(commands);
        for (int n_attempt = 0; bc.getJobID() == 0 && n_attempt < 300; ++n_attempt) {
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (bc.getJobID() == 0) {
            IJ.error((String)"Failed to run the Job on the cluster");
            this.CleanUp();
            return false;
        }
        try {
            PrintWriter out = new PrintWriter(tmp_dir + "JobID");
            String tmp = new String(command);
            tmp.replace(" ", "_");
            out.println(new String(bc.getJobID() + " " + this.nImages + " " + img.getTitle() + " " + command));
            out.close();
            File[] fll = new File[]{new File(tmp_dir + "JobID")};
            ss.upload(fll, null, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }

    private boolean isAllSoftwareInstalled(SecureShellSession aSession, ClusterProfile aProfile) {
        String fijiDir = aProfile.getRunningDir() + "Fiji.app";
        boolean hasFiji = aSession.checkDirectory(fijiDir);
        boolean hasLinuxExe = aSession.checkFile(fijiDir, "ImageJ-linux64");
        String mosaicPluginDir = fijiDir + File.separator + "plugins" + File.separator + "Mosaic_ToolSuite" + File.separator;
        boolean hasPlugin = aSession.checkFile(mosaicPluginDir, "Mosaic_ToolSuite.jar");
        boolean hasPluginForCluster = aSession.checkFile(mosaicPluginDir, "Mosaic_ToolSuite_for_cluster.jar");
        boolean hasNewPlugin = aSession.checkFile(mosaicPluginDir, "MosaicSuite-");
        return hasFiji && hasLinuxExe && (hasPluginForCluster || hasPlugin || hasNewPlugin);
    }

    public static String[] getJobDirectories(final int JobID, String directory) {
        File file = null;
        String tmp_dir_ = null;
        if (directory != null) {
            tmp_dir_ = directory.endsWith(File.separator) ? directory : directory + File.separator;
            file = new File(directory);
        } else {
            tmp_dir_ = IJ.getDirectory((String)"temp");
            file = new File(tmp_dir_);
        }
        final String tmp_dir = new File(tmp_dir_).getAbsolutePath();
        String[] directories = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File fp = new File(tmp_dir + File.separator + "Job[0-9]+");
                Pattern jobID = Pattern.compile(fp.getAbsolutePath().replace("\\", "\\\\"));
                File fpm = new File(dir + File.separator + name);
                Matcher matcher = jobID.matcher(fpm.getAbsolutePath());
                File f = new File(dir, name);
                if (f.isDirectory() && matcher.find()) {
                    if (JobID != 0) {
                        return f.getAbsolutePath().equals(tmp_dir + "Job" + JobID);
                    }
                    return true;
                }
                return false;
            }
        });
        if (directories == null) {
            return new String[0];
        }
        for (int i = 0; i < directories.length; ++i) {
            directories[i] = tmp_dir + File.separator + directories[i];
        }
        return directories;
    }

    private int CreateJobSelector(String[] directories) {
        int l;
        ChooseGUI cg = new ChooseGUI();
        String c = cg.chooseString("Job Selector", "Select a Job to visualize", directories);
        if (c == null) {
            return 0;
        }
        for (l = c.length() - 1; Character.isDigit(c.charAt(l)) && l >= 0; --l) {
        }
        return Integer.parseInt(c.substring(++l, c.length()));
    }

    private void stackVisualize(String[] output, int JobID, ProgressBarWin wp) {
        String[] directories = ClusterSession.getJobDirectories(JobID, null);
        if (JobID == 0 && (JobID = this.CreateJobSelector(directories)) == 0) {
            return;
        }
        GenericDialog gd = new GenericDialog("Job output selector:");
        for (int i = 0; i < output.length; ++i) {
            gd.addCheckbox(output[i], false);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        boolean[] cs = new boolean[output.length];
        for (int i = 0; i < output.length; ++i) {
            cs[i] = gd.getNextBoolean();
        }
        for (int j = 0; j < directories.length; ++j) {
            for (int i = 0; i < output.length; ++i) {
                ImagePlus ip;
                if (!cs[i] || !output[i].endsWith(".tiff") && !output[i].endsWith(".tif") && !output[i].endsWith(".zip")) continue;
                wp.SetStatusMessage("Visualizing " + output[i]);
                String dirName = directories[j] + File.separator + output[i].replace("*", "_");
                logger.debug((Object)("Listing files in: [" + dirName + "]"));
                File[] fl = new File(dirName).listFiles();
                if (fl == null) {
                    logger.error((Object)"Null file array");
                    continue;
                }
                int nf = fl.length;
                Opener op = new Opener();
                if (fl.length == 0 || (ip = op.openImage(fl[0].getAbsolutePath())) == null) continue;
                int nc = ip.getNChannels();
                int ns = ip.getNSlices();
                ip.close();
                IJ.run((String)"Image Sequence...", (String)("open=" + directories[j] + File.separator + output[i].replace("*", "_") + " starting=1 increment=1 scale=100 file=[] or=[] sort"));
                IJ.run((String)"Stack to Hyperstack...", (String)("order=xyczt(default) channels=" + nc + " slices=" + ns + " frames=" + nf + " display=Composite"));
            }
        }
    }

    private void reorganize(String[] output, int JobID) {
        String[] directories = ClusterSession.getJobDirectories(JobID, null);
        for (int i = 0; i < directories.length; ++i) {
            String[] s = MosaicUtils.readAndSplit(directories[i] + File.separator + "JobID");
            if (s == null) continue;
            int nf = Integer.parseInt(s[1]);
            String filename = s[2];
            int idp = filename.lastIndexOf(".");
            if (idp >= 0) {
                filename = filename.substring(0, idp);
            }
            MosaicUtils.reorganize(output, "tmp", filename, directories[i], nf);
        }
    }

    private void getData(String[] output, SecureShellSession ss, ProgressBarWin wp, BatchInterface bc) {
        String tmp_dir = IJ.getDirectory((String)"temp");
        File[] fldw = new File[bc.getNJobs() * output.length + 1];
        fldw[0] = new File(bc.getDir() + File.separator + "JobID");
        for (int i = 0; i < bc.getNJobs(); ++i) {
            for (int j = 0; j < output.length; ++j) {
                String tmp = new String(output[j]);
                fldw[i * output.length + j + 1] = new File(bc.getDir() + File.separator + tmp.replace("*", "tmp_" + (i + 1)));
            }
        }
        try {
            ShellCommand.exeCmdNoPrint("mkdir " + tmp_dir + File.separator + "Job" + bc.getJobID());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        wp.SetStatusMessage("Downloading...");
        ss.download(fldw, new File(tmp_dir + File.separator + "Job" + bc.getJobID()), wp, this.cp);
    }

    private boolean runPluginsOnFrames(ImagePlus img, String command, String options, String[] output, double ExtTime) {
        return this.runPluginsOnFrames(img, command, options, output, ExtTime, true);
    }

    public String getClusterDirectory() {
        if (this.ss == null) {
            return null;
        }
        return this.ss.getTransfertDir();
    }

    public void upload(File dir, File[] fl) {
        if (this.ss == null) {
            this.ss = new SecureShellSession(this.cp);
        }
        ProgressBarWin wp = new ProgressBarWin();
        this.ss.upload(fl, dir, wp, null);
    }

    public void upload(File[] fl) {
        if (this.ss == null) {
            this.ss = new SecureShellSession(this.cp);
        }
        ProgressBarWin wp = new ProgressBarWin();
        this.ss.upload(fl, wp, null);
    }

    private boolean runPluginsOnFrames(ImagePlus img, String command, String options, String[] output, double ExtTime, boolean sync) {
        ProgressBarWin wp;
        if (this.ss == null) {
            this.ss = new SecureShellSession(this.cp);
        }
        if (!this.createJobArrayFromImage(img, command, options, this.ss, ExtTime, wp = new ProgressBarWin())) {
            wp.SetStatusMessage("Failed to create job array");
            try {
                this.ss.close();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.ss = null;
            wp.dispose();
            return false;
        }
        if (!sync) {
            wp.dispose();
            try {
                this.ss.close();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.ss = null;
            return true;
        }
        BatchInterface bc = this.cp.getBatchSystem();
        wp.SetProgress(0);
        wp.SetStatusMessage("Getting all jobs ...");
        BatchInterface[] bcl = bc.getAllJobs(this.ss, command);
        if (bcl == null) {
            bcl = new BatchInterface[]{};
        }
        ClusterStatusStack[] css = new ClusterStatusStack[bcl.length];
        ImageStack[] st = new ImageStack[bcl.length];
        ImagePlus[] ip = new ImagePlus[bcl.length];
        for (int j = 0; j < bcl.length; ++j) {
            bcl[j].createJobStatus();
            css[j] = new ClusterStatusStack();
            st[j] = css[j].CreateStack(bcl[j].getJobStatus());
            ip[j] = new ImagePlus("Cluster status " + bcl[j].getJobID(), st[j]);
            ip[j].show();
            bcl[j].setJobStatus(bcl[j].getJobStatus());
        }
        wp.SetProgress(0);
        int n_bc = 0;
        while (n_bc < bcl.length) {
            double progress = 0.0;
            double total = 0.0;
            n_bc = 0;
            for (int j = 0; j < bcl.length; ++j) {
                if (bcl[j] == null) {
                    ++n_bc;
                    continue;
                }
                String[] commands = new String[]{bcl[j].statusJobCommand()};
                bcl[j].reset();
                this.ss.setShellProcessOutput(bcl[j]);
                this.ss.runCommands(commands);
                bcl[j].waitParsing();
                if (JobStatus.allComplete(bcl[j].getJobsStatus())) {
                    css[j].UpdateStack(st[j], bcl[j].getJobStatus());
                    ip[j].updateAndDraw();
                    this.getData(output, this.ss, wp, bcl[j]);
                    bcl[j].clean(this.ss);
                    wp.SetProgress(0);
                    wp.SetStatusMessage("Reorganize...");
                    this.reorganize(output, bcl[j].getJobID());
                    bcl[j] = null;
                    wp.SetStatusMessage("Computing ...");
                    int p = (int)(progress * 100.0 / total);
                    wp.SetProgress(p);
                    continue;
                }
                css[j].UpdateStack(st[j], bcl[j].getJobStatus());
                ip[j].updateAndDraw();
                progress += (double)JobStatus.countComplete(bcl[j].getJobsStatus());
                total += (double)bcl[j].getJobStatus().length;
            }
            wp.SetStatusMessage("Computing ...");
            int p = (int)(progress * 100.0 / total);
            wp.SetProgress(p);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < ip.length; ++i) {
            ip[i].close();
        }
        wp.SetProgress(0);
        wp.SetStatusMessage("Reorganize...");
        this.reorganize(output, 0);
        wp.SetProgress(0);
        wp.SetStatusMessage("Stack visualize...");
        this.stackVisualize(output, 0, wp);
        wp.SetStatusMessage("End");
        return true;
    }

    public static ClusterSession getFinishedJob(String[] out, String command, ClusterGUI cg) {
        return ClusterSession.processImage(null, command, null, out, cg, new Float(0.0), new Float(0.0), true);
    }

    public static ClusterSession getFinishedJob(String[] out, String command) {
        return ClusterSession.processImage(null, command, null, out, null, new Float(0.0), new Float(0.0), true);
    }

    public static ClusterSession processImage(ImagePlus aImp, String command, String options, String[] out, ClusterGUI cg) {
        return ClusterSession.processImage(aImp, command, options, out, cg, new Float(0.0), new Float(0.0), true);
    }

    public static ClusterSession processImage(ImagePlus aImp, String command, String options, String[] out) {
        return ClusterSession.processImage(aImp, command, options, out, null, new Float(0.0), new Float(0.0), true);
    }

    private static ClusterSession processImage(ImagePlus aImp, String command, String options, String[] out, ClusterGUI cg, Float max, Float min, boolean sync) {
        if (cg == null) {
            cg = new ClusterGUI();
        }
        ClusterSession ss = cg.getClusterSession();
        if ((double)max.floatValue() == 0.0 && aImp != null) {
            StackStatistics stack_stats = new StackStatistics(aImp);
            max = Float.valueOf((float)stack_stats.max);
            min = Float.valueOf((float)stack_stats.min);
        }
        if (!ss.runPluginsOnFrames(aImp, command, "min=" + min + " max=" + max + " " + options, out, cg.getEstimatedTime(), sync)) {
            return null;
        }
        return ss;
    }

    public static ClusterSession processFiles(File[] list, String command, String options, String[] out) {
        return ClusterSession.processFiles(list, command, options, out, null);
    }

    private static void getMaxMin(File fl, MM mm) {
        Opener opener = new Opener();
        ImagePlus imp = opener.openImage(fl.getAbsolutePath());
        float global_max = 0.0f;
        float global_min = 0.0f;
        if (imp != null) {
            StackStatistics stack_stats = new StackStatistics(imp);
            global_max = (float)stack_stats.max;
            global_min = (float)stack_stats.min;
        }
        if (global_max > mm.max) {
            mm.max = global_max;
        }
        if (global_min < mm.min) {
            mm.min = global_min;
        }
    }

    private static void getFilesMaxMin(File[] fls, MM mm) {
        for (File fl : fls) {
            ClusterSession.getMaxMin(fl, mm);
        }
    }

    public static ClusterSession processFiles(File[] list, String command, String options, String[] out, ClusterGUI cg) {
        if (cg == null) {
            cg = new ClusterGUI();
        }
        ClusterSession ss = cg.getClusterSession();
        MM mm = new MM();
        mm.min = new Float(Float.MAX_VALUE).floatValue();
        mm.max = new Float(0.0).floatValue();
        ClusterSession.getFilesMaxMin(list, mm);
        for (File fl : list) {
            ClusterSession.processFile(fl, command, options, out, cg, Float.valueOf(mm.max), Float.valueOf(mm.min));
        }
        ss.runPluginsOnFrames(null, command, options, out, cg.getEstimatedTime());
        return ss;
    }

    public static ClusterSession processFile(File fl, String command, String options, String[] out) {
        return ClusterSession.processFile(fl, command, options, out, null);
    }

    public static ClusterSession processFile(File fl, String command, String options, String[] out, ClusterGUI cg) {
        if (cg == null) {
            cg = new ClusterGUI();
        }
        Opener opener = new Opener();
        ImagePlus imp = opener.openImage(fl.getAbsolutePath());
        ClusterSession ss = ClusterSession.processImage(imp, command, options, out, cg, new Float(0.0), new Float(0.0), true);
        return ss;
    }

    public String getSplitAndUploadFilename(int num) {
        return "tmp_" + (num + 1) + ".tif";
    }

    private static ClusterSession processFile(File fl, String command, String options, String[] out, ClusterGUI cg, Float max, Float min) {
        Opener opener = new Opener();
        ImagePlus imp = opener.openImage(fl.getAbsolutePath());
        ClusterSession ss = ClusterSession.processImage(imp, command, options, out, cg, max, min, false);
        return ss;
    }

    public static File processJobsData(String path) {
        String dirS = null;
        String[] dir = ClusterSession.getJobDirectories(0, null);
        if (dir.length > 0) {
            if (path != null) {
                dirS = path;
            } else {
                DirectoryChooser dc = new DirectoryChooser("Choose directory where to save result");
                dirS = dc.getDirectory();
            }
            ProgressBarWin wp = new ProgressBarWin();
            for (int i = 0; i < dir.length; ++i) {
                wp.SetStatusMessage("Moving " + dir[i]);
                try {
                    String[] tmp = dir[i].split(File.separator);
                    File t = new File(dirS + File.separator + tmp[tmp.length - 1]);
                    ShellCommand.exeCmdNoPrint("cp -r " + dir[i] + " " + t);
                    System.out.println("cp -r " + dir[i] + " " + t);
                    ShellCommand.exeCmdNoPrint("rm -rf " + dir[i]);
                    System.out.println("rm -rf " + dir[i]);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            wp.dispose();
        }
        return new File(dirS);
    }

    public static void mergeJobs(File jobsrc, File[] jobdst) {
        int i;
        if (jobdst.length == 0) {
            return;
        }
        String tmp = IJ.getDirectory((String)"temp") + File.separator + "temp_merge" + File.separator;
        try {
            ShellCommand.exeCmd("mkdir " + tmp);
            ProgressBarWin pbw = new ProgressBarWin();
            ShellCommand.copy(jobsrc, new File(tmp), pbw);
            pbw.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String[] sp_src = MosaicUtils.readAndSplit(jobsrc.getAbsolutePath() + File.separator + "JobID");
        String[] sp = new String[sp_src.length];
        for (i = 0; i < sp_src.length; ++i) {
            sp[i] = sp_src[i];
        }
        for (i = 0; i < jobdst.length; ++i) {
            Object[] fl = jobdst[i].listFiles();
            File[] fileArray = fl;
            int n = fileArray.length;
            for (int j = 0; j < n; ++j) {
                ProgressBarWin pbw;
                File t = fileArray[j];
                if (!t.isDirectory()) continue;
                File dir = new File(tmp + File.separator + t.getName());
                if (dir.exists()) {
                    pbw = new ProgressBarWin();
                    ShellCommand.copy(t, dir, pbw);
                    pbw.dispose();
                    continue;
                }
                try {
                    ShellCommand.exeCmd("mkdir " + dir.getAbsolutePath());
                    pbw = new ProgressBarWin();
                    ShellCommand.copy(t, dir, pbw);
                    pbw.dispose();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            String[] sp_dst = MosaicUtils.readAndSplit(jobdst[i].getAbsolutePath() + File.separator + "JobID");
            sp[0] = sp[0] + "#" + sp_dst[0];
            sp[1] = Integer.toString(Integer.parseInt(sp[1]) + Integer.parseInt(sp_dst[1]));
            sp[2] = sp[2] + "#" + sp_dst[2];
            if (sp_src[3].equals(sp_dst[3])) continue;
            IJ.showMessage((String)"Error : You cannot merge Jobs of two different plugins");
            return;
        }
        try {
            PrintWriter out = new PrintWriter(tmp + File.separator + "JobID");
            out.print(sp[0]);
            for (String s : sp) {
                out.print(" " + (String)s);
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            File[] fl_;
            for (File f : fl_ = jobsrc.listFiles()) {
                ShellCommand.exeCmd("rm -rf " + f.getAbsolutePath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ProgressBarWin pbw = new ProgressBarWin();
        ShellCommand.copy(new File(tmp), jobsrc, pbw);
        pbw.dispose();
        try {
            ShellCommand.exeCmd("rm -rf " + new File(tmp).getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i2 = 0; i2 < jobdst.length; ++i2) {
            try {
                ShellCommand.exeCmd("rm -rf " + jobdst[i2].getAbsolutePath());
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class MM {
        public float min;
        public float max;

        protected MM() {
        }
    }
}

