/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils.images;

import ij.IJ;
import ij.ImagePlus;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.iterators.SpaceIterator;

public abstract class BaseImage {
    protected SpaceIterator iIterator;

    public BaseImage(int[] aDimensions, int aMaxDimensions) {
        if (aDimensions.length > aMaxDimensions) {
            throw new RuntimeException("Dimensions number bigger than " + aMaxDimensions + " is not supported!");
        }
        this.iIterator = new SpaceIterator(aDimensions);
    }

    public boolean isInBound(Point aPoint) {
        return this.iIterator.isInBound(aPoint);
    }

    public boolean isInBound(Integer aIndex) {
        return this.iIterator.isInBound(aIndex);
    }

    public int getNumOfDimensions() {
        return this.iIterator.getNumOfDimensions();
    }

    public int[] getDimensions() {
        return this.iIterator.getDimensions();
    }

    public int getDimension(int aDimensionIndex) {
        return this.iIterator.getDimensions()[aDimensionIndex];
    }

    public int getWidth() {
        return this.iIterator.getDimensions()[0];
    }

    public int getHeight() {
        return this.iIterator.getDimensions()[1];
    }

    public int getDepth() {
        return this.getNumOfSlices();
    }

    public int getNumOfSlices() {
        return this.getNumOfDimensions() == 2 ? 1 : this.iIterator.getDimensions()[2];
    }

    public int getSize() {
        return this.iIterator.getSize();
    }

    public int pointToIndex(Point aPoint) {
        return this.iIterator.pointToIndex(aPoint);
    }

    public Point indexToPoint(int aIndex) {
        return this.iIterator.indexToPoint(aIndex);
    }

    protected static int[] getDimensions(ImagePlus aImage) {
        int[] dims = new int[aImage.getNDimensions()];
        int[] imageDimensions = aImage.getDimensions();
        dims[0] = imageDimensions[0];
        dims[1] = imageDimensions[1];
        if (dims.length > 2) {
            dims[2] = aImage.getStackSize();
        }
        return dims;
    }

    public void save(String aFileName) {
        ImagePlus ip = this.convertToImg("ResultWindow_save");
        IJ.save((ImagePlus)ip, (String)aFileName);
        ip.close();
    }

    public ImagePlus show(String aTitle) {
        ImagePlus imp = this.convertToImg(aTitle);
        imp.show();
        return imp;
    }

    public abstract ImagePlus convertToImg(String var1);

    public String toString() {
        String result = "BaseImage [";
        for (int i = 0; i < this.iIterator.getNumOfDimensions(); ++i) {
            result = result + this.iIterator.getDimensions()[i];
            result = result + ", ";
        }
        result = result.substring(0, result.length() - 2);
        result = result + "]";
        return result;
    }
}

