/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils.images;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.StackStatistics;
import java.util.Arrays;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.BaseImage;
import mosaic.utils.ArrayOps;

public class IntensityImage
extends BaseImage {
    private final ImagePlus iInputImg;
    private float[] iDataIntensity;

    public IntensityImage(ImagePlus aInputImg) {
        this(aInputImg, true);
    }

    public IntensityImage(IntensityImage aInputImg) {
        this(aInputImg.getDimensions());
        for (int i = 0; i < aInputImg.getSize(); ++i) {
            this.iDataIntensity[i] = aInputImg.iDataIntensity[i];
        }
    }

    public IntensityImage(ImagePlus aInputImg, boolean aShouldNormalize) {
        super(IntensityImage.getDimensions(aInputImg), 3);
        this.iInputImg = aInputImg;
        this.initIntensityData(this.iInputImg);
        if (aShouldNormalize) {
            this.normalize();
        }
    }

    public IntensityImage(int[] aDimensions) {
        super(aDimensions, 3);
        this.iInputImg = null;
        this.iDataIntensity = new float[this.getSize()];
    }

    public float[] getDataIntensity() {
        return this.iDataIntensity;
    }

    public ImagePlus getImage() {
        return this.iInputImg;
    }

    public void normalize() {
        ArrayOps.normalize(this.iDataIntensity);
    }

    public float get(int idx) {
        return this.iDataIntensity[idx];
    }

    public void set(int idx, float aValue) {
        this.iDataIntensity[idx] = aValue;
    }

    public void set(Point p, float aValue) {
        this.set(this.pointToIndex(p), aValue);
    }

    public void setSafe(Point aPoint, float aValue) {
        if (!this.isInBound(aPoint)) {
            return;
        }
        this.set(this.pointToIndex(aPoint), aValue);
    }

    public float get(Point p) {
        return this.get(this.pointToIndex(p));
    }

    public float getSafe(Point aPoint) {
        if (!this.isInBound(aPoint)) {
            return 0.0f;
        }
        return this.get(this.pointToIndex(aPoint));
    }

    private void initIntensityData(ImagePlus aImage) {
        if (aImage.getType() != 2) {
            aImage.setStack(aImage.getStack().convertToFloat());
        }
        this.iDataIntensity = new float[this.getSize()];
        int nSlices = aImage.getStackSize();
        int sizeOfOneImage = this.getWidth() * this.getHeight();
        ImageStack stack = aImage.getStack();
        for (int i = 0; i < nSlices; ++i) {
            float[] pixels = (float[])stack.getPixels(i + 1);
            int imageIndex = 0;
            for (int y = 0; y < this.getHeight(); ++y) {
                for (int x = 0; x < this.getWidth(); ++x) {
                    this.iDataIntensity[i * sizeOfOneImage + imageIndex] = pixels[imageIndex];
                    ++imageIndex;
                }
            }
        }
    }

    @Override
    public ImagePlus convertToImg(String aTitle) {
        String title = aTitle;
        ImagePlus imp = new ImagePlus(title, this.getFloatStack());
        StackStatistics stackStats = new StackStatistics(imp);
        imp.setDisplayRange(stackStats.min, stackStats.max);
        return imp;
    }

    public ImageStack getFloatStack() {
        int w = this.getWidth();
        int h = this.getHeight();
        int area = w * h;
        ImageStack stack = new ImageStack(w, h);
        for (int i = 0; i < this.getNumOfSlices(); ++i) {
            stack.addSlice("", (Object)Arrays.copyOfRange(this.iDataIntensity, i * area, (i + 1) * area));
        }
        return stack;
    }
}

