/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils.masks;

import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.masks.EllipseBase;

public class BallMask
extends EllipseBase {
    public BallMask(float aRadius, int aNumOfDimensions) {
        super(aRadius, (int)Math.floor(2.0f * aRadius), new float[aNumOfDimensions]);
        float[] scaling = new float[aNumOfDimensions];
        for (int i = 0; i < aNumOfDimensions; ++i) {
            scaling[i] = 1.0f;
        }
        this.iScaling = scaling;
        this.fillMask();
    }

    public BallMask(float aRadius, int aSizeOfRegion, float[] aScaling) {
        super(aRadius, aSizeOfRegion, aScaling);
        this.fillMask();
    }

    private void fillMask() {
        int size = this.iIterator.getSize();
        for (int i = 0; i < size; ++i) {
            Point offset = this.iIterator.indexToPoint(i);
            float ellipseDist = this.hyperEllipse(offset);
            if (ellipseDist <= 1.0f) {
                this.iMask[i] = true;
                ++this.iNumOfFgPoints;
                continue;
            }
            this.iMask[i] = false;
        }
    }
}

