/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.imageUtils.masks;

import mosaic.core.imageUtils.Connectivity;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.masks.EllipseBase;

public class SphereMask
extends EllipseBase {
    private final Connectivity iConnectivity;

    public SphereMask(float aRadius, int aSizeOfRegion, float[] aScaling) {
        super(aRadius, aSizeOfRegion, aScaling);
        this.iConnectivity = new Connectivity(this.iDimensions.length, this.iDimensions.length - 1);
        this.fillMask();
    }

    private void fillMask() {
        int size = this.iIterator.getSize();
        for (int i = 0; i < size; ++i) {
            Point offset = this.iIterator.indexToPoint(i);
            float ellipseDist = this.hyperEllipse(offset);
            if (!(ellipseDist <= 1.0f)) continue;
            if (this.isBoundary(offset)) {
                this.iMask[i] = true;
                ++this.iNumOfFgPoints;
                continue;
            }
            this.iMask[i] = false;
        }
    }

    private boolean isBoundary(Point aPoint) {
        for (Point neighborPoint : this.iConnectivity.iterator()) {
            float vHypEllipse = this.hyperEllipse(neighborPoint = neighborPoint.add(aPoint));
            if (!(vHypEllipse > 1.0f)) continue;
            return true;
        }
        return false;
    }
}

