/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.particleLinking;

import ij.IJ;
import java.util.Vector;
import mosaic.core.detection.Particle;
import mosaic.core.particleLinking.LinkerOptions;
import mosaic.core.particleLinking.ParticleLinker;
import org.apache.log4j.Logger;

public class ParticleLinkerGreedy
extends ParticleLinker {
    private static final Logger logger = Logger.getLogger(ParticleLinkerGreedy.class);

    @Override
    protected void link(Vector<Particle> p1, Vector<Particle> p2, LinkerOptions aLinkOpts, int currFrame, int NumOfFrames, int numOfParticles, int numOfLinkParticles, int currLinkLevel, float maxCost) {
        this.logInfo("Initializing cost matrix: " + (currFrame + 1) + "/" + NumOfFrames + " with frame: " + (currFrame + currLinkLevel + 1));
        float[][] cost = this.initCostMatrix(aLinkOpts, p1, p2, currLinkLevel, maxCost);
        this.logInfo("Initializing Relation matrix: " + (currFrame + 1) + "/" + NumOfFrames);
        boolean[][] g = this.initRelationMatrix(numOfParticles, numOfLinkParticles, maxCost, cost);
        int[][] helperVectors = this.initHelperVectors(numOfParticles, numOfLinkParticles, g);
        int[] gX = helperVectors[0];
        int[] gY = helperVectors[1];
        this.logInfo("Optimizing Relation matrix: " + (currFrame + 1) + "/" + NumOfFrames);
        this.optimizeRelationMatrix(numOfParticles, numOfLinkParticles, maxCost, cost, g, gX, gY);
        this.logInfo("Linking particles: " + (currFrame + 1) + "/" + NumOfFrames);
        this.linkParticles(aLinkOpts, p1, p2, currLinkLevel, gY, numOfParticles, numOfLinkParticles);
    }

    private void linkParticles(LinkerOptions aLinkOpts, Vector<Particle> p1, Vector<Particle> p2, int aLinkLevel, int[] gY, int aNumOfParticles, int aNumOfLinkParticles) {
        for (int i = 0; i < aNumOfParticles; ++i) {
            int j = gY[i];
            if (j == aNumOfLinkParticles) continue;
            Particle pA = p1.elementAt(i);
            Particle pB = p2.elementAt(j);
            pA.next[aLinkLevel - 1] = j;
            this.handleCostFeatures(pA, pB, aLinkOpts, aLinkLevel);
        }
    }

    public void optimizeRelationMatrix(int aNumOfParticles, int aNumOfLinkParticles, float aMaxCost, float[][] aCostMatrix, boolean[][] g, int[] gX, int[] gY) {
        double minDeltaCost;
        do {
            minDeltaCost = 0.0;
            int iOld = -1;
            int jOld = -1;
            int xOld = -1;
            int yOld = -1;
            for (int i = 0; i < aNumOfParticles + 1; ++i) {
                for (int j = 0; j < aNumOfLinkParticles + 1; ++j) {
                    int y;
                    int x;
                    double newDeltaCost;
                    if (i == aNumOfParticles && j == aNumOfLinkParticles || g[i][j] || !(aCostMatrix[i][j] <= aMaxCost) || !((newDeltaCost = (double)(aCostMatrix[i][j] + aCostMatrix[x = gX[j]][y = gY[i]] - (aCostMatrix[i][y] + aCostMatrix[x][j]))) < minDeltaCost)) continue;
                    minDeltaCost = newDeltaCost;
                    iOld = i;
                    jOld = j;
                    xOld = x;
                    yOld = y;
                }
            }
            if (!(minDeltaCost < 0.0)) continue;
            g[iOld][yOld] = false;
            g[xOld][jOld] = false;
            g[iOld][jOld] = true;
            g[xOld][yOld] = true;
            gY[iOld] = jOld;
            gX[jOld] = iOld;
            gY[xOld] = yOld;
            gX[yOld] = xOld;
            gX[aNumOfLinkParticles] = aNumOfParticles;
            gY[aNumOfParticles] = aNumOfLinkParticles;
        } while (!(minDeltaCost >= 0.0));
    }

    private float[][] initCostMatrix(LinkerOptions aLinkOpts, Vector<Particle> p1, Vector<Particle> p2, int aLinkLevel, float aMaxCost) {
        int i;
        int numOfParticles = p1.size();
        int numOfLinkParticles = p2.size();
        float[][] cost = new float[numOfParticles + 1][numOfLinkParticles + 1];
        for (i = 0; i < numOfParticles; ++i) {
            for (int j = 0; j < numOfLinkParticles; ++j) {
                Particle pA = p1.elementAt(i);
                Particle pB = p2.elementAt(j);
                cost[i][j] = this.linkCost(pA, pB, aLinkOpts, aLinkLevel);
            }
        }
        for (i = 0; i < numOfParticles; ++i) {
            cost[i][numOfLinkParticles] = aMaxCost;
        }
        for (i = 0; i < numOfLinkParticles; ++i) {
            cost[numOfParticles][i] = aMaxCost;
        }
        cost[numOfParticles][numOfLinkParticles] = 0.0f;
        return cost;
    }

    private int[][] initHelperVectors(int aNumOfParticles, int aNumOfLinkParticles, boolean[][] g) {
        int[] gX = new int[aNumOfLinkParticles + 1];
        int[] gY = new int[aNumOfParticles + 1];
        for (int i = 0; i < aNumOfParticles + 1; ++i) {
            for (int j = 0; j < aNumOfLinkParticles + 1; ++j) {
                if (!g[i][j]) continue;
                gX[j] = i;
                gY[i] = j;
            }
        }
        gX[aNumOfLinkParticles] = aNumOfParticles;
        gY[aNumOfParticles] = aNumOfLinkParticles;
        return new int[][]{gX, gY};
    }

    private boolean[][] initRelationMatrix(int aNumOfParticles, int aNumOfLinkParticles, float aMaxCost, float[][] aCostMatrix) {
        boolean[][] g = new boolean[aNumOfParticles + 1][aNumOfLinkParticles + 1];
        boolean[] isColumnAssigned = new boolean[aNumOfLinkParticles + 1];
        for (int i = 0; i < aNumOfParticles; ++i) {
            IJ.showProgress((int)i, (int)aNumOfParticles);
            double min = aMaxCost;
            int prev = -1;
            for (int j = 0; j < aNumOfLinkParticles; ++j) {
                if (isColumnAssigned[j] || !((double)aCostMatrix[i][j] < min)) continue;
                min = aCostMatrix[i][j];
                if (prev >= 0) {
                    isColumnAssigned[prev] = false;
                    g[i][prev] = false;
                }
                isColumnAssigned[j] = true;
                g[i][j] = true;
                prev = j;
            }
            if (min != (double)aMaxCost) continue;
            g[i][aNumOfLinkParticles] = true;
            isColumnAssigned[aNumOfLinkParticles] = true;
        }
        for (int j = 0; j < aNumOfLinkParticles; ++j) {
            boolean isLinked = false;
            for (int i = 0; i < aNumOfParticles + 1; ++i) {
                if (!g[i][j]) continue;
                isLinked = true;
                break;
            }
            if (isLinked) continue;
            g[aNumOfParticles][j] = true;
        }
        g[aNumOfParticles][aNumOfLinkParticles] = true;
        return g;
    }

    private void logInfo(String aLogStr) {
        IJ.showStatus((String)aLogStr);
        logger.info((Object)aLogStr);
    }
}

