/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.psf;

import ij.IJ;
import ij.gui.GenericDialog;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import mosaic.core.psf.PSFSettings;
import mosaic.core.psf.psf;
import mosaic.core.psf.psfList;
import mosaic.utils.io.serialize.DataFile;
import mosaic.utils.io.serialize.SerializedDataFile;
import net.imglib2.Cursor;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;

public class GeneratePSF {
    private PSFSettings settings = new PSFSettings();
    private int[] sz;
    private Choice PSFc;
    private psf<FloatType> psfc;
    protected TextField dimF;

    private void selectPSF(int dim, String psf2) {
        if (dim == 0) {
            IJ.error((String)"Dimension must be a valid integer != 0");
        }
        this.psfc = psfList.factory(psf2, dim, FloatType.class);
        this.psfc.getParamenters();
    }

    protected void selectPSF(int dim) {
        String psf2 = this.PSFc.getSelectedItem();
        if (dim == 0) {
            IJ.error((String)"Dimension must be a valid integer != 0");
        }
        this.psfc = psfList.factory(psf2, dim, FloatType.class);
        this.psfc.getParamenters();
    }

    static <T extends RealType<T>> double[][] generateImage2DAsDoubleArray(psf<T> psf2) {
        if (psf2.getSuggestedImageSize().length != 2) {
            return null;
        }
        int[] sz = psf2.getSuggestedImageSize();
        double[][] img = new double[sz[0]][sz[1]];
        int[] mid = new int[sz.length];
        for (int i = 0; i < mid.length; ++i) {
            mid[i] = sz[i] / 2;
        }
        int[] old_mid = null;
        if (!psf2.isFile()) {
            old_mid = psf2.getCenter();
            psf2.setCenter(mid);
        }
        int[] loc = new int[sz.length];
        for (int i = 0; i < sz[0]; ++i) {
            for (int j = 0; j < sz[1]; ++j) {
                double f;
                loc[0] = i;
                loc[1] = j;
                psf2.setPosition(loc);
                img[i][j] = f = (double)((RealType)psf2.get()).getRealFloat();
            }
        }
        psf2.setCenter(old_mid);
        return img;
    }

    static <T extends RealType<T>> float[][] generateImage2DAsFloatArray(psf<T> psf2) {
        if (psf2.getSuggestedImageSize().length != 2) {
            return null;
        }
        int[] sz = psf2.getSuggestedImageSize();
        float[][] img = new float[sz[0]][sz[1]];
        int[] mid = new int[sz.length];
        for (int i = 0; i < mid.length; ++i) {
            mid[i] = sz[i] / 2;
        }
        int[] old_mid = null;
        if (!psf2.isFile()) {
            old_mid = psf2.getCenter();
            psf2.setCenter(mid);
        }
        int[] loc = new int[sz.length];
        for (int i = 0; i < sz[0]; ++i) {
            for (int j = 0; j < sz[1]; ++j) {
                float f;
                loc[0] = i;
                loc[1] = j;
                psf2.setPosition(loc);
                img[i][j] = f = ((RealType)psf2.get()).getRealFloat();
            }
        }
        psf2.setCenter(old_mid);
        return img;
    }

    static <T extends RealType<T>> double[][][] generateImage3DAsDoubleArray(psf<T> psf2) {
        if (psf2.getSuggestedImageSize().length != 3) {
            return null;
        }
        int[] sz = psf2.getSuggestedImageSize();
        double[][][] img = new double[sz[2]][sz[1]][sz[0]];
        int[] mid = new int[sz.length];
        for (int i = 0; i < mid.length; ++i) {
            mid[i] = sz[i] / 2;
        }
        int[] old_mid = null;
        if (!psf2.isFile()) {
            old_mid = psf2.getCenter();
            psf2.setCenter(mid);
        }
        int[] loc = new int[sz.length];
        for (int i = 0; i < sz[0]; ++i) {
            for (int j = 0; j < sz[1]; ++j) {
                for (int k = 0; k < sz[2]; ++k) {
                    loc[0] = i;
                    loc[1] = j;
                    loc[2] = k;
                    psf2.setPosition(loc);
                    float f = ((RealType)psf2.get()).getRealFloat();
                    img[k][j][i] = f;
                }
            }
        }
        psf2.setCenter(old_mid);
        return img;
    }

    static <T extends RealType<T>> float[][][] generateImage3DAsFloatArray(psf<T> psf2) {
        if (psf2.getSuggestedImageSize().length != 3) {
            return null;
        }
        int[] sz = psf2.getSuggestedImageSize();
        float[][][] img = new float[sz[0]][sz[1]][sz[2]];
        int[] mid = new int[sz.length];
        for (int i = 0; i < mid.length; ++i) {
            mid[i] = sz[i] / 2;
        }
        int[] old_mid = null;
        if (!psf2.isFile()) {
            old_mid = psf2.getCenter();
            psf2.setCenter(mid);
        }
        int[] loc = new int[sz.length];
        for (int i = 0; i < sz[2]; ++i) {
            for (int j = 0; j < sz[1]; ++j) {
                for (int k = 0; k < sz[0]; ++k) {
                    float f;
                    loc[0] = i;
                    loc[1] = j;
                    loc[2] = k;
                    psf2.setPosition(loc);
                    img[k][j][i] = f = ((RealType)psf2.get()).getRealFloat();
                }
            }
        }
        psf2.setCenter(old_mid);
        return img;
    }

    public Img<FloatType> generate(int dim) {
        this.settings.clist = psfList.psfList[0];
        this.settings = GeneratePSF.getConfigHandler().LoadFromFile(IJ.getDirectory((String)"temp") + File.separator + "psf_settings.dat", PSFSettings.class, this.settings);
        GenericDialog gd = new GenericDialog("PSF Generator");
        gd.addNumericField("Dimensions ", (double)dim, 0);
        if (!IJ.isMacro()) {
            this.dimF = (TextField)gd.getNumericFields().lastElement();
            gd.addChoice("PSF: ", psfList.psfList, this.settings.clist);
            this.PSFc = (Choice)gd.getChoices().lastElement();
            Button optionButton = new Button("Options");
            GridBagConstraints c = new GridBagConstraints();
            int gridx = 2;
            int gridy = 1;
            c.gridx = 2;
            c.gridy = gridy++;
            c.anchor = 13;
            gd.add((Component)optionButton, (Object)c);
            optionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int dim = Integer.parseInt(GeneratePSF.this.dimF.getText());
                    GeneratePSF.this.selectPSF(dim);
                }
            });
        } else {
            gd.addChoice("PSF: ", psfList.psfList, this.settings.clist);
        }
        gd.showDialog();
        String choice = gd.getNextChoice();
        if (IJ.isMacro()) {
            dim = (int)gd.getNextNumber();
            this.selectPSF(dim, choice);
        }
        if (this.psfc == null) {
            dim = (int)gd.getNextNumber();
            this.selectPSF(dim, choice);
        }
        this.sz = this.psfc.getSuggestedImageSize();
        if (this.sz == null) {
            return null;
        }
        int[] mid = new int[this.sz.length];
        for (int i = 0; i < mid.length; ++i) {
            mid[i] = this.sz[i] / 2;
        }
        if (!this.psfc.isFile()) {
            this.psfc.setCenter(mid);
        }
        int[] loc = new int[this.sz.length];
        ArrayImgFactory imgFactory = new ArrayImgFactory();
        Img PSFimg = imgFactory.create(this.sz, (Object)new FloatType());
        Cursor cft = PSFimg.cursor();
        while (cft.hasNext()) {
            cft.next();
            cft.localize(loc);
            this.psfc.setPosition(loc);
            float f = ((FloatType)this.psfc.get()).getRealFloat();
            ((FloatType)cft.get()).set(f);
        }
        this.settings.clist = choice;
        GeneratePSF.getConfigHandler().SaveToFile(IJ.getDirectory((String)"temp") + File.separator + "psf_settings.dat", this.settings);
        return PSFimg;
    }

    public String getParameters() {
        return this.psfc.getStringParameters();
    }

    private static DataFile<PSFSettings> getConfigHandler() {
        return new SerializedDataFile<PSFSettings>();
    }
}

