/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mosaic.core.cluster.ClusterSession;
import mosaic.core.utils.ARGBToARGB;
import mosaic.core.utils.ChooseGUI;
import mosaic.core.utils.FloatToARGB;
import mosaic.core.utils.IntToARGB;
import mosaic.core.utils.Region3DColocRScript;
import mosaic.core.utils.Segmentation;
import mosaic.plugins.BregmanGLM_Batch;
import mosaic.utils.ConvertArray;
import mosaic.utils.Debug;
import mosaic.utils.ImgUtils;
import mosaic.utils.SysOps;
import mosaic.utils.io.csv.CSV;
import mosaic.utils.io.csv.CsvMetaInfo;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class MosaicUtils {
    public static <T extends RealType<T>> ToARGB getConversion(Object data, Cursor<T> crs) {
        ToARGB conv = null;
        if (data instanceof RealType) {
            conv = new FloatToARGB();
        } else if (data instanceof IntegerType) {
            conv = new IntToARGB();
        } else if (data instanceof ARGBType) {
            conv = new ARGBToARGB();
        } else {
            throw new RuntimeException();
        }
        crs.next();
        RealType min = (RealType)((RealType)crs.get()).createVariable();
        RealType max = (RealType)((RealType)crs.get()).createVariable();
        MosaicUtils.getMinMax(crs, min, max);
        conv.setMinMax(min.getRealDouble(), max.getRealDouble());
        return conv;
    }

    private static File filter_possible(Vector<File> PossibleFile) {
        if (PossibleFile == null || PossibleFile.size() == 0) {
            return null;
        }
        if (PossibleFile.size() == 1) {
            return PossibleFile.get(0);
        }
        return new ChooseGUI().chooseFile("Choose segmentation", "Found multiple segmentations", PossibleFile);
    }

    public static boolean checkSegmentationInfo(ImagePlus aImp, String plugin) {
        String Folder = ImgUtils.getImageDirectory(aImp);
        Segmentation[] sg = MosaicUtils.getSegmentationPluginsClasses();
        for (int i = 0; i < sg.length; ++i) {
            String[] sR = sg[i].getRegionList(aImp);
            for (int j = 0; j < sR.length; ++j) {
                File fR = new File(Folder + sR[j]);
                Debug.print("checkSegmentationInfo", fR.getAbsoluteFile());
                if (!fR.exists()) continue;
                return true;
            }
            String[] jb = ClusterSession.getJobDirectories(0, Folder);
            for (int k = 0; k < jb.length; ++k) {
                String[] fl = MosaicUtils.readAndSplit(jb[k] + File.separator + "JobID");
                if (!fl[2].contains(aImp.getTitle()) || !sg[i].getName().equals(fl[3])) continue;
                if (plugin == null) {
                    return true;
                }
                if (!sg[i].getName().equals(plugin)) continue;
                return true;
            }
        }
        return false;
    }

    public static SegmentationInfo getSegmentationInfo(ImagePlus aImp) {
        String Folder = ImgUtils.getImageDirectory(aImp);
        Segmentation[] sg = MosaicUtils.getSegmentationPluginsClasses();
        SegmentationInfo sI = new SegmentationInfo();
        Vector<File> PossibleFile = new Vector<File>();
        for (int i = 0; i < sg.length; ++i) {
            String[] sR = sg[i].getRegionList(aImp);
            for (int j = 0; j < sR.length; ++j) {
                File fR = new File(Folder + sR[j]);
                if (!fR.exists()) continue;
                PossibleFile.add(fR);
            }
            String[] jb = ClusterSession.getJobDirectories(0, Folder);
            for (int k = 0; k < jb.length; ++k) {
                String[] fl = MosaicUtils.readAndSplit(jb[k] + File.separator + "JobID");
                if (!fl[2].contains(aImp.getTitle()) || !sg[i].getName().equals(fl[3])) continue;
                sR = sg[i].getRegionList(aImp);
                for (int j = 0; j < sR.length; ++j) {
                    File fR = new File(jb[k] + File.separator + sR[j]);
                    if (!fR.exists()) continue;
                    PossibleFile.add(fR);
                }
            }
            sI.RegionList = MosaicUtils.filter_possible(PossibleFile);
            if (sI.RegionList != null) continue;
            return null;
        }
        return sI;
    }

    private static Segmentation[] getSegmentationPluginsClasses() {
        return new Segmentation[]{new BregmanGLM_Batch()};
    }

    public static void MergeFrames(ImagePlus a1, ImagePlus a2) {
        if (a1 == null || a2 == null) {
            return;
        }
        if (a1.getImageStack().getSize() == 0) {
            a1.setStack("Merge frames", a2.getImageStack().duplicate());
            a1.setDimensions(a2.getNChannels(), a2.getNSlices(), a2.getNFrames());
            return;
        }
        int hcount = a2.getNFrames() + a1.getNFrames();
        for (int k = 1; k <= a2.getNFrames(); ++k) {
            for (int j = 1; j <= a2.getNSlices(); ++j) {
                for (int i = 1; i <= a2.getNChannels(); ++i) {
                    a2.setPosition(i, j, k);
                    a1.getImageStack().addSlice("", a2.getChannelProcessor().getPixels());
                }
            }
        }
        a1.getStack().setColorModel(a2.getStack().getColorModel());
        a1.setDimensions(a2.getNChannels(), a2.getNSlices(), hcount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readAndSplit(String file) {
        String output = null;
        try (Scanner scanner = null;){
            scanner = new Scanner(new File(file));
            output = scanner.useDelimiter("\\Z").next();
        }
        return output.split(" ");
    }

    public static ImageStack getSubStackInFloat(ImageStack is, int startPos, int endPos, boolean duplicate) {
        if (startPos > endPos || startPos < 0 || endPos < 0) {
            return null;
        }
        ImageStack subStack = new ImageStack(is.getWidth(), is.getHeight());
        for (int i = startPos; i <= endPos; ++i) {
            ImageProcessor fp = duplicate ? is.getProcessor(i).convertToFloat().duplicate() : is.getProcessor(i).convertToFloat();
            subStack.addSlice(is.getSliceLabel(i), fp);
        }
        return subStack;
    }

    public static boolean write2File(String directory, String file_name, String info) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(directory, file_name));
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            PrintWriter print_writer = new PrintWriter(bos);
            print_writer.print(info);
            print_writer.close();
            return true;
        }
        catch (IOException e) {
            IJ.error((String)("" + e));
            return false;
        }
    }

    public static <T extends NativeType<T>> boolean copyEmbedded(Img<T> A, Img<T> B, int fix) {
        if (A == null || B == null || A.numDimensions() - B.numDimensions() != 1) {
            return false;
        }
        Cursor img_c = B.cursor();
        IntervalView view = Views.hyperSlice(A, (int)B.numDimensions(), (long)fix);
        Cursor img_v = Views.flatIterable((RandomAccessibleInterval)view).cursor();
        while (img_c.hasNext()) {
            img_c.fwd();
            img_v.fwd();
            ((NativeType)img_v.get()).set((Type)img_c.get());
        }
        return true;
    }

    public static ImagePlus getImageFrame(ImagePlus aImage, int aFrame) {
        ImageStack stack = aImage.getStack();
        int imagesPerFrame = stack.getSize() / aImage.getNFrames();
        ImageStack subStack = new ImageStack(aImage.getWidth(), aImage.getHeight());
        for (int j = 1; j <= imagesPerFrame; ++j) {
            subStack.addSlice("st" + j, stack.getProcessor((aFrame - 1) * imagesPerFrame + j));
        }
        return new ImagePlus("tmp", subStack);
    }

    public static ImagePlus getImageSlice(ImagePlus aImage, int aChannel) {
        if (aChannel == 0) {
            return null;
        }
        ImageStack stack = aImage.getStack();
        int imagesPerChannel = stack.getSize() / aImage.getNSlices();
        ImageStack tmp_stk = new ImageStack(aImage.getWidth(), aImage.getHeight());
        for (int j = 0; j < imagesPerChannel; ++j) {
            tmp_stk.addSlice("st" + j, stack.getProcessor((aChannel - 1) * imagesPerChannel + j + 1));
        }
        return new ImagePlus("tmp", tmp_stk);
    }

    public static void reorganize(String[] output, String base, String sv, int nf) {
        String tmp;
        int j;
        for (j = 0; j < output.length; ++j) {
            String dirName = sv + "/" + output[j].replace("*", "_");
            SysOps.createDir(dirName);
        }
        for (j = 0; j < output.length; ++j) {
            tmp = output[j];
            for (int k = 0; k < nf; ++k) {
                String src = "";
                String dest = "";
                if (new File(sv + File.separator + tmp.replace("*", base)).exists()) {
                    src = sv + File.separator + tmp.replace("*", base);
                    dest = sv + File.separator + tmp.replace("*", "_") + File.separator + base + tmp.replace("*", "");
                } else {
                    src = sv + File.separator + tmp.replace("*", base + (k + 1));
                    dest = sv + File.separator + tmp.replace("*", "_") + File.separator + base + (k + 1) + tmp.replace("*", "");
                }
                SysOps.moveFile(src, dest, true);
            }
        }
        for (j = 0; j < output.length; ++j) {
            tmp = new String(output[j]);
            String dirStr = sv + "/" + tmp.replace("*", "_");
            File dir = new File(dirStr);
            if (dir.listFiles() == null || dir.listFiles().length != 0) continue;
            SysOps.removeDir(dir);
        }
    }

    public static void reorganize(String[] output, String base_src, String base_dst, String sv, int nf) {
        String tmp;
        int j;
        for (j = 0; j < output.length; ++j) {
            tmp = new String(output[j]);
            String dirName = sv + "/" + tmp.replace("*", "_");
            SysOps.createDir(dirName);
        }
        for (j = 0; j < output.length; ++j) {
            tmp = new String(output[j]);
            for (int k = 0; k < nf; ++k) {
                String src = "";
                String dest = "";
                if (new File(sv + File.separator + tmp.replace("*", base_src)).exists()) {
                    src = sv + File.separator + tmp.replace("*", base_src);
                    dest = sv + File.separator + tmp.replace("*", "_") + File.separator + base_dst + tmp.replace("*", "");
                } else if (nf == 1) {
                    src = sv + File.separator + tmp.replace("*", base_src + "_" + (k + 1));
                    dest = sv + File.separator + tmp.replace("*", "_") + File.separator + base_dst + tmp.replace("*", "");
                } else {
                    src = sv + File.separator + tmp.replace("*", base_src + "_" + (k + 1));
                    dest = sv + File.separator + tmp.replace("*", "_") + File.separator + base_dst + "_" + (k + 1) + tmp.replace("*", "");
                }
                SysOps.moveFile(src, dest, true);
            }
        }
        for (j = 0; j < output.length; ++j) {
            tmp = new String(output[j]);
            String dirStr = sv + "/" + tmp.replace("*", "_");
            File dir = new File(dirStr);
            if (dir.listFiles() == null || dir.listFiles().length != 0) continue;
            SysOps.removeDir(dir);
        }
    }

    public static String parseString(String aParameterName, String aOptions) {
        String sub;
        if (aOptions == null || aParameterName == null) {
            return null;
        }
        Pattern config = Pattern.compile(aParameterName);
        Pattern spaces = Pattern.compile("[\\s]*=[\\s]*");
        Pattern pathp = Pattern.compile("[a-zA-Z0-9/_.-:-]+");
        Matcher matcher = config.matcher(aOptions);
        if (matcher.find() && (matcher = spaces.matcher(sub = aOptions.substring(matcher.end()))).find() && (matcher = pathp.matcher(sub = sub.substring(matcher.end()))).find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static boolean parseCheckbox(String aKey, String aOptions) {
        String s1 = aOptions;
        String s2 = aKey + " ";
        if (s1.startsWith(s2)) {
            return true;
        }
        s2 = " " + s2;
        int len1 = s1.length();
        int len2 = s2.length();
        boolean inLiteral = false;
        for (int i = 0; i < len1 - len2 + 1; ++i) {
            char c = s1.charAt(i);
            if (inLiteral && c == ']') {
                inLiteral = false;
            } else if (c == '[') {
                inLiteral = true;
            }
            if (c != s2.charAt(0) || inLiteral || i > 1 && s1.charAt(i - 1) == '=') continue;
            boolean match = true;
            for (int j = 0; j < len2; ++j) {
                if (s2.charAt(j) == s1.charAt(i + j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static <T> long[] getImageDimensions(Img<T> img) {
        long[] dimensions_l = new long[img.numDimensions()];
        img.dimensions(dimensions_l);
        return dimensions_l;
    }

    public static <T> int[] getImageIntDimensions(Img<T> img) {
        return ConvertArray.toInt(MosaicUtils.getImageDimensions(img));
    }

    private static <T extends RealType<T>> void getMinMax(Cursor<T> cur, T min, T max) {
        min.setReal(Double.MAX_VALUE);
        max.setReal(Double.MIN_VALUE);
        while (cur.hasNext()) {
            cur.fwd();
            if (((RealType)cur.get()).getRealDouble() < min.getRealDouble()) {
                min.setReal(((RealType)cur.get()).getRealDouble());
            }
            if (!(((RealType)cur.get()).getRealDouble() > max.getRealDouble())) continue;
            max.setReal(((RealType)cur.get()).getRealDouble());
        }
    }

    private static String[] getCSV(String[] dir) {
        Vector<String> outcsv = new Vector<String>();
        for (String d : dir) {
            if (!d.endsWith(".csv")) continue;
            outcsv.add(d.replace("*", "_"));
        }
        Debug.print("CSV files:", outcsv);
        return outcsv.toArray(new String[0]);
    }

    private static <T> void Stitch(String[] aDirs, File aBaseDir, File aOutputCsvFile, CsvMetaInfo[] aMetaInfo, Class<T> aClazz) {
        boolean firstFile = true;
        CSV<T> csv = new CSV<T>(aClazz);
        for (int j = 0; j < aDirs.length; ++j) {
            String currentDir = aDirs[j];
            File[] currentFiles = new File(aBaseDir + File.separator + currentDir.replace("*", "_")).listFiles();
            if (currentFiles == null) continue;
            Object[] currentFilesAbsPaths = new String[currentFiles.length];
            for (int i = 0; i < currentFiles.length; ++i) {
                if (!currentFiles[i].getName().endsWith(".csv")) continue;
                currentFilesAbsPaths[i] = currentFiles[i].getAbsolutePath();
            }
            Arrays.sort(currentFilesAbsPaths);
            Debug.print(currentDir, currentFiles);
            csv.clearMetaInformation();
            if (aMetaInfo != null) {
                for (CsvMetaInfo cmi : aMetaInfo) {
                    csv.setMetaInformation(cmi);
                }
            }
            if (firstFile) {
                firstFile = false;
                csv.setCSVPreferenceFromFile((String)currentFilesAbsPaths[0]);
            }
            try {
                csv.StitchAny((String[])currentFilesAbsPaths, aOutputCsvFile + currentDir);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void StitchCSV(String aBaseDir, String[] output, String aBackgroundValue) {
        CsvMetaInfo[] csvMetaInfoArray;
        if (aBackgroundValue != null) {
            CsvMetaInfo[] csvMetaInfoArray2 = new CsvMetaInfo[1];
            csvMetaInfoArray = csvMetaInfoArray2;
            csvMetaInfoArray2[0] = new CsvMetaInfo("background", aBackgroundValue);
        } else {
            csvMetaInfoArray = null;
        }
        CsvMetaInfo[] mt = csvMetaInfoArray;
        String[] outcsv = MosaicUtils.getCSV(output);
        MosaicUtils.Stitch(outcsv, new File(aBaseDir), new File(aBaseDir + File.separator + "stitch"), mt, Region3DColocRScript.class);
    }

    public static void StitchJobsCSV(String fl, String[] output, String bck) {
        for (String jobDir : ClusterSession.getJobDirectories(0, fl)) {
            MosaicUtils.StitchCSV(jobDir, output, bck);
        }
    }

    public static <T extends RealType<T>> double volume_image(Img<T> aImage) {
        double sum = 0.0;
        Cursor cursor = aImage.cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            sum += ((RealType)cursor.get()).getRealDouble();
        }
        return sum;
    }

    public static <T extends RealType<T>> void rescale_image(Img<T> aImage, float aScaleFactor) {
        Cursor cursor = aImage.cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            ((RealType)cursor.get()).setReal(((RealType)cursor.get()).getRealFloat() * aScaleFactor);
        }
    }

    public static interface ToARGB {
        public void setMinMax(double var1, double var3);

        public ARGBType toARGB(Object var1);
    }

    public static class SegmentationInfo {
        public File RegionList;
    }
}

