/*
 * Decompiled with CFR 0.152.
 */
package mosaic.filamentSegmentation;

import mosaic.utils.math.Matrix;

public class GaussPsf {
    public static double[][] generateKernel(int xl, int yl, double sigma) {
        int x;
        int y;
        double[][] psf2 = new double[yl][xl];
        double middlex = (double)(xl - 1) / 2.0;
        double middley = (double)(yl - 1) / 2.0;
        double sum = 0.0;
        for (y = 0; y < yl; ++y) {
            for (x = 0; x < xl; ++x) {
                double val;
                psf2[y][x] = val = Math.exp(-(Math.pow((double)x - middlex, 2.0) + Math.pow((double)y - middley, 2.0)) / (2.0 * sigma * sigma));
                sum += val;
            }
        }
        if (sum != 0.0) {
            for (y = 0; y < yl; ++y) {
                x = 0;
                while (x < xl) {
                    double[] dArray = psf2[y];
                    int n = x++;
                    dArray[n] = dArray[n] / sum;
                }
            }
        }
        return psf2;
    }

    public static Matrix generate(int xl, int yl, double sigma) {
        return new Matrix(GaussPsf.generateKernel(xl, yl, sigma));
    }
}

