/*
 * Decompiled with CFR 0.152.
 */
package mosaic.particleTracker;

import ij.ImagePlus;
import ij.gui.StackWindow;
import java.awt.Checkbox;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import mosaic.particleTracker.Trajectory;

public class FocusStackWin
extends StackWindow
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private Checkbox Auto_Z;
    private final Trajectory traj;
    private final float scal_z;

    public FocusStackWin(ImagePlus aimp, Trajectory traj_, float scal_z_) {
        super(aimp);
        this.addPanel();
        this.traj = traj_;
        this.scal_z = scal_z_;
        if (this.tSelector != null) {
            this.tSelector.addAdjustmentListener((AdjustmentListener)((Object)this));
        } else if (this.zSelector != null) {
            this.zSelector.addAdjustmentListener((AdjustmentListener)((Object)this));
        } else if (this.cSelector != null) {
            this.cSelector.addAdjustmentListener((AdjustmentListener)((Object)this));
        }
    }

    private void addPanel() {
        Panel panel = new Panel(new GridLayout(2, 1));
        this.Auto_Z = new Checkbox("Auto Z");
        this.Auto_Z.addItemListener(this);
        panel.add(this.Auto_Z);
        this.add(panel);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Point loc = this.getLocation();
        Dimension size = this.getSize();
        if (loc.y + size.height > screen.height) {
            this.getCanvas().zoomOut(0, 0);
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (this.Auto_Z.getState()) {
            int frame = 0;
            if (this.getImagePlus().getNFrames() != 1) {
                frame = this.getImagePlus().getFrame() - 1;
            } else if (this.getImagePlus().getNSlices() != 1) {
                frame = this.getImagePlus().getSlice() - 1;
            } else if (this.getImagePlus().getNChannels() != 1) {
                frame = this.getImagePlus().getChannel() - 1;
            }
            int slice = (int)(this.traj.iParticles[frame].iZ / this.scal_z);
            this.getImagePlus().setSlice(slice);
            if (this.getImagePlus().getNFrames() != 1) {
                this.getImagePlus().setPosition(this.getImagePlus().getChannel(), slice + 1, this.getImagePlus().getFrame());
            } else if (this.getImagePlus().getNSlices() != 1) {
                this.getImagePlus().setPosition(slice + 1, this.getImagePlus().getSlice(), this.getImagePlus().getFrame());
            }
        }
        super.adjustmentValueChanged(e);
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        if (this.Auto_Z.getState()) {
            int frame = 0;
            if (this.getImagePlus().getNFrames() != 1) {
                frame = this.getImagePlus().getFrame() - 1;
            } else if (this.getImagePlus().getNSlices() != 1) {
                frame = this.getImagePlus().getSlice() - 1;
            } else if (this.getImagePlus().getNChannels() != 1) {
                frame = this.getImagePlus().getChannel() - 1;
            }
            int slice = (int)(this.traj.iParticles[frame].iZ / this.scal_z);
            this.getImagePlus().setSlice(slice);
            if (this.getImagePlus().getNFrames() != 1) {
                this.getImagePlus().setPosition(this.getImagePlus().getChannel(), slice + 1, this.getImagePlus().getFrame());
            } else if (this.getImagePlus().getNSlices() != 1) {
                this.getImagePlus().setPosition(slice + 1, this.getImagePlus().getSlice(), this.getImagePlus().getFrame());
            }
        }
    }
}

