/*
 * Decompiled with CFR 0.152.
 */
package mosaic.particleTracker;

import java.io.File;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mosaic.core.detection.Particle;
import mosaic.particleTracker.Trajectory;
import mosaic.particleTracker.TrajectoryAnalysis;
import mosaic.plugins.ParticleTracker3DModular_;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TrajectoriesReportXML {
    private Document iReport;
    private final ParticleTracker3DModular_ iTracker;

    public TrajectoriesReportXML(String aFileName, ParticleTracker3DModular_ aTracker) {
        this.iTracker = aTracker;
        try {
            this.iReport = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.generateReport();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(this.iReport);
            StreamResult result = new StreamResult(new File(aFileName));
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    private void generateReport() {
        Element rootElement = this.iReport.createElement("ParticleTracker");
        this.iReport.appendChild(rootElement);
        this.generateConfiguration(rootElement);
        this.generateFramesInfo(rootElement);
        this.generateTrajectoriesInfo(rootElement);
    }

    private void generateConfiguration(Element aParent) {
        Element conf = this.addElement(aParent, "Configuration");
        this.addElementWithAttr(conf, "KernelRadius", "value", this.iTracker.getRadius());
        this.addElementWithAttr(conf, "CutoffRadius", "value", this.iTracker.getCutoffRadius());
        this.addElementWithAttr(conf, "Threshold", "mode", this.iTracker.getThresholdMode(), "value", this.iTracker.getThresholdValue());
        this.addElementWithAttr(conf, "Displacement", "value", this.iTracker.displacement);
        this.addElementWithAttr(conf, "Linkrange", "value", this.iTracker.iLinkRange);
    }

    private void generateFramesInfo(Element aParent) {
        Element conf = this.addElement(aParent, "FramesInfo");
        this.addElementWithAttr(conf, "Width", "value", this.iTracker.getWidth());
        this.addElementWithAttr(conf, "Height", "value", this.iTracker.getHeight());
        this.addElementWithAttr(conf, "NumberOfSlices", "value", this.iTracker.getNumberOfSlices());
        this.addElementWithAttr(conf, "NumberOfFrames", "value", this.iTracker.getNumberOfFrames());
        this.addElementWithAttr(conf, "GlobalMinimum", "value", this.iTracker.getGlobalMinimum());
        this.addElementWithAttr(conf, "GlobalMaximum", "value", this.iTracker.getGlobalMaximum());
    }

    private void generateTrajectoriesInfo(Element aParent) {
        Element traj = this.addElement(aParent, "Trajectories");
        Iterator<Trajectory> iter = this.iTracker.iTrajectories.iterator();
        while (iter.hasNext()) {
            this.addTrajectory(traj, iter.next());
        }
    }

    private void addTrajectory(Element aParent, Trajectory aTrajectory) {
        Element traj = this.addElementWithAttr(aParent, "Trajectory", "ID", aTrajectory.iSerialNumber);
        this.generateTrajectoryAnalysis(traj, aTrajectory);
        this.generateTrajectoryData(traj, aTrajectory);
    }

    private void generateTrajectoryData(Element aParent, Trajectory aTrajectory) {
        Element trajData = this.addElement(aParent, "TrajectoryData");
        for (Particle p : aTrajectory.iParticles) {
            Element frame = this.addElementWithAttr(trajData, "Frame", "number", p.getFrame());
            Element coordinates = this.addElement(frame, "Coordinates");
            coordinates.setAttribute("x", "" + p.getx());
            coordinates.setAttribute("y", "" + p.gety());
            coordinates.setAttribute("z", "" + p.getz());
            Element intensity = this.addElement(frame, "IntensityMoments");
            intensity.setAttribute("m0", "" + p.m0);
            intensity.setAttribute("m1", "" + p.m1);
            intensity.setAttribute("m2", "" + p.m2);
            intensity.setAttribute("m3", "" + p.m3);
            intensity.setAttribute("m4", "" + p.m4);
            this.addElementWithAttr(frame, "NonParticleDiscriminationScore", "value", p.nonParticleDiscriminationScore);
        }
    }

    private void generateTrajectoryAnalysis(Element aParent, Trajectory aTrajectory) {
        ParticleTracker3DModular_.CalibrationData calData = this.iTracker.getImageCalibrationData();
        if (calData.errorMsg == null) {
            Element trajAnalysis = this.addElement(aParent, "TrajectoryAnalysis");
            TrajectoryAnalysis ta = new TrajectoryAnalysis(aTrajectory);
            ta.setLengthOfAPixel(calData.pixelDimension);
            ta.setTimeInterval(calData.timeInterval);
            if (ta.calculateAll()) {
                this.addElementWithAttr(trajAnalysis, "MSS", "slope", "" + ta.getMSSlinear(), "yAxisIntercept", "" + ta.getMSSlinearY0());
                this.addElementWithAttr(trajAnalysis, "MSD", "slope", "" + ta.getGammasLogarithmic()[1], "yAxisIntercept", "" + ta.getGammasLogarithmicY0()[1]);
                this.addElementWithAttr(trajAnalysis, "DiffusionCoefficient", "D2", "" + ta.getDiffusionCoefficients()[1]);
            } else {
                this.addElementWithAttr(trajAnalysis, "MSS", "slope", "", "yAxisIntercept", "");
                this.addElementWithAttr(trajAnalysis, "MSD", "slope", "", "yAxisIntercept", "");
                this.addElementWithAttr(trajAnalysis, "DiffusionCoefficient", "D2", "");
            }
        }
    }

    private Element addElement(Element aParent, String aName) {
        Element el = this.iReport.createElement(aName);
        aParent.appendChild(el);
        return el;
    }

    private Element addElementWithAttr(Element aParent, String aName, String aAttribute, int aValue) {
        return this.addElementWithAttr(aParent, aName, aAttribute, "" + aValue);
    }

    private Element addElementWithAttr(Element aParent, String aName, String aAttribute, double aValue) {
        return this.addElementWithAttr(aParent, aName, aAttribute, "" + aValue);
    }

    private Element addElementWithAttr(Element aParent, String aName, String aAttribute, String aValue) {
        Element el = this.iReport.createElement(aName);
        el.setAttribute(aAttribute, aValue);
        aParent.appendChild(el);
        return el;
    }

    private Element addElementWithAttr(Element aParent, String aName, String aAttribute1, String aValue1, String aAttribute2, String aValue2) {
        Element el = this.iReport.createElement(aName);
        el.setAttribute(aAttribute1, aValue1);
        el.setAttribute(aAttribute2, aValue2);
        aParent.appendChild(el);
        return el;
    }
}

