/*
 * Decompiled with CFR 0.152.
 */
package mosaic.particleTracker;

import java.util.ArrayList;
import mosaic.core.detection.Particle;
import mosaic.particleTracker.Trajectory;
import mosaic.utils.math.LeastSquares;

public class TrajectoryAnalysis {
    private final Particle[] iParticles;
    private int[] iMomentOrders;
    private int[] iFrameShifts;
    private double[][] iMSDs;
    private double[] iGammasLogarithmic;
    private double[] iGammasLogarithmicY0;
    private double[] iGammasLinear;
    private double[] iGammasLinearY0;
    private double[] iDiffusionCoefficients;
    private double iMSSlinear;
    private double iMSSlinearY0;
    private double iMSSlogarithmic;
    private double iMSSlogarithmicY0;
    private double iDX;
    private double iDT;
    private double iDistance;
    private double iAvgDistance;
    private double iStraightness;
    private double iBending;
    private double iBendingLinear;
    private double iEfficiency;
    public static final boolean SUCCESS = true;
    public static final boolean FAILURE = false;

    public TrajectoryAnalysis(Trajectory aTrajectory) {
        this(aTrajectory != null ? aTrajectory.iParticles : null);
    }

    TrajectoryAnalysis(Particle[] aParticles) {
        this.iParticles = aParticles;
        if (this.iParticles != null && this.iParticles.length > 0) {
            this.setFrameShifts(1, (this.iParticles[this.iParticles.length - 1].getFrame() - this.iParticles[0].getFrame() + 1) / 3);
        }
        this.setMomentOrders(1, 10);
        this.iDX = 1.0;
        this.iDT = 1.0;
    }

    private void setMomentOrders(int aMin, int aMax) {
        if (aMax >= aMin) {
            this.iMomentOrders = TrajectoryAnalysis.generateArrayRange(aMin, aMax);
        }
    }

    public void setMomentOrders(int[] aOrders) {
        this.iMomentOrders = aOrders;
    }

    public int[] getMomentOrders() {
        return this.iMomentOrders;
    }

    private void setFrameShifts(int aMin, int aMax) {
        if (aMax >= aMin) {
            this.iFrameShifts = TrajectoryAnalysis.generateArrayRange(aMin, aMax);
        }
    }

    public void setFrameShifts(int[] aFrameShifts) {
        this.iFrameShifts = aFrameShifts;
    }

    public int[] getFrameShifts() {
        return this.iFrameShifts;
    }

    public boolean calculateAll() {
        if (this.iFrameShifts != null && this.iFrameShifts.length >= 1 && this.iMomentOrders != null && this.iMomentOrders.length >= 1 && this.iParticles != null && this.iParticles.length >= 6) {
            return this.calculateTrajectoryMotionFeatures() && this.calculateMSDs() && this.calculateGammasAndDiffusionCoefficients() && this.calculateMSS();
        }
        return false;
    }

    double[] getMSDforMomentIdx(int aMomentIdx) {
        return this.iMSDs[aMomentIdx];
    }

    public double[] getGammasLogarithmic() {
        return this.iGammasLogarithmic;
    }

    public double[] getGammasLogarithmicY0() {
        return this.iGammasLogarithmicY0;
    }

    public double[] getGammasLinear() {
        return this.iGammasLinear;
    }

    public double[] getGammasLinearY0() {
        return this.iGammasLinearY0;
    }

    public double[] getDiffusionCoefficients() {
        return this.iDiffusionCoefficients;
    }

    public double getMSSlinear() {
        return this.iMSSlinear;
    }

    public double getMSSlinearY0() {
        return this.iMSSlinearY0;
    }

    public double getMSSlogarithmic() {
        return this.iMSSlogarithmic;
    }

    public double getMSSlogarithmicY0() {
        return this.iMSSlogarithmicY0;
    }

    public double getDistance() {
        return this.iDistance;
    }

    public double getAvgDistance() {
        return this.iAvgDistance;
    }

    public double getStraightness() {
        return this.iStraightness;
    }

    public double getBending() {
        return this.iBending;
    }

    public double getBendingLinear() {
        return this.iBendingLinear;
    }

    public double getEfficiency() {
        return this.iEfficiency;
    }

    public void setLengthOfAPixel(double aLength) {
        this.iDX = aLength;
    }

    public void setTimeInterval(double aInterval) {
        this.iDT = aInterval;
    }

    public double getTimeInterval() {
        return this.iDT;
    }

    double[] toLogScale(double[] aVector) {
        double[] result = new double[aVector.length];
        for (int i = 0; i < aVector.length; ++i) {
            result[i] = Math.log(aVector[i]);
        }
        return result;
    }

    double[] toLogScale(int[] aVector) {
        double[] result = new double[aVector.length];
        for (int i = 0; i < aVector.length; ++i) {
            result[i] = Math.log(aVector[i]);
        }
        return result;
    }

    double[] toDouble(int[] aValues) {
        double[] result = new double[aValues.length];
        for (int i = 0; i < aValues.length; ++i) {
            result[i] = aValues[i];
        }
        return result;
    }

    public String toString() {
        String str = String.format("Physical length unit(per pixel): %15.4f\n", this.iDX);
        str = str + String.format("Physical time unit(time between frames): %15.4f\n\n", this.iDT);
        str = str + "MSDs:\n";
        str = str + "-----------------------------------\n";
        for (double[] m : this.iMSDs) {
            String line = "";
            for (double d : m) {
                line = line + String.format("%15.4f ", d);
            }
            str = str + line + "\n";
        }
        str = str + "\nGAMMAs:\n";
        str = str + "-----------------------------------\n";
        String line = "";
        for (double g : this.iGammasLogarithmic) {
            line = line + String.format("%15.4f ", g);
        }
        str = str + line + "\n";
        str = str + "\nDiffusion Coefficientss:\n";
        str = str + "-----------------------------------\n";
        line = "";
        for (double g : this.iDiffusionCoefficients) {
            line = line + String.format("%15.4f ", g);
        }
        str = str + line + "\n";
        str = str + "\nMSS:\n";
        str = str + "-----------------------------------\n";
        str = str + String.format("%15.4f\n", this.iMSSlinear);
        return str;
    }

    private double meanDisplacement(int aDelta, int aOrder) {
        int noOfParticles = this.iParticles.length;
        if (noOfParticles < 2 || aDelta <= 0) {
            return 0.0;
        }
        double sum = 0.0;
        int noOfElements = 0;
        block0: for (int i = 0; i < noOfParticles; ++i) {
            Particle pi = this.iParticles[i];
            for (int j = i + 1; j < noOfParticles; ++j) {
                Particle pj = this.iParticles[j];
                if (pj.getFrame() == pi.getFrame() + aDelta) {
                    double dx = pj.iX - pi.iX;
                    double dy = pj.iY - pi.iY;
                    sum += Math.pow((dx * dx + dy * dy) * this.iDX * this.iDX, (double)aOrder / 2.0);
                    ++noOfElements;
                    continue block0;
                }
                if (pj.getFrame() > pi.getFrame() + aDelta) continue block0;
            }
        }
        return noOfElements == 0 ? 0.0 : sum / (double)noOfElements;
    }

    private boolean calculateTrajectoryMotionFeatures() {
        int noOfParticles = this.iParticles.length;
        this.iAvgDistance = 0.0;
        this.iDistance = 0.0;
        if (noOfParticles < 2) {
            return true;
        }
        ArrayList<Double> angles = new ArrayList<Double>();
        double prevAngl = 0.0;
        boolean prevAvaiable = false;
        double efficiencyDenominator = 0.0;
        Particle pj = this.iParticles[0];
        for (int i = 1; i < noOfParticles; ++i) {
            Particle pi = this.iParticles[i];
            double dx = pi.iX - pj.iX;
            double dy = pi.iY - pj.iY;
            double squaredDist = (dx * dx + dy * dy) * this.iDX * this.iDX;
            efficiencyDenominator += squaredDist;
            this.iDistance += Math.sqrt(squaredDist);
            pj = pi;
            double angle = 0.0;
            boolean skip = false;
            if (dx == 0.0 && dy > 0.0) {
                angle = 1.5707963267948966;
            } else if (dx == 0.0 && dy < 0.0) {
                angle = 4.71238898038469;
            } else if (dx > 0.0 && dy == 0.0) {
                angle = 0.0;
            } else if (dx < 0.0 && dy == 0.0) {
                angle = Math.PI;
            } else if (dx > 0.0 && dy > 0.0) {
                angle = Math.atan(dy / dx);
            } else if (dx < 0.0 && dy > 0.0) {
                angle = Math.PI + Math.atan(dy / dx);
            } else if (dx < 0.0 && dy < 0.0) {
                angle = Math.PI + Math.atan(dy / dx);
            } else if (dx > 0.0 && dy < 0.0) {
                angle = Math.PI * 2 + Math.atan(dy / dx);
            } else {
                skip = true;
            }
            if (skip) continue;
            if (prevAvaiable) {
                angles.add(prevAngl - angle);
            }
            prevAngl = angle;
            prevAvaiable = true;
        }
        this.iAvgDistance = this.iDistance / (double)(this.iParticles[noOfParticles - 1].getFrame() - this.iParticles[0].getFrame());
        double straightness = 0.0;
        double bendingSin = 0.0;
        double bendingDegrees = 0.0;
        for (int i = 0; i < angles.size(); ++i) {
            if ((Double)angles.get(i) < -Math.PI) {
                angles.set(i, (Double)angles.get(i) + Math.PI * 2);
            } else if ((Double)angles.get(i) > Math.PI) {
                angles.set(i, (Double)angles.get(i) - Math.PI * 2);
            }
            straightness += Math.cos((Double)angles.get(i));
            bendingSin += Math.sin((Double)angles.get(i));
            bendingDegrees += ((Double)angles.get(i)).doubleValue();
        }
        this.iStraightness = straightness / (double)angles.size();
        this.iBending = bendingSin / (double)angles.size();
        this.iBendingLinear = bendingDegrees / (double)angles.size();
        Particle firstP = this.iParticles[0];
        Particle lastP = this.iParticles[noOfParticles - 1];
        double dx = lastP.iX - firstP.iX;
        double dy = lastP.iY - firstP.iY;
        double squaredDist = (dx * dx + dy * dy) * this.iDX * this.iDX;
        this.iEfficiency = squaredDist / ((double)(noOfParticles - 1) * efficiencyDenominator);
        return true;
    }

    private boolean calculateMSDs() {
        this.iMSDs = new double[this.iMomentOrders.length][this.iFrameShifts.length];
        int orderIdx = 0;
        for (int order : this.iMomentOrders) {
            int deltaIdx = 0;
            for (int delta : this.iFrameShifts) {
                double displacement;
                this.iMSDs[orderIdx][deltaIdx] = displacement = this.meanDisplacement(delta, order);
                ++deltaIdx;
            }
            ++orderIdx;
        }
        return true;
    }

    private boolean calculateGammasAndDiffusionCoefficients() {
        LeastSquares ls = new LeastSquares();
        int noOfMoments = this.iMomentOrders.length;
        this.iGammasLogarithmic = new double[noOfMoments];
        this.iGammasLinear = new double[noOfMoments];
        this.iGammasLogarithmicY0 = new double[noOfMoments];
        this.iGammasLinearY0 = new double[noOfMoments];
        this.iDiffusionCoefficients = new double[noOfMoments];
        int gammaIdx = 0;
        for (double[] m : this.iMSDs) {
            double[] moments = new double[m.length];
            double[] deltas = new double[m.length];
            int count = 0;
            for (int i = 0; i < this.iFrameShifts.length; ++i) {
                if (m[i] == 0.0) continue;
                moments[count] = m[i];
                deltas[count] = this.iFrameShifts[i];
                ++count;
            }
            if (count < 2) {
                return false;
            }
            double[] tmpMoments = new double[count];
            double[] tmpDeltas = new double[count];
            for (int i = 0; i < count; ++i) {
                tmpMoments[i] = moments[i];
                tmpDeltas[i] = deltas[i] * this.iDT;
            }
            double[] mLog = this.toLogScale(tmpMoments);
            double[] dLog = this.toLogScale(tmpDeltas);
            ls.calculate(dLog, mLog);
            if (Double.isNaN(ls.getAlpha()) || Double.isNaN(ls.getBeta())) {
                return false;
            }
            this.iGammasLogarithmic[gammaIdx] = ls.getBeta();
            this.iGammasLogarithmicY0[gammaIdx] = ls.getAlpha();
            this.iDiffusionCoefficients[gammaIdx] = 0.25 * Math.exp(ls.getAlpha());
            ls.calculate(tmpDeltas, tmpMoments);
            this.iGammasLinear[gammaIdx] = ls.getBeta();
            this.iGammasLinearY0[gammaIdx] = ls.getAlpha();
            ++gammaIdx;
        }
        return true;
    }

    private boolean calculateMSS() {
        LeastSquares ls = new LeastSquares();
        ls.calculate(this.toDouble(this.iMomentOrders), this.iGammasLogarithmic);
        this.iMSSlinear = ls.getBeta();
        this.iMSSlinearY0 = ls.getAlpha();
        ls.calculate(this.toLogScale(this.iMomentOrders), this.toLogScale(this.iGammasLogarithmic));
        this.iMSSlogarithmic = ls.getBeta();
        this.iMSSlogarithmicY0 = ls.getAlpha();
        return true;
    }

    private static int[] generateArrayRange(int aMin, int aMax) {
        int[] range = new int[aMax - aMin + 1];
        int idx = 0;
        int m = aMin;
        while (m <= aMax) {
            range[idx] = m++;
            ++idx;
        }
        return range;
    }
}

