/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ImageProcessor;
import mosaic.utils.math.MathOps;

public class BesselPSF_Convolver
implements ExtendedPlugInFilter {
    static final int FLAGS = 13;
    int mSetupFlags = 13;
    ImagePlus mImp;
    double mRMax = 5.0E-7;
    double mNA = 1.2f;
    double mLambda = 4.5000000000000003E-7;
    double mXResolution = 1.0;
    double mYResolution = 1.0;
    int mKernelWidth = 0;
    int mKernelHeight = 0;

    public int setup(String aArgs, ImagePlus aImp) {
        this.mImp = aImp;
        this.mSetupFlags = IJ.setupDialog((ImagePlus)this.mImp, (int)13);
        return this.mSetupFlags;
    }

    public int showDialog(ImagePlus arg0, String arg1, PlugInFilterRunner arg2) {
        if (!this.checkAndSetUnit(this.mImp)) {
            return 4096;
        }
        if (!this.showDialog()) {
            return 4096;
        }
        return this.mSetupFlags;
    }

    public void setNPasses(int arg0) {
    }

    public void run(ImageProcessor aImageProcessor) {
        float[] kernel = this.generateBesselKernel();
        aImageProcessor.convolve(kernel, this.mKernelWidth, this.mKernelHeight);
    }

    private float[] generateBesselKernel() {
        int vXRadius = (int)(this.mRMax / this.mXResolution) + 1;
        int vYRadius = (int)(this.mRMax / this.mYResolution) + 1;
        this.mKernelWidth = vXRadius * 2 + 1;
        this.mKernelHeight = vYRadius * 2 + 1;
        float[] vKernel = new float[this.mKernelWidth * this.mKernelHeight];
        double vBesselMax = this.bessel_PSF(this.mXResolution / 10.0, this.mLambda, this.mNA);
        for (int vYI = 0; vYI < this.mKernelHeight; ++vYI) {
            for (int vXI = 0; vXI < this.mKernelWidth; ++vXI) {
                double vDist = Math.sqrt(Math.pow((double)(vXRadius - vXI) * this.mXResolution, 2.0) + Math.pow((double)(vYRadius - vYI) * this.mYResolution, 2.0));
                vKernel[vYI * this.mKernelWidth + vXI] = (float)(this.bessel_PSF(vDist, this.mLambda, this.mNA) / vBesselMax);
            }
        }
        vKernel[vYRadius * this.mKernelWidth + vXRadius] = 1.0f;
        return vKernel;
    }

    private double bessel_PSF(double aRadius, double aLambda, double aApparture) {
        double vA = Math.PI * 2 * aApparture / aLambda;
        double vR = 2.0 * MathOps.bessel1(aRadius * vA) / aRadius;
        return vR * vR;
    }

    private boolean checkAndSetUnit(ImagePlus aImp) {
        if (!aImp.getCalibration().getUnit().endsWith("m")) {
            IJ.showMessage((String)"Please set a 'x-meter'(e.g. \"nm\",\"mm\" unit in the image properties.");
            return false;
        }
        String vUnit = aImp.getCalibration().getUnit();
        double vS = 0.0;
        if (vUnit.equalsIgnoreCase("km")) {
            vS = 0.001;
        }
        if (vUnit.equalsIgnoreCase("m")) {
            vS = 1.0;
        }
        if (vUnit.equalsIgnoreCase("dm")) {
            vS = 10.0;
        }
        if (vUnit.equalsIgnoreCase("cm")) {
            vS = 100.0;
        }
        if (vUnit.equalsIgnoreCase("mm")) {
            vS = 1000.0;
        }
        if (vUnit.equalsIgnoreCase("\u00b5m") || vUnit.equalsIgnoreCase("um")) {
            vS = 1000000.0;
        }
        if (vUnit.equalsIgnoreCase("nm")) {
            vS = 1.0E9;
        }
        if (vS != 0.0) {
            this.mXResolution = aImp.getCalibration().pixelWidth / vS;
            this.mYResolution = aImp.getCalibration().pixelHeight / vS;
            return true;
        }
        IJ.showMessage((String)("Unit in image properties unknown: " + vUnit + "."));
        return false;
    }

    private boolean showDialog() {
        GenericDialog gd = new GenericDialog("Bessel PSF parameter");
        gd.addNumericField("wavelength", this.mLambda * 1.0E9, 0, 5, "nm");
        gd.addNumericField("Numeric Aparture: ", this.mNA, 0, 5, "");
        gd.addNumericField("Max Radius", this.mRMax * 1.0E9, 0, 5, "nm");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.mLambda = gd.getNextNumber() * 1.0E-9;
        this.mNA = gd.getNextNumber();
        this.mRMax = gd.getNextNumber() * 1.0E-9;
        return true;
    }
}

