/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.macro.Interpreter;
import ij.process.ImageProcessor;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import mosaic.bregman.ColocalizationAnalysis;
import mosaic.bregman.Files;
import mosaic.bregman.GUI.GenericGUI;
import mosaic.bregman.Parameters;
import mosaic.bregman.RScript;
import mosaic.bregman.SquasshLauncher;
import mosaic.core.cluster.ClusterSession;
import mosaic.core.utils.MosaicUtils;
import mosaic.core.utils.Segmentation;
import mosaic.core.utils.ShellCommand;
import mosaic.utils.ImgUtils;
import mosaic.utils.SysOps;
import mosaic.utils.io.serialize.DataFile;
import mosaic.utils.io.serialize.JsonDataFile;
import org.apache.log4j.Logger;

public class BregmanGLM_Batch
implements Segmentation {
    private static final Logger logger = Logger.getLogger(BregmanGLM_Batch.class);
    private static final String PluginName = "Squassh";
    private static final String SettingsFilepath = SysOps.getTmpPath() + "spb_settings.json";
    private static final String ConfigPrefix = "===> Conf: ";
    private boolean iIsConfigReadFromArguments = false;
    private boolean iIsMacro = false;
    private ImagePlus iInputImage;
    private Parameters iParameters;

    public void run(ImageProcessor imp) {
    }

    public int setup(String aArgs, ImagePlus aInputImage) {
        this.iInputImage = aInputImage;
        boolean bl = this.iIsMacro = IJ.isMacro() || Interpreter.batchMode;
        if (this.iIsMacro) {
            aArgs = Macro.getOptions();
        }
        if (aArgs == null) {
            aArgs = "";
        }
        logger.info((Object)("Input options: [" + aArgs + "]"));
        this.iParameters = this.readConfiguration(aArgs);
        this.iParameters.nthreads = this.readNumberOfThreads(aArgs);
        double normalizationMin = this.readNormalizationMinParams(aArgs);
        double normalizationMax = this.readNormalizationMaxParams(aArgs);
        boolean iProcessOnCluster = this.readClusterFlag(aArgs);
        String workDir = this.readWorkingDirectoryFromArgs(aArgs);
        logger.info((Object)("===> Conf: Working directory read from args: [" + (workDir == null ? "<null>" : workDir) + "]"));
        logger.info((Object)("===> Conf: Input image = [" + this.iInputImage + "][" + ImgUtils.getImageAbsolutePath(this.iInputImage) + "]"));
        logger.info((Object)("===> Conf: Working directory read from config file (or default) = [" + this.iParameters.wd + "]"));
        DataSource iSourceData = null;
        if (workDir != null) {
            iSourceData = DataSource.WORK_DIR_OR_FILE;
        } else if (this.iInputImage != null) {
            iSourceData = DataSource.IMAGE;
            String imgPath = ImgUtils.getImageAbsolutePath(this.iInputImage);
            workDir = imgPath != null ? imgPath : (this.iInputImage != null ? "Input Image: " + this.iInputImage.getTitle() : null);
        } else if (this.iParameters.wd != null) {
            iSourceData = DataSource.WORK_DIR_OR_FILE;
            workDir = this.iParameters.wd;
        } else {
            iSourceData = DataSource.NONE;
            workDir = "Input Image: <path to file or folder>, or press button below.";
        }
        logger.info((Object)("===> Conf: Working mode = " + (Object)((Object)iSourceData) + ", Working directory = [" + workDir + "]"));
        boolean isHeadlessMode = GraphicsEnvironment.isHeadless();
        boolean iGuiModeEnabled = !this.iIsMacro && !isHeadlessMode;
        logger.info((Object)("headlessMode = " + isHeadlessMode + ", isMacro = " + IJ.isMacro() + ", batchMode = " + Interpreter.batchMode));
        GenericGUI window = new GenericGUI(this.iInputImage, iGuiModeEnabled, this.iParameters, this.iIsConfigReadFromArguments);
        RunMode runMode = window.drawStandardWindow(workDir, iProcessOnCluster);
        logger.info((Object)this.iParameters);
        logger.info((Object)("Runmode = " + (Object)((Object)runMode)));
        if (runMode == RunMode.STOP) {
            if (!iGuiModeEnabled) {
                Macro.abort();
            }
            return 4096;
        }
        String guiWorkDir = window.getInput();
        logger.info((Object)("===> Conf: Working directory (from GUI) = [" + guiWorkDir + "]"));
        boolean isWorkingDirectoryCorrect = this.isWorkingDirectoryCorrect(guiWorkDir);
        if (!guiWorkDir.equals(workDir)) {
            if (isWorkingDirectoryCorrect) {
                iSourceData = DataSource.WORK_DIR_OR_FILE;
                workDir = guiWorkDir;
            } else {
                return 4096;
            }
        }
        if (iSourceData != DataSource.IMAGE && iSourceData != DataSource.WORK_DIR_OR_FILE) {
            logger.info((Object)"No image to process!");
            return 4096;
        }
        if (isWorkingDirectoryCorrect) {
            this.iParameters.wd = guiWorkDir;
        }
        if (!this.iIsConfigReadFromArguments) {
            this.saveConfig(SettingsFilepath, this.iParameters);
        }
        switch (runMode) {
            case LOCAL: {
                this.runLocally(workDir, iSourceData, normalizationMin, normalizationMax);
                break;
            }
            case CLUSTER: {
                this.runOnCluster(workDir, iSourceData);
                break;
            }
            default: {
                logger.error((Object)("Code should never end up in this place (" + (Object)((Object)runMode) + ")"));
            }
        }
        return 4096;
    }

    private void runLocally(String aPathToFileOrDir, DataSource aSourceData, double aNormalizationMin, double aNormalizationMax) {
        String objectsDataFile = null;
        String objectsColocFile = null;
        String imagesDataFile = null;
        String outputSaveDir = null;
        List<ColocalizationAnalysis.ChannelPair> channelPairs = null;
        logger.info((Object)("Running locally with data source (" + (Object)((Object)aSourceData) + ") and working dir [" + aPathToFileOrDir + "]"));
        if (aSourceData == DataSource.IMAGE) {
            String imageDirectory = ImgUtils.getImageDirectory(this.iInputImage);
            String string = outputSaveDir = imageDirectory != null ? imageDirectory + File.separator : IJ.getDirectory((String)"Select output directory");
            if (outputSaveDir == null) {
                return;
            }
            logger.info((Object)("Output save dir: [" + outputSaveDir + "]"));
            SquasshLauncher squasshLauncher = new SquasshLauncher(this.iInputImage, this.iParameters, outputSaveDir, aNormalizationMin, aNormalizationMax, null);
            Set<Files.FileInfo> savedFiles = squasshLauncher.getSavedFiles();
            channelPairs = squasshLauncher.getChannelPairs();
            if (savedFiles.size() == 0) {
                return;
            }
            Files.moveFilesToOutputDirs(savedFiles, outputSaveDir);
            String titleNoExt = SysOps.removeExtension(this.iInputImage.getTitle());
            objectsDataFile = outputSaveDir + Files.getMovedFilePath(Files.FileType.ObjectsData, titleNoExt);
            objectsColocFile = outputSaveDir + Files.getMovedFilePath(Files.FileType.ObjectsColoc, titleNoExt);
            imagesDataFile = outputSaveDir + Files.getMovedFilePath(Files.FileType.ImageColoc, titleNoExt);
        } else {
            Object[] objectArray;
            File inputFile = new File(aPathToFileOrDir);
            if (inputFile.isDirectory()) {
                objectArray = inputFile.listFiles();
            } else {
                File[] fileArray = new File[1];
                objectArray = fileArray;
                fileArray[0] = inputFile;
            }
            Object[] files = objectArray;
            Arrays.sort(files);
            if (files.length == 0) {
                logger.info((Object)"No files to process in given direcotry. Exiting.");
                return;
            }
            outputSaveDir = inputFile.isDirectory() ? aPathToFileOrDir + File.separator : inputFile.getParent() + File.separator;
            LinkedHashSet<Files.FileInfo> allFiles = new LinkedHashSet<Files.FileInfo>();
            for (Object f : files) {
                if (((File)f).isDirectory() || ((File)f).getName().equals("R_analysis.R") || ((File)f).getName().startsWith(".") || ((File)f).getName().endsWith(".csv")) continue;
                logger.info((Object)("Opening file for segmenting: [" + ((File)f).getAbsolutePath() + "]"));
                SquasshLauncher squasshLauncher = new SquasshLauncher(IJ.openImage((String)((File)f).getAbsolutePath()), this.iParameters, outputSaveDir, aNormalizationMin, aNormalizationMax, null);
                channelPairs = squasshLauncher.getChannelPairs();
                allFiles.addAll(squasshLauncher.getSavedFiles());
            }
            if (allFiles.size() == 0) {
                logger.debug((Object)"No files have been written. Exiting.");
                return;
            }
            String titlePrefix = null;
            if (inputFile.isDirectory()) {
                titlePrefix = "stitch_";
                Set<Files.FileInfo> movedFilesNames = Files.moveFilesToOutputDirs(allFiles, outputSaveDir);
                Files.stitchCsvFiles(movedFilesNames, outputSaveDir, null);
            } else {
                titlePrefix = SysOps.removeExtension(inputFile.getName());
            }
            objectsDataFile = outputSaveDir + Files.createTitleWithExt(Files.FileType.ObjectsData, titlePrefix);
            objectsColocFile = outputSaveDir + Files.createTitleWithExt(Files.FileType.ObjectsColoc, titlePrefix);
            imagesDataFile = outputSaveDir + Files.createTitleWithExt(Files.FileType.ImageColoc, titlePrefix);
        }
        if (IJ.isWindows()) {
            outputSaveDir = outputSaveDir.replace("\\", "\\\\");
            objectsDataFile = objectsDataFile.replace("\\", "\\\\");
            objectsColocFile = objectsColocFile.replace("\\", "\\\\");
            imagesDataFile = imagesDataFile.replace("\\", "\\\\");
        }
        this.runRscript(outputSaveDir, objectsDataFile, objectsColocFile, imagesDataFile, channelPairs);
    }

    private void runOnCluster(String aWorkDir, DataSource aSourceData) {
        this.saveParamitersForCluster(this.iParameters);
        ClusterSession.setPreferredSlotPerProcess(4);
        String backgroundImageFile = null;
        String outputPath = null;
        switch (aSourceData) {
            case WORK_DIR_OR_FILE: {
                File fl = new File(aWorkDir);
                if (fl.isDirectory()) {
                    File[] fileslist = fl.listFiles();
                    ClusterSession.processFiles(fileslist, PluginName, "nthreads=4", Files.outSuffixesCluster);
                    outputPath = fl.getAbsolutePath();
                    break;
                }
                if (fl.isFile()) {
                    ClusterSession.processFile(fl, PluginName, "nthreads=4", Files.outSuffixesCluster);
                    backgroundImageFile = fl.getAbsolutePath();
                    outputPath = SysOps.getPathToFile(backgroundImageFile);
                    break;
                }
                ClusterSession.getFinishedJob(Files.outSuffixesCluster, PluginName);
                fl = new File(IJ.getDirectory((String)"Select output directory"));
                outputPath = fl.getAbsolutePath();
                break;
            }
            case IMAGE: {
                ClusterSession.processImage(this.iInputImage, PluginName, "nthreads=4", Files.outSuffixesCluster);
                backgroundImageFile = ImgUtils.getImageDirectory(this.iInputImage) + File.separator + this.iInputImage.getTitle();
                outputPath = ImgUtils.getImageDirectory(this.iInputImage);
                break;
            }
            default: {
                logger.error((Object)("Wrong source data for image processing: " + (Object)((Object)aSourceData)));
            }
        }
        logger.info((Object)("cluster mode output path [" + outputPath + "], background image file [" + backgroundImageFile + "]"));
        File dir = ClusterSession.processJobsData(outputPath);
        MosaicUtils.StitchJobsCSV(dir.getAbsolutePath(), Files.outSuffixesCluster, backgroundImageFile);
    }

    private void runRscript(String aOutputSavePath, String aObjectsDataFile, String aObjectsColocFile, String aImagesDataFile, List<ColocalizationAnalysis.ChannelPair> aChannelPairs) {
        if (new File(aObjectsDataFile).exists() && new File(aImagesDataFile).exists() && this.iParameters.save_images) {
            RScript.makeRScript(aOutputSavePath, aObjectsDataFile, aObjectsColocFile, aImagesDataFile, aChannelPairs, this.iParameters.nbimages, this.iParameters.groupnames, this.iParameters.ch1, this.iParameters.ch2);
            try {
                logger.info((Object)"================ RSCRIPT BEGIN ====================");
                String command = "cd " + aOutputSavePath + "; Rscript " + aOutputSavePath + File.separator + "R_analysis.R";
                logger.info((Object)("Command: [" + command + "]"));
                ShellCommand.exeCmdString(command);
                logger.info((Object)"================ RSCRIPT END ====================");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isWorkingDirectoryCorrect(String workingDir) {
        return workingDir != null && !workingDir.startsWith("Input Image:") && !workingDir.isEmpty() && new File(workingDir).exists();
    }

    private int readNumberOfThreads(String aArgs) {
        int num = 1;
        String noOfThreads = MosaicUtils.parseString("nthreads", aArgs);
        if (noOfThreads != null) {
            logger.info((Object)("===> Conf: Number of threads provided in arguments = [" + noOfThreads + "]"));
            num = Integer.parseInt(noOfThreads);
        } else {
            num = Runtime.getRuntime().availableProcessors();
            logger.info((Object)("===> Conf: Number of threads taken from runtime = [" + num + "]"));
        }
        return num;
    }

    private boolean readClusterFlag(String aArgs) {
        boolean processOnCluster = MosaicUtils.parseCheckbox("process", aArgs);
        logger.info((Object)("===> Conf: Process on cluster flag set to: " + processOnCluster));
        return processOnCluster;
    }

    private double readNormalizationMinParams(String aArgs) {
        String normmin = MosaicUtils.parseString("min", aArgs);
        if (normmin != null) {
            logger.info((Object)("===> Conf: Min normalization provided in arguments = [" + normmin + "]"));
            return Double.parseDouble(normmin);
        }
        return 0.0;
    }

    private double readNormalizationMaxParams(String aArgs) {
        String normmax = MosaicUtils.parseString("max", aArgs);
        if (normmax != null) {
            logger.info((Object)("===> Conf: Max normalization provided in arguments = [" + normmax + "]"));
            return Double.parseDouble(normmax);
        }
        return 0.0;
    }

    private String readWorkingDirectoryFromArgs(String aArgs) {
        String filepath = MosaicUtils.parseString("input", aArgs);
        if (filepath != null) {
            logger.info((Object)("===> Conf: Working directory provided in arguments (input) =  [" + filepath + "]"));
        }
        return filepath;
    }

    private Parameters readConfiguration(String aArgs) {
        String configFile = MosaicUtils.parseString("config", aArgs);
        if (configFile != null) {
            logger.info((Object)("===> Conf: Reading config provided in arguments [" + configFile + "]"));
            this.iIsConfigReadFromArguments = true;
        } else if (!this.iIsMacro) {
            configFile = SettingsFilepath;
            logger.info((Object)("===> Conf: Reading default config [" + configFile + "]"));
        }
        Parameters parameters = null;
        if (configFile != null) {
            parameters = BregmanGLM_Batch.getConfigHandler().LoadFromFile(configFile, Parameters.class, new Parameters());
        } else {
            logger.info((Object)"===> Conf: Setting config to hardcoded default.");
            parameters = new Parameters();
        }
        return parameters;
    }

    private static DataFile<Parameters> getConfigHandler() {
        return new JsonDataFile<Parameters>();
    }

    private void saveConfig(String aFullFileName, Parameters aParams) {
        BregmanGLM_Batch.getConfigHandler().SaveToFile(aFullFileName, aParams);
    }

    private void saveParamitersForCluster(Parameters aParameters) {
        this.saveConfig(ClusterSession.DefaultSettingsFileName, aParameters);
    }

    @Override
    public String[] getMask(ImagePlus aImp) {
        String titleNoExt = SysOps.removeExtension(aImp.getTitle());
        return new String[]{Files.getMovedFilePath(Files.FileType.Mask, titleNoExt, 1), Files.getMovedFilePath(Files.FileType.Mask, titleNoExt, 2)};
    }

    @Override
    public String[] getRegionList(ImagePlus aImp) {
        String titleNoExt = SysOps.removeExtension(aImp.getTitle());
        return new String[]{Files.getMovedFilePath(Files.FileType.ObjectsData, titleNoExt), Files.createTitleWithExt(Files.FileType.ObjectsData, "stitch_")};
    }

    @Override
    public String getName() {
        return PluginName;
    }

    public static enum RunMode {
        CLUSTER,
        LOCAL,
        STOP;

    }

    private static enum DataSource {
        IMAGE,
        WORK_DIR_OR_FILE,
        NONE;

    }
}

