/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import com.google.gson.Gson;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.macro.Interpreter;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import mosaic.core.imageUtils.images.IntensityImage;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.utils.MosaicUtils;
import mosaic.regions.DRS.AlgorithmDRS;
import mosaic.regions.DRS.PluginSettingsDRS;
import mosaic.regions.DRS.SettingsDRS;
import mosaic.regions.GUI.Controller;
import mosaic.regions.GUI.GuiDrs;
import mosaic.regions.RegionsUtils;
import mosaic.regions.energies.ImageModel;
import mosaic.utils.Debug;
import mosaic.utils.ImgUtils;
import mosaic.utils.SysOps;
import mosaic.utils.io.serialize.DataFile;
import mosaic.utils.io.serialize.JsonDataFile;
import org.apache.log4j.Logger;

public class DiscreteRegionSampling
implements PlugInFilter {
    private static final Logger logger = Logger.getLogger(DiscreteRegionSampling.class);
    private static PluginSettingsDRS iMacroSettings = null;
    private PluginSettingsDRS iSettings = null;
    private boolean iNormalizeInputImg = true;
    private boolean iShowGui = true;
    private int iPadSize = 1;
    private ImagePlus iInputImageChosenByUser;
    private ImagePlus iInputLabelImageChosenByUser;
    private GuiDrs iUserGui;
    private LabelImage iLabelImage;
    private ImagePlus iOutputLabelImage;
    private ImagePlus iProbabilityImage;

    public int setup(String aInputArgs, ImagePlus aInputImg) {
        logger.info((Object)"Starting DiscreteRegionSampling");
        this.iInputImageChosenByUser = aInputImg;
        this.initSettingsAndParseMacroOptions();
        return 159;
    }

    public void run(ImageProcessor aIp) {
        this.iShowGui = !IJ.isMacro() && !Interpreter.batchMode;
        logger.info((Object)("showGui: " + this.iShowGui + ", normalize: " + this.iNormalizeInputImg));
        if (this.iShowGui) {
            this.iUserGui = new GuiDrs(this.iSettings, this.iInputImageChosenByUser);
            this.iUserGui.showDialog();
            if (this.iUserGui.wasCanceled()) {
                logger.debug((Object)"Execution cancelled");
                return;
            }
            this.iInputLabelImageChosenByUser = this.iUserGui.getInputLabelImage();
        } else if (this.iSettings.initFileName != null) {
            this.iInputLabelImageChosenByUser = WindowManager.getImage((String)this.iSettings.initFileName);
        }
        logger.info((Object)("Input image [" + this.iInputImageChosenByUser.getTitle() + "]"));
        logger.info((Object)ImgUtils.getImageInfo(this.iInputImageChosenByUser));
        logger.info((Object)("Label image [" + (this.iInputLabelImageChosenByUser != null ? this.iInputLabelImageChosenByUser.getTitle() : "<no file>") + "]"));
        logger.debug((Object)("Settings:\n" + Debug.getJsonString(this.iSettings)));
        DiscreteRegionSampling.getConfigHandler().SaveToFile(this.configFilePath(), this.iSettings);
        if (Recorder.record) {
            Recorder.recordString((String)("call('mosaic.plugins.DiscreteRegionSampling.macroSetup', '" + new Gson().toJson((Object)this.iSettings) + "');\n"));
        }
        if (this.runSegmentation()) {
            this.saveSegmentedImage();
        }
    }

    private void initSettingsAndParseMacroOptions() {
        this.iSettings = iMacroSettings;
        iMacroSettings = null;
        String options = Macro.getOptions();
        logger.info((Object)("Macro Options: [" + options + "]"));
        if (options != null) {
            String path;
            String normalizeString = MosaicUtils.parseString("normalize", options);
            if (normalizeString != null) {
                this.iNormalizeInputImg = Boolean.parseBoolean(normalizeString);
            }
            if (this.iSettings == null && (path = MosaicUtils.parseString("config", options)) != null) {
                logger.debug((Object)"Reading settings from file provided in macro options.");
                this.iSettings = DiscreteRegionSampling.getConfigHandler().LoadFromFile(path, PluginSettingsDRS.class);
            }
        }
        if (this.iSettings == null) {
            logger.debug((Object)("Trying to read config file from default location [" + this.configFilePath() + "]"));
            this.iSettings = DiscreteRegionSampling.getConfigHandler().LoadFromFile(this.configFilePath(), PluginSettingsDRS.class, new PluginSettingsDRS());
        }
    }

    public static void macroSetup(String aSettingsData) {
        logger.info((Object)("macroSetup() run with: [" + aSettingsData + "]"));
        PluginSettingsDRS obj = (PluginSettingsDRS)new Gson().fromJson(aSettingsData, PluginSettingsDRS.class);
        logger.debug((Object)("DRS Settings: [" + obj + "]"));
        iMacroSettings = obj;
    }

    private static DataFile<PluginSettingsDRS> getConfigHandler() {
        return new JsonDataFile<PluginSettingsDRS>();
    }

    private String configFilePath() {
        return SysOps.getTmpPath() + "drs_settings.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runSegmentation() {
        IntensityImage iIntensityImage = RegionsUtils.initInputImage(this.iInputImageChosenByUser, this.iNormalizeInputImg, this.iPadSize);
        if (iIntensityImage == null) {
            return false;
        }
        this.iLabelImage = RegionsUtils.initLabelImage(iIntensityImage, this.iInputImageChosenByUser, this.iInputLabelImageChosenByUser, this.iPadSize, this.iSettings.initType, this.iSettings.initBoxRatio, this.iSettings.initBubblesRadius, this.iSettings.initBubblesDisplacement, this.iSettings.initLocalMaxGaussBlurSigma, this.iSettings.initLocalMaxTolerance, this.iSettings.initLocalMaxBubblesRadius, this.iSettings.initLocalMaxMinimumRegionSize);
        if (this.iLabelImage == null) {
            return false;
        }
        ImageModel iImageModel = RegionsUtils.initEnergies(iIntensityImage, this.iLabelImage, this.iInputImageChosenByUser.getCalibration(), this.iSettings.energyFunctional, 0.0f, this.iSettings.energyPsGaussEnergyRadius, this.iSettings.energyPsBalloonForceCoeff, this.iSettings.regularizationType, this.iSettings.energyCurvatureMaskRadius, this.iSettings.energyContourLengthCoeff);
        Controller iController = new Controller(this.iShowGui);
        SettingsDRS drsSettings = new SettingsDRS(this.iSettings.allowFusion, this.iSettings.allowFission, this.iSettings.allowHandles, this.iSettings.maxNumOfIterations, this.iSettings.offBoundarySampleProbability, this.iSettings.useBiasedProposal, this.iSettings.usePairProposal, this.iSettings.burnInFactor);
        AlgorithmDRS algorithm = new AlgorithmDRS(iIntensityImage, this.iLabelImage, iImageModel, drsSettings);
        int modulo = this.iSettings.maxNumOfIterations / 20;
        if (modulo < 1) {
            modulo = 1;
        }
        boolean isDone = false;
        int iteration = 0;
        try {
            while (iteration < this.iSettings.maxNumOfIterations && !isDone) {
                if (++iteration % modulo == 0) {
                    logger.debug((Object)("Iteration progress: " + iteration * 100 / this.iSettings.maxNumOfIterations + "%"));
                    IJ.showStatus((String)("Iteration: " + iteration + "/" + this.iSettings.maxNumOfIterations));
                    IJ.showProgress((int)iteration, (int)this.iSettings.maxNumOfIterations);
                }
                algorithm.runOneIteration();
                isDone = iController.hasAborted();
            }
        }
        catch (IllegalStateException e) {
            IJ.showMessage((String)("DRS stopped because: " + e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            IJ.showProgress((int)this.iSettings.maxNumOfIterations, (int)this.iSettings.maxNumOfIterations);
            iController.close();
        }
        if (this.iSettings.showProbabilityImage || this.iSettings.saveProbabilityImage) {
            this.iProbabilityImage = algorithm.createProbabilityImage();
            this.iProbabilityImage.setStack(ImgUtils.crop(this.iProbabilityImage.getStack(), this.iPadSize, this.iLabelImage.getNumOfDimensions() > 2));
        }
        if (this.iSettings.showLabelImage || this.iSettings.saveLabelImage) {
            this.iOutputLabelImage = this.iLabelImage.convertToImg("Label");
            this.iOutputLabelImage.setStack(ImgUtils.crop(this.iOutputLabelImage.getStack(), this.iPadSize, this.iLabelImage.getNumOfDimensions() > 2));
        }
        if (this.iSettings.showProbabilityImage) {
            this.iProbabilityImage.show();
        }
        if (this.iSettings.showLabelImage) {
            this.iOutputLabelImage.show();
        }
        return true;
    }

    private void saveSegmentedImage() {
        String directory = ImgUtils.getImageDirectory(this.iInputImageChosenByUser);
        if (directory != null) {
            String fileNameNoExt = SysOps.removeExtension(this.iInputImageChosenByUser.getTitle());
            if (this.iSettings.saveProbabilityImage) {
                this.saveImage(directory, fileNameNoExt, "_prob_c1.tif", this.iProbabilityImage);
            }
            if (this.iSettings.saveLabelImage) {
                this.saveImage(directory, fileNameNoExt, "_seg_c1.tif", this.iOutputLabelImage);
            }
        }
    }

    private void saveImage(String aOutputDir, String aFileNameNoExt, String aTag, ImagePlus aImage) {
        String dirNameProb = aOutputDir + "_" + aTag;
        SysOps.createDir(dirNameProb);
        String outputImgFileName = dirNameProb + "/" + aFileNameNoExt + aTag;
        logger.debug((Object)("Saving file: [" + outputImgFileName + "]"));
        IJ.save((ImagePlus)aImage, (String)outputImgFileName);
    }
}

