/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.process.FloatProcessor;
import mosaic.plugins.utils.CurvatureFilterBase;
import mosaic.utils.ImgUtils;
import mosaic.variationalCurvatureFilters.CurvatureFilter;

public class Inpainting
extends CurvatureFilterBase {
    protected ImagePlus iMask;

    private void superResolution(FloatProcessor aInputIp, FloatProcessor aOriginalIp, CurvatureFilter aFilter, int aNumberOfIterations) {
        int originalWidth = aOriginalIp.getWidth();
        int originalHeight = aOriginalIp.getHeight();
        int roundedWidth = (int)(Math.ceil((double)originalWidth / 2.0) * 2.0);
        int roundedHeight = (int)(Math.ceil((double)originalHeight / 2.0) * 2.0);
        float[][] img = new float[roundedHeight][roundedWidth];
        float maxValueOfPixel = (float)aOriginalIp.getMax();
        if (maxValueOfPixel < 1.0f) {
            maxValueOfPixel = 1.0f;
        }
        ImgUtils.ImgToYX2Darray(aOriginalIp, img, maxValueOfPixel);
        aFilter.runFilter(img, aNumberOfIterations, new CurvatureFilter.Mask(){

            @Override
            public boolean shouldBeProcessed(int x, int y) {
                return Inpainting.this.iMask.getProcessor().getf(x, y) != 0.0f;
            }
        });
        ImgUtils.YX2DarrayToImg(img, aInputIp, maxValueOfPixel);
    }

    @Override
    protected boolean setup(String aArgs) {
        this.setFilePrefix("inpainting_");
        this.updateFlags(31);
        OpenDialog od = new OpenDialog("(Inpainting) Open mask file", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name != null) {
            this.iMask = new Opener().openImage(directory + name);
            int iw = this.iInputImg.getWidth();
            int ih = this.iInputImg.getHeight();
            if (this.iMask.getWidth() != iw || this.iMask.getHeight() != ih) {
                IJ.error((String)("Mask should have same dimensions as input image! Input image: [" + iw + "x" + ih + "] Mask: [" + this.iMask.getWidth() + "x" + this.iMask.getHeight() + "]"));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void processImg(FloatProcessor aOutputImg, FloatProcessor aOrigImg, int aChannelNumber) {
        this.superResolution(aOutputImg, aOrigImg, this.getCurvatureFilter(), this.getNumberOfIterations());
    }
}

