/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Plot;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import mosaic.core.utils.MosaicUtils;
import mosaic.psf2d.PsfRefinement;
import mosaic.psf2d.PsfSampler;
import mosaic.psf2d.PsfSourcePosition;
import mosaic.utils.ArrayOps;
import mosaic.utils.math.MathOps;

public class PSF_Tool
implements PlugInFilter,
MouseListener,
ActionListener,
WindowListener {
    private double radius;
    private double sample_radius;
    private float pix_size;
    private double na;
    private double lambda;
    private float mic_mag;
    private final int mag_fact = 4;
    private int num_of_particles = 0;
    private final int sample_points = 50;
    private boolean select_start = false;
    private PsfRefinement Refine;
    private PsfSampler[] EstimatePSF;
    private float[] PSF;
    private float[] rad;
    private Vector<PsfSourcePosition> Positions;
    private double whm = 0.0;
    private ImagePlus imp;
    private ImageCanvas canvas;
    private ImageProcessor org_ip;
    private ImageProcessor eq;
    private ImageProcessor color;
    private ImageProcessor lastcolor;
    private int[] iArray;
    private final JFrame ui = new JFrame("Point Selection");
    private JButton start;
    private JButton equalize;
    private JButton estimate;
    private JButton report;
    private JPanel button_panel;
    private JPanel checkbox_panel;
    private JTextArea text_panel;
    private JScrollPane scroller;
    private final StringBuffer selections = new StringBuffer();
    private final String centroid = new String("%Centroid Positions:\n%\tx-coord\ty-coord");

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        if (imp == null) {
            IJ.error((String)"You must load an Image first");
            return 4096;
        }
        this.imp = imp;
        return 193;
    }

    public void run(ImageProcessor ip) {
        this.org_ip = ip;
        this.eq = ip;
        this.color = new ColorProcessor(this.org_ip.getWidth(), this.org_ip.getHeight());
        this.lastcolor = new ColorProcessor(this.org_ip.getWidth(), this.org_ip.getHeight());
        this.iArray = new int[3];
        GenericDialog gd = new GenericDialog("Configuration");
        gd.addMessage("Please enter necessary Information");
        gd.addNumericField("Maximum Sampling Radius [Pixel]", 6.0, 2);
        gd.addNumericField("Pixel Size on Camera Chip [um]", 16.0, 2);
        gd.addNumericField("Numerical Aperture of Microscope Objective", 1.3, 3);
        gd.addNumericField("Wavelength of Detected Light [nm]", 532.0, 2);
        gd.addNumericField("Microscope Magnification Factor", 100.0, 2);
        gd.showDialog();
        if (gd.wasCanceled()) {
            IJ.error((String)"PlugIn canceled!");
            return;
        }
        this.radius = 3.0;
        this.sample_radius = gd.getNextNumber();
        this.pix_size = (float)gd.getNextNumber();
        this.na = gd.getNextNumber();
        this.lambda = gd.getNextNumber();
        this.mic_mag = (float)gd.getNextNumber();
        this.Positions = new Vector();
        ImageWindow win = this.imp.getWindow();
        this.canvas = win.getCanvas();
        this.canvas.addMouseListener((MouseListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PSF_Tool.this.userInterface();
            }
        });
    }

    private void showAbout() {
        IJ.showMessage((String)"Point Spread Function Estimation Tool", (String)"An ImageJ Plugin for Point Spread Function Estimation\nWritten by: Benedikt Baumgartner at the Computational Biophysics Lab, ETH Zurich\nVersion: 1.0-Beta Februar, 2007\nRequires: ImageJ 1.36b or higher\n");
    }

    @Override
    public synchronized void mouseClicked(MouseEvent e) {
        if (this.select_start) {
            PsfSourcePosition selected = new PsfSourcePosition(this.canvas.offScreenX(e.getX()), this.canvas.offScreenY(e.getY()));
            this.Refine = new PsfRefinement(this.org_ip, (int)this.radius, selected);
            this.Refine.refineParticlePosition();
            selected = this.Refine.getRefinedParticle();
            this.singlePSF(selected);
            this.selections.setLength(0);
            this.selections.append(this.centroid);
            this.selections.append("\n%\t" + selected.iX + "\t" + selected.iY);
            this.Positions.addElement(selected);
            this.num_of_particles = this.Positions.size();
            JCheckBox chb = new JCheckBox("Refined Centroid Position: " + selected.iX + ", " + selected.iY + "  Width at Half Maximum: " + (double)((int)(this.whm * 100.0)) / 100.0 + " nm");
            chb.setSelected(true);
            this.checkbox_panel.setLayout(new GridLayout(this.num_of_particles, 1));
            this.checkbox_panel.add(chb);
            this.checkbox_panel.updateUI();
            this.color.setColor(Color.RED);
            this.color.drawPixel(Math.round(selected.iX), Math.round(selected.iY));
            this.imp.updateAndDraw();
        }
    }

    @Override
    public synchronized void mouseEntered(MouseEvent e) {
    }

    @Override
    public synchronized void mouseExited(MouseEvent e) {
    }

    @Override
    public synchronized void mousePressed(MouseEvent e) {
    }

    @Override
    public synchronized void mouseReleased(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.start) {
            this.selections.setLength(0);
            this.selections.append(this.centroid);
            this.eq = this.org_ip.duplicate();
            this.Positions.removeAllElements();
            this.num_of_particles = 0;
            this.text_panel.setText("Click on Point Source in Image now!");
            this.text_panel.append("\nYour Selections:");
            this.checkbox_panel.removeAll();
            this.checkbox_panel.updateUI();
            this.select_start = true;
            this.eq.convertToRGB();
            this.lastcolor.insert(this.eq, 0, 0);
            this.color.insert(this.eq, 0, 0);
            this.imp.setProcessor("Point Source Selection", this.color);
            this.imp.updateAndDraw();
        }
        if (source == this.equalize) {
            this.eq = this.enhanceContrast();
            this.eq.convertToRGB();
            this.lastcolor.insert(this.eq, 0, 0);
            this.color.insert(this.eq, 0, 0);
            this.imp.setProcessor("Point Source Selection", this.color);
            this.imp.updateAndDraw();
        }
        if (source == this.estimate) {
            if (this.Positions.isEmpty()) {
                IJ.error((String)"Please select point source before refinement!");
            } else {
                int i;
                this.deleteUnchecked();
                if (this.num_of_particles == 0) {
                    return;
                }
                this.selections.setLength(0);
                for (int i2 = 0; i2 < this.PSF.length; ++i2) {
                    this.PSF[i2] = 0.0f;
                }
                this.selections.append(this.centroid);
                PsfSourcePosition[] particles = new PsfSourcePosition[this.num_of_particles];
                this.EstimatePSF = new PsfSampler[this.num_of_particles];
                for (i = 0; i < this.num_of_particles; ++i) {
                    particles[i] = this.Positions.elementAt(i);
                    this.selections.append("\n%" + (i + 1) + ":\t" + particles[i].iX + "\t" + particles[i].iY);
                    this.EstimatePSF[i] = new PsfSampler(this.org_ip, particles[i], (int)this.sample_radius, 50, 4, this.mic_mag, this.pix_size);
                    float[] PSFtmp = this.EstimatePSF[i].getPsf();
                    for (int j = 0; j < PSFtmp.length; ++j) {
                        this.PSF[j] = this.PSF[j] + PSFtmp[j];
                    }
                }
                for (i = 0; i < this.PSF.length; ++i) {
                    this.PSF[i] = this.PSF[i] / (float)this.num_of_particles;
                }
                ArrayOps.normalize(this.PSF);
                this.rad = this.EstimatePSF[0].getRadius();
                this.whm = this.widthAtHalfMaximum();
                this.text_panel.setText("PSF estimation done. Continue by starting a new selection!");
                this.drawPSF("PSF");
            }
        }
        if (source == this.report) {
            SaveDialog sd = new SaveDialog("Save report", IJ.getDirectory((String)"image"), "PSF_Report.txt");
            if (sd.getDirectory() == null || sd.getFileName() == null) {
                return;
            }
            MosaicUtils.write2File(sd.getDirectory(), sd.getFileName(), this.getFullReport().toString());
            return;
        }
    }

    private void deleteUnchecked() {
        Component[] components = this.checkbox_panel.getComponents();
        for (int i = components.length - 1; i >= 0; --i) {
            JCheckBox cb = (JCheckBox)components[i];
            if (cb.isSelected()) continue;
            --this.num_of_particles;
            PsfSourcePosition last = this.Positions.elementAt(i);
            this.Positions.removeElementAt(i);
            this.iArray = this.lastcolor.getPixel(Math.round(last.iX), Math.round(last.iY), this.iArray);
            this.color.putPixel(Math.round(last.iX), Math.round(last.iY), this.iArray);
            this.imp.updateAndDraw();
            this.checkbox_panel.remove(cb);
        }
        this.checkbox_panel.updateUI();
    }

    void userInterface() {
        this.ui.setLayout(new BorderLayout());
        this.start = new JButton("Start New Selection");
        this.equalize = new JButton("Enhance Contrast");
        this.estimate = new JButton("Estimate PSF");
        this.report = new JButton("Create Report");
        this.start.addActionListener(this);
        this.equalize.addActionListener(this);
        this.estimate.addActionListener(this);
        this.report.addActionListener(this);
        this.button_panel = new JPanel(new GridLayout(2, 2));
        this.button_panel.add(this.start);
        this.button_panel.add(this.equalize);
        this.button_panel.add(this.estimate);
        this.button_panel.add(this.report);
        this.checkbox_panel = new JPanel();
        this.checkbox_panel.setLayout(new GridLayout(1, 1));
        this.text_panel = new JTextArea("Start by clicking on \"Start New Selection\"");
        this.text_panel.setEditable(false);
        this.scroller = new JScrollPane(this.checkbox_panel);
        this.ui.getContentPane().add((Component)this.text_panel, "North");
        this.ui.getContentPane().add((Component)this.scroller, "Center");
        this.ui.getContentPane().add((Component)this.button_panel, "South");
        this.ui.setSize(500, 250);
        this.ui.setLocation(300, 200);
        this.ui.setVisible(true);
        this.ui.addWindowListener(this);
    }

    private void singlePSF(PsfSourcePosition single_part) {
        PsfSampler single_estimate = new PsfSampler(this.org_ip, single_part, (int)this.sample_radius, 50, 4, this.mic_mag, this.pix_size);
        this.PSF = single_estimate.getPsf();
        this.rad = single_estimate.getRadius();
        this.whm = this.widthAtHalfMaximum();
        this.drawPSF("PSF of Last Selection");
    }

    private double widthAtHalfMaximum() {
        double d = 0.5;
        if ((double)this.PSF[0] < 0.5) {
            return 0.0;
        }
        int v = 0;
        while ((double)this.PSF[v] > 0.5) {
            ++v;
        }
        double p0 = this.PSF[v - 1];
        double p1 = this.PSF[v];
        double r0 = this.rad[v - 1];
        double r1 = this.rad[v];
        this.whm = r0 + (r1 - r0) / (p1 - p0) * (0.5 - p0);
        return this.whm;
    }

    private void drawPSF(String title) {
        Plot plotWin = new Plot(title, "Radius [nm]", "Intensity", this.rad, this.PSF);
        plotWin.setLimits(0.0, (double)this.rad[this.rad.length - 1], 0.0, 1.0);
        double[] r = new double[this.rad.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.rad[i];
        }
        double[] thpsf = this.theoreticalPSF();
        plotWin.setColor(Color.BLACK);
        plotWin.addLabel(0.5, 0.4, "Theoretical PSF");
        plotWin.addPoints(r, thpsf, 2);
        plotWin.setColor(Color.BLUE);
        if (this.whm != 0.0) {
            plotWin.setColor(Color.BLUE);
            plotWin.addLabel(0.5, 0.25, "Width at Half Maximum: " + (double)((int)(this.whm * 100.0)) / 100.0 + " nm");
            double[] x = new double[2];
            double[] y = new double[2];
            x[0] = 0.0;
            x[1] = this.whm;
            y[0] = 0.5;
            y[1] = 0.5;
            plotWin.addPoints(x, y, 2);
        }
        plotWin.show();
    }

    private double[] theoreticalPSF() {
        double arg = Math.PI * 2 * this.na / this.lambda;
        double[] b = new double[this.rad.length];
        for (int i = 0; i < this.rad.length; ++i) {
            double barg = arg * (double)this.rad[i];
            b[i] = 2.0 * MathOps.bessel1(barg) / barg * (2.0 * MathOps.bessel1(barg) / barg);
        }
        b[0] = 1.0;
        return b;
    }

    private ImageProcessor enhanceContrast() {
        int p;
        int u;
        int v;
        int max = 0;
        int min = 255;
        int c = 0;
        int w = this.eq.getWidth();
        int h = this.eq.getHeight();
        for (v = 0; v < h; ++v) {
            for (u = 0; u < w; ++u) {
                p = this.eq.getPixel(u, v);
                if (p > max) {
                    max = p;
                }
                if (p >= min) continue;
                min = p;
            }
        }
        c = max - min;
        for (v = 0; v < h; ++v) {
            for (u = 0; u < w; ++u) {
                p = this.eq.getPixel(u, v);
                int q = (p - min) * 255 / c;
                this.eq.putPixel(u, v, q);
            }
        }
        return this.eq;
    }

    private StringBuffer getConfiguration() {
        StringBuffer configuration = new StringBuffer("%User Configuration:\n");
        configuration.append("%Apparent Radius of Point Sources [Pixel]:\t");
        configuration.append(this.radius + "\n");
        configuration.append("%Maximum Sampling Radius [Pixel]:\t");
        configuration.append(this.sample_radius + "\n");
        configuration.append("%Pixel Size on Chip [um]:\t");
        configuration.append(this.pix_size + "\n");
        configuration.append("%Numerical Aperture:\t");
        configuration.append(this.na + "\n");
        configuration.append("%Wavelength [nm]:\t");
        configuration.append(this.lambda + "\n");
        configuration.append("%Microscope Magnification Factor:\t");
        configuration.append(this.mic_mag + "\n");
        configuration.append("%Pixel Magnification:\t");
        configuration.append("4\n");
        configuration.append("%Number of Sample Points:\t");
        configuration.append("50\n");
        return configuration;
    }

    private StringBuffer getPSFdata() {
        StringBuffer PSFdata = new StringBuffer("%PSF Data:\n");
        PSFdata.append("%\tRadius [nm]\t\tValue\n");
        for (int i = 0; i < this.PSF.length; ++i) {
            PSFdata.append("\t" + this.rad[i] + "\t\t" + this.PSF[i] + "\n");
        }
        PSFdata.append("%\n");
        PSFdata.append("%Width at half maximum [nm]:\t" + (double)((int)(this.whm * 100.0)) / 100.0 + "\n");
        return PSFdata;
    }

    private StringBuffer getFullReport() {
        StringBuffer report = new StringBuffer();
        report.append(this.getConfiguration());
        report.append("\n");
        report.append(this.selections);
        if (this.PSF != null) {
            report.append("\n\n");
            report.append(this.getPSFdata().toString());
        }
        report.append("\n");
        if (this.EstimatePSF != null) {
            for (int i = 0; i < this.EstimatePSF.length; ++i) {
                report.append("\n\n%Point Source " + (i + 1) + ":");
                report.append(this.EstimatePSF[i].getPsfReport());
            }
        } else {
            report.append("Press Button \"Estimate PSF\" before creating the report file to get more detailed results!");
        }
        return report;
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        this.ui.setVisible(false);
        this.ui.dispose();
        this.canvas.removeMouseListener((MouseListener)this);
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }
}

