/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.plugin.ZProjector;
import ij.plugin.filter.Convolver;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class PSF_estimator_3D
implements PlugInFilter {
    private final int mMaskRadius = 5;
    protected double mRInc = 0.001;
    private final double mPhiInc = 0.15707963267948966;
    protected int mRMaxInNm = 800;
    protected int mZMaxInNm = 1600;
    protected int mMapSizeR = 1000;
    protected int mMapSizeZ = 1000;
    private final float mGaussPreprocessRadius = 1.0f;
    private int[][][] mMask;
    protected int mHeight;
    protected int mWidth;
    protected int mNSlices;
    private float mGlobalMin;
    private float mGlobalMax;
    protected double mPxWidthInNm;
    protected double mPxDepthInNm;
    protected ImagePlus mZProjectedImagePlus;
    private ImagePlus mOriginalImagePlus;
    private ImageStack mPreprocessedFrameImage;
    private int mPreprocessedFrameNb = 0;
    protected final Vector<Bead> mBeads = new Vector();
    protected ImagePlus mBeadImage;

    public int setup(String arg, ImagePlus aOrigImp) {
        if (aOrigImp == null) {
            IJ.showMessage((String)"Please open an image with beads first.");
            return 4096;
        }
        while (true) {
            String vUnit;
            if ((vUnit = aOrigImp.getCalibration().getUnit()).equals("nm")) {
                this.mPxWidthInNm = aOrigImp.getCalibration().pixelWidth;
                this.mPxDepthInNm = aOrigImp.getCalibration().pixelDepth;
                break;
            }
            if (vUnit.equals("\u00b5m")) {
                this.mPxWidthInNm = aOrigImp.getCalibration().pixelWidth * 1000.0;
                this.mPxDepthInNm = aOrigImp.getCalibration().pixelDepth * 1000.0;
                break;
            }
            if (vUnit.equals("mm")) {
                this.mPxWidthInNm = aOrigImp.getCalibration().pixelWidth * 1000000.0;
                this.mPxDepthInNm = aOrigImp.getCalibration().pixelDepth * 1000000.0;
                break;
            }
            IJ.showMessage((String)"Please enter correct voxel sizes in nm, \u00b5m or mm");
            IJ.run((String)"Properties...");
        }
        this.mOriginalImagePlus = aOrigImp;
        this.mHeight = aOrigImp.getHeight();
        this.mWidth = aOrigImp.getWidth();
        this.mNSlices = aOrigImp.getNSlices();
        if (!this.getUserDefinedParams()) {
            return 4096;
        }
        this.mRInc = 1.0 / ((double)this.mMapSizeR * 1.1);
        StackStatistics vSS = new StackStatistics(aOrigImp);
        this.mGlobalMin = (float)vSS.min;
        this.mGlobalMax = (float)vSS.max;
        this.mMask = this.generateMask(5);
        this.doZProjection(this.mOriginalImagePlus);
        this.initVisualization();
        return 4096;
    }

    public void run(ImageProcessor ip) {
    }

    private boolean registerOrDeleteNewBeadAt(int aX, int aY) {
        int vFrame = this.mZProjectedImagePlus.getCurrentSlice();
        if (this.mPreprocessedFrameNb != vFrame) {
            this.mPreprocessedFrameImage = PSF_estimator_3D.getAFrameCopy(this.mOriginalImagePlus, vFrame);
            this.normalizeFrameFloat(this.mPreprocessedFrameImage);
            this.gaussBlur3D(this.mPreprocessedFrameImage, 1.0f);
            this.boxCarBackgroundSubtractor(this.mPreprocessedFrameImage);
            this.mPreprocessedFrameNb = vFrame;
        }
        double[] vCentroid = this.centroidDetectionRefinement(this.mPreprocessedFrameImage, aX, aY, this.getBrightestSliceIndexAt(aX, aY, this.mPreprocessedFrameImage));
        for (int vB = 0; vB < this.mBeads.size(); ++vB) {
            if (!(Math.abs(this.mBeads.elementAt((int)vB).mCentroidX - vCentroid[0]) < 0.5) || !(Math.abs(this.mBeads.elementAt((int)vB).mCentroidY - vCentroid[1]) < 0.5) || vFrame != this.mBeads.elementAt((int)vB).mFrame) continue;
            this.mBeads.removeElementAt(vB);
            return false;
        }
        ImageStack vIS = PSF_estimator_3D.getAFrameCopy(this.mOriginalImagePlus, vFrame);
        this.mBeads.add(new Bead(vCentroid[0], vCentroid[1], vCentroid[2], vFrame, vIS));
        Bead meanBead = this.meanBeads(this.mBeads);
        meanBead.thresholdPSFMap(0.005f);
        meanBead.showBead();
        return true;
    }

    private void boxCarBackgroundSubtractor(ImageStack is) {
        Convolver convolver = new Convolver();
        float[] kernel = new float[11];
        int n = kernel.length;
        for (int i = 0; i < kernel.length; ++i) {
            kernel[i] = 1.0f / (float)n;
        }
        for (int s = 1; s <= is.getSize(); ++s) {
            ImageProcessor bg_proc = is.getProcessor(s).duplicate();
            convolver.convolveFloat(bg_proc, kernel, 1, n);
            convolver.convolveFloat(bg_proc, kernel, n, 1);
            is.getProcessor(s).copyBits(bg_proc, 0, 0, 4);
        }
    }

    private double[] centroidDetectionRefinement(ImageStack aIS, float aX, float aY, float aZ) {
        double vEpsX = 1.0;
        double vEpsY = 1.0;
        double vEpsZ = 1.0;
        int vRadius = 5;
        int vCounter = 10;
        for (int s = 0; s < aIS.getSize(); ++s) {
            float[] pixels = (float[])aIS.getPixels(s + 1);
            for (int i = 0; i < pixels.length; ++i) {
                if (!(pixels[i] < 0.0f)) continue;
                pixels[i] = 0.0f;
            }
        }
        while (vCounter > 0 && (vEpsX > 0.5 || vEpsX < -0.5 || vEpsY > 0.5 || vEpsY < -0.5 || vEpsZ < 0.5 || vEpsZ > 0.5)) {
            --vCounter;
            float vM0 = 0.0f;
            vEpsX = 0.0;
            vEpsY = 0.0;
            vEpsZ = 0.0;
            for (int vS = -5; vS <= 5; ++vS) {
                if ((int)aZ + vS < 0 || (int)aZ + vS >= aIS.getSize()) continue;
                int vZ = (int)aZ + vS;
                for (int vV = -5; vV <= 5; ++vV) {
                    if ((int)aY + vV < 0 || (int)aY + vV >= aIS.getHeight()) continue;
                    int vY = (int)aY + vV;
                    for (int vU = -5; vU <= 5; ++vU) {
                        if (aX + (float)vU < 0.0f || (int)aX + vU >= aIS.getWidth()) continue;
                        int vX = (int)aX + vU;
                        float vPxVal = aIS.getProcessor(vZ + 1).getPixelValue(vX, vY) * (float)this.mMask[vS + 5][vV + 5][vU + 5];
                        vM0 += vPxVal;
                        vEpsX += (double)((float)vU * vPxVal);
                        vEpsY += (double)((float)vV * vPxVal);
                        vEpsZ += (double)((float)vS * vPxVal);
                    }
                }
            }
            if (vCounter <= 0) {
                System.out.println("no convergence in centroid detection!");
            }
            int tx = (int)(10.0 * (vEpsX /= (double)vM0));
            int ty = (int)(10.0 * (vEpsY /= (double)vM0));
            int tz = (int)(10.0 * (vEpsZ /= (double)vM0));
            if ((double)tx / 10.0 > 0.5) {
                if ((int)aX + 1 < aIS.getHeight()) {
                    aX += 1.0f;
                }
            } else if ((double)tx / 10.0 < -0.5 && (int)aX - 1 >= 0) {
                aX -= 1.0f;
            }
            if ((double)ty / 10.0 > 0.5) {
                if ((int)aY + 1 < aIS.getWidth()) {
                    aY += 1.0f;
                }
            } else if ((double)ty / 10.0 < -0.5 && (int)aY - 1 >= 0) {
                aY -= 1.0f;
            }
            if ((double)tz / 10.0 > 0.5) {
                if ((int)aZ + 1 < aIS.getSize()) {
                    aZ += 1.0f;
                }
            } else if ((double)tz / 10.0 < -0.5 && (int)aZ - 1 >= 0) {
                aZ -= 1.0f;
            }
            if (!((double)tx / 10.0 <= 0.5) || !((double)tx / 10.0 >= -0.5) || !((double)ty / 10.0 <= 0.5) || !((double)ty / 10.0 >= -0.5) || !((double)tz / 10.0 <= 0.5) || !((double)tz / 10.0 >= -0.5)) continue;
            break;
        }
        return new double[]{(double)aX + vEpsX + 0.5, (double)aY + vEpsY + 0.5, (double)aZ + vEpsZ + 0.5};
    }

    private int[][][] generateMask(int mask_radius) {
        int width = 2 * mask_radius + 1;
        int[][][] vMask = new int[width][width][width];
        for (int s = -mask_radius; s <= mask_radius; ++s) {
            for (int i = -mask_radius; i <= mask_radius; ++i) {
                for (int j = -mask_radius; j <= mask_radius; ++j) {
                    vMask[s + mask_radius][j + mask_radius][i + mask_radius] = i * i + j * j + s * s <= mask_radius * mask_radius ? 1 : 0;
                }
            }
        }
        return vMask;
    }

    private void normalizeFrameFloat(ImageStack is) {
        for (int s = 1; s <= is.getSize(); ++s) {
            float[] pixels = (float[])is.getPixels(s);
            for (int i = 0; i < pixels.length; ++i) {
                float tmp_pix_value;
                pixels[i] = tmp_pix_value = (pixels[i] - this.mGlobalMin) / (this.mGlobalMax - this.mGlobalMin);
            }
        }
    }

    private void gaussBlur3D(ImageStack is, float aRadius) {
        float[] vKernel = this.CalculateNormalizedGaussKernel(aRadius);
        int kernel_radius = vKernel.length / 2;
        int nSlices = is.getSize();
        int vWidth = is.getWidth();
        for (int i = 1; i <= nSlices; ++i) {
            ImageProcessor restored_proc = is.getProcessor(i);
            Convolver convolver = new Convolver();
            convolver.setNormalize(false);
            convolver.convolve(restored_proc, vKernel, vKernel.length, 1);
            convolver.convolve(restored_proc, vKernel, 1, vKernel.length);
        }
        if (is.getSize() == 1) {
            return;
        }
        kernel_radius = vKernel.length / 2;
        float[][] vOrigProcessors = new float[nSlices][];
        float[][] vRestoredProcessors = new float[nSlices][];
        for (int s = 0; s < nSlices; ++s) {
            vOrigProcessors[s] = (float[])is.getProcessor(s + 1).getPixelsCopy();
            vRestoredProcessors[s] = (float[])is.getProcessor(s + 1).getPixels();
        }
        for (int y = kernel_radius; y < is.getHeight() - kernel_radius; ++y) {
            for (int x = kernel_radius; x < is.getWidth() - kernel_radius; ++x) {
                for (int s = kernel_radius + 1; s <= is.getSize() - kernel_radius; ++s) {
                    float sum = 0.0f;
                    for (int i = -kernel_radius; i <= kernel_radius; ++i) {
                        sum += vKernel[i + kernel_radius] * vOrigProcessors[s + i - 1][y * vWidth + x];
                    }
                    vRestoredProcessors[s - 1][y * vWidth + x] = sum;
                }
            }
        }
    }

    private float[] CalculateNormalizedGaussKernel(float aRadius) {
        int vL = (int)aRadius * 3 * 2 + 1;
        if (vL < 3) {
            vL = 3;
        }
        float[] vKernel = new float[vL];
        int vM = vKernel.length / 2;
        for (int vI = 0; vI < vM; ++vI) {
            vKernel[vI] = (float)(1.0 / (Math.PI * 2 * (double)aRadius * (double)aRadius) * Math.exp(-((float)((vM - vI) * (vM - vI))) / (2.0f * aRadius * aRadius)));
            vKernel[vKernel.length - vI - 1] = vKernel[vI];
        }
        vKernel[vM] = (float)(1.0 / (Math.PI * 2 * (double)aRadius * (double)aRadius));
        float vSum = 0.0f;
        for (int vI = 0; vI < vKernel.length; ++vI) {
            vSum += vKernel[vI];
        }
        float vScale = 1.0f / vSum;
        int vI = 0;
        while (vI < vKernel.length) {
            int n = vI++;
            vKernel[n] = vKernel[n] * vScale;
        }
        return vKernel;
    }

    private static ImageStack getAFrameCopy(ImagePlus aMovie, int aFrameNumber) {
        if (aFrameNumber > aMovie.getNFrames() || aFrameNumber < 1) {
            throw new IllegalArgumentException("frame number = " + aFrameNumber);
        }
        int vS = aMovie.getNSlices();
        return PSF_estimator_3D.getSubStackFloatCopy(aMovie.getStack(), (aFrameNumber - 1) * vS + 1, aFrameNumber * vS);
    }

    private static ImageStack getSubStackFloatCopy(ImageStack is, int startPos, int endPos) {
        ImageStack res = new ImageStack(is.getWidth(), is.getHeight());
        if (startPos > endPos || startPos < 0 || endPos < 0) {
            return null;
        }
        for (int i = startPos; i <= endPos; ++i) {
            res.addSlice(is.getSliceLabel(i), is.getProcessor(i).convertToFloat().duplicate());
        }
        return res;
    }

    private void doZProjection(ImagePlus aIMP) {
        ImageStack vZProjectedStack = new ImageStack(this.mWidth, this.mHeight);
        ZProjector vZProjector = new ZProjector(aIMP);
        vZProjector.setMethod(1);
        for (int vC = 0; vC < aIMP.getNFrames(); ++vC) {
            vZProjector.setStartSlice(vC * this.mNSlices + 1);
            vZProjector.setStopSlice((vC + 1) * this.mNSlices);
            vZProjector.doProjection();
            vZProjectedStack.addSlice("", vZProjector.getProjection().getProcessor());
        }
        this.mZProjectedImagePlus = new ImagePlus("Z-Projected " + aIMP.getTitle(), vZProjectedStack);
        this.mZProjectedImagePlus.repaintWindow();
    }

    private int getBrightestSliceIndexAt(int aX, int aY, ImageStack aIS) {
        float vMaxInt = 0.0f;
        int vMaxSlice = 0;
        for (int vZ = 0; vZ < this.mNSlices; ++vZ) {
            float f;
            float vThisInt = aIS.getProcessor(vZ + 1).getf(aX, aY);
            if (!(f > vMaxInt)) continue;
            vMaxInt = vThisInt;
            vMaxSlice = vZ;
        }
        return vMaxSlice;
    }

    private void initVisualization() {
        DrawCanvas vDrawCanvas = new DrawCanvas(this.mZProjectedImagePlus);
        new TrajectoryStackWindow(this.mZProjectedImagePlus, vDrawCanvas);
    }

    private Bead meanBeads(Vector<Bead> aBeads) {
        double[][] vMeanMap = new double[this.mMapSizeZ][this.mMapSizeR];
        int[][] vMeanMapScaler = new int[this.mMapSizeZ][this.mMapSizeR];
        for (int vZ = 0; vZ < this.mMapSizeZ; ++vZ) {
            for (int vR = 0; vR < this.mMapSizeR; ++vR) {
                vMeanMap[vZ][vR] = 0.0;
                vMeanMapScaler[vZ][vR] = 0;
            }
        }
        for (Bead vB : aBeads) {
            double[][] vBeadMap = vB.getPSFMap();
            for (int vZ = 0; vZ < this.mMapSizeZ; ++vZ) {
                for (int vR = 0; vR < this.mMapSizeR; ++vR) {
                    if (!(vBeadMap[vZ][vR] > 0.0)) continue;
                    double[] dArray = vMeanMap[vZ];
                    int n = vR;
                    dArray[n] = dArray[n] + vBeadMap[vZ][vR];
                    int[] nArray = vMeanMapScaler[vZ];
                    int n2 = vR;
                    nArray[n2] = nArray[n2] + 1;
                }
            }
        }
        for (int vZ = 0; vZ < this.mMapSizeZ; ++vZ) {
            for (int vR = 0; vR < this.mMapSizeR; ++vR) {
                if (vMeanMapScaler[vZ][vR] > 0) {
                    double[] dArray = vMeanMap[vZ];
                    int n = vR;
                    dArray[n] = dArray[n] / (double)vMeanMapScaler[vZ][vR];
                    continue;
                }
                vMeanMap[vZ][vR] = 0.0;
            }
        }
        return new Bead(vMeanMap);
    }

    protected void mouseClicked(int aXCoord, int aYCoord) {
        if (IJ.shiftKeyDown()) {
            this.registerOrDeleteNewBeadAt(aXCoord, aYCoord);
            this.mZProjectedImagePlus.repaintWindow();
        }
    }

    private boolean getUserDefinedParams() {
        GenericDialog gd = new GenericDialog("Configuration");
        gd.addMessage("Pease make sure to have correctly set the\n pixel size in nm in the image properties");
        gd.addMessage("--------");
        gd.addMessage("Please enter necessary Information");
        gd.addNumericField("Maximum lateral sampling radius[nm]", (double)this.mRMaxInNm, 0);
        gd.addNumericField("Maximum axial sampling radius[nm]", (double)this.mZMaxInNm, 0);
        gd.addNumericField("Final lateral PSF map size [px]", (double)this.mMapSizeR, 0);
        gd.addNumericField("Final axial PSF map size [px]", (double)this.mMapSizeZ, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.mRMaxInNm = (int)gd.getNextNumber();
        this.mZMaxInNm = (int)gd.getNextNumber();
        this.mMapSizeR = (int)gd.getNextNumber();
        this.mMapSizeZ = (int)gd.getNextNumber();
        return true;
    }

    private class TrajectoryStackWindow
    extends StackWindow
    implements MouseListener {
        private static final long serialVersionUID = 1L;

        public TrajectoryStackWindow(ImagePlus aIMP, ImageCanvas aIC) {
            super(aIMP, aIC);
            aIC.addMouseListener((MouseListener)this);
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent aE) {
            PSF_estimator_3D.this.mouseClicked(this.ic.offScreenX(aE.getPoint().x), this.ic.offScreenY(aE.getPoint().y));
        }
    }

    private class DrawCanvas
    extends ImageCanvas {
        private static final long serialVersionUID = 1L;

        public DrawCanvas(ImagePlus aImagePlus) {
            super(aImagePlus);
        }

        public void paint(Graphics aG) {
            super.paint(aG);
            int vFrame = PSF_estimator_3D.this.mZProjectedImagePlus.getCurrentSlice();
            aG.setColor(Color.red);
            for (Bead vBead : PSF_estimator_3D.this.mBeads) {
                if (vBead.mFrame != vFrame) continue;
                int vX = (int)Math.round(vBead.mCentroidX * this.magnification);
                int vY = (int)Math.round(vBead.mCentroidY * this.magnification);
                aG.drawLine(vX - 5, vY, vX + 5, vY);
                aG.drawLine(vX, vY - 5, vX, vY + 5);
            }
        }
    }

    private class Bead {
        double mCentroidX = -1.0;
        double mCentroidY = -1.0;
        double mCentroidZ = -1.0;
        int mFrame = -1;
        double[][] mPSFMap;

        public Bead(double aX, double aY, double aZ, int aFrame, ImageStack aIS) {
            this.mCentroidX = aX;
            this.mCentroidY = aY;
            this.mCentroidZ = aZ;
            this.mFrame = aFrame;
            double[] vCentroid = new double[]{this.mCentroidX, this.mCentroidY, this.mCentroidZ};
            System.out.println("Centroid: x = " + this.mCentroidX + ", y = " + this.mCentroidY + "z = " + this.mCentroidZ);
            this.mPSFMap = this.generatePSFmap(aIS, vCentroid, PSF_estimator_3D.this.mRMaxInNm, PSF_estimator_3D.this.mZMaxInNm, PSF_estimator_3D.this.mMapSizeR, PSF_estimator_3D.this.mMapSizeZ);
            this.normalizePSFMap();
        }

        public Bead(double[][] meanMap) {
            this.mPSFMap = meanMap;
        }

        public void showBead(double[][] aPSFmap) {
            float[][] vMap = new float[aPSFmap.length][aPSFmap[0].length];
            for (int vZ = 0; vZ < aPSFmap.length; ++vZ) {
                for (int vR = 0; vR < aPSFmap[0].length; ++vR) {
                    vMap[vZ][vR] = (float)aPSFmap[vZ][vR];
                }
            }
            if (PSF_estimator_3D.this.mBeadImage != null) {
                PSF_estimator_3D.this.mBeadImage.changes = false;
                PSF_estimator_3D.this.mBeadImage.close();
            }
            PSF_estimator_3D.this.mBeadImage = new ImagePlus("bsp map", (ImageProcessor)new FloatProcessor(vMap));
            PSF_estimator_3D.this.mBeadImage.getCalibration().setUnit("nm");
            PSF_estimator_3D.this.mBeadImage.getCalibration().pixelWidth = 2.0f * (float)PSF_estimator_3D.this.mZMaxInNm / (float)PSF_estimator_3D.this.mMapSizeZ;
            PSF_estimator_3D.this.mBeadImage.getCalibration().pixelHeight = (float)PSF_estimator_3D.this.mRMaxInNm / (float)PSF_estimator_3D.this.mMapSizeR;
            PSF_estimator_3D.this.mBeadImage.show();
        }

        public void showBead() {
            this.showBead(this.mPSFMap);
        }

        protected void thresholdPSFMap(float aPercentile) {
            int vJ;
            int vI;
            double vMin = Double.MAX_VALUE;
            double vMax = Double.MIN_VALUE;
            for (vI = 0; vI < this.mPSFMap.length; ++vI) {
                for (vJ = 0; vJ < this.mPSFMap[0].length; ++vJ) {
                    if (this.mPSFMap[vI][vJ] < vMin) {
                        vMin = this.mPSFMap[vI][vJ];
                    }
                    if (!(this.mPSFMap[vI][vJ] > vMax)) continue;
                    vMax = this.mPSFMap[vI][vJ];
                }
            }
            for (vI = 0; vI < this.mPSFMap.length; ++vI) {
                vJ = 0;
                while (vJ < this.mPSFMap[0].length) {
                    double[] dArray = this.mPSFMap[vI];
                    int n = vJ++;
                    dArray[n] = dArray[n] - vMin;
                }
            }
            vMax -= vMin;
            for (vI = 0; vI < this.mPSFMap.length; ++vI) {
                for (vJ = 0; vJ < this.mPSFMap[0].length; ++vJ) {
                    double vNewVal = this.mPSFMap[vI][vJ] - (double)aPercentile * vMax;
                    this.mPSFMap[vI][vJ] = vNewVal < 0.0 ? 0.0 : vNewVal;
                }
            }
        }

        protected void normalizePSFMap() {
            int vJ;
            int vI;
            float vSum = 0.0f;
            for (vI = 0; vI < this.mPSFMap.length; ++vI) {
                for (vJ = 0; vJ < this.mPSFMap[0].length; ++vJ) {
                    vSum = (float)((double)vSum + this.mPSFMap[vI][vJ]);
                }
            }
            for (vI = 0; vI < this.mPSFMap.length; ++vI) {
                vJ = 0;
                while (vJ < this.mPSFMap[0].length) {
                    double[] dArray = this.mPSFMap[vI];
                    int n = vJ++;
                    dArray[n] = dArray[n] / (double)vSum;
                }
            }
        }

        protected boolean interpolatePSFmap(double[][] aMap) {
            Vector<Integer> vValuableZIndices = new Vector<Integer>();
            block0: for (int vZ = 0; vZ < aMap.length; ++vZ) {
                for (int vR = 0; vR < aMap[vZ].length; ++vR) {
                    if (!(aMap[vZ][vR] > 0.0)) continue;
                    vValuableZIndices.add(vZ);
                    continue block0;
                }
            }
            for (int vR = 0; vR < aMap[0].length; ++vR) {
                float[] vNodeX = new float[vValuableZIndices.size()];
                float[] vNodeY = new float[vValuableZIndices.size()];
                for (int vI = 0; vI < vValuableZIndices.size(); ++vI) {
                    vNodeX[vI] = ((Integer)vValuableZIndices.elementAt(vI)).intValue();
                    vNodeY[vI] = (float)aMap[(Integer)vValuableZIndices.elementAt(vI)][vR];
                }
                if (vValuableZIndices.isEmpty()) continue;
                for (int vZ = ((Integer)vValuableZIndices.elementAt(0)).intValue(); vZ <= (Integer)vValuableZIndices.lastElement(); ++vZ) {
                    if (aMap[vZ][vR] > 0.0) continue;
                    aMap[vZ][vR] = this.interpolateLinear(vZ, vNodeX, vNodeY);
                }
            }
            return true;
        }

        protected double[][] generatePSFmap(ImageStack aIS, double[] aCentroid, float aRMaxDist, float aZMaxDist, int aMapSizeR, int aMapSizeZ) {
            double[][] vPSFmap = this.generatePSFmapSparse(aIS, aCentroid, aRMaxDist, aZMaxDist, aMapSizeR, aMapSizeZ);
            if (!this.checkSparseMap(vPSFmap)) {
                IJ.showMessage((String)"Too small sampling rate !!");
            }
            this.interpolatePSFmap(vPSFmap);
            return vPSFmap;
        }

        protected boolean checkSparseMap(double[][] aMap) {
            for (int vR = 0; vR < aMap[0].length; ++vR) {
                boolean vFoundNonZeroValue = false;
                for (int vZ = 0; vZ < aMap.length; ++vZ) {
                    if (!(aMap[vZ][vR] > 0.0)) continue;
                    vFoundNonZeroValue = true;
                }
                if (vFoundNonZeroValue) continue;
                return false;
            }
            return true;
        }

        protected double[][] generatePSFmapSparse(ImageStack aIS, double[] aCentroid, float aRMaxDist, float aZMaxDist, int aMapSizeR, int aMapSizeZ) {
            int vZ;
            double[][] vMap = new double[aMapSizeZ][aMapSizeR];
            int[][] vMapCount = new int[aMapSizeZ][aMapSizeR];
            double vMaxRInPx = (double)aRMaxDist / PSF_estimator_3D.this.mPxWidthInNm;
            double vMaxZInPx = (double)aZMaxDist / PSF_estimator_3D.this.mPxDepthInNm;
            double vRIncrementPerPxInPx = vMaxRInPx / (double)aMapSizeR;
            double vZIncrementPerPxInPx = 2.0 * vMaxZInPx / (double)aMapSizeZ;
            int vZStart = (int)(aCentroid[2] - vMaxZInPx);
            int vYStart = (int)(aCentroid[1] - vMaxRInPx);
            int vXStart = (int)(aCentroid[0] - vMaxRInPx);
            int vZEnd = (int)(aCentroid[2] + vMaxZInPx) + 1;
            int vYEnd = (int)(aCentroid[1] + vMaxRInPx);
            int vXEnd = (int)(aCentroid[0] + vMaxRInPx);
            if (vZStart < 0 || vZEnd >= PSF_estimator_3D.this.mNSlices || vYStart < 0 || vYEnd >= PSF_estimator_3D.this.mHeight || vXStart < 0 || vXEnd >= PSF_estimator_3D.this.mWidth) {
                System.out.println("Warning: sampling region is partly out of the image domain.");
                vZStart = Math.max(0, vZStart);
                vYStart = Math.max(0, vYStart);
                vXStart = Math.max(0, vXStart);
                vZEnd = Math.min(vZEnd, PSF_estimator_3D.this.mNSlices - 1);
                vYEnd = Math.min(vYEnd, PSF_estimator_3D.this.mHeight - 1);
                vXEnd = Math.min(vXEnd, PSF_estimator_3D.this.mWidth - 1);
            }
            for (vZ = vZStart; vZ <= vZEnd; ++vZ) {
                if (vZ < 1 || vZStart < 0 || vZEnd > PSF_estimator_3D.this.mNSlices) continue;
                for (double vR = 0.0; vR <= vMaxRInPx; vR += PSF_estimator_3D.this.mRInc) {
                    for (double vPhi = 0.0; vPhi < Math.PI * 2; vPhi += 0.15707963267948966) {
                        double vInterpolatedOnNorthGridEdge;
                        double vInterpolatedOnSouthGridEdge;
                        double vInterpolatedOnSouthGridEdge2;
                        double vInterpolatedOnNorthGridEdge2;
                        double vYRest;
                        double d;
                        float vZDistInPx = (float)((double)vZ - aCentroid[2]);
                        double vX = aCentroid[0] + vR * Math.cos(vPhi);
                        double vY = aCentroid[1] + vR * Math.sin(vPhi);
                        int vXs = (int)vX;
                        int vYs = (int)vY;
                        double vInterpolatedIntensity = 0.0;
                        double vXRest = vX - (double)vXs - 0.5;
                        if (d < 0.0) {
                            double d2;
                            vXRest *= -1.0;
                            vYRest = vY - (double)vYs - 0.5;
                            if (d2 < 0.0) {
                                vInterpolatedOnNorthGridEdge2 = (1.0 - vXRest) * (double)aIS.getProcessor(vZ).getPixelValue(vXs, vYs) + vXRest * (double)aIS.getProcessor(vZ).getPixelValue(vXs - 1, vYs);
                                vInterpolatedOnSouthGridEdge2 = (1.0 - vXRest) * (double)aIS.getProcessor(vZ).getPixelValue(vXs, vYs - 1) + vXRest * (double)aIS.getProcessor(vZ).getPixelValue(vXs - 1, vYs - 1);
                                vInterpolatedIntensity = (1.0 - (vYRest *= -1.0)) * vInterpolatedOnNorthGridEdge2 + vYRest * vInterpolatedOnSouthGridEdge2;
                            } else {
                                vInterpolatedOnSouthGridEdge = (1.0 - vXRest) * (double)aIS.getProcessor(vZ).getPixelValue(vXs, vYs) + vXRest * (double)aIS.getProcessor(vZ).getPixelValue(vXs - 1, vYs);
                                vInterpolatedOnNorthGridEdge = (1.0 - vXRest) * (double)aIS.getProcessor(vZ).getPixelValue(vXs, vYs + 1) + vXRest * (double)aIS.getProcessor(vZ).getPixelValue(vXs - 1, vYs + 1);
                                vInterpolatedIntensity = (1.0 - vYRest) * vInterpolatedOnSouthGridEdge + vYRest * vInterpolatedOnNorthGridEdge;
                            }
                        } else {
                            double d3;
                            vYRest = vY - (double)vYs - 0.5;
                            if (d3 < 0.0) {
                                vInterpolatedOnNorthGridEdge2 = (1.0 - vXRest) * (double)aIS.getProcessor(vZ).getPixelValue(vXs, vYs) + vXRest * (double)aIS.getProcessor(vZ).getPixelValue(vXs + 1, vYs);
                                vInterpolatedOnSouthGridEdge2 = (1.0 - vXRest) * (double)aIS.getProcessor(vZ).getPixelValue(vXs, vYs - 1) + vXRest * (double)aIS.getProcessor(vZ).getPixelValue(vXs + 1, vYs - 1);
                                vInterpolatedIntensity = (1.0 - (vYRest *= -1.0)) * vInterpolatedOnNorthGridEdge2 + vYRest * vInterpolatedOnSouthGridEdge2;
                            } else {
                                vInterpolatedOnSouthGridEdge = (1.0 - vXRest) * (double)aIS.getProcessor(vZ).getPixelValue(vXs, vYs) + vXRest * (double)aIS.getProcessor(vZ).getPixelValue(vXs + 1, vYs);
                                vInterpolatedOnNorthGridEdge = (1.0 - vXRest) * (double)aIS.getProcessor(vZ).getPixelValue(vXs, vYs + 1) + vXRest * (double)aIS.getProcessor(vZ).getPixelValue(vXs + 1, vYs + 1);
                                vInterpolatedIntensity = (1.0 - vYRest) * vInterpolatedOnSouthGridEdge + vYRest * vInterpolatedOnNorthGridEdge;
                            }
                        }
                        if ((int)(((double)vZDistInPx + vMaxZInPx) / vZIncrementPerPxInPx) < 0 || (int)(((double)vZDistInPx + vMaxZInPx) / vZIncrementPerPxInPx) >= vMap.length || (int)(vR / vRIncrementPerPxInPx) >= PSF_estimator_3D.this.mMapSizeR || (int)(vR / vRIncrementPerPxInPx) < 0) continue;
                        double[] dArray = vMap[(int)(((double)vZDistInPx + vMaxZInPx) / vZIncrementPerPxInPx)];
                        int n = (int)(vR / vRIncrementPerPxInPx);
                        dArray[n] = dArray[n] + vInterpolatedIntensity;
                        int[] nArray = vMapCount[(int)(((double)vZDistInPx + vMaxZInPx) / vZIncrementPerPxInPx)];
                        int n2 = (int)(vR / vRIncrementPerPxInPx);
                        nArray[n2] = nArray[n2] + 1;
                    }
                }
            }
            for (vZ = 0; vZ < aMapSizeZ; ++vZ) {
                for (int vR = 0; vR < aMapSizeR; ++vR) {
                    if (vMapCount[vZ][vR] == 0) continue;
                    double[] dArray = vMap[vZ];
                    int n = vR;
                    dArray[n] = dArray[n] / (double)vMapCount[vZ][vR];
                }
            }
            return vMap;
        }

        public float interpolateLinear(float aX, float[] aKnotsX, float[] aKnotsY) {
            int vI = 0;
            if (aX < aKnotsX[0] || aX > aKnotsX[aKnotsX.length - 1]) {
                throw new IllegalArgumentException("x is not in knot interval");
            }
            for (vI = 0; vI < aKnotsX.length - 1 && !(aX < aKnotsX[vI]); ++vI) {
            }
            float vL = aKnotsX[vI] - aKnotsX[vI - 1];
            float vA = aX - aKnotsX[vI - 1];
            return aKnotsY[vI - 1] * (1.0f - vA / vL) + aKnotsY[vI] * (vA / vL);
        }

        public double[][] getPSFMap() {
            return this.mPSFMap;
        }
    }
}

