/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.GenericDialog;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Roi;
import ij.gui.YesNoCancelDialog;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.SaveDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import ij.process.StackStatistics;
import java.awt.Button;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JLabel;
import mosaic.core.detection.FeaturePointDetector;
import mosaic.core.detection.GUIhelper;
import mosaic.core.detection.MyFrame;
import mosaic.core.detection.Particle;
import mosaic.core.detection.PreviewCanvas;
import mosaic.core.detection.PreviewInterface;
import mosaic.core.particleLinking.LinkerOptions;
import mosaic.core.particleLinking.ParticleLinker;
import mosaic.core.particleLinking.ParticleLinkerGreedy;
import mosaic.core.particleLinking.ParticleLinkerHungarian;
import mosaic.core.utils.MosaicUtils;
import mosaic.particleTracker.FocusStackWin;
import mosaic.particleTracker.ParticleTrackerHelp;
import mosaic.particleTracker.ResultsWindow;
import mosaic.particleTracker.TrajectoriesReportXML;
import mosaic.particleTracker.Trajectory;
import mosaic.particleTracker.TrajectoryAnalysis;
import mosaic.particleTracker.TrajectoryStackWin;
import mosaic.utils.io.csv.CSV;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImg;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.apache.log4j.Logger;

public class ParticleTracker3DModular_
implements PlugInFilter,
PreviewInterface {
    private static final Logger logger = Logger.getLogger(ParticleTracker3DModular_.class);
    private boolean iIsInGuiMode = false;
    private boolean iSaveMss = false;
    private boolean iInputModeTextFile = false;
    private boolean iInputModeTextFileCsv = false;
    private boolean iInputModeTextFileFrames = false;
    private File iInputModeTextFileSegmentationInfo = null;
    public ImagePlus iInputImage;
    private FileInfo iInputImageFileInfo = null;
    public String iResultFilesBaseTitle;
    public Img<ARGBType> iTrajImg;
    public MyFrame[] iFrames;
    public Vector<Trajectory> iTrajectories;
    public int iLinkRange = 2;
    public double displacement = 10.0;
    private boolean force;
    private boolean straight_line;
    private float l_s = 1.0f;
    private float l_f = 1.0f;
    private float l_d = 1.0f;
    private ParticleLinker iParticleLinker = new ParticleLinkerGreedy();
    public int chosen_traj = -1;
    public ResultsWindow results_window;
    private String files_dir;
    private String file_sel;
    private String background;
    private int iNumOfFrames;
    private int iNumOfSlices;
    private FeaturePointDetector detector;
    protected NonBlockingGenericDialog gd;
    private PreviewCanvas preview_canvas = null;
    private String[] files_list;
    private boolean iCreateImageFromParticles = false;
    private boolean creating_traj_image = false;
    private boolean frames_processed = false;
    private ImagePlus iPreviewImage = null;

    public int setup(String aInputArgs, ImagePlus aInputImage) {
        this.iIsInGuiMode = !IJ.isMacro() && !Interpreter.batchMode;
        String options = Macro.getOptions();
        logger.info((Object)("Macro Options: [" + options + "]"));
        if (options != null && MosaicUtils.parseCheckbox("saveMss", options)) {
            logger.info((Object)"Save MSS results = true");
            this.iSaveMss = true;
        }
        this.iInputImage = aInputImage;
        if (this.iInputImage == null) {
            if (IJ.showMessageWithCancel((String)"Text Files Mode", (String)"Do you want to load particles positions from text files?")) {
                this.iInputModeTextFile = true;
                return 512;
            }
            IJ.error((String)"You must load an Image Sequence or Movie first");
            return 4096;
        }
        this.iInputImageFileInfo = this.iInputImage.getOriginalFileInfo();
        this.iResultFilesBaseTitle = this.iInputImage.getTitle();
        if (MosaicUtils.checkSegmentationInfo(this.iInputImage, null) && (!this.iIsInGuiMode || new YesNoCancelDialog(null, "Segmentation", "A segmentation has been founded for this image, do you want to track the regions").yesPressed())) {
            MosaicUtils.SegmentationInfo info = MosaicUtils.getSegmentationInfo(aInputImage);
            logger.debug((Object)("Taking input from segmentation results (file = [" + this.iInputImage.getTitle() + "], dir = [" + this.iInputImageFileInfo.directory + "]) "));
            this.iInputModeTextFile = true;
            this.iInputModeTextFileCsv = true;
            this.iInputModeTextFileSegmentationInfo = info.RegionList;
            return 512;
        }
        if (this.iInputImage.getStackSize() > 1 && this.iInputImage.getNFrames() == 1) {
            GenericDialog gd = new GenericDialog("Data dimension (this functionality will be removed soon)");
            gd.addChoice("Are these 3D data ?", new String[]{"No", "Yes"}, "No");
            gd.showDialog();
            if (!gd.wasCanceled() && gd.getNextChoice().equals("No")) {
                String saved_options = null;
                if (!this.iIsInGuiMode && Macro.getOptions() != null && !Macro.getOptions().trim().isEmpty()) {
                    saved_options = Macro.getOptions();
                }
                IJ.run((ImagePlus)aInputImage, (String)"Stack to Hyperstack...", (String)("order=xyczt(default) channels=1 slices=1 frames=" + aInputImage.getNSlices() + " display=Composite"));
                if (saved_options != null) {
                    Macro.setOptions((String)saved_options);
                }
            }
        }
        return 159;
    }

    public void run(ImageProcessor ip) {
        this.initializeMembers();
        if (!this.iInputModeTextFile && this.iIsInGuiMode) {
            this.preview_canvas = GUIhelper.generatePreviewCanvas(this.iInputImage);
        }
        if (!this.getUserDefinedParams()) {
            return;
        }
        if (!this.processFrames()) {
            return;
        }
        if (!this.linkParticles()) {
            return;
        }
        this.generateTrajectories();
        this.assignColorsToTrajectories();
        if (!this.iIsInGuiMode) {
            this.writeDataToDisk();
        } else {
            this.results_window = new ResultsWindow(this, "Results");
            this.results_window.configuration_panel.append(this.getConfiguration().toString());
            this.results_window.configuration_panel.append(this.getInputFramesInformation().toString());
            this.results_window.text_panel.appendLine("Particle Tracker DONE!");
            this.results_window.text_panel.appendLine("Found " + this.iTrajectories.size() + " Trajectories");
            this.results_window.setVisible(true);
            IJ.showStatus((String)"Creating trajectory image ...");
            this.creating_traj_image = true;
            this.iTrajImg = this.createHyperStackFromFrames();
        }
    }

    public boolean linkParticles() {
        IJ.showStatus((String)"Linking Particles");
        logger.debug((Object)"Link Particles");
        LinkerOptions lo = new LinkerOptions();
        lo.linkRange = this.iLinkRange;
        lo.maxDisplacement = (float)this.displacement;
        lo.force = this.force;
        lo.straightLine = this.straight_line;
        lo.lSpace = this.l_s;
        lo.lFeature = this.l_f;
        lo.lDynamic = this.l_d;
        int length = this.iFrames.length;
        ArrayList<Vector<Particle>> particles = new ArrayList<Vector<Particle>>(length);
        for (int i = 0; i < length; ++i) {
            particles.add(this.iFrames[i].getParticles());
        }
        return this.iParticleLinker.linkParticles(particles, lo);
    }

    private MyFrame[] convertIntoFrames(Vector<Particle> p) {
        if (this.background != null && this.iInputImage == null) {
            this.iInputImage = new Opener().openImage(new File(this.background.replace("*", "1")).getAbsolutePath());
        }
        this.filterParticles(p);
        return ParticleTracker3DModular_.createFrames(p);
    }

    private void initializeMembers() {
        if (!this.iInputModeTextFile) {
            StackStatistics stack_stats = new StackStatistics(this.iInputImage);
            float global_max = (float)stack_stats.max;
            float global_min = (float)stack_stats.min;
            this.iNumOfFrames = this.iInputImage.getNFrames();
            this.iNumOfSlices = this.iInputImage.getNSlices();
            this.detector = new FeaturePointDetector(global_max, global_min);
        } else {
            this.iNumOfSlices = 1;
        }
    }

    private boolean processFrames() {
        block12: {
            block11: {
                if (this.frames_processed) {
                    return true;
                }
                if (!this.iInputModeTextFile || !this.iInputModeTextFileCsv) break block11;
                IJ.showStatus((String)"Reading CSV Regions data ...");
                CSV<Particle> P_csv = new CSV<Particle>(Particle.class);
                P_csv.setCSVPreferenceFromFile(this.files_dir + File.separator + this.file_sel);
                Vector<Particle> p = P_csv.Read(this.files_dir + File.separator + this.file_sel, null);
                this.iInputImageFileInfo = new FileInfo();
                this.iInputImageFileInfo.directory = this.files_dir;
                if (p.size() == 0) {
                    IJ.error((String)"No regions defined for this image,nothing to do");
                    return false;
                }
                this.background = P_csv.getMetaInformation("background");
                IJ.showStatus((String)"Creating frames with particles ...");
                this.iFrames = this.convertIntoFrames(p);
                for (int i = 0; i < this.iFrames.length; ++i) {
                    this.iFrames[i].removeDuplicatedParticles();
                }
                this.iNumOfFrames = this.iFrames.length;
                break block12;
            }
            if (this.iInputModeTextFile) {
                this.iInputImageFileInfo = new FileInfo();
                this.iInputImageFileInfo.directory = this.files_dir;
            }
            this.iFrames = new MyFrame[this.iNumOfFrames];
            int frame_i = 0;
            int file_index = 0;
            while (frame_i < this.iNumOfFrames) {
                block15: {
                    MyFrame current_frame;
                    block16: {
                        block13: {
                            block14: {
                                current_frame = null;
                                if (!this.iInputModeTextFileFrames) break block13;
                                if (!this.files_list[file_index].startsWith(".") && !this.files_list[file_index].endsWith("~")) break block14;
                                --frame_i;
                                break block15;
                            }
                            IJ.showStatus((String)("Reading Particles from file " + this.files_list[file_index] + "(" + frame_i + "/" + this.files_list.length + ")"));
                            current_frame = new MyFrame(this.files_dir + this.files_list[file_index]);
                            if (current_frame.getParticles() == null) {
                                return false;
                            }
                            break block16;
                        }
                        ImageStack frameStack = MosaicUtils.getSubStackInFloat(this.iInputImage.getStack(), frame_i * this.iNumOfSlices + 1, (frame_i + 1) * this.iNumOfSlices, false);
                        current_frame = new MyFrame(frame_i);
                        IJ.showStatus((String)("Detecting Particles in Frame " + (frame_i + 1) + "/" + this.iNumOfFrames));
                        logger.info((Object)("Detecting particles in frame: " + (frame_i + 1) + "/" + this.iNumOfFrames));
                        Vector<Particle> detectedParticles = this.detector.featurePointDetection(frameStack);
                        current_frame.setParticles(detectedParticles);
                    }
                    if (current_frame.iFrameNumber >= this.iFrames.length) {
                        IJ.showMessage((String)("Error, frame " + current_frame.iFrameNumber + "  is out of range, enumeration must not have hole, and must start from 0"));
                        return false;
                    }
                    this.iFrames[current_frame.iFrameNumber] = current_frame;
                }
                ++frame_i;
                ++file_index;
            }
            for (int i = 0; i < this.iFrames.length; ++i) {
                if (this.iFrames[i] != null) continue;
                IJ.showMessage((String)("Error, frame: " + i + " does not exist"));
                return false;
            }
        }
        if (this.iCreateImageFromParticles) {
            IJ.showStatus((String)"Creating image from particles and trajectories ...");
            Img<ARGBType> iw = this.createHyperStackFromFrames();
            if (iw != null) {
                this.iInputImage = ImageJFunctions.wrap(iw, (String)"Video");
                this.iInputImage.show();
            } else {
                return false;
            }
        }
        this.frames_processed = true;
        return true;
    }

    private boolean getUserDefinedParams() {
        this.gd = new NonBlockingGenericDialog("Particle Tracker...");
        Panel p = new Panel();
        Button help_b = new Button("help");
        p.add(help_b);
        this.gd.addPanel(p);
        help_b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Point p = ParticleTracker3DModular_.this.gd.getLocationOnScreen();
                new ParticleTrackerHelp(p.x, p.y);
            }
        });
        boolean convert = false;
        if (this.iInputModeTextFile) {
            if (this.iInputModeTextFileSegmentationInfo == null) {
                GenericDialog textModeDialog = new GenericDialog("input text files type", (Frame)IJ.getInstance());
                String[] opts = new String[]{"multiple frame files", "CSV File"};
                textModeDialog.addRadioButtonGroup("Please specify the info provided for the Particles...", opts, opts.length, 1, opts[0]);
                textModeDialog.addCheckbox("Create initial image from read data", true);
                textModeDialog.showDialog();
                if (textModeDialog.wasCanceled()) {
                    return false;
                }
                String typeOfInputFile = textModeDialog.getNextRadioButton();
                int idx = Arrays.asList(opts).indexOf(typeOfInputFile);
                this.iInputModeTextFileFrames = idx == 0;
                this.iInputModeTextFileCsv = !this.iInputModeTextFileFrames;
                this.iCreateImageFromParticles = textModeDialog.getNextBoolean();
                this.files_list = this.getFilesList();
                if (this.files_list == null) {
                    return false;
                }
                if (this.iInputModeTextFileCsv) {
                    Vector<String> v = new Vector<String>();
                    for (int i = 0; i < this.files_list.length; ++i) {
                        File f = new File(this.files_dir + File.separator + this.files_list[i]);
                        if (!this.files_list[i].endsWith("csv") || !f.exists() || f.isDirectory()) continue;
                        v.add(this.files_list[i]);
                    }
                    this.files_list = new String[v.size()];
                    v.toArray(this.files_list);
                }
                this.iResultFilesBaseTitle = "text_files";
                this.iNumOfFrames = 0;
                for (int i = 0; i < this.files_list.length; ++i) {
                    if (this.files_list[i].startsWith(".") || this.files_list[i].endsWith("~")) continue;
                    ++this.iNumOfFrames;
                }
            } else {
                this.files_dir = this.iInputModeTextFileSegmentationInfo.getParent();
                this.file_sel = this.iInputModeTextFileSegmentationInfo.getName();
                logger.debug((Object)("Segmentation Mode, output set to: [" + this.files_dir + "][" + this.file_sel + "]"));
            }
        } else {
            GUIhelper.addUserDefinedParametersDialog((GenericDialog)this.gd, this.detector);
            this.gd.addPanel(GUIhelper.makePreviewPanel(this, this.iInputImage), 10, new Insets(5, 0, 0, 0));
            if (this.iInputImage.getType() != 0 && this.iInputImage.getType() != 1 && this.iInputImage.getType() != 2) {
                this.gd.addCheckbox("Convert to Gray8 (recommended)", true);
                convert = true;
            }
        }
        this.gd.addMessage("Particle Linking:\n");
        this.gd.addNumericField("Link Range", 2.0, 0);
        this.gd.addNumericField("Displacement", 10.0, 2);
        String[] d_pos = new String[]{"Brownian", "Straight lines", "Constant velocity"};
        this.gd.addChoice("Dynamics: ", d_pos, d_pos[0]);
        Button a_opt = new Button("Advanced options");
        a_opt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParticleTracker3DModular_.this.createLinkFactorDialog();
            }
        });
        if (!this.iIsInGuiMode) {
            this.createLinkFactorDialog();
        }
        Panel preview_panel = new Panel();
        preview_panel.add(a_opt);
        this.gd.addPanel(preview_panel);
        JLabel labelJ = new JLabel("<html>Please refer to and cite:<br><br>I. F. Sbalzarini and P. Koumoutsakos.<br> Feature Point Tracking and<br> Trajectory Analysis for<br>Video Imaging in Cell Biology,<br>Journal of Structural Biology<br> 151(2):182-195, 2005.<br></html>");
        p = new Panel();
        p.add(labelJ);
        this.gd.addPanel(p);
        this.gd.showDialog();
        if (this.gd.wasCanceled()) {
            return false;
        }
        if (!this.iInputModeTextFile) {
            Boolean changed = GUIhelper.getUserDefinedParameters((GenericDialog)this.gd, this.detector);
            if (changed.booleanValue() && this.frames_processed) {
                this.iFrames = null;
                this.frames_processed = false;
            }
            if (convert) {
                convert = this.gd.getNextBoolean();
            }
        }
        this.iLinkRange = (int)this.gd.getNextNumber();
        this.displacement = this.gd.getNextNumber();
        String dm = this.gd.getNextChoice();
        if (dm.equals("Brownian")) {
            this.force = false;
            this.straight_line = false;
        } else if (dm.equals("Straight lines")) {
            this.force = false;
            this.straight_line = true;
        } else if (dm.equals("Constant velocity")) {
            this.force = true;
            this.straight_line = false;
        }
        if (convert) {
            StackConverter sc = new StackConverter(this.iInputImage);
            sc.convertToGray8();
            this.iResultFilesBaseTitle = this.iInputImage.getTitle();
            StackStatistics stack_stats = new StackStatistics(this.iInputImage);
            this.detector.setGlobalMax((float)stack_stats.max);
            this.detector.setGlobalMin((float)stack_stats.min);
            this.iNumOfFrames = this.iInputImage.getNFrames();
        }
        return true;
    }

    public String trajectoryHeader() {
        String unit = "pixel";
        return new String("%% frame x (" + unit + ")     y (" + unit + ")    z (" + unit + ")      m0         m1           m2           m3           m4           s \n");
    }

    private StringBuffer getTrajectoriesInfo() {
        StringBuffer traj_info = new StringBuffer("%% Trajectories:\n");
        traj_info.append("%%\t 1st column: frame number\n");
        traj_info.append("%%\t 2nd column: x coordinate top-down(pixel)\n");
        traj_info.append("%%\t 3rd column: y coordinate left-right(pixel)\n");
        traj_info.append("%%\t 4th column: z coordinate bottom-top(pixel)\n");
        if (this.iInputModeTextFile) {
            traj_info.append("%%\t next columns: other information provided for each particle in the given order\n");
        } else {
            traj_info.append("%%\t 4th column: zero-order intensity moment m0\n");
            traj_info.append("%%\t 5th column: first-order intensity moment m1\n");
            traj_info.append("%%\t 6th column: second-order intensity moment m2\n");
            traj_info.append("%%\t 7th column: second-order intensity moment m3\n");
            traj_info.append("%%\t 8th column: second-order intensity moment m4\n");
            traj_info.append("%%\t 9th column: non-particle discrimination score\n");
        }
        traj_info.append("\n");
        for (Trajectory curr_traj : this.iTrajectories) {
            traj_info.append("%% Trajectory " + curr_traj.iSerialNumber + "\n");
            traj_info.append(this.trajectoryHeader());
            traj_info.append(curr_traj.toStringBuffer());
        }
        return traj_info;
    }

    private void writeDataToDisk() {
        logger.debug((Object)"Writing data to disk");
        if (this.iInputImageFileInfo == null) {
            IJ.error((String)"You're running a macro. Data are written to disk at the directory where your image is stored. Please store youre image first.");
            return;
        }
        logger.debug((Object)("Dir [" + this.iInputImageFileInfo.directory + "]"));
        MosaicUtils.write2File(this.iInputImageFileInfo.directory, "Traj_" + this.iResultFilesBaseTitle + ".txt", this.getFullReport().toString());
        if (!this.iInputModeTextFile) {
            new TrajectoriesReportXML(new File(this.iInputImageFileInfo.directory, "Traj_" + this.iResultFilesBaseTitle + ".xml").getAbsolutePath(), this);
        }
        try {
            if (this.iSaveMss) {
                CalibrationData calData = this.getImageCalibrationData();
                if (calData.errorMsg == null) {
                    ResultsTable rtMss = this.mssAllResultsToTable(calData.pixelDimension, calData.timeInterval);
                    rtMss.saveAs(new File(this.iInputImageFileInfo.directory, "TrajMss_" + this.iResultFilesBaseTitle + ".csv").getAbsolutePath());
                }
            }
            ResultsTable rt = this.generateResultsTableWithTrajectories();
            rt.saveAs(new File(this.iInputImageFileInfo.directory, "Traj_" + this.iResultFilesBaseTitle + ".csv").getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized void preview(int zDepth) {
        if (this.iInputImage == null) {
            return;
        }
        GUIhelper.getUserDefinedPreviewParams((GenericDialog)this.gd, this.detector);
        ImagePlus frame = MosaicUtils.getImageFrame(this.iInputImage, this.iInputImage.getFrame());
        ImageStack frameStack = frame.getStack();
        MyFrame preview_frame = new MyFrame(this.iInputImage.getFrame());
        Vector<Particle> detectedParticles = this.detector.featurePointDetection(frameStack);
        preview_frame.setParticles(detectedParticles);
        Img backgroundImg = ImagePlusAdapter.convertFloat((ImagePlus)frame);
        preview_frame.setParticleRadius(this.getRadius());
        Img<ARGBType> img_frame = preview_frame.createImage(backgroundImg, frame.getCalibration());
        ImagePlus wrap = ImageJFunctions.wrap(img_frame, (String)"Preview detection");
        if (this.iPreviewImage == null) {
            this.iPreviewImage = wrap;
        } else {
            this.iPreviewImage.setImage(wrap);
        }
        this.iPreviewImage.setSlice(zDepth);
        this.iPreviewImage.show();
    }

    public void setDrawingParticle(boolean showParticles) {
        for (Trajectory t : this.iTrajectories) {
            t.showParticles = showParticles;
        }
    }

    public void resetTrajectoriesFilter() {
        for (Trajectory t : this.iTrajectories) {
            t.to_display = true;
        }
    }

    public StringBuffer getConfiguration() {
        StringBuffer configuration = new StringBuffer("% Configuration:\n");
        if (!this.iInputModeTextFile) {
            configuration.append("% \tKernel radius: ");
            configuration.append(this.getRadius());
            configuration.append("\n");
            configuration.append("% \tCutoff radius: ");
            configuration.append(this.detector.getCutoff());
            configuration.append("\n");
            if (this.detector.getThresholdMode() == FeaturePointDetector.Mode.PERCENTILE_MODE) {
                configuration.append("% \tPercentile: ");
                configuration.append(this.detector.getPercentile() * 100.0f);
                configuration.append("\n");
            } else if (this.detector.getThresholdMode() == FeaturePointDetector.Mode.ABS_THRESHOLD_MODE) {
                configuration.append("% \tAbsolute threshold: ");
                configuration.append(this.detector.getAbsIntensityThreshold());
                configuration.append("\n");
            }
        }
        configuration.append("% \tDisplacement : ");
        configuration.append(this.displacement);
        configuration.append("\n");
        configuration.append("% \tLinkrange    : ");
        configuration.append(this.iLinkRange);
        configuration.append("\n");
        return configuration;
    }

    public StringBuffer getInputFramesInformation() {
        if (this.iInputModeTextFile) {
            return new StringBuffer("Frames info was loaded from text files");
        }
        StringBuffer info = new StringBuffer("% Frames information:\n");
        info.append("% \tWidth : ");
        info.append(this.iInputImage.getStack().getWidth());
        info.append(" pixel\n");
        info.append("% \tHeight: ");
        info.append(this.iInputImage.getStack().getHeight());
        info.append(" pixel\n");
        info.append("% \tDepth: ");
        info.append(this.iNumOfSlices);
        info.append(" slices\n");
        info.append("% \tGlobal minimum: ");
        info.append(this.detector.getGlobalMin());
        info.append("\n");
        info.append("% \tGlobal maximum: ");
        info.append(this.detector.getGlobalMax());
        info.append("\n");
        return info;
    }

    public void generateView(ImagePlus duplicated_imp, Img<ARGBType> out) {
        if (this.iTrajectories.size() == 0) {
            IJ.error((String)"There are no any trajectories detected - nothing to visualize.");
            return;
        }
        String new_title = "All Trajectories Visual";
        if (duplicated_imp == null) {
            if (out == null) {
                if (this.creating_traj_image) {
                    IJ.error((String)"One moment please ..., we are computing the image");
                    return;
                }
                IJ.error((String)"An internal error has occurred we are not able to compute the result image");
                return;
            }
            duplicated_imp = ImageJFunctions.wrap(out, (String)"All Trajectories Visual");
            duplicated_imp.show();
        } else {
            duplicated_imp.setImage(ImageJFunctions.wrap(out, (String)"All Trajectories Visual"));
        }
        new TrajectoryStackWin(this, duplicated_imp, duplicated_imp.getWindow().getCanvas(), out);
    }

    private <T extends RealType<T>> Img<ARGBType> copyScaleConvertToRGB(RandomAccessibleInterval<T> img, FinalInterval r, int magnification) {
        long[] sz = new long[img.numDimensions()];
        r.dimensions(sz);
        sz[0] = sz[0] * (long)magnification;
        sz[1] = sz[1] * (long)magnification;
        ArrayImgFactory imgFactory = new ArrayImgFactory();
        Img output = imgFactory.create(sz, (Object)new ARGBType());
        IntervalView vi = Views.interval(img, (Interval)r);
        IterableInterval fvi = Views.flatIterable((RandomAccessibleInterval)vi);
        Cursor cur = fvi.cursor();
        RandomAccess rc_o = output.randomAccess();
        MosaicUtils.ToARGB pixel_converter = MosaicUtils.getConversion(cur.get(), fvi.cursor());
        int start_frame = (int)r.min(rc_o.numDimensions() - 1);
        int start_x = (int)r.min(0);
        int start_y = (int)r.min(1);
        int[] loc = new int[rc_o.numDimensions()];
        int[] loc_p = new int[rc_o.numDimensions()];
        while (cur.hasNext()) {
            ARGBType a = pixel_converter.toARGB(cur.next());
            cur.localize(loc);
            cur.localize(loc_p);
            for (int i = 0; i < magnification; ++i) {
                for (int j = 0; j < magnification; ++j) {
                    loc_p[0] = (loc[0] - start_x) * magnification + i;
                    loc_p[1] = (loc[1] - start_y) * magnification + j;
                    loc_p[rc_o.numDimensions() - 1] = loc[rc_o.numDimensions() - 1] - start_frame;
                    rc_o.setPosition(loc_p);
                    ((ARGBType)rc_o.get()).set(a);
                }
            }
        }
        return output;
    }

    public void generateTrajFocusView(int trajectory_index) {
        int magnification = this.results_window.magnification_factor;
        String new_title = "[Trajectory number " + (trajectory_index + 1) + "]";
        Trajectory traj = this.iTrajectories.elementAt(trajectory_index);
        Rectangle r = traj.focus_area.getBounds();
        ImagePlusImg img = ImagePlusAdapter.wrap((ImagePlus)this.iInputImage);
        long[] min = new long[img.numDimensions()];
        long[] max = new long[img.numDimensions()];
        min[0] = r.x;
        max[0] = r.x + r.width;
        min[1] = r.y;
        max[1] = r.y + r.height;
        for (int i = 2; i < img.numDimensions() - 1; ++i) {
            min[i] = 0L;
            max[i] = img.dimension(i);
        }
        min[img.numDimensions() - 1] = traj.getStartFrame();
        max[img.numDimensions() - 1] = traj.getStopFrame();
        FinalInterval in = new FinalInterval(min, max);
        Img<ARGBType> focus_view = this.copyScaleConvertToRGB((RandomAccessibleInterval)img, in, magnification);
        IJ.showStatus((String)"Creating frames ... ");
        Vector<Trajectory> vt = new Vector<Trajectory>();
        vt.add(traj);
        Calibration cal = this.iInputImage.getCalibration();
        MyFrame.updateImage(focus_view, traj.focus_area.getBounds(), traj.getStartFrame(), vt, cal, MyFrame.DrawType.TRAJECTORY_HISTORY, this.getRadius());
        ImagePlus imp = ImageJFunctions.show(focus_view);
        imp.setTitle(new_title);
        new FocusStackWin(imp, traj, (float)cal.pixelDepth);
        IJ.showStatus((String)"Done");
    }

    public void generateAreaFocusView(int magnification) {
        String new_title = "[Area Focus]";
        int roi_image_id = IJ.getImage().getID();
        Roi user_roi = IJ.getImage().getRoi();
        if (user_roi == null) {
            IJ.error((String)"generateAreaFocusView: No Roi was selected");
            return;
        }
        IJ.run((String)"Scale...", (String)("x=" + magnification + " y=" + magnification + " process create title=" + "[Area Focus]"));
        ImagePlus duplicated_imp = IJ.getImage();
        IJ.run((String)"RGB Color");
        IJ.selectWindow((int)roi_image_id);
        IJ.selectWindow((int)duplicated_imp.getID());
    }

    private String[] getFilesList() {
        OpenDialog od = new OpenDialog("test", IJ.getDirectory((String)"image"), "");
        this.files_dir = od.getDirectory();
        this.file_sel = od.getFileName();
        if (this.files_dir == null) {
            return null;
        }
        String[] list = new File(od.getDirectory()).list();
        return list;
    }

    public Img<ARGBType> createHyperStackFromFrames() {
        return this.createHyperStackFromFrames(this.background);
    }

    private Img<ARGBType> createHyperStackFromFrames(String aBackgroundFilename) {
        int i;
        int[] maxDims = this.getParticlesRange();
        int i2 = 0;
        while (i2 < maxDims.length) {
            int n = i2++;
            maxDims[n] = maxDims[n] + 1;
        }
        CellImg outputImg = null;
        if (this.iInputModeTextFile) {
            if (aBackgroundFilename == null) {
                long[] extendedDims = new long[maxDims.length + 1];
                for (i = 0; i < maxDims.length; ++i) {
                    extendedDims[i] = maxDims[i];
                }
                extendedDims[maxDims.length] = this.iFrames.length;
                outputImg = new CellImgFactory().create(extendedDims, (NativeType)new ARGBType());
            } else {
                if (this.iInputImage == null) {
                    File file = new File(aBackgroundFilename.replace("*", Integer.toString(1)));
                    this.iInputImage = new Opener().openImage(file.getAbsolutePath());
                    if (this.iInputImage != null) {
                        IJ.error((String)("Cannot open the background " + aBackgroundFilename));
                        this.creating_traj_image = false;
                        return null;
                    }
                }
                ImagePlus imp = this.iInputImage.getNFrames() > 1 ? MosaicUtils.getImageFrame(this.iInputImage, 1) : this.iInputImage;
                ImagePlusImg backgroundImg = ImagePlusAdapter.wrap((ImagePlus)imp);
                long[] extendedDims = new long[backgroundImg.numDimensions() + 1];
                for (int i3 = 0; i3 < backgroundImg.numDimensions(); ++i3) {
                    extendedDims[i3] = backgroundImg.dimension(i3);
                }
                extendedDims[backgroundImg.numDimensions()] = this.iFrames.length;
                outputImg = new CellImgFactory().create(extendedDims, (NativeType)new ARGBType());
            }
        } else {
            ImagePlusImg backgroundImg = ImagePlusAdapter.wrap((ImagePlus)this.iInputImage);
            long[] extendedDims = new long[backgroundImg.numDimensions()];
            for (int i4 = 0; i4 < backgroundImg.numDimensions(); ++i4) {
                extendedDims[i4] = backgroundImg.dimension(i4);
            }
            outputImg = new CellImgFactory().create(extendedDims, (NativeType)new ARGBType());
        }
        Img<ARGBType> frameImg = null;
        for (i = 0; i < this.iFrames.length; ++i) {
            IJ.showStatus((String)("Creating frame " + (i + 1)));
            if (this.iInputModeTextFile) {
                if (aBackgroundFilename != null) {
                    ImagePlus imp = null;
                    if (this.iInputImage.getNFrames() > 1 && i < this.iInputImage.getNFrames()) {
                        imp = MosaicUtils.getImageFrame(this.iInputImage, i + 1);
                    } else if (this.iInputImage.getNChannels() >= 1 && i < this.iInputImage.getNChannels()) {
                        imp = MosaicUtils.getImageSlice(this.iInputImage, i + 1);
                    }
                    if (imp == null) {
                        IJ.error((String)"Cannot find the background image or wrong format");
                        this.creating_traj_image = false;
                        return null;
                    }
                    ImagePlusImg backgroundImg = ImagePlusAdapter.wrap(imp);
                    frameImg = this.iFrames[i].createImage(backgroundImg, this.iTrajectories, this.iInputImage.getCalibration(), i, MyFrame.DrawType.TRAJECTORY_HISTORY);
                } else {
                    frameImg = this.iFrames[i].createImage(maxDims, this.iTrajectories, i, MyFrame.DrawType.TRAJECTORY_HISTORY);
                }
            } else {
                ImagePlus timp = MosaicUtils.getImageFrame(this.iInputImage, i + 1);
                ImagePlusImg backgroundImg = ImagePlusAdapter.wrap((ImagePlus)timp);
                this.iFrames[i].setParticleRadius(this.getRadius());
                frameImg = this.iFrames[i].createImage(backgroundImg, this.iTrajectories, this.iInputImage.getCalibration(), i, MyFrame.DrawType.TRAJECTORY_HISTORY);
            }
            if (frameImg == null) break;
            MosaicUtils.copyEmbedded(outputImg, frameImg, i);
        }
        IJ.showStatus((String)"Done");
        return outputImg;
    }

    public StringBuffer getFullReport() {
        int i;
        StringBuffer report = new StringBuffer();
        report.append(this.getConfiguration());
        report.append(this.getInputFramesInformation());
        report.append("\n");
        report.append("%\tPer frame information (verbose output):\n");
        for (i = 0; i < this.iFrames.length; ++i) {
            report.append(this.iFrames[i].getFullFrameInfo());
        }
        report.append("% Trajectory linking (verbose output):\n");
        for (i = 0; i < this.iFrames.length; ++i) {
            report.append(this.iFrames[i].toStringBuffer());
        }
        report.append("\n");
        report.append(this.getTrajectoriesInfo());
        return report;
    }

    @Override
    public void preview(ActionEvent e, int zDepth) {
        this.iInputImage.getWindow().setLocation((int)this.gd.getLocationOnScreen().getX() + this.gd.getWidth(), (int)this.gd.getLocationOnScreen().getY());
        this.preview(zDepth);
        this.preview_canvas.repaint();
    }

    @Override
    public void saveDetected(ActionEvent e) {
        GUIhelper.getUserDefinedPreviewParams((GenericDialog)this.gd, this.detector);
        if (this.processFrames()) {
            this.saveDetected(this.iFrames);
        }
        this.preview_canvas.repaint();
    }

    private void saveDetected(MyFrame[] frames) {
        SaveDialog sd = new SaveDialog("Save Detected Particles", IJ.getDirectory((String)"image"), "frame", "");
        if (sd.getDirectory() == null || sd.getFileName() == null) {
            return;
        }
        for (MyFrame f : frames) {
            String fileName = sd.getFileName() + "_" + f.iFrameNumber;
            if (MosaicUtils.write2File(sd.getDirectory(), fileName, f.frameDetectedParticlesForSave(false).toString())) continue;
            IJ.log((String)("Problem occured while writing to file. Directory: [" + sd.getDirectory() + "] File: [" + fileName + "]"));
            return;
        }
    }

    public ResultsTable generateResultsTableWithParticles() {
        ResultsTable rt = this.getResultsTable();
        if (rt != null) {
            for (MyFrame f : this.iFrames) {
                for (Particle p : f.getParticles()) {
                    rt.incrementCounter();
                    int rownum = rt.getCounter() - 1;
                    this.addParticleInfo(rt, rownum, p);
                }
            }
        }
        return rt;
    }

    public ResultsTable generateResultsTableWithTrajectories() {
        ResultsTable rt = this.getResultsTable();
        if (rt != null) {
            for (Trajectory curr_traj : this.iTrajectories) {
                this.putOneTrajectoryIntoResultsTable(rt, curr_traj);
            }
        }
        return rt;
    }

    public ResultsTable transferSelectedTrajectoriesToResultTable(Trajectory aSelectedTrajectory) {
        ResultsTable rt = this.getResultsTable();
        if (rt != null) {
            this.putOneTrajectoryIntoResultsTable(rt, aSelectedTrajectory);
        }
        return rt;
    }

    private void putOneTrajectoryIntoResultsTable(ResultsTable rt, Trajectory curr_traj) {
        for (Particle p : curr_traj.iParticles) {
            rt.incrementCounter();
            int rownum = rt.getCounter() - 1;
            rt.setValue("Trajectory", rownum, (double)curr_traj.iSerialNumber);
            this.addParticleInfo(rt, rownum, p);
        }
    }

    private void addParticleInfo(ResultsTable rt, int rownum, Particle p) {
        rt.setValue("Frame", rownum, (double)p.getFrame());
        rt.setValue("x", rownum, (double)p.iX);
        rt.setValue("y", rownum, (double)p.iY);
        rt.setValue("z", rownum, (double)p.iZ);
        rt.setValue("m0", rownum, (double)p.m0);
        rt.setValue("m1", rownum, (double)p.m1);
        rt.setValue("m2", rownum, (double)p.m2);
        rt.setValue("m3", rownum, (double)p.m3);
        rt.setValue("m4", rownum, (double)p.m4);
        rt.setValue("NPscore", rownum, (double)p.nonParticleDiscriminationScore);
    }

    private ResultsTable getResultsTable() {
        ResultsTable rt = ResultsTable.getResultsTable();
        if (rt.getCounter() != 0 || rt.getLastColumn() != -1) {
            if (IJ.showMessageWithCancel((String)"Results Table", (String)"Reset Results Table?")) {
                rt.reset();
            } else {
                return null;
            }
        }
        return rt;
    }

    private void computeMssForOneTrajectory(ResultsTable rt, Trajectory currentTrajectory, double aPixelDimensions, double aTimeInterval) {
        TrajectoryAnalysis ta = new TrajectoryAnalysis(currentTrajectory);
        ta.setLengthOfAPixel(aPixelDimensions);
        ta.setTimeInterval(aTimeInterval);
        if (ta.calculateAll()) {
            rt.incrementCounter();
            int rownum = rt.getCounter() - 1;
            rt.setValue("Trajectory", rownum, (double)currentTrajectory.iSerialNumber);
            rt.setValue("Trajectory length", rownum, (double)currentTrajectory.getLength());
            rt.setValue("MSS: slope", rownum, ta.getMSSlinear());
            rt.setValue("MSS: y-axis intercept", rownum, ta.getMSSlinearY0());
            boolean secondOrder = true;
            rt.setValue("MSD: slope", rownum, ta.getGammasLogarithmic()[1]);
            rt.setValue("MSD: y-axis intercept", rownum, ta.getGammasLogarithmicY0()[1]);
            rt.setValue("Diffusion Coefficient D2 (m^2/s)", rownum, ta.getDiffusionCoefficients()[1]);
            rt.setValue("Distance (m)", rownum, ta.getDistance());
            rt.setValue("AvgDistance (m/frame)", rownum, ta.getAvgDistance());
            rt.setValue("Straightness", rownum, ta.getStraightness());
            rt.setValue("Bending", rownum, ta.getBending());
            rt.setValue("Bending (linear)", rownum, ta.getBendingLinear());
            rt.setValue("Efficiency", rownum, ta.getEfficiency());
            rt.setValue("Pixel size", rownum, aPixelDimensions);
            rt.setValue("Time interval", rownum, aTimeInterval);
        }
    }

    public ResultsTable mssTrajectoryResultsToTable(Trajectory aTrajectory, double aPixelDimensions, double aTimeInterval) {
        ResultsTable rt = this.getResultsTable();
        if (rt != null) {
            for (int i = 4; i < 12; ++i) {
                rt.setDecimalPlaces(i, 8);
            }
            this.computeMssForOneTrajectory(rt, aTrajectory, aPixelDimensions, aTimeInterval);
            if (this.iIsInGuiMode) {
                rt.show("Results");
            }
        }
        return rt;
    }

    public ResultsTable mssAllResultsToTable(double aPixelDimensions, double aTimeInterval) {
        ResultsTable rt = this.getResultsTable();
        if (rt != null) {
            rt.reset();
            for (Trajectory currentTrajectory : this.iTrajectories) {
                this.computeMssForOneTrajectory(rt, currentTrajectory, aPixelDimensions, aTimeInterval);
            }
            logger.info((Object)("Computed MSS for " + rt.getCounter() + " trajectories."));
            if (this.iIsInGuiMode) {
                rt.show("Results");
            }
        }
        return rt;
    }

    public CalibrationData getImageCalibrationData() {
        double width = this.iInputImage.getCalibration().pixelWidth;
        double height = this.iInputImage.getCalibration().pixelHeight;
        double interval = this.iInputImage.getCalibration().frameInterval;
        String intervalUnit = this.iInputImage.getCalibration().getTimeUnit();
        String unit = this.iInputImage.getCalibration().getUnit();
        String message = "";
        if (width != height) {
            message = message + "Pixel width is different than height. \n";
        } else if (interval == 0.0) {
            message = message + "Frame interval is equall to 0. To perform analysis it must have correct value \n";
        } else if (!(unit.equals("nm") || unit.equals("\u00b5m") || unit.equals("um") || unit.equals("mm") || unit.equals("m"))) {
            message = message + "Dimension unit must be one of: m, mm, um or (\u00b5m), nm";
        } else if (!(intervalUnit.equals("us") || intervalUnit.equals("\u00b5s") || intervalUnit.equals("ms") || intervalUnit.equals("sec") || intervalUnit.equals("s"))) {
            message = message + "Time interval unit must be one of: s, sec, ms, us, \u00b5m";
        }
        if (!message.equals("")) {
            return new CalibrationData(null, null, message);
        }
        double pixelDimensions = width;
        double timeInterval = interval;
        if (unit.equals("nm")) {
            pixelDimensions /= 1.0E9;
        } else if (unit.equals("\u00b5m") || unit.equals("um")) {
            pixelDimensions /= 1000000.0;
        } else if (unit.equals("mm")) {
            pixelDimensions /= 1000.0;
        }
        if (intervalUnit.equals("\u00b5s") || intervalUnit.equals("us")) {
            timeInterval /= 1000000.0;
        } else if (intervalUnit.equals("ms")) {
            timeInterval /= 1000.0;
        }
        return new CalibrationData(pixelDimensions, timeInterval, null);
    }

    public double getCutoffRadius() {
        return this.detector.getCutoff();
    }

    public String getThresholdMode() {
        if (this.detector.getThresholdMode() == FeaturePointDetector.Mode.PERCENTILE_MODE) {
            return "percentile";
        }
        if (this.detector.getThresholdMode() == FeaturePointDetector.Mode.ABS_THRESHOLD_MODE) {
            return "Absolute";
        }
        return "Unknown";
    }

    public String getThresholdValue() {
        if (this.detector.getThresholdMode() == FeaturePointDetector.Mode.PERCENTILE_MODE) {
            return "" + this.detector.getPercentile() * 100.0f;
        }
        if (this.detector.getThresholdMode() == FeaturePointDetector.Mode.ABS_THRESHOLD_MODE) {
            return "" + this.detector.getAbsIntensityThreshold();
        }
        return "0";
    }

    public int getWidth() {
        return this.iInputImage.getStack().getWidth();
    }

    public int getHeight() {
        return this.iInputImage.getStack().getHeight();
    }

    public int getNumberOfSlices() {
        return this.iNumOfSlices;
    }

    public float getGlobalMinimum() {
        return this.detector.getGlobalMin();
    }

    public float getGlobalMaximum() {
        return this.detector.getGlobalMax();
    }

    public int getNumberOfFrames() {
        return this.iNumOfFrames;
    }

    protected void createLinkFactorDialog() {
        GenericDialog gd = new GenericDialog("Link factor");
        gd.addMessage("weight of different contributions for linking\n relative to the distance normalized to one");
        gd.addNumericField("Object feature", (double)this.l_f, 3);
        gd.addNumericField("Dynamics_", (double)this.l_d, 3);
        String[] sc = new String[]{"Greedy", "Hungarian"};
        gd.addChoice("Optimizer", sc, sc[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.l_s = 1.0f;
        this.l_f = (float)gd.getNextNumber();
        this.l_d = (float)gd.getNextNumber();
        String linkerString = gd.getNextChoice();
        this.iParticleLinker = linkerString.equals("Greedy") ? new ParticleLinkerGreedy() : new ParticleLinkerHungarian();
    }

    private void filterParticles(Vector<Particle> aParticles) {
        int size = 0;
        double intensity = 0.0;
        GenericDialog gd = new GenericDialog("Filter particles");
        gd.addNumericField("Size (m0) >=", 0.0, 1);
        gd.addNumericField("Intensity (m2) >=", 0.0, 3);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            size = (int)gd.getNextNumber();
            intensity = gd.getNextNumber();
        }
        for (int i = aParticles.size() - 1; i >= 0; --i) {
            Particle p = aParticles.get(i);
            if (!(p.m0 < (float)size) && !((double)p.m2 < intensity)) continue;
            aParticles.remove(i);
        }
    }

    private int[] getParticlesRange() {
        int[] nArray;
        int x = 0;
        int y = 0;
        int z = 0;
        for (MyFrame f : this.iFrames) {
            for (Particle p : f.getParticles()) {
                if (p.iX > (float)x) {
                    x = (int)Math.ceil(p.iX);
                }
                if (p.iY > (float)y) {
                    y = (int)Math.ceil(p.iY);
                }
                if (!(p.iZ > (float)z)) continue;
                z = (int)Math.ceil(p.iZ);
            }
        }
        if (z == 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = x;
            nArray = nArray2;
            nArray2[1] = y;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = x;
            nArray3[1] = y;
            nArray = nArray3;
            nArray3[2] = z;
        }
        return nArray;
    }

    public int getRadius() {
        return this.detector != null ? this.detector.getRadius() : -1;
    }

    private static MyFrame[] createFrames(Vector<Particle> aParticles) {
        int numOfParticles = aParticles.size();
        if (numOfParticles == 0) {
            return new MyFrame[0];
        }
        int numOfFrames = aParticles.get(numOfParticles - 1).getFrame() + 1;
        MyFrame[] frames = new MyFrame[numOfFrames];
        int lastFrameNum = -1;
        int i = 0;
        while (i < numOfParticles) {
            Vector<Particle> particlesInOneFrame = new Vector<Particle>();
            int currFrameNum = aParticles.get(i).getFrame();
            do {
                particlesInOneFrame.add(aParticles.get(i++));
            } while (i < numOfParticles && aParticles.get(i).getFrame() == currFrameNum);
            for (int f = lastFrameNum + 1; f < currFrameNum; ++f) {
                frames[f] = new MyFrame(new Vector<Particle>(), f);
            }
            frames[currFrameNum] = new MyFrame(particlesInOneFrame, currFrameNum);
            lastFrameNum = currFrameNum;
        }
        return frames;
    }

    public void generateTrajectories() {
        IJ.showStatus((String)"Generating Trajectories");
        logger.debug((Object)"Generate trajectories");
        this.iTrajectories = new Vector();
        Vector<Particle> currTrajectory = new Vector<Particle>(this.iNumOfFrames);
        for (int currFrameNum = 0; currFrameNum < this.iNumOfFrames; ++currFrameNum) {
            Vector<Particle> particles = this.iFrames[currFrameNum].getParticles();
            for (Particle p : particles) {
                boolean isNextParticleFound;
                if (p.special) continue;
                currTrajectory.clear();
                int currTrajFrameNum = currFrameNum;
                block2: do {
                    p.special = true;
                    currTrajectory.add(p);
                    isNextParticleFound = false;
                    for (int n = 1; n <= this.iLinkRange; ++n) {
                        if (p.next[n - 1] == -1) continue;
                        Vector<Particle> p2 = this.iFrames[currTrajFrameNum + n].getParticles();
                        Particle linkedParticle = p2.elementAt(p.next[n - 1]);
                        if (linkedParticle.special) continue block2;
                        p = linkedParticle;
                        currTrajFrameNum += n;
                        isNextParticleFound = true;
                        continue block2;
                    }
                } while (isNextParticleFound);
                if (currTrajectory.size() <= 1) continue;
                this.iTrajectories.add(new Trajectory(currTrajectory.toArray(new Particle[0]), this.iTrajectories.size() + 1, this.iInputImage));
            }
        }
    }

    public void assignColorsToTrajectories() {
        int len = this.iTrajectories.size();
        Vector<Color> vI = this.generateColors(len);
        for (int s = 0; s < len; ++s) {
            this.iTrajectories.elementAt((int)s).color = vI.elementAt(s);
        }
    }

    private Vector<Color> generateColors(int aNumOfColors) {
        if (aNumOfColors < 1) {
            return null;
        }
        Vector<Color> colors = new Vector<Color>(aNumOfColors);
        int base = 257;
        int step = (0xFFFFFF - base) / aNumOfColors;
        step = step > 0 ? step : 1;
        for (int s = 0; s < aNumOfColors; ++s) {
            colors.add(new Color(base += step));
        }
        Collections.shuffle(colors);
        return colors;
    }

    public boolean filterTrajectories() {
        GenericDialog fod = new GenericDialog("Filter Options...", (Frame)IJ.getInstance());
        fod.addNumericField("Only keep trajectories longer than", 0.0, 0, 10, "frames (0 means - showAll)");
        fod.addNumericField("Show only trajectory with ID:", 0.0, 0, 10, " (0 means - show All)");
        fod.showDialog();
        if (fod.wasCanceled()) {
            return false;
        }
        int minTrajectoryLength = (int)fod.getNextNumber();
        int idToShow = (int)fod.getNextNumber();
        if (idToShow < 0 || idToShow > this.iTrajectories.size()) {
            IJ.showMessage((String)"ID of trajectory to filter is not valid. All trajectories will be displayed");
            idToShow = 0;
        }
        int numOfVisibleTrajs = 0;
        for (Trajectory t : this.iTrajectories) {
            if (t.getLength() <= minTrajectoryLength || idToShow != 0 && t.iSerialNumber != idToShow) {
                t.to_display = false;
                continue;
            }
            t.to_display = true;
            ++numOfVisibleTrajs;
        }
        this.results_window.text_panel.appendLine(numOfVisibleTrajs + " trajectories remained after filter");
        return true;
    }

    public static void main(String[] args) {
        Class<ParticleTracker3DModular_> clazz = ParticleTracker3DModular_.class;
        String url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class").toString();
        String pluginsDir = url.substring("file:".length(), url.length() - clazz.getName().length() - ".class".length());
        System.setProperty("plugins.dir", pluginsDir);
        new ImageJ();
        IJ.runPlugIn((String)clazz.getName(), (String)"");
    }

    public class CalibrationData {
        public Double pixelDimension;
        public Double timeInterval;
        public String errorMsg;

        public CalibrationData(Double aPixelDimension, Double aTimeInterval, String aErrorMsg) {
            this.pixelDimension = aPixelDimension;
            this.timeInterval = aTimeInterval;
            this.errorMsg = aErrorMsg;
        }
    }
}

