/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.plugin.frame.RoiManager;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.lang.reflect.Array;
import java.util.Arrays;
import mosaic.noise_sample.GenericNoiseSampler;
import mosaic.noise_sample.NoiseSample;
import mosaic.noise_sample.noiseList;
import net.imglib2.Cursor;
import net.imglib2.histogram.BinMapper1d;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.histogram.Integer1dBinMapper;
import net.imglib2.histogram.Real1dBinMapper;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.FloatType;

public class Poisson_Noise
implements ExtendedPlugInFilter {
    static final int FLAGS = 13;
    ImagePlus iOrigImg;
    String iNoiseModel;
    double iDilatation = 1.0;

    public int setup(String aArgs, ImagePlus aImp) {
        this.iOrigImg = aImp;
        return 13;
    }

    public int showDialog(ImagePlus arg0, String arg1, PlugInFilterRunner arg2) {
        GenericDialog gd = new GenericDialog("Choose type of noise");
        gd.addChoice("Choose noise model", noiseList.noiseList, noiseList.noiseList[0]);
        gd.addNumericField("Offset", 0.0, 3);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        this.iDilatation = gd.getNextNumber();
        this.iNoiseModel = gd.getNextChoice();
        return 13;
    }

    public void run(ImageProcessor aImageProcessor) {
        NoiseSample ns;
        int vType;
        boolean BYTE = false;
        boolean SHORT = true;
        int FLOAT = 2;
        if (aImageProcessor instanceof ByteProcessor) {
            vType = 0;
            ns = noiseList.factory(this.iNoiseModel, this.iDilatation);
        } else if (aImageProcessor instanceof ShortProcessor) {
            vType = 1;
            ns = noiseList.factory(this.iNoiseModel, this.iDilatation);
        } else if (aImageProcessor instanceof FloatProcessor) {
            vType = 2;
            ns = noiseList.factory(this.iNoiseModel, this.iDilatation);
        } else {
            IJ.showMessage((String)"Wrong image type");
            return;
        }
        if (ns == null) {
            if (vType == 0) {
                this.setupGenericNoise(UnsignedByteType.class);
            } else if (vType == 1) {
                this.setupGenericNoise(ShortType.class);
            } else if (vType == 2) {
                this.setupGenericNoise(FloatType.class);
            }
        }
        if (vType == 0) {
            this.sample(this.iOrigImg, UnsignedByteType.class, ns);
        } else if (vType == 1) {
            this.sample(this.iOrigImg, ShortType.class, ns);
        } else if (vType == 2) {
            this.sample(this.iOrigImg, FloatType.class, ns);
        }
    }

    public void setNPasses(int arg0) {
    }

    private <S extends IntegerType<S>> BinMapper1d<S> createIntegerMapper(int nbin) {
        return new Integer1dBinMapper(0L, (long)nbin, true);
    }

    <T extends RealType<T>> BinMapper1d<T> createMapper(Class<T> cls, double min, double max) {
        RealType test = null;
        try {
            test = (RealType)cls.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        RealType test_o = test;
        if (test_o instanceof UnsignedByteType) {
            return this.createIntegerMapper(256);
        }
        if (test_o instanceof ShortType) {
            return this.createIntegerMapper(65536);
        }
        if (test_o instanceof FloatType) {
            return new Real1dBinMapper(min, max, 65536L, true);
        }
        return null;
    }

    private <T extends RealType<T> & NativeType<T>> void setupGenericNoise(Class<T> cls) {
        Roi[] roisArray;
        GenericNoiseSampler<RealType> gns = new GenericNoiseSampler<RealType>(cls);
        RoiManager manager = RoiManager.getInstance();
        if (manager == null) {
            manager = new RoiManager();
        }
        for (Roi roi : roisArray = manager.getRoisAsArray()) {
            ImagePlus tmp = new ImagePlus(roi.getName(), WindowManager.getImage((int)roi.getImageID()).getProcessor());
            Rectangle b = roi.getBounds();
            ImageProcessor ip = tmp.getProcessor();
            ip.setRoi(b.x, b.y, b.width, b.height);
            tmp.setProcessor(null, ip.crop());
            double histMin = tmp.getStatistics().histMin;
            double histMax = tmp.getStatistics().histMax;
            BinMapper1d<T> bM = this.createMapper(cls, histMin, histMax);
            Histogram1d hist = new Histogram1d(bM);
            ImagePlusImg image = ImagePlusAdapter.wrap((ImagePlus)tmp);
            Cursor cur = image.cursor();
            try {
                RealType mean_t = (RealType)cls.newInstance();
                RealType[] ipnt = (RealType[])Array.newInstance(cls, (int)image.size());
                double mean = 0.0;
                int cnt = 0;
                while (cur.hasNext()) {
                    ipnt[cnt] = (RealType)cur.next();
                    mean += ipnt[cnt].getRealDouble();
                    ++cnt;
                }
                mean_t.setReal(mean /= (double)cnt);
                hist.addData(Arrays.asList(ipnt));
                gns.setHistogram(mean_t, hist);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
        }
    }

    private <T extends RealType<T> & NativeType<T>> void sample(ImagePlus imp, Class<T> cls, NoiseSample<?> ns) {
        ImagePlusImg image = ImagePlusAdapter.wrap((ImagePlus)imp);
        Cursor cur = image.cursor();
        int numOfDims = 2;
        numOfDims += imp.getNFrames() > 1 ? 1 : 0;
        numOfDims += imp.getNChannels() > 1 ? 1 : 0;
        int[] loc = new int[numOfDims += imp.getNSlices() > 1 ? 1 : 0];
        NoiseSample<?> nsT = ns;
        try {
            RealType smp = (RealType)cls.newInstance();
            while (cur.hasNext()) {
                cur.next();
                cur.localize(loc);
                nsT.sample(cur.get(), smp);
                ((RealType)cur.get()).set((Type)smp);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

