/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import mosaic.bregman.segmentation.Region;
import mosaic.core.imageUtils.MaskOnSpaceMapper;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.iterators.SpaceIterator;
import mosaic.core.imageUtils.masks.BallMask;
import mosaic.core.psf.psf;
import mosaic.core.psf.psfList;
import mosaic.utils.Debug;
import mosaic.utils.io.csv.CSV;
import mosaic.utils.io.csv.CsvColumnConfig;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class RegionCreator
implements PlugInFilter {
    private int N_region;
    private int Max_radius;
    private int Min_radius;
    private int Max_intensity;
    private int Min_intensity;
    private long[] Image_sz;
    private float[] Spacing;
    protected psf<FloatType> cPSF;
    private double Background;
    protected String conv;
    protected Choice cConv;
    private String imageT;
    private final String[] ImageType = new String[]{"8-bit", "16-bit", "float"};
    private HashMap<Integer, BallMask> map;
    public static final String[] Region3DTrack_map = new String[]{"Frame", "x", "y", "z", "Size", "Intensity", "Surface"};

    private <S extends NumericType<S>> int drawSphereWithRadius(RandomAccessibleInterval<S> out, Point pt, float[] cal, S intensity, int p_radius) {
        if (cal == null) {
            cal = new float[out.numDimensions()];
            for (int i = 0; i < out.numDimensions(); ++i) {
                cal[i] = 1.0f;
            }
        }
        RandomAccess out_a = out.randomAccess();
        int[] sz = new int[out_a.numDimensions()];
        for (int d = 0; d < out_a.numDimensions(); ++d) {
            sz[d] = (int)out.dimension(d);
        }
        double radius = p_radius;
        MaskOnSpaceMapper rg_m = null;
        float min = Float.MAX_VALUE;
        for (int i1 = 0; i1 < cal.length; ++i1) {
            if (!(cal[i1] < min)) continue;
            min = cal[i1];
        }
        float min_s = min;
        Integer rc = (int)(radius / (double)min_s);
        int i = 0;
        while (i < out.numDimensions()) {
            int n = i++;
            cal[n] = cal[n] / min_s;
        }
        if (rc < 1) {
            rc = 1;
        }
        BallMask cm = null;
        cm = this.map.get(rc);
        if (cm != null) {
            throw new RuntimeException();
        }
        cm = new BallMask(rc.intValue(), 2 * rc + 1, cal);
        rg_m = new MaskOnSpaceMapper(cm, sz);
        Point ptt = pt;
        Point p_c = new Point(ptt);
        p_c.div(cal);
        rg_m.setMiddlePoint(p_c);
        int sp = 0;
        while (rg_m.hasNext()) {
            Point p = rg_m.nextPoint();
            if (!p.isInside(sz)) continue;
            out_a.setPosition(p.iCoords);
            ((NumericType)out_a.get()).set(intensity);
            ++sp;
        }
        return sp;
    }

    private <T extends RealType<T> & NativeType<T>> Img<T> createImage(Class<T> cls) {
        Img out = null;
        ArrayImgFactory imgFactory = new ArrayImgFactory();
        try {
            out = imgFactory.create(this.Image_sz, cls.newInstance());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return out;
    }

    private int[] calculateGridPoint(int spacing) {
        int szi = 0;
        System.out.println("Max object size: " + spacing);
        System.out.println("Spacing: " + Debug.getArrayDims(this.Spacing) + " " + Arrays.toString(this.Spacing));
        System.out.println("Image_sz: " + Debug.getArrayDims(this.Image_sz) + " " + Arrays.toString(this.Image_sz));
        for (int i = 0; i < this.Image_sz.length - 1 && this.Image_sz[i] != 1L; ++i) {
            ++szi;
        }
        int[] gs = new int[szi];
        for (int i = 0; i < szi; ++i) {
            int numOfObjects = (int)((float)this.Image_sz[i] / ((float)spacing + this.Spacing[i]));
            if ((float)(this.Image_sz[i] - (long)((float)numOfObjects * ((float)spacing + this.Spacing[i]))) < this.Spacing[i]) {
                --numOfObjects;
            }
            if (numOfObjects < 0) {
                numOfObjects = 0;
            }
            gs[i] = numOfObjects;
        }
        System.out.println("gs: " + Debug.getArrayDims(gs) + " " + Arrays.toString(gs));
        return gs;
    }

    private long totalGridPoint(int[] gs) {
        long gp = 1L;
        for (int i = 0; i < gs.length; ++i) {
            gp *= (long)gs[i];
        }
        return gp;
    }

    private void FillGridPoint(Point[] p, int[] i, int spacing) {
        int cnt = 0;
        Iterator<Point> rg = new SpaceIterator(i).getPointIterator();
        Point t = new Point(new int[i.length]);
        for (int s = 0; s < i.length; ++s) {
            t.iCoords[s] = 1;
        }
        while (rg.hasNext() && cnt < p.length) {
            p[cnt] = rg.next();
            p[cnt] = p[cnt].add(t);
            p[cnt] = p[cnt].mult(spacing);
            p[cnt] = p[cnt].div(this.Spacing);
            ++cnt;
        }
    }

    public static CellProcessor[] getRegion3DTrackCellProcessor() {
        return new CellProcessor[]{new ParseInt(), new ParseDouble(), new ParseDouble(), new ParseDouble(), new ParseDouble(), new ParseDouble(), new ParseDouble()};
    }

    private <T extends RealType<T> & NativeType<T>> void Process(T Background, T max_int, T min_int, int max_radius, int min_radius, Class<T> cls) {
        this.map = new HashMap();
        Vector<Region3DTrack> pt_r = new Vector<Region3DTrack>();
        Img<T> out = this.createImage(cls);
        Cursor c = out.cursor();
        while (c.hasNext()) {
            c.next();
            ((RealType)c.get()).set(Background);
        }
        int i = 0;
        while ((long)i < this.Image_sz[this.Image_sz.length - 1]) {
            IJ.showStatus((String)("Creating frame: " + i));
            int[] gs = null;
            System.out.println("MAX: max_radius: " + max_radius);
            gs = this.calculateGridPoint(2 * max_radius + 1);
            long np = this.totalGridPoint(gs);
            if (np == 0L) {
                IJ.error((String)"The size of the image is too small or the region too big");
                return;
            }
            if (np < (long)this.N_region) {
                IJ.error((String)"Too much region increase the size of the image or reduce the number of the region");
                return;
            }
            Point[] p = new Point[(int)np];
            this.FillGridPoint(p, gs, 2 * max_radius + 1);
            Collections.shuffle(Arrays.asList(p));
            IntervalView vti = Views.hyperSlice(out, (int)(this.Image_sz.length - 1), (long)i);
            for (int k = 0; k < this.N_region; ++k) {
                int s;
                double max_it = max_int.getRealDouble();
                double min_it = min_int.getRealDouble();
                double max_r = max_radius;
                double min_r = min_radius;
                Random r = new Random();
                RealType inte_a = null;
                try {
                    inte_a = (RealType)cls.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    throw new RuntimeException();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException();
                }
                inte_a.setReal(min_it + (max_it - min_it) * r.nextDouble());
                int radius = (int)(min_r + (max_r - min_r) * r.nextDouble());
                Region3DTrack tmp = new Region3DTrack();
                double dif = (int)(max_r - (double)radius);
                double tot = 0.0;
                float[] x = new float[this.Image_sz.length - 1];
                for (s = 0; s < this.Image_sz.length - 1; ++s) {
                    x[s] = r.nextFloat();
                    tot += (double)(x[s] * x[s]);
                }
                tot = Math.sqrt(tot);
                for (s = 0; s < this.Image_sz.length - 1; ++s) {
                    int n = s;
                    x[n] = (float)((double)x[n] / tot);
                    int n2 = s;
                    x[n2] = (float)((double)x[n2] * dif);
                    int n3 = s;
                    p[k].iCoords[n3] = (int)((float)p[k].iCoords[n3] + x[s]);
                }
                int nsp = this.drawSphereWithRadius((RandomAccessibleInterval)vti, p[k], this.Spacing, (NumericType)inte_a, radius);
                tmp.setData(p[k]);
                tmp.setSize(nsp);
                tmp.setIntensity(inte_a.getRealDouble());
                tmp.setFrame(i);
                pt_r.add(tmp);
            }
            this.cPSF.convolve(vti, Background);
            ++i;
        }
        String ImgTitle = new String();
        ImgTitle = ImgTitle + "Regions_size_" + max_radius + "_" + min_radius + "_" + max_int + "_" + min_int;
        ImageJFunctions.show(out, (String)ImgTitle).setDimensions(1, (int)this.Image_sz[2], (int)this.Image_sz[3]);
        CSV<Region3DTrack> P_csv = new CSV<Region3DTrack>(Region3DTrack.class);
        String output = IJ.getDirectory((String)"Choose output directory");
        if (output != null) {
            output = output + ImgTitle + ".csv";
            CsvColumnConfig oc = new CsvColumnConfig(Region3DTrack_map, RegionCreator.getRegion3DTrackCellProcessor());
            P_csv.Write(output, pt_r, oc, false);
        }
    }

    public void run(ImageProcessor arg0) {
        if (this.imageT.equals("8-bit")) {
            UnsignedByteType bck = new UnsignedByteType();
            UnsignedByteType max_int = new UnsignedByteType();
            UnsignedByteType min_int = new UnsignedByteType();
            bck.setReal(this.Background);
            max_int.setReal((float)this.Max_intensity);
            min_int.setReal((float)this.Min_intensity);
            this.Process(bck, max_int, min_int, this.Max_radius, this.Min_radius, UnsignedByteType.class);
        } else if (this.imageT.equals("16-bit")) {
            ShortType bck = new ShortType();
            ShortType max_int = new ShortType();
            ShortType min_int = new ShortType();
            bck.setReal(this.Background);
            max_int.setReal((float)this.Max_intensity);
            min_int.setReal((float)this.Min_intensity);
            this.Process(bck, max_int, min_int, this.Max_radius, this.Min_radius, ShortType.class);
        } else if (this.imageT.equals("float")) {
            FloatType bck = new FloatType();
            FloatType max_int = new FloatType();
            FloatType min_int = new FloatType();
            bck.setReal(this.Background);
            max_int.setReal((float)this.Max_intensity);
            min_int.setReal((float)this.Min_intensity);
            this.Process(bck, max_int, min_int, this.Max_radius, this.Min_radius, FloatType.class);
        }
    }

    public int setup(String arg0, ImagePlus original_imp) {
        GenericDialog gd = new GenericDialog("Region creator");
        gd.addNumericField("Background: ", 7.0, 3);
        gd.addNumericField("Max_radius", 10.0, 0);
        gd.addNumericField("Min_radius", 10.0, 0);
        gd.addNumericField("Max_intensity", 45.0, 3);
        gd.addNumericField("Min_intensity", 10.0, 3);
        gd.addNumericField("N_frame", 100.0, 0);
        gd.addNumericField("Image_X", 512.0, 0);
        gd.addNumericField("Image_Y", 512.0, 0);
        gd.addNumericField("Image_Z", 50.0, 0);
        gd.addNumericField("Spacing_X", 1.0, 1);
        gd.addNumericField("Spacing_Y", 1.0, 1);
        gd.addNumericField("Spacing_Z", 3.0, 1);
        gd.addNumericField("N_regions", 20.0, 0);
        String[] nsc = new String[]{"Gauss"};
        gd.addChoice("Blur", nsc, nsc[0]);
        this.cConv = (Choice)gd.getChoices().lastElement();
        Button optionButton = new Button("Options");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 13;
        c.anchor = 13;
        gd.add((Component)optionButton, (Object)c);
        optionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegionCreator.this.conv = RegionCreator.this.cConv.getSelectedItem();
                RegionCreator.this.cPSF = psfList.factory(RegionCreator.this.conv, 3, FloatType.class);
                if (RegionCreator.this.cPSF == null) {
                    IJ.error((String)("Cannot create " + RegionCreator.this.conv + ", convolution PSF"));
                    return;
                }
                RegionCreator.this.cPSF.getParamenters();
            }
        });
        gd.addChoice("Image_type: ", this.ImageType, this.ImageType[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        this.Background = gd.getNextNumber();
        this.Max_radius = (int)gd.getNextNumber();
        this.Min_radius = (int)gd.getNextNumber();
        this.Max_intensity = (int)gd.getNextNumber();
        this.Min_intensity = (int)gd.getNextNumber();
        long[] tmp = new long[4];
        tmp[3] = (long)gd.getNextNumber();
        tmp[0] = (long)gd.getNextNumber();
        tmp[1] = (long)gd.getNextNumber();
        tmp[2] = (long)gd.getNextNumber();
        if (tmp[2] == 1L) {
            tmp[2] = tmp[3];
            this.Image_sz = new long[3];
            this.Image_sz[0] = tmp[0];
            this.Image_sz[1] = tmp[1];
            this.Image_sz[2] = tmp[2];
            this.Spacing = new float[2];
            this.Spacing[0] = (int)gd.getNextNumber();
            this.Spacing[1] = (int)gd.getNextNumber();
            gd.getNextNumber();
            this.N_region = (int)gd.getNextNumber();
        } else {
            this.Image_sz = new long[4];
            this.Image_sz[0] = tmp[0];
            this.Image_sz[1] = tmp[1];
            this.Image_sz[2] = tmp[2];
            this.Image_sz[3] = tmp[3];
            this.Spacing = new float[3];
            this.Spacing[0] = (int)gd.getNextNumber();
            this.Spacing[1] = (int)gd.getNextNumber();
            this.Spacing[2] = (int)gd.getNextNumber();
            this.N_region = (int)gd.getNextNumber();
        }
        if (this.cPSF == null) {
            this.conv = gd.getNextChoice();
            this.cPSF = psfList.factory(this.conv, this.Image_sz.length - 1, FloatType.class);
            if (this.cPSF == null) {
                IJ.error((String)("Cannot create " + this.conv + ", convolution PSF"));
                return 4096;
            }
        } else {
            gd.getNextChoice();
        }
        this.imageT = gd.getNextChoice();
        if (IJ.isMacro()) {
            this.cPSF.getParamenters();
        }
        this.run(null);
        return 4096;
    }

    public class Region3DTrack {
        private int Frame;
        private double x;
        private double y;
        private double z;
        private double Size;
        private double Intensity;
        private double Surface;

        public void setFrame(int fr) {
            this.Frame = fr;
        }

        public void setx(double x_) {
            this.x = x_;
        }

        public void sety(double y_) {
            this.y = y_;
        }

        public void setz(double z_) {
            this.z = z_;
        }

        public void setIntensity(double Intensity_) {
            this.Intensity = Intensity_;
        }

        public void setSize(double Size_) {
            this.Size = Size_;
        }

        public void setSurface(double Surface_) {
            this.Surface = Surface_;
        }

        public int getFrame() {
            return this.Frame;
        }

        public double getx() {
            return this.x;
        }

        public double gety() {
            return this.y;
        }

        public double getz() {
            return this.z;
        }

        public double getIntensity() {
            return this.Intensity;
        }

        public double getSize() {
            return this.Size;
        }

        public double getSurface() {
            return this.Surface;
        }

        public void setData(Region r) {
            this.Frame = 0;
            this.x = r.getcx();
            this.y = r.getcy();
            this.z = r.getcz();
            this.Size = r.getrsize();
            this.Intensity = r.getintensity();
            this.Surface = r.getperimeter();
        }

        public void setData(Region3DTrack r) {
            this.Frame = r.Frame;
            this.x = r.x;
            this.y = r.y;
            this.z = r.z;
            this.Size = r.Size;
            this.Intensity = r.Intensity;
            this.Surface = r.Surface;
        }

        public void setObject_ID(int Object_ID_) {
        }

        public void setPerimeter(double Perimeter_) {
            this.Surface = Perimeter_;
        }

        public void setLength(double Length_) {
        }

        public void setImage_ID(int Image_ID_) {
            this.Frame = Image_ID_;
        }

        public void Coord_X(double Coord_X_) {
            this.x = Coord_X_;
        }

        public void Coord_Y(double Coord_Y_) {
            this.y = Coord_Y_;
        }

        public void Coord_Z(double Coord_Z_) {
            this.z = Coord_Z_;
        }

        public void setCoord_X(double Coord_X_) {
            this.x = Coord_X_;
        }

        public void setCoord_Y(double Coord_Y_) {
            this.y = Coord_Y_;
        }

        public void setCoord_Z(double Coord_Z_) {
            this.z = Coord_Z_;
        }

        public int getImage_ID() {
            return this.Frame;
        }

        public int getObject_ID() {
            return 0;
        }

        public double getPerimeter() {
            return 0.0;
        }

        public double getLength() {
            return 0.0;
        }

        public double getCoord_X() {
            return this.x;
        }

        public double getCoord_Y() {
            return this.y;
        }

        public double getCoord_Z() {
            return this.z;
        }

        public void setData(Point point) {
            if (point.iCoords.length >= 3) {
                this.x = point.iCoords[0];
                this.y = point.iCoords[1];
                this.z = point.iCoords[2];
            } else {
                this.x = point.iCoords[0];
                this.y = point.iCoords[1];
            }
        }

        public void setFile(String dummy) {
        }

        public String getFile() {
            return null;
        }
    }
}

