/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins.utils;

import ij.gui.GenericDialog;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import mosaic.plugins.utils.PlugInFloatBase;
import mosaic.variationalCurvatureFilters.CurvatureFilter;
import mosaic.variationalCurvatureFilters.FilterKernel;
import mosaic.variationalCurvatureFilters.FilterKernelBernstein;
import mosaic.variationalCurvatureFilters.FilterKernelGc;
import mosaic.variationalCurvatureFilters.FilterKernelMc;
import mosaic.variationalCurvatureFilters.FilterKernelTv;
import mosaic.variationalCurvatureFilters.NoSplitFilter;
import mosaic.variationalCurvatureFilters.SplitFilter;

public abstract class CurvatureFilterBase
extends PlugInFloatBase {
    private CurvatureFilter iCf;
    private int iNumberOfIterations;
    private boolean hasSplitMethodMenu = false;

    protected void setSplitMethodMenu(boolean aSplitMethodMenuAvailable) {
        this.hasSplitMethodMenu = aSplitMethodMenuAvailable;
    }

    protected CurvatureFilter getCurvatureFilter() {
        return this.iCf;
    }

    protected int getNumberOfIterations() {
        return this.iNumberOfIterations;
    }

    @Override
    protected boolean showDialog() {
        String[] filters = new String[]{"GC (Gaussian Curvature)", "MC (Mean Curvature)", "TV (Total Variation)", "Bernstein"};
        String[] types = new String[]{"Split", "No split"};
        GenericDialog gd = new GenericDialog("Curvature Filter Settings");
        gd.addRadioButtonGroup("Filter type: ", filters, 4, 1, filters[0]);
        if (this.hasSplitMethodMenu) {
            gd.addRadioButtonGroup("Method: ", types, 1, 2, types[1]);
        }
        gd.addNumericField("Number of iterations: ", 10.0, 0);
        gd.addMessage("\n");
        String referenceInfo = "\n@phdthesis{gong:phd, \n  title={Spectrally regularized surfaces}, \n  author={Gong, Yuanhao}, \n  year={2015}, \n  school={ETH Zurich, Nr. 22616},\n  note={http://dx.doi.org/10.3929/ethz-a-010438292}}\n\n";
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        TextArea ta = new TextArea("\n@phdthesis{gong:phd, \n  title={Spectrally regularized surfaces}, \n  author={Gong, Yuanhao}, \n  year={2015}, \n  school={ETH Zurich, Nr. 22616},\n  note={http://dx.doi.org/10.3929/ethz-a-010438292}}\n\n", 8, 50, 3);
        ta.setBackground(SystemColor.control);
        ta.setEditable(false);
        ta.setFocusable(true);
        panel.add(ta);
        gd.addPanel(panel);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            String filter = gd.getNextRadioButton();
            String type = this.hasSplitMethodMenu ? gd.getNextRadioButton() : types[1];
            this.iNumberOfIterations = (int)gd.getNextNumber();
            FilterKernel fk = null;
            if (filter.equals(filters[0])) {
                fk = new FilterKernelGc();
            } else if (filter.equals(filters[1])) {
                fk = new FilterKernelMc();
            } else if (filter.equals(filters[2])) {
                fk = new FilterKernelTv();
            } else if (filter.equals(filters[3])) {
                fk = new FilterKernelBernstein();
            }
            if (fk == null) {
                return false;
            }
            this.iCf = type.equals(types[0]) ? new SplitFilter(fk) : new NoSplitFilter(fk);
            if (this.iCf != null && this.iNumberOfIterations >= 0) {
                return true;
            }
        }
        return false;
    }
}

