/*
 * Decompiled with CFR 0.152.
 */
package mosaic.plugins.utils;

import ij.IJ;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import mosaic.plugins.utils.PlugInBase;

public abstract class PlugInFloat3DBase
extends PlugInBase {
    private int iFlags = 65567;

    protected abstract void processImg(FloatProcessor[] var1, FloatProcessor[] var2, int var3);

    @Override
    protected int getFlags() {
        return this.iFlags;
    }

    @Override
    protected void updateFlags(int aFlag) {
        this.iFlags |= aFlag;
    }

    public void run(ImageProcessor aIp) {
        IJ.showStatus((String)"In progress...");
        int noOfChannels = this.iInputImg.getNChannels();
        int noOfSlices = this.iInputImg.getNSlices();
        int noOfFrames = this.iInputImg.getNFrames();
        int noOfColorChannelsInProcessor = this.iInputImg.getProcessor().getNChannels();
        ArrayList<Thread> th = new ArrayList<Thread>();
        ArrayList<ProcessOneCube> poc = new ArrayList<ProcessOneCube>();
        for (int frame = 0; frame < noOfFrames; ++frame) {
            for (int channel = 0; channel < noOfChannels; ++channel) {
                for (int i = 0; i < noOfColorChannelsInProcessor; ++i) {
                    ImageProcessor[] currentIps = new ImageProcessor[noOfSlices];
                    FloatProcessor[] results = new FloatProcessor[noOfSlices];
                    FloatProcessor[] originals = new FloatProcessor[noOfSlices];
                    for (int slice = 0; slice < noOfSlices; ++slice) {
                        FloatProcessor result = null;
                        ImageProcessor currentIp = null;
                        int stackNo = this.iInputImg.getStackIndex(channel + 1, slice + 1, frame + 1);
                        if (this.iResultOutput != PlugInBase.ResultOutput.NONE) {
                            currentIp = this.iProcessedImg.getStack().getProcessor(stackNo);
                            result = currentIp.toFloat(i, null);
                        }
                        ImageProcessor processor = this.iInputImg.getStack().getProcessor(stackNo);
                        FloatProcessor orig = processor.toFloat(i, null);
                        orig.setSliceNumber(stackNo);
                        currentIps[slice] = currentIp;
                        results[slice] = result;
                        originals[slice] = orig;
                    }
                    ProcessOneCube p = new ProcessOneCube(currentIps, results, originals, i);
                    Thread t = new Thread(p);
                    th.add(t);
                    poc.add(p);
                }
            }
        }
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            for (Runnable runnable : th) {
                executor.execute(runnable);
            }
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < th.size(); ++i) {
            ((ProcessOneCube)poc.get(i)).update();
        }
        IJ.showStatus((String)"Done.");
    }

    private class ProcessOneCube
    implements Runnable {
        int iColorChannel;
        ImageProcessor[] iCurrentIp;
        FloatProcessor[] iResultImg;
        FloatProcessor[] iOriginalImg;

        ProcessOneCube(ImageProcessor[] aCurrentIp, FloatProcessor[] aResultImg, FloatProcessor[] aOriginalImg, int aColorChannel) {
            this.iColorChannel = aColorChannel;
            this.iCurrentIp = aCurrentIp;
            this.iResultImg = aResultImg;
            this.iOriginalImg = aOriginalImg;
        }

        @Override
        public void run() {
            PlugInFloat3DBase.this.processImg(this.iResultImg, this.iOriginalImg, this.iColorChannel);
        }

        public void update() {
            if (PlugInFloat3DBase.this.iResultOutput != PlugInBase.ResultOutput.NONE) {
                for (int slice = 0; slice < this.iCurrentIp.length; ++slice) {
                    this.iCurrentIp[slice].setPixels(this.iColorChannel, this.iResultImg[slice]);
                }
            }
        }
    }
}

