/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.DRS;

import java.util.ArrayList;
import java.util.List;
import mosaic.utils.ImgUtils;
import net.imglib2.Cursor;
import net.imglib2.algorithm.fft2.FFTConvolution;
import net.imglib2.algorithm.stats.Normalize;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.real.FloatType;

public class SobelImg {
    public static Img<FloatType> filter(Img<FloatType> aImg, boolean aChangeInput) {
        int numDimensions = aImg.numDimensions();
        if (numDimensions < 2 || numDimensions > 3) {
            throw new RuntimeException("Unhandled number of dimensions (only 2D and 3D is possible): " + numDimensions);
        }
        Img<FloatType> outputImg = aChangeInput ? aImg : ImgUtils.createNewEmpty(aImg);
        ArrayList<Img> imgs = new ArrayList<Img>(numDimensions);
        ArrayList<Cursor> cursors = new ArrayList<Cursor>(numDimensions);
        for (int i = 0; i < numDimensions; ++i) {
            Img newImg = aImg.copy();
            imgs.add(newImg);
            cursors.add(newImg.cursor());
        }
        List<Img<FloatType>> kernels = SobelImg.generateKernels(numDimensions);
        for (int i = 0; i < numDimensions; ++i) {
            new FFTConvolution((Img)imgs.get(i), kernels.get(i)).convolve();
        }
        Cursor o = outputImg.cursor();
        while (o.hasNext()) {
            o.fwd();
            double v = 0.0;
            for (int i = 0; i < numDimensions; ++i) {
                Cursor c = (Cursor)cursors.get(i);
                c.fwd();
                v += Math.pow(((FloatType)c.get()).getRealDouble(), 2.0);
            }
            ((FloatType)o.get()).setReal(Math.sqrt(v));
        }
        Normalize.normalize(outputImg, (NumericType)new FloatType(0.0f), (NumericType)new FloatType(1.0f));
        return outputImg;
    }

    private static List<Img<FloatType>> generateKernels(int numDimensions) {
        ArrayList<Img<FloatType>> kernels = new ArrayList<Img<FloatType>>(numDimensions);
        if (numDimensions == 2) {
            int len = 3;
            double[][] k = new double[3][3];
            k[0][0] = -0.1111111111111111;
            k[0][1] = 0.0;
            k[0][2] = 0.1111111111111111;
            k[1][0] = -0.2222222222222222;
            k[1][1] = 0.0;
            k[1][2] = 0.2222222222222222;
            k[2][0] = -0.1111111111111111;
            k[2][1] = 0.0;
            k[2][2] = 0.1111111111111111;
            float[] k1 = new float[9];
            float[] k2 = new float[9];
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    k1[3 * x + y] = (float)k[x][y];
                    k2[3 * x + y] = (float)k[y][x];
                }
            }
            kernels.add((Img<FloatType>)ArrayImgs.floats((float[])k1, (long[])new long[]{3L, 3L}));
            kernels.add((Img<FloatType>)ArrayImgs.floats((float[])k2, (long[])new long[]{3L, 3L}));
        } else if (numDimensions == 3) {
            int len = 3;
            double[][][] k = new double[3][3][3];
            k[0][0][0] = -0.07407407407407407;
            k[0][0][1] = 0.0;
            k[0][0][2] = 0.07407407407407407;
            k[0][1][0] = -0.1111111111111111;
            k[0][1][1] = 0.0;
            k[0][1][2] = 0.1111111111111111;
            k[0][2][0] = -0.07407407407407407;
            k[0][2][1] = 0.0;
            k[0][2][2] = 0.07407407407407407;
            k[1][0][0] = -0.1111111111111111;
            k[1][0][1] = 0.0;
            k[1][0][2] = 0.1111111111111111;
            k[1][1][0] = -0.2222222222222222;
            k[1][1][1] = 0.0;
            k[1][1][2] = 0.2222222222222222;
            k[1][2][0] = -0.1111111111111111;
            k[1][2][1] = 0.0;
            k[1][2][2] = 0.1111111111111111;
            k[2][0][0] = -0.07407407407407407;
            k[2][0][1] = 0.0;
            k[2][0][2] = 0.07407407407407407;
            k[2][1][0] = -0.1111111111111111;
            k[2][1][1] = 0.0;
            k[2][1][2] = 0.1111111111111111;
            k[2][2][0] = -0.07407407407407407;
            k[2][2][1] = 0.0;
            k[2][2][2] = 0.07407407407407407;
            float[] k1 = new float[27];
            float[] k2 = new float[27];
            float[] k3 = new float[27];
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    for (int z = 0; z < 3; ++z) {
                        k1[9 * x + 3 * y + z] = (float)k[x][y][z];
                        k2[9 * x + 3 * y + z] = (float)k[x][z][y];
                        k3[9 * x + 3 * y + z] = (float)k[z][y][x];
                    }
                }
            }
            kernels.add((Img<FloatType>)ArrayImgs.floats((float[])k1, (long[])new long[]{3L, 3L, 3L}));
            kernels.add((Img<FloatType>)ArrayImgs.floats((float[])k2, (long[])new long[]{3L, 3L, 3L}));
            kernels.add((Img<FloatType>)ArrayImgs.floats((float[])k3, (long[])new long[]{3L, 3L, 3L}));
        }
        return kernels;
    }
}

