/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.DRS;

import ij.ImagePlus;
import volume.Kernel;
import volume.Sobel;
import volume.Sobel3D;
import volume.VolumeFloat;

public class SobelVolume
extends VolumeFloat {
    private static final long serialVersionUID = 1L;
    private VolumeFloat iVolume;

    public SobelVolume(ImagePlus aImage) {
        super(aImage.getWidth(), aImage.getHeight(), aImage.getNSlices(), 1.0, 1.0, 1.0);
        this.iVolume = new VolumeFloat(aImage.getWidth(), aImage.getHeight(), aImage.getNSlices());
        this.iVolume.load(aImage.getImageStack(), 0);
    }

    public void sobel2D() {
        Sobel aKernel = new Sobel();
        int depthoffset = this.InitParams(this.iVolume, (Kernel)aKernel);
        if (depthoffset < 0) {
            return;
        }
        float[][][] volume = this.iVolume.v;
        double[][] kernel = aKernel.k;
        int kernelWidth = aKernel.halfwidth;
        for (int z = 0; z < this.depth; ++z) {
            int vz = z + depthoffset;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    if (this.valid(x, y)) {
                        double dx = 0.0;
                        double dy = 0.0;
                        for (int l = -kernelWidth; l <= kernelWidth; ++l) {
                            int kx = l + kernelWidth;
                            int vy = y + l;
                            for (int k = -kernelWidth; k <= kernelWidth; ++k) {
                                int ky = k + kernelWidth;
                                int vx = x + k;
                                float val = volume[vz][vy][vx];
                                dx += (double)val * kernel[kx][ky];
                                dy += (double)val * kernel[ky][kx];
                            }
                        }
                        this.v[z][y][x] = (float)Math.sqrt(dx * dx + dy * dy);
                        continue;
                    }
                    this.v[z][y][x] = 0.0f;
                }
            }
        }
    }

    public void sobel3D() {
        Sobel3D aKernel = new Sobel3D();
        int depthoffset = this.InitParams(this.iVolume, (Kernel)aKernel);
        if (depthoffset < 0) {
            return;
        }
        float[][][] volume = this.iVolume.v;
        double[][][] kernel = aKernel.k;
        int kernelWidth = aKernel.halfwidth;
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    if (this.valid(x, y, z)) {
                        double dx = 0.0;
                        double dy = 0.0;
                        double dz = 0.0;
                        for (int m = -kernelWidth; m <= kernelWidth; ++m) {
                            int kx = m + kernelWidth;
                            int vz = z + depthoffset + m;
                            for (int l = -kernelWidth; l <= kernelWidth; ++l) {
                                int ky = l + kernelWidth;
                                int vy = y + l;
                                for (int k = -kernelWidth; k <= kernelWidth; ++k) {
                                    int kz = k + kernelWidth;
                                    int vx = x + k;
                                    float val = volume[vz][vy][vx];
                                    dx += (double)val * kernel[kx][ky][kz];
                                    dy += (double)val * kernel[kx][kz][ky];
                                    dz += (double)val * kernel[kz][ky][kx];
                                }
                            }
                        }
                        this.v[z][y][x] = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                        continue;
                    }
                    this.v[z][y][x] = 0.0f;
                }
            }
        }
    }

    private int InitParams(VolumeFloat aVolume, Kernel aKernel) {
        if (this.width < aVolume.getWidth() || this.height < aVolume.getHeight() || this.depth > aVolume.getDepth()) {
            throw new RuntimeException("SobelVolume: convolution volume wrong size.");
        }
        if (aVolume.getEdge() > this.edge) {
            this.edge = aVolume.getEdge();
        }
        if (aKernel.halfwidth > this.edge) {
            this.edge = aKernel.halfwidth;
        }
        return this.depth < aVolume.getDepth() ? (aVolume.getDepth() - this.depth) / 2 : 0;
    }
}

