/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.GUI;

import mosaic.regions.GUI.CurvatureFlowGUI;
import mosaic.regions.GUI.DefaultRegularizationGUI;
import mosaic.regions.GUI.SettingsBaseGUI;
import mosaic.regions.RegionsUtils;
import mosaic.regions.Settings;

abstract class RegularizationGUI
extends SettingsBaseGUI {
    protected RegularizationGUI(Settings aSettings) {
        super(aSettings);
    }

    private static RegularizationGUI factory(Settings aSettings, RegionsUtils.RegularizationType type) {
        RegularizationGUI result = null;
        switch (type) {
            case Sphere_Regularization: {
                result = new CurvatureFlowGUI(aSettings);
                break;
            }
            default: {
                result = new DefaultRegularizationGUI();
            }
        }
        return result;
    }

    public static RegularizationGUI factory(Settings aSettings, String regularization) {
        RegionsUtils.RegularizationType type = RegionsUtils.RegularizationType.getEnum(regularization);
        return RegularizationGUI.factory(aSettings, type);
    }
}

