/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.GUI;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import mosaic.core.imageUtils.images.IntensityImage;
import mosaic.core.imageUtils.images.LabelImage;

public class SegmentationProcessWindow {
    protected ImageStack iStack;
    protected ImagePlus iImage;
    private int iMaxLabel = 0;
    private boolean iShouldKeepAllSlices = false;
    private boolean iIsThatFirstPass = true;

    public SegmentationProcessWindow(int aWidth, int aHeight, boolean aShouldKeepAllSlices, boolean aFloat) {
        this.iShouldKeepAllSlices = aShouldKeepAllSlices;
        this.iImage = !aFloat ? new ImagePlus(null, (ImageProcessor)new ShortProcessor(aWidth, aHeight)) : new ImagePlus(null, (ImageProcessor)new FloatProcessor(aWidth, aHeight));
        this.iStack = this.iImage.createEmptyStack();
        if (this.iImage.getWindow() != null) {
            this.iImage.getWindow().addWindowListener((WindowListener)new StackWindowListener());
        }
    }

    public SegmentationProcessWindow(int aWidth, int aHeight, boolean aShouldKeepAllSlices) {
        this(aWidth, aHeight, aShouldKeepAllSlices, false);
    }

    public void setImageTitle(String aTitle) {
        this.iImage.setTitle(aTitle);
    }

    public ImagePlus getImage() {
        return this.iImage;
    }

    public void addSliceToStack(IntensityImage aLabelImage, String aTitle, boolean aShowImg) {
        if (this.iStack == null) {
            return;
        }
        if (aLabelImage.getNumOfDimensions() > 3) {
            throw new RuntimeException("Unsupported dimensions: " + aLabelImage.getNumOfDimensions());
        }
        this.addStack(aTitle, aLabelImage.getFloatStack(), aShowImg);
        if (this.iIsThatFirstPass) {
            this.iIsThatFirstPass = false;
            this.iImage.setStack(this.iStack);
            if (aShowImg) {
                this.iImage.show();
            }
        }
    }

    public void addSliceToStack(LabelImage aLabelImage, String aTitle, int aBiggestLabelSoFar, boolean aShowImg) {
        if (this.iStack == null) {
            return;
        }
        if (aLabelImage.getNumOfDimensions() > 3) {
            throw new RuntimeException("Unsupported dimensions: " + aLabelImage.getNumOfDimensions());
        }
        this.addStack(aTitle, aLabelImage.getShortStack(false, false, false), aShowImg);
        if (this.iIsThatFirstPass) {
            this.iIsThatFirstPass = false;
            this.iImage.setStack(this.iStack);
            if (aShowImg) {
                this.iImage.show();
            }
        }
        if (aBiggestLabelSoFar > this.iMaxLabel) {
            this.iMaxLabel = 2 * aBiggestLabelSoFar;
            IJ.setMinAndMax((ImagePlus)this.iImage, (double)0.0, (double)this.iMaxLabel);
            IJ.run((ImagePlus)this.iImage, (String)"3-3-2 RGB", null);
        }
    }

    private void addStack(String aTitle, ImageStack aStack, boolean aShowImg) {
        boolean isLastFrameInImage;
        int lastFrame;
        if (!this.iShouldKeepAllSlices) {
            while (this.iStack.getSize() > 0) {
                this.iStack.deleteLastSlice();
            }
        } else {
            while (this.iStack.getSize() % aStack.getSize() != 0) {
                this.iStack.deleteSlice(1);
            }
        }
        int lastSlice = this.iImage.getSlice();
        int nextFrame = lastFrame = this.iImage.getFrame();
        boolean bl = isLastFrameInImage = lastFrame == this.iImage.getDimensions()[4];
        if (isLastFrameInImage) {
            ++nextFrame;
        }
        for (int i = 1; i <= aStack.getSize(); ++i) {
            this.iStack.addSlice(aTitle, aStack.getProcessor(i));
        }
        int depth = aStack.getSize();
        int frame = this.iStack.getSize() / depth;
        this.iImage.setDimensions(1, depth, frame);
        if (this.iShouldKeepAllSlices && frame == 2) {
            this.iImage.setOpenAsHyperStack(true);
            if (aShowImg) {
                new StackWindow(this.iImage);
            }
        }
        if (this.iIsThatFirstPass) {
            lastSlice = (depth + 1) / 2;
        }
        this.iImage.setPosition(1, lastSlice, nextFrame);
    }

    private class StackWindowListener
    implements WindowListener {
        protected StackWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SegmentationProcessWindow.this.iStack = null;
        }

        @Override
        public void windowClosed(WindowEvent e) {
            ImageWindow win = SegmentationProcessWindow.this.iImage.getWindow();
            if (win != null) {
                win.addWindowListener(this);
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }
    }
}

