/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.GUI;

import java.awt.TextArea;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import mosaic.regions.GUI.GuiRC;

class TextAreaListener
implements DropTargetListener,
TextListener,
FocusListener {
    private final TextArea textArea;
    private final String defaultText;
    private final GuiRC gd;

    protected TextAreaListener(GuiRC gd, TextArea ta, String defaulftTxt) {
        this.gd = gd;
        this.textArea = ta;
        this.defaultText = defaulftTxt;
        new DropTarget(ta, this);
        ta.addTextListener(this);
        ta.addFocusListener(this);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        DataFlavor[] flavors;
        boolean failed = true;
        boolean done = false;
        event.acceptDrop(3);
        Transferable transferable = event.getTransferable();
        for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
            try {
                if (flavor.isFlavorJavaFileListType() && !done) {
                    List files = (List)transferable.getTransferData(flavor);
                    for (File file : files) {
                        String filename = file.getPath();
                        this.textArea.setText(filename);
                        this.textArea.validate();
                        failed = false;
                        done = true;
                    }
                    continue;
                }
                if (!flavor.isRepresentationClassInputStream() || done) continue;
                JTextArea ta = new JTextArea();
                ta.read(new InputStreamReader((InputStream)transferable.getTransferData(flavor)), "from system clipboard");
                String dndString = ta.getText().trim();
                StringTokenizer tokenizer = new StringTokenizer(dndString);
                String elem = "";
                while (tokenizer.hasMoreElements() && !(elem = tokenizer.nextToken()).startsWith("file")) {
                    elem = "";
                }
                this.textArea.setText(elem);
                ta.setText(null);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (failed) {
            String data = null;
            try {
                DataFlavor nixFileDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
                data = (String)transferable.getTransferData(nixFileDataFlavor);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            StringTokenizer st = new StringTokenizer(data, "\r\n");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.startsWith("#") || token.isEmpty()) continue;
                this.textArea.setText(token);
            }
        }
        event.dropComplete(true);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void textValueChanged(TextEvent e) {
        String text = this.textArea.getText();
        if (!text.isEmpty() && !text.equals(this.defaultText)) {
            if (this.defaultText.equals("Drop Label Image here, or insert Path to file")) {
                this.gd.setLabelImageChoiceEmpty();
            }
            if (this.defaultText.equals("Input Image: \n\nDrop image here,\ninsert Path to file,\nor press Button below")) {
                this.gd.setInputImageChoiceEmpty();
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.textArea.getText().equals(this.defaultText)) {
            this.textArea.setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.textArea.getText().isEmpty()) {
            this.textArea.setText(this.defaultText);
        }
    }
}

