/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.RC;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import mosaic.core.binarize.BinarizedImage;
import mosaic.core.binarize.BinarizedIntervalLabelImage;
import mosaic.core.imageUtils.FloodFill;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.IntensityImage;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.imageUtils.iterators.SpaceIterator;
import mosaic.regions.RC.ContourParticle;
import mosaic.regions.RC.ContourParticleWithIndex;
import mosaic.regions.RC.LabelDispenser;
import mosaic.regions.RC.LabelPair;
import mosaic.regions.RC.SettingsRC;
import mosaic.regions.energies.E_Deconvolution;
import mosaic.regions.energies.Energy;
import mosaic.regions.energies.ImageModel;
import mosaic.regions.energies.OscillationDetection;
import mosaic.regions.topology.TopologicalNumber;
import mosaic.regions.utils.LabelStatisticToolbox;
import mosaic.regions.utils.LabelStatistics;
import org.apache.log4j.Logger;

public class AlgorithmRC {
    private static final Logger logger = Logger.getLogger(AlgorithmRC.class);
    private final LabelImage iLabelImage;
    private final IntensityImage iIntensityImage;
    private final ImageModel iImageModel;
    private final SettingsRC iSettings;
    private final HashMap<Point, ContourParticle> iContourParticles = new HashMap();
    private final HashMap<Integer, LabelStatistics> iLabelStatistics = new HashMap();
    private final HashMap<Point, LabelPair> iCompetingRegions = new HashMap();
    private final HashMap<Point, ContourParticle> iCandidates = new HashMap();
    private final LabelDispenser labelDispenser = new LabelDispenser();
    private final OscillationDetection oscillationDetection;
    private final TopologicalNumber iTopologicalNumber;
    private static final float AcceptedPointsFactor = 1.0f;
    private static final boolean RemoveNonSignificantRegions = true;
    private static final int MinimumAreaSize = 1;
    private boolean shrinkFirst = false;
    private float acceptedPointsFactor = 1.0f;

    public AlgorithmRC(IntensityImage aIntensityImage, LabelImage aLabelImage, ImageModel aModel, SettingsRC aSettings) {
        this.iLabelImage = aLabelImage;
        this.iIntensityImage = aIntensityImage;
        this.iImageModel = aModel;
        this.iSettings = aSettings;
        this.oscillationDetection = new OscillationDetection(this.iSettings.oscillationThreshold, this.iSettings.maxNumOfIterations);
        this.iTopologicalNumber = new TopologicalNumber(this.iLabelImage);
        this.iLabelImage.initBorder();
        List<Point> contourPoints = this.iLabelImage.initContour();
        this.initContourContainer(contourPoints);
        int maxUsedLabel = LabelStatisticToolbox.initStatistics(this.iLabelImage, this.iIntensityImage, this.iLabelStatistics);
        this.labelDispenser.setMaxValueOfUsedLabel(maxUsedLabel);
        this.initEnergies();
    }

    private void initContourContainer(List<Point> aContourPoints) {
        for (Point point : aContourPoints) {
            ContourParticle particle = new ContourParticle(this.iLabelImage.getLabelAbs(point), this.iIntensityImage.get(point));
            this.iContourParticles.put(point, particle);
        }
    }

    double CalculateVariance(double aSumSq, double aMean, int aN) {
        if (aN < 2) {
            return 0.0;
        }
        return (aSumSq - (double)aN * aMean * aMean) / ((double)aN - 1.0);
    }

    public int getBiggestLabel() {
        return this.labelDispenser.getHighestLabelEverUsed();
    }

    public HashMap<Integer, LabelStatistics> getLabelStatistics() {
        return this.iLabelStatistics;
    }

    private void initEnergies() {
        if (this.iSettings.usingDeconvolutionPcEnergy) {
            ((E_Deconvolution)this.iImageModel.getEdata()).GenerateModelImage(this.iLabelImage, this.iLabelStatistics);
            ((E_Deconvolution)this.iImageModel.getEdata()).RenewDeconvolution(this.iLabelImage, this.iLabelStatistics);
        }
    }

    public void calculateRegionsCenterOfMass() {
        for (LabelStatistics labelStats : this.iLabelStatistics.values()) {
            for (int i = 0; i < labelStats.iMeanPosition.length; ++i) {
                labelStats.iMeanPosition[i] = 0.0;
            }
        }
        Iterator<Point> ri = new SpaceIterator(this.iLabelImage.getDimensions()).getPointIterator();
        while (ri.hasNext()) {
            Point point = ri.next();
            int label = this.iLabelImage.getLabel(point);
            LabelStatistics labelStats = this.iLabelStatistics.get(this.iLabelImage.labelToAbs(label));
            if (labelStats != null) {
                for (int i = 0; i < point.getNumOfDimensions(); ++i) {
                    int n = i;
                    labelStats.iMeanPosition[n] = labelStats.iMeanPosition[n] + (double)point.iCoords[i];
                }
                continue;
            }
            if (this.iLabelImage.isBorderLabel(label)) continue;
            logger.error((Object)("Cound not find label statistics for label: " + label + " at: " + point));
        }
        for (LabelStatistics labelStats : this.iLabelStatistics.values()) {
            int i = 0;
            while (i < labelStats.iMeanPosition.length) {
                int n = i++;
                labelStats.iMeanPosition[n] = labelStats.iMeanPosition[n] / (double)labelStats.iLabelCount;
            }
        }
    }

    private void changeNeighboursOfParticleToCountour(int aAbsLabel, Point aPoint) {
        if (this.iLabelImage.isContourLabel(aAbsLabel)) {
            logger.error((Object)("AddNeighborsAtRemove. one label is not absLabel " + aAbsLabel + " at " + aPoint));
        }
        for (Integer p : this.iLabelImage.iterateNeighbours(aPoint)) {
            int label = this.iLabelImage.getLabel(p);
            if (!this.iLabelImage.isInnerLabel(label) || label != aAbsLabel) continue;
            ContourParticle q = new ContourParticle(aAbsLabel, this.iIntensityImage.get(p));
            q.candidateLabel = 0;
            this.iLabelImage.setLabel(p, this.iLabelImage.labelToNeg(aAbsLabel));
            this.iContourParticles.put(this.iLabelImage.indexToPoint(p), q);
        }
    }

    private void removeEnclosedNeighboursFromContour(int aLabelAbs, Point aPoint) {
        for (int qIndex : this.iLabelImage.iterateNeighbours(aPoint)) {
            if (this.iLabelImage.getLabel(qIndex) != this.iLabelImage.labelToNeg(aLabelAbs) || !this.iLabelImage.isEnclosedByLabel(qIndex, aLabelAbs)) continue;
            this.iContourParticles.remove(this.iLabelImage.indexToPoint(qIndex));
            this.iLabelImage.setLabel(qIndex, aLabelAbs);
        }
        if (this.iLabelImage.isEnclosedByLabel(aPoint, aLabelAbs)) {
            this.iContourParticles.remove(aPoint);
            this.iLabelImage.setLabel(aPoint, aLabelAbs);
        }
    }

    private void changeContourPointLabelToCandidateLabelAndUpdateNeighbours(Point aPoint, ContourParticle aContourParticle) {
        int fromLabel = aContourParticle.label;
        int toLabel = aContourParticle.candidateLabel;
        float intensity = aContourParticle.intensity;
        this.iLabelImage.setLabel(aPoint, this.iLabelImage.labelToNeg(toLabel));
        LabelStatisticToolbox.updateLabelStatistics(intensity, fromLabel, toLabel, this.iLabelStatistics);
        if (this.iSettings.usingDeconvolutionPcEnergy) {
            ((E_Deconvolution)this.iImageModel.getEdata()).UpdateConvolvedImage(aPoint, fromLabel, toLabel, this.iLabelStatistics);
        }
        aContourParticle.candidateLabel = fromLabel;
        if (fromLabel != 0) {
            this.changeNeighboursOfParticleToCountour(fromLabel, aPoint);
        }
        if (toLabel == 0) {
            this.iContourParticles.remove(aPoint);
        } else {
            aContourParticle.label = toLabel;
            this.iContourParticles.put(aPoint, aContourParticle);
            this.removeEnclosedNeighboursFromContour(toLabel, aPoint);
        }
    }

    private void removeSinglePointRegions() {
        Object[] array;
        for (Object o : array = this.iContourParticles.entrySet().toArray()) {
            Map.Entry vIt = (Map.Entry)o;
            ContourParticle contourParticle = (ContourParticle)vIt.getValue();
            LabelStatistics labelStat = this.iLabelStatistics.get(contourParticle.label);
            if (labelStat == null) {
                logger.error((Object)("There is not label statistics for label: " + contourParticle.label + " at " + vIt.getKey()));
                continue;
            }
            if (labelStat.iLabelCount != 1) continue;
            contourParticle.candidateLabel = 0;
            this.changeContourPointLabelToCandidateLabelAndUpdateNeighbours((Point)vIt.getKey(), (ContourParticle)vIt.getValue());
        }
        LabelStatisticToolbox.removeEmptyStatistics(this.iLabelStatistics);
    }

    private void removeNotSignificantRegions() {
        for (Map.Entry<Integer, LabelStatistics> labelStats : this.iLabelStatistics.entrySet()) {
            int label = labelStats.getKey();
            if (label == 0 || labelStats.getValue().iLabelCount > 1) continue;
            this.removeRegion(label);
        }
        LabelStatisticToolbox.removeEmptyStatistics(this.iLabelStatistics);
    }

    private void removeRegion(int aLabel) {
        HashMap<Point, ContourParticle> labelParticles = new HashMap<Point, ContourParticle>();
        for (Map.Entry<Point, ContourParticle> particleIt : this.iContourParticles.entrySet()) {
            if (particleIt.getValue().label != aLabel) continue;
            labelParticles.put(particleIt.getKey(), particleIt.getValue());
        }
        while (!labelParticles.isEmpty()) {
            Iterator iter = labelParticles.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry tmp = iter.next();
                ((ContourParticle)tmp.getValue()).candidateLabel = 0;
                this.changeContourPointLabelToCandidateLabelAndUpdateNeighbours((Point)tmp.getKey(), (ContourParticle)tmp.getValue());
                iter.remove();
            }
            if (this.iLabelStatistics.get((Object)Integer.valueOf((int)aLabel)).iLabelCount <= 0) continue;
            for (Map.Entry<Point, ContourParticle> particleIt : this.iContourParticles.entrySet()) {
                if (particleIt.getValue().label != aLabel) continue;
                labelParticles.put(particleIt.getKey(), particleIt.getValue());
            }
        }
    }

    private void limitNumberOfCandidates() {
        if (this.acceptedPointsFactor >= 1.0f) {
            return;
        }
        LinkedList<ContourParticleWithIndex> sortedCandidates = new LinkedList<ContourParticleWithIndex>();
        for (Map.Entry<Point, ContourParticle> iter : this.iCandidates.entrySet()) {
            ContourParticleWithIndex candidate = new ContourParticleWithIndex(iter.getKey(), iter.getValue());
            sortedCandidates.add(candidate);
        }
        Collections.sort(sortedCandidates);
        this.iCandidates.clear();
        int vNbElements = (int)((double)((float)sortedCandidates.size() * this.acceptedPointsFactor) + 0.5);
        for (ContourParticleWithIndex vSortedListIterator : sortedCandidates) {
            if (vNbElements-- < 1) break;
            this.iCandidates.put(vSortedListIterator.iPoint, vSortedListIterator.iContourParticle);
        }
    }

    private void relabelRegionAtPoint(Point aPoint, int aNewLabel, BinarizedImage aAreaWithOldLabels) {
        HashSet<Integer> oldLabels = new HashSet<Integer>();
        HashSet<Point> oldContours = new HashSet<Point>();
        FloodFill ff = new FloodFill(this.iLabelImage, aAreaWithOldLabels, aPoint);
        double sumOfVal = 0.0;
        double sumOfSqVal = 0.0;
        int count = 0;
        for (Integer currentPoint : ff) {
            int oldLabel = this.iLabelImage.getLabel(currentPoint);
            this.iLabelImage.setLabel(currentPoint, aNewLabel);
            oldLabels.add(this.iLabelImage.labelToAbs(oldLabel));
            if (this.iLabelImage.isContourLabel(oldLabel)) {
                oldContours.add(this.iLabelImage.indexToPoint(currentPoint));
            }
            float val = this.iIntensityImage.get(currentPoint);
            sumOfVal += (double)val;
            sumOfSqVal += (double)(val * val);
            ++count;
        }
        for (Point p : oldContours) {
            if (this.iLabelImage.isBoundaryPoint(p)) {
                ContourParticle contourPoint = this.iContourParticles.get(p);
                contourPoint.label = aNewLabel;
                this.iLabelImage.setLabel(p, this.iLabelImage.labelToNeg(aNewLabel));
                continue;
            }
            this.iContourParticles.remove(p);
        }
        LabelStatistics newLabelStats = new LabelStatistics(aNewLabel, this.iLabelImage.getNumOfDimensions());
        newLabelStats.iLabelCount = count;
        newLabelStats.iSum = sumOfVal;
        newLabelStats.iSumOfSq = sumOfSqVal;
        newLabelStats.iMeanIntensity = newLabelStats.iLabelCount > 0 ? newLabelStats.iSum / (double)newLabelStats.iLabelCount : 0.0;
        newLabelStats.iVarIntensity = this.CalculateVariance(newLabelStats.iSumOfSq, newLabelStats.iMeanIntensity, newLabelStats.iLabelCount);
        this.iLabelStatistics.put(aNewLabel, newLabelStats);
        Iterator iterator = oldLabels.iterator();
        while (iterator.hasNext()) {
            int oldLabel = (Integer)iterator.next();
            this.iLabelStatistics.remove(oldLabel);
        }
        LabelStatisticToolbox.removeEmptyStatistics(this.iLabelStatistics);
    }

    private void relabelMergedRegions(Point aPoint, int aLabel, Set<Integer> aCheckedLabels) {
        BinarizedIntervalLabelImage labelArea = new BinarizedIntervalLabelImage(this.iLabelImage);
        Stack<Integer> labelsToCheck = new Stack<Integer>();
        this.addNewThreshold(aCheckedLabels, labelArea, labelsToCheck, aLabel);
        while (!labelsToCheck.isEmpty()) {
            int labelToCheck = labelsToCheck.pop();
            for (LabelPair mergingPair : this.iCompetingRegions.values()) {
                int label1 = mergingPair.first;
                int label2 = mergingPair.second;
                if (label1 == labelToCheck) {
                    this.addNewThreshold(aCheckedLabels, labelArea, labelsToCheck, label2);
                }
                if (label2 != labelToCheck) continue;
                this.addNewThreshold(aCheckedLabels, labelArea, labelsToCheck, label1);
            }
        }
        if (labelArea.EvaluateAtIndex(aPoint)) {
            this.relabelRegionAtPoint(aPoint, this.labelDispenser.getNewLabel(), labelArea);
        }
    }

    private void addNewThreshold(Set<Integer> aCheckedLabels, BinarizedIntervalLabelImage aLabelArea, Stack<Integer> aLabelsToCheck, int aLabelToAdd) {
        if (!aCheckedLabels.contains(aLabelToAdd)) {
            aLabelArea.AddOneValThreshold(aLabelToAdd);
            aLabelArea.AddOneValThreshold(this.iLabelImage.labelToNeg(aLabelToAdd));
            aCheckedLabels.add(aLabelToAdd);
            aLabelsToCheck.push(aLabelToAdd);
        }
    }

    private void relabelRegion(Point aStartPoint, int aLabel) {
        if (this.iLabelImage.getLabelAbs(aStartPoint) == aLabel) {
            BinarizedIntervalLabelImage labelArea = new BinarizedIntervalLabelImage(this.iLabelImage);
            labelArea.AddOneValThreshold(aLabel);
            labelArea.AddOneValThreshold(this.iLabelImage.labelToNeg(aLabel));
            this.relabelRegionAtPoint(aStartPoint, this.labelDispenser.getNewLabel(), labelArea);
        }
    }

    private void removeCandidatesWithNonNegativeDeltaEnergy() {
        Iterator<Map.Entry<Point, ContourParticle>> iter = this.iCandidates.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Point, ContourParticle> next = iter.next();
            ContourParticle particle = next.getValue();
            if (!(particle.energyDifference >= 0.0)) continue;
            iter.remove();
        }
    }

    public boolean performIteration() {
        if (this.iSettings.usingDeconvolutionPcEnergy) {
            ((E_Deconvolution)this.iImageModel.getEdata()).RenewDeconvolution(this.iLabelImage, this.iLabelStatistics);
        }
        this.removeSinglePointRegions();
        this.removeNotSignificantRegions();
        this.buildCandidateList();
        this.filterCandidates();
        if (this.oscillationDetection.DetectOscillations(this.iCandidates.values())) {
            this.acceptedPointsFactor = (float)((double)this.acceptedPointsFactor / 2.0);
        }
        this.limitNumberOfCandidates();
        boolean convergence = this.moveCandidates();
        LabelStatisticToolbox.removeEmptyStatistics(this.iLabelStatistics);
        if (this.shrinkFirst && convergence) {
            convergence = false;
            this.shrinkFirst = false;
            this.acceptedPointsFactor = 1.0f;
        }
        return convergence;
    }

    private void buildCandidateList() {
        this.initiateCandidateList();
        for (Map.Entry<Point, ContourParticle> iter : this.iCandidates.entrySet()) {
            Point point = iter.getKey();
            ContourParticle contour = iter.getValue();
            contour.candidateLabel = 0;
            contour.referenceCount = 0;
            contour.energyDifference = this.iImageModel.calculateDeltaEnergy((Point)point, (ContourParticle)contour, (int)0, this.iLabelStatistics).energyDifference;
            contour.setTestedLabel(0);
        }
        if (this.shrinkFirst) {
            return;
        }
        this.iCompetingRegions.clear();
        for (Map.Entry<Point, ContourParticle> iter : this.iContourParticles.entrySet()) {
            Point propagatingPoint = iter.getKey();
            ContourParticle propagatingContour = iter.getValue();
            int propagatingRegionLabel = propagatingContour.label;
            for (Integer neighbor : this.iLabelImage.iterateNeighbours(propagatingPoint)) {
                int labelOfDefender = this.iLabelImage.getLabelAbs(neighbor);
                if (this.iLabelImage.isBorderLabel(labelOfDefender) || labelOfDefender == propagatingRegionLabel) continue;
                Point neighbourPoint = this.iLabelImage.indexToPoint(neighbor);
                propagatingContour.addDaughter(neighbourPoint);
                ContourParticle contourCandidate = this.iCandidates.get(neighbourPoint);
                if (contourCandidate == null) {
                    contourCandidate = new ContourParticle(labelOfDefender, this.iIntensityImage.get(neighbor));
                    this.iCandidates.put(neighbourPoint, contourCandidate);
                }
                contourCandidate.isDaughter = true;
                contourCandidate.addMother(propagatingPoint);
                if (!contourCandidate.hasLabelBeenTested(propagatingRegionLabel)) {
                    contourCandidate.setTestedLabel(propagatingRegionLabel);
                    Energy.EnergyResult energyResult = this.iImageModel.calculateDeltaEnergy(neighbourPoint, contourCandidate, propagatingRegionLabel, this.iLabelStatistics);
                    if (!(energyResult.energyDifference < contourCandidate.energyDifference)) continue;
                    contourCandidate.candidateLabel = propagatingRegionLabel;
                    contourCandidate.referenceCount = 1;
                    contourCandidate.energyDifference = energyResult.energyDifference;
                    if (!energyResult.merge.booleanValue() || contourCandidate.label == 0 || contourCandidate.candidateLabel == 0) continue;
                    this.iCompetingRegions.put(propagatingPoint, new LabelPair(contourCandidate.candidateLabel, contourCandidate.label));
                    continue;
                }
                if (contourCandidate.candidateLabel != propagatingRegionLabel) continue;
                ++contourCandidate.referenceCount;
            }
        }
    }

    private void initiateCandidateList() {
        this.iCandidates.clear();
        this.iCandidates.putAll(this.iContourParticles);
        for (ContourParticle contour : this.iCandidates.values()) {
            contour.isMother = true;
            contour.isDaughter = false;
            contour.isProcessed = false;
            contour.clearLists();
        }
    }

    private void filterCandidates() {
        if (!this.shrinkFirst) {
            LinkedList<Point> illegalPoints = new LinkedList<Point>();
            for (Map.Entry<Point, ContourParticle> e : this.iCandidates.entrySet()) {
                Point point = e.getKey();
                ContourParticle contour = e.getValue();
                if (contour.isProcessed || !contour.isMother) continue;
                contour.isProcessed = true;
                List<ContourParticleWithIndex> networkMembers = this.buildDependencyNetwork(point);
                HashSet<Point> selectedCandidatesPoints = new HashSet<Point>();
                for (ContourParticleWithIndex networkPoint : networkMembers) {
                    boolean isMoveLegal = true;
                    ContourParticle currentContour = networkPoint.iContourParticle;
                    Point currentPoint = networkPoint.iPoint;
                    if (currentContour.isDaughter && currentContour.referenceCount < 1 && currentContour.candidateLabel != 0) {
                        isMoveLegal = false;
                    }
                    if (isMoveLegal && currentContour.isMother) {
                        boolean rule3Fulfilled = false;
                        for (Point daughter : currentContour.getDaughterList()) {
                            ContourParticle daughterContour = this.iCandidates.get(daughter);
                            boolean alreadyAccepted = selectedCandidatesPoints.contains(daughter);
                            if (alreadyAccepted && daughterContour.candidateLabel == currentContour.label && daughterContour.referenceCount <= 1) {
                                isMoveLegal = false;
                                break;
                            }
                            if (rule3Fulfilled) continue;
                            if (!alreadyAccepted) {
                                rule3Fulfilled = true;
                                continue;
                            }
                            if (daughterContour.candidateLabel == currentContour.label) continue;
                            rule3Fulfilled = true;
                        }
                        if (!rule3Fulfilled) {
                            isMoveLegal = false;
                        }
                    }
                    if (isMoveLegal) {
                        selectedCandidatesPoints.add(currentPoint);
                        for (Point daughter : currentContour.getDaughterList()) {
                            ContourParticle daughterContour = this.iCandidates.get(daughter);
                            if (daughterContour.candidateLabel != currentContour.label) continue;
                            --daughterContour.referenceCount;
                        }
                        continue;
                    }
                    illegalPoints.add(currentPoint);
                }
            }
            for (Point illegalPoint : illegalPoints) {
                this.iCandidates.remove(illegalPoint);
            }
        }
        this.removeCandidatesWithNonNegativeDeltaEnergy();
    }

    private List<ContourParticleWithIndex> buildDependencyNetwork(Point aMotherPoint) {
        LinkedList<ContourParticleWithIndex> networkMembers = new LinkedList<ContourParticleWithIndex>();
        Stack<Point> pointsToVisit = new Stack<Point>();
        pointsToVisit.push(aMotherPoint);
        while (!pointsToVisit.empty()) {
            Point motherPoint = (Point)pointsToVisit.pop();
            ContourParticle motherContour = this.iCandidates.get(motherPoint);
            networkMembers.add(new ContourParticleWithIndex(motherPoint, motherContour));
            for (Point daughterPoint : motherContour.getDaughterList()) {
                ContourParticle daughterContour = this.iCandidates.get(daughterPoint);
                if (daughterContour.isProcessed) continue;
                daughterContour.isProcessed = true;
                if (daughterContour.isMother) {
                    pointsToVisit.push(daughterPoint);
                } else {
                    networkMembers.add(new ContourParticleWithIndex(daughterPoint, daughterContour));
                }
                for (Point mother : daughterContour.getMotherList()) {
                    ContourParticle motherContourPoint = this.iCandidates.get(mother);
                    if (motherContourPoint.isProcessed) continue;
                    motherContourPoint.isProcessed = true;
                    pointsToVisit.push(mother);
                }
            }
        }
        Collections.sort(networkMembers);
        return networkMembers;
    }

    private boolean moveAllFgSimplePoints() {
        boolean convergenceResult = true;
        boolean candidateWereMoved = true;
        while (!this.iCandidates.isEmpty() && candidateWereMoved) {
            candidateWereMoved = false;
            Iterator<Map.Entry<Point, ContourParticle>> candidateIter = this.iCandidates.entrySet().iterator();
            while (candidateIter.hasNext()) {
                Map.Entry<Point, ContourParticle> entry = candidateIter.next();
                Point currentPoint = entry.getKey();
                ContourParticle currentContour = entry.getValue();
                if (this.iTopologicalNumber.isPointFgSimple(currentPoint)) {
                    this.changeContourPointLabelToCandidateLabelAndUpdateNeighbours(currentPoint, currentContour);
                    candidateIter.remove();
                    candidateWereMoved = true;
                    convergenceResult = false;
                }
                currentContour.isProcessed = false;
            }
        }
        return convergenceResult;
    }

    private boolean checkForHandles(int currentCandidateLabel, List<TopologicalNumber.TopologicalNumberResult> topologicalNumbers) {
        boolean validPoint = true;
        if (!this.iSettings.allowHandles) {
            for (TopologicalNumber.TopologicalNumberResult tn : topologicalNumbers) {
                if (tn.iLabel == currentCandidateLabel && tn.iNumOfConnectedComponentsFG > 1) {
                    validPoint = false;
                }
                if (tn.iNumOfConnectedComponentsFG != 1 || tn.iNumOfConnectedComponentsBG <= 1) continue;
                validPoint = false;
            }
        }
        return validPoint;
    }

    private boolean checkForSplits(Set<Seed> seeds, Point currentPoint, int currentLabel, List<TopologicalNumber.TopologicalNumberResult> topologicalNumbers) {
        boolean validPoint = true;
        boolean isItGoingToSplit = false;
        for (TopologicalNumber.TopologicalNumberResult tn : topologicalNumbers) {
            if (tn.iLabel != currentLabel || tn.iNumOfConnectedComponentsFG <= 1) continue;
            isItGoingToSplit = true;
            break;
        }
        if (isItGoingToSplit) {
            if (this.iSettings.allowFission) {
                this.registerNeighbourSeedsWithSameLabel(seeds, currentPoint, currentLabel);
            } else {
                validPoint = false;
            }
        }
        return validPoint;
    }

    private boolean mergeRegions() {
        boolean didMerge = false;
        if (this.iSettings.allowFusion) {
            HashSet<Integer> checkedLabels = new HashSet<Integer>();
            for (Map.Entry<Point, LabelPair> iter : this.iCompetingRegions.entrySet()) {
                Point point = iter.getKey();
                int firstLabel = iter.getValue().first;
                this.relabelMergedRegions(point, firstLabel, checkedLabels);
                didMerge = true;
            }
        }
        return didMerge;
    }

    private boolean relabelSplitRegions(Set<Seed> seeds) {
        boolean didSplit = false;
        for (Seed seed : seeds) {
            this.relabelRegion(seed.getPoint(), seed.getLabel());
            didSplit = true;
        }
        return didSplit;
    }

    private boolean moveCandidates() {
        boolean convergenceResult = this.moveAllFgSimplePoints();
        Iterator<Map.Entry<Point, ContourParticle>> pointIterator = this.iCandidates.entrySet().iterator();
        HashSet<Seed> seeds = new HashSet<Seed>();
        while (pointIterator.hasNext()) {
            Map.Entry<Point, ContourParticle> e = pointIterator.next();
            Point currentPoint = e.getKey();
            ContourParticle currentParticle = e.getValue();
            int currentLabel = currentParticle.label;
            int currentCandidateLabel = currentParticle.candidateLabel;
            List<TopologicalNumber.TopologicalNumberResult> topologicalNumbers = this.iTopologicalNumber.getTopologicalNumbersForAllAdjacentLabels(currentPoint);
            boolean validPoint = this.checkForHandles(currentCandidateLabel, topologicalNumbers);
            boolean bl = validPoint = validPoint && this.checkForSplits(seeds, currentPoint, currentLabel, topologicalNumbers);
            if (validPoint) {
                this.changeContourPointLabelToCandidateLabelAndUpdateNeighbours(currentPoint, currentParticle);
                convergenceResult = false;
                if (currentParticle.isProcessed) {
                    this.registerNeighbourSeedsWithSameLabel(seeds, currentPoint, currentLabel);
                    if (!seeds.remove(new Seed(currentPoint, currentLabel))) {
                        throw new RuntimeException("no seed in set");
                    }
                }
            }
            if (!this.iCandidates.containsKey(currentPoint)) continue;
            pointIterator.remove();
        }
        boolean didSplitOrMerge = false;
        if (this.relabelSplitRegions(seeds)) {
            didSplitOrMerge = true;
        }
        if (this.mergeRegions()) {
            didSplitOrMerge = true;
        }
        if (didSplitOrMerge && this.iSettings.usingDeconvolutionPcEnergy) {
            ((E_Deconvolution)this.iImageModel.getEdata()).RenewDeconvolution(this.iLabelImage, this.iLabelStatistics);
        }
        return convergenceResult;
    }

    private void registerNeighbourSeedsWithSameLabel(Set<Seed> aSeeds, Point aPoint, int aLabel) {
        for (Integer neighbour : this.iLabelImage.iterateNeighbours(aPoint)) {
            int label = this.iLabelImage.getLabelAbs(neighbour);
            if (label != aLabel) continue;
            Point neighbourPoint = this.iLabelImage.indexToPoint(neighbour);
            aSeeds.add(new Seed(neighbourPoint, label));
            ContourParticle contourParticle = this.iCandidates.get(neighbourPoint);
            if (contourParticle == null) continue;
            contourParticle.isProcessed = true;
        }
    }

    private class Seed {
        private final Point iPoint;
        private final Integer iLabel;

        protected Seed(Point aPoint, Integer aLabel) {
            this.iPoint = aPoint;
            this.iLabel = aLabel;
        }

        protected Point getPoint() {
            return this.iPoint;
        }

        protected Integer getLabel() {
            return this.iLabel;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.iPoint == null ? 0 : this.iPoint.hashCode());
            result = 31 * result + (this.iLabel == null ? 0 : this.iLabel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Seed other = (Seed)obj;
            if (this.iLabel == null && other.iLabel != null) {
                return false;
            }
            if (!this.iLabel.equals(other.iLabel)) {
                return false;
            }
            if (this.iPoint == null && other.iPoint != null) {
                return false;
            }
            return this.iPoint.equals(other.iPoint);
        }
    }
}

