/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.energies;

import ij.measure.Calibration;
import java.util.HashMap;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.regions.RC.ContourParticle;
import mosaic.regions.energies.CurvatureBasedFlow;
import mosaic.regions.energies.Energy;
import mosaic.regions.utils.LabelStatistics;

public class E_CurvatureFlow
extends Energy.InternalEnergy {
    private final CurvatureBasedFlow curv;

    public E_CurvatureFlow(LabelImage labelImage, int rad, Calibration cal) {
        this.curv = new CurvatureBasedFlow(rad, labelImage, cal);
    }

    @Override
    public Energy.EnergyResult CalculateEnergyDifference(Point contourPoint, ContourParticle contourParticle, int toLabel, HashMap<Integer, LabelStatistics> labelMap) {
        int fromLabel = contourParticle.label;
        double flow = this.curv.generateData(contourPoint, fromLabel, toLabel);
        return new Energy.EnergyResult(flow, null);
    }
}

