/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.energies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mosaic.regions.RC.ContourParticle;

public class OscillationDetection {
    private final double iOscillationThreshold;
    private static final double AverageFactor = 0.1;
    private static final int LengthOfLastResultsWindow = 10;
    private final ArrayList<Double> iAllSumsAvg;
    private double iSumAvg = 0.0;
    private boolean isFirstRound = true;

    public OscillationDetection(double aOscillationThreshold, int aMaxNumOfIterations) {
        this.iOscillationThreshold = aOscillationThreshold;
        this.iAllSumsAvg = new ArrayList(aMaxNumOfIterations);
    }

    public boolean DetectOscillations(Collection<ContourParticle> aParticles) {
        double sumNew = this.sumAllEnergies(aParticles);
        double oldSumAvg = this.isFirstRound ? sumNew : this.iSumAvg;
        this.iSumAvg = 0.1 * sumNew + 0.9 * oldSumAvg;
        this.iAllSumsAvg.add(this.iSumAvg);
        if (!this.isFirstRound) {
            double totstd = this.calculateStdDev(this.iAllSumsAvg);
            int n = this.iAllSumsAvg.size();
            int start = Math.max(0, n - 10);
            double winstd = this.calculateStdDev(this.iAllSumsAvg.subList(start, n));
            if (winstd / totstd < this.iOscillationThreshold) {
                return true;
            }
        }
        this.isFirstRound = false;
        return false;
    }

    private double sumAllEnergies(Collection<ContourParticle> aContainer) {
        double totalEnergyDiff = 0.0;
        for (ContourParticle vPointIterator : aContainer) {
            totalEnergyDiff += vPointIterator.energyDifference;
        }
        return totalEnergyDiff;
    }

    private double calculateMean(List<Double> aData) {
        double sum = 0.0;
        for (double d : aData) {
            sum += d;
        }
        return sum / (double)aData.size();
    }

    private double calculateStdDev(List<Double> aData) {
        double meanValue = this.calculateMean(aData);
        int n = aData.size();
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += Math.pow(meanValue - aData.get(i), 2.0);
        }
        return Math.sqrt(sum /= (double)n);
    }
}

