/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.initializers;

import mosaic.core.imageUtils.images.LabelImage;
import mosaic.core.imageUtils.iterators.RegionIterator;
import mosaic.regions.initializers.Initializer;

public class BoxInitializer
extends Initializer {
    public BoxInitializer(LabelImage aLabelImage) {
        super(aLabelImage);
    }

    public void initialize(double aRatio) {
        int[] regionDimensions = (int[])this.iDimensionsSize.clone();
        int[] offsets = (int[])this.iDimensionsSize.clone();
        for (int i = 0; i < this.iNumOfDimensions; ++i) {
            regionDimensions[i] = (int)((double)regionDimensions[i] * aRatio);
            offsets[i] = (this.iDimensionsSize[i] - regionDimensions[i]) / 2;
        }
        boolean label = true;
        RegionIterator it = new RegionIterator(this.iDimensionsSize, regionDimensions, offsets);
        while (it.hasNext()) {
            int idx = it.next();
            this.iLabelImage.setLabel(idx, 1);
        }
    }
}

