/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.initializers;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.Duplicator;
import java.util.List;
import mosaic.core.binarize.BinarizedIntervalIntesityImage;
import mosaic.core.imageUtils.FloodFill;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.IntensityImage;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.regions.initializers.Initializer;
import mosaic.regions.utils.BubbleDrawer;
import mosaic.regions.utils.MaximumFinder2D;
import mosaic.regions.utils.MaximumFinder3D;
import mosaic.regions.utils.MaximumFinderInterface;

public class MaximaBubbles
extends Initializer {
    private final MaximumFinderInterface iMaximumFinder;
    private int iRadius;
    private double iSigma;
    private double iTolerance;
    private int iMinimumRegionSize;
    private IntensityImage iIntensityImage;

    public MaximaBubbles(IntensityImage aIntensityImage, LabelImage aLabelImage, double aSigma, double aTolerance, int aRadius, int aMinimumRegionSize) {
        super(aLabelImage);
        this.iMaximumFinder = this.createMaximumFinder(aIntensityImage);
        this.iRadius = aRadius;
        this.iSigma = aSigma;
        this.iTolerance = aTolerance;
        this.iMinimumRegionSize = aMinimumRegionSize;
        this.iIntensityImage = aIntensityImage;
    }

    public void initialize() {
        this.smoothIntensityImage();
        List<Point> list = this.iMaximumFinder.getMaximaPointList(this.iIntensityImage.getDataIntensity(), this.iTolerance, false);
        BinarizedIntervalIntesityImage binarizedImage = new BinarizedIntervalIntesityImage(this.iIntensityImage);
        int label = 1;
        for (Point maximumPoint : list) {
            this.setLabelInPointArea(binarizedImage, label, maximumPoint);
            ++label;
        }
    }

    private void setLabelInPointArea(BinarizedIntervalIntesityImage aBinarizedImage, int aLabel, Point aMaximumPoint) {
        float maximumPointValue = this.iIntensityImage.get(aMaximumPoint);
        float thresholdedValue = (float)((double)maximumPointValue * (1.0 - this.iTolerance));
        aBinarizedImage.clearThresholds();
        aBinarizedImage.AddThresholdBetween(thresholdedValue, maximumPointValue);
        FloodFill ff = new FloodFill(this.iLabelImage, aBinarizedImage, aMaximumPoint);
        if (ff.size() < this.iMinimumRegionSize) {
            BubbleDrawer bd = new BubbleDrawer(this.iLabelImage, this.iRadius / 2, this.iRadius);
            bd.drawCenter(aMaximumPoint, aLabel);
        } else {
            for (int p : ff) {
                this.iLabelImage.setLabel(p, aLabel);
            }
        }
    }

    private MaximumFinderInterface createMaximumFinder(IntensityImage aIntensityImage) {
        MaximumFinderInterface maximumFinder;
        int dim = aIntensityImage.getNumOfDimensions();
        if (dim == 2) {
            maximumFinder = new MaximumFinder2D(aIntensityImage.getDimensions());
        } else if (dim == 3) {
            maximumFinder = new MaximumFinder3D(aIntensityImage.getDimensions());
        } else {
            throw new RuntimeException("Not supported dimension for MaximumFinder");
        }
        return maximumFinder;
    }

    private void smoothIntensityImage() {
        ImagePlus imp = new Duplicator().run(this.iIntensityImage.getImage());
        IJ.run((ImagePlus)imp, (String)"Gaussian Blur...", (String)("sigma=" + this.iSigma + " stack"));
        this.iIntensityImage = new IntensityImage(imp);
    }
}

