/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.topology;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mosaic.core.imageUtils.Connectivity;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.images.LabelImage;
import mosaic.regions.topology.UnitCubeConnectedComponenetsCounter;

public class TopologicalNumber {
    private final Connectivity iFgConnectivity;
    private final UnitCubeConnectedComponenetsCounter iFgConnectedComponentsCounter;
    private final UnitCubeConnectedComponenetsCounter iBgConnectedComponentsCounter;
    private final LabelImage iLabelImage;
    private final int iUnitCubeSize;
    private final char[] iOneLabelSubImageFg;
    private final char[] iOneLabelSubImageBg;
    private final Point[] iPointOffsets;
    private final int[] iSubImage;
    private static final int ValueForForbiddenPoints = 0;

    public TopologicalNumber(LabelImage aLabelImage) {
        this.iFgConnectivity = aLabelImage.getConnFG();
        this.iFgConnectedComponentsCounter = new UnitCubeConnectedComponenetsCounter(this.iFgConnectivity);
        this.iBgConnectedComponentsCounter = new UnitCubeConnectedComponenetsCounter(aLabelImage.getConnBG());
        this.iLabelImage = aLabelImage;
        this.iUnitCubeSize = this.iFgConnectivity.getNeighborhoodSize();
        this.iSubImage = new int[this.iUnitCubeSize];
        this.iOneLabelSubImageFg = new char[this.iUnitCubeSize];
        this.iOneLabelSubImageBg = new char[this.iUnitCubeSize];
        this.iPointOffsets = new Point[this.iUnitCubeSize];
        for (int i = 0; i < this.iUnitCubeSize; ++i) {
            this.iPointOffsets[i] = this.iFgConnectivity.toPoint(i);
        }
    }

    private void getSubImage(Point aMiddlePoint) {
        for (int i = 0; i < this.iUnitCubeSize; ++i) {
            int label = this.iLabelImage.getLabelAbs(aMiddlePoint.add(this.iPointOffsets[i]));
            if (this.iLabelImage.isBorderLabel(label)) {
                label = 0;
            }
            this.iSubImage[i] = label;
        }
    }

    public List<TopologicalNumberResult> getTopologicalNumbersForAllAdjacentLabels(Point aMiddlePoint) {
        this.getSubImage(aMiddlePoint);
        Set<Integer> adjacentLabels = this.findAllLabelsInFgNeighborhood();
        ArrayList<TopologicalNumberResult> topologicalNumsResult = new ArrayList<TopologicalNumberResult>(adjacentLabels.size());
        for (int label : adjacentLabels) {
            this.generateFgAndBgSubImagesForLabel(label);
            int FGNumber = this.iFgConnectedComponentsCounter.SetImage(this.iOneLabelSubImageFg).getNumberOfConnectedComponents();
            int BGNumber = this.iBgConnectedComponentsCounter.SetImage(this.iOneLabelSubImageBg).getNumberOfConnectedComponents();
            topologicalNumsResult.add(new TopologicalNumberResult(label, FGNumber, BGNumber));
        }
        return topologicalNumsResult;
    }

    public List<TopologicalNumberResult> getTopologicalNumbers(Point aMiddlePoint, List<Integer> aLabels) {
        this.getSubImage(aMiddlePoint);
        Set<Integer> adjacentLabels = this.findAllLabelsInFgNeighborhood();
        ArrayList<TopologicalNumberResult> topologicalNumsResult = new ArrayList<TopologicalNumberResult>(aLabels.size());
        for (int label : aLabels) {
            TopologicalNumberResult result = null;
            if (adjacentLabels.contains(label)) {
                this.generateFgAndBgSubImagesForLabel(label);
                int FGNumber = this.iFgConnectedComponentsCounter.SetImage(this.iOneLabelSubImageFg).getNumberOfConnectedComponents();
                int BGNumber = this.iBgConnectedComponentsCounter.SetImage(this.iOneLabelSubImageBg).getNumberOfConnectedComponents();
                result = new TopologicalNumberResult(label, FGNumber, BGNumber);
            }
            topologicalNumsResult.add(result);
        }
        return topologicalNumsResult;
    }

    public boolean isPointFgSimple(Point aMiddlePoint) {
        this.getSubImage(aMiddlePoint);
        Set<Integer> adjacentLabels = this.findAllLabelsInFgNeighborhood();
        for (int label : adjacentLabels) {
            this.generateFgAndBgSubImagesForLabel(label);
            int FGNumber = this.iFgConnectedComponentsCounter.SetImage(this.iOneLabelSubImageFg).getNumberOfConnectedComponents();
            int BGNumber = this.iBgConnectedComponentsCounter.SetImage(this.iOneLabelSubImageBg).getNumberOfConnectedComponents();
            if (FGNumber == 1 && BGNumber == 1) continue;
            return false;
        }
        return true;
    }

    private Set<Integer> findAllLabelsInFgNeighborhood() {
        HashSet<Integer> adjacentLabels = new HashSet<Integer>();
        for (int index : this.iFgConnectivity.itOfsInt()) {
            if (this.iSubImage[index] == 0) continue;
            adjacentLabels.add(this.iSubImage[index]);
        }
        return adjacentLabels;
    }

    private void generateFgAndBgSubImagesForLabel(int label) {
        for (int i = 0; i < this.iUnitCubeSize; ++i) {
            this.iOneLabelSubImageFg[i] = (char)(this.iSubImage[i] == label ? 1 : 0);
            this.iOneLabelSubImageBg[i] = (char)('\u0001' - this.iOneLabelSubImageFg[i]);
        }
    }

    public static class TopologicalNumberResult {
        public final int iLabel;
        public int iNumOfConnectedComponentsFG;
        public int iNumOfConnectedComponentsBG;

        protected TopologicalNumberResult(int label, int FGNumber, int BGNumber) {
            this.iLabel = label;
            this.iNumOfConnectedComponentsFG = FGNumber;
            this.iNumOfConnectedComponentsBG = BGNumber;
        }

        public String toString() {
            return "TopologicalNumberResult {" + this.iLabel + ", " + this.iNumOfConnectedComponentsFG + ", " + this.iNumOfConnectedComponentsBG + "}";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.iLabel;
            result = 31 * result + this.iNumOfConnectedComponentsBG;
            result = 31 * result + this.iNumOfConnectedComponentsFG;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TopologicalNumberResult other = (TopologicalNumberResult)obj;
            if (this.iLabel != other.iLabel) {
                return false;
            }
            if (this.iNumOfConnectedComponentsBG != other.iNumOfConnectedComponentsBG) {
                return false;
            }
            return this.iNumOfConnectedComponentsFG == other.iNumOfConnectedComponentsFG;
        }
    }
}

