/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.utils;

import ij.plugin.filter.MaximumFinder;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.List;
import mosaic.core.imageUtils.Point;
import mosaic.regions.utils.MaximumFinderInterface;

public class MaximumFinder2D
implements MaximumFinderInterface {
    private final int width;
    private final int height;

    public MaximumFinder2D(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public MaximumFinder2D(int[] dims) {
        this(dims[0], dims[1]);
    }

    @Override
    public List<Point> getMaximaPointList(float[] pixels, double tolerance, boolean excludeOnEdges) {
        FloatProcessor ip = new FloatProcessor(this.width, this.height, pixels, null);
        MaximumFinder mf = new MaximumFinder();
        Polygon poly = mf.getMaxima((ImageProcessor)ip, tolerance, excludeOnEdges);
        int n = poly.npoints;
        int[] xs = poly.xpoints;
        int[] ys = poly.ypoints;
        ArrayList<Point> list = new ArrayList<Point>(n);
        for (int i = 0; i < n; ++i) {
            list.add(new Point(xs[i], ys[i]));
        }
        return list;
    }
}

