/*
 * Decompiled with CFR 0.152.
 */
package mosaic.regions.utils;

import ij.IJ;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import java.awt.Label;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import mosaic.core.imageUtils.Connectivity;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.iterators.SpaceIterator;
import mosaic.regions.utils.MaximumFinderInterface;

public class MaximumFinder3D
implements MaximumFinderInterface {
    private static final int SEGMENTED = 2;
    private static final int POINT_SELECTION = 3;
    private static final int LIST = 4;
    private static final int COUNT = 5;
    private static boolean excludeOnEdges = false;
    private final boolean previewing = false;
    private final Label messageArea = null;
    private final int width;
    private final int height;
    private int[][] points;
    private static final byte MAXIMUM = 1;
    private static final byte LISTED = 2;
    private static final byte PROCESSED = 4;
    private static final byte MAX_AREA = 8;
    private static final byte EQUAL = 16;
    private static final byte MAX_POINT = 32;
    private static final byte[] outputTypeMasks = new byte[]{32, 8, 8};
    private static final float SQRT2 = 1.4142135f;
    private final int depth;
    private final int size;
    private final SpaceIterator iterator;
    private final Connectivity conn;

    public MaximumFinder3D(int[] dims) {
        this(dims[0], dims[1], dims[2]);
    }

    private MaximumFinder3D(int w, int h, int z) {
        this.width = w;
        this.height = h;
        this.depth = z;
        this.conn = new Connectivity(3, 0);
        this.size = this.width * this.height * this.depth;
        this.iterator = new SpaceIterator(this.width, this.height, this.depth);
    }

    private int[][] getMaxima(float[] ip, double tolerance, boolean excludeOnEdges) {
        this.findMaxima(ip, tolerance, -808080.0, 3, excludeOnEdges, false);
        return this.points;
    }

    @Override
    public List<Point> getMaximaPointList(float[] ip, double tolerance, boolean excludeOnEdges) {
        int[][] points = this.getMaxima(ip, tolerance, excludeOnEdges);
        ArrayList<Point> list = new ArrayList<Point>();
        if (points == null) {
            System.out.println("no maxima");
            return list;
        }
        int[] xs = points[0];
        int[] ys = points[1];
        int[] zs = points[2];
        int n = xs.length;
        for (int i = 0; i < n; ++i) {
            int x = xs[i];
            int y = ys[i];
            int z = zs[i];
            Point p = new Point(x, y, z);
            list.add(p);
        }
        return list;
    }

    private byte[] findMaxima(float[] ip, double tolerance, double threshold, int outputType, boolean excludeOnEdges, boolean isEDM) {
        byte[] outIp;
        float globalMin = Float.MAX_VALUE;
        float globalMax = -3.4028235E38f;
        for (int i = 0; i < this.size; ++i) {
            float v = ip[i];
            if (globalMin > v) {
                globalMin = v;
            }
            if (!(globalMax < v)) continue;
            globalMax = v;
        }
        byte[] types = new byte[this.size];
        if (threshold != -808080.0) {
            threshold -= (double)(globalMax - globalMin) * 1.0E-6;
        }
        boolean excludeEdgesNow = excludeOnEdges && outputType != 2;
        IJ.showStatus((String)"Getting sorted maxima...");
        long[] maxPoints = this.getSortedMaxPoints(ip, types, excludeEdgesNow, globalMin, globalMax, threshold);
        IJ.showStatus((String)"Analyzing  maxima...");
        float maxSortingError = 0.0f;
        maxSortingError = 1.1f * (isEDM ? 0.70710677f : (globalMax - globalMin) / 2.0E9f);
        this.analyzeAndMarkMaxima(ip, types, maxPoints, excludeEdgesNow, tolerance, outputType, maxSortingError);
        if (outputType == 3 || outputType == 4 || outputType == 5) {
            return null;
        }
        if (outputType == 2) {
            outIp = null;
        } else {
            for (int i = 0; i < this.width * this.height; ++i) {
                types[i] = (byte)((types[i] & outputTypeMasks[outputType]) != 0 ? 255 : 0);
            }
            outIp = types;
        }
        return outIp;
    }

    private long[] getSortedMaxPoints(float[] ip, byte[] typeP, boolean excludeEdgesNow, float globalMin, float globalMax, double threshold) {
        byte[] types = typeP;
        int nMax = 0;
        boolean checkThreshold = threshold != -808080.0;
        for (int i = 0; i < this.size; ++i) {
            boolean isInner;
            Point p = this.iterator.indexToPoint(i);
            int x = p.iCoords[0];
            int y = p.iCoords[1];
            int z = p.iCoords[2];
            float v = ip[i];
            if (v == globalMin) continue;
            boolean isBorder = x == 0 || x == this.width - 1 || y == 0 || y == this.height - 1 || z == 0 || z == this.depth - 1;
            boolean bl = isInner = !isBorder;
            if (excludeEdgesNow && isBorder || checkThreshold && (double)v < threshold) continue;
            boolean isMax = true;
            for (Point q : this.conn.iterateNeighbors(p)) {
                float vNeighbor;
                if (!isInner && !this.iterator.isInBound(q) || !((vNeighbor = ip[this.iterator.pointToIndex(q)]) > v)) continue;
                isMax = false;
                break;
            }
            if (!isMax) continue;
            types[i] = 1;
            ++nMax;
        }
        float vFactor = (float)(2.0E9 / (double)(globalMax - globalMin));
        long[] maxPoints = new long[nMax];
        int iMax = 0;
        for (int i = 0; i < this.size; ++i) {
            if (types[i] != 1) continue;
            float fValue = ip[i];
            int iValue = (int)((fValue - globalMin) * vFactor);
            maxPoints[iMax++] = (long)iValue << 32 | (long)i;
        }
        Arrays.sort(maxPoints);
        return maxPoints;
    }

    private void analyzeAndMarkMaxima(float[] ip, byte[] typeP, long[] maxPoints, boolean excludeEdgesNow, double tolerance, int outputType, float maxSortingError) {
        boolean displayOrCount;
        byte[] types = typeP;
        int nMax = maxPoints.length;
        int[] pList = new int[this.size];
        Vector<int[]> xyVector = null;
        boolean bl = displayOrCount = outputType == 3 || outputType == 4 || outputType == 5;
        if (displayOrCount) {
            xyVector = new Vector<int[]>();
        }
        for (int iMax = nMax - 1; iMax >= 0; --iMax) {
            boolean sortingError;
            int offset0 = (int)maxPoints[iMax];
            if ((types[offset0] & 4) != 0) continue;
            Point p = this.iterator.indexToPoint(offset0);
            int x0 = p.iCoords[0];
            int y0 = p.iCoords[1];
            int z0 = p.iCoords[2];
            float v0 = ip[offset0];
            do {
                pList[0] = offset0;
                int n = offset0;
                types[n] = (byte)(types[n] | 0x12);
                int listLen = 1;
                int listI = 0;
                boolean isEdgeMaximum = x0 == 0 || x0 == this.width - 1 || y0 == 0 || y0 == this.height - 1 || z0 == 0 || z0 == this.depth - 1;
                sortingError = false;
                boolean maxPossible = true;
                double xEqual = x0;
                double yEqual = y0;
                double zEqual = z0;
                int nEqual = 1;
                block2: do {
                    int offset = pList[listI];
                    Point pp = this.iterator.indexToPoint(offset);
                    int x = pp.iCoords[0];
                    int y = pp.iCoords[1];
                    int z = pp.iCoords[2];
                    boolean isInner = z != 0 && z != this.depth - 1 && y != 0 && y != this.height - 1 && x != 0 && x != this.width - 1;
                    for (Point q : this.conn.iterateNeighbors(pp)) {
                        int offset2 = this.iterator.pointToIndex(q);
                        if (!isInner && !this.iterator.isInBound(q) || (types[offset2] & 2) != 0) continue;
                        if ((types[offset2] & 4) != 0) {
                            maxPossible = false;
                            continue block2;
                        }
                        int x2 = q.iCoords[0];
                        int y2 = q.iCoords[1];
                        int z2 = q.iCoords[2];
                        float v2 = ip[offset2];
                        if (v2 > v0 + maxSortingError) {
                            maxPossible = false;
                            continue block2;
                        }
                        if (!(v2 >= v0 - (float)tolerance)) continue;
                        if (v2 > v0) {
                            sortingError = true;
                            offset0 = offset2;
                            v0 = v2;
                            x0 = x2;
                            y0 = y2;
                            z0 = z2;
                        }
                        pList[listLen] = offset2;
                        ++listLen;
                        int n2 = offset2;
                        types[n2] = (byte)(types[n2] | 2);
                        if (x2 == 0 || x2 == this.width - 1 || y2 == 0 || y2 == this.height - 1 || z2 == 0 || z2 == this.depth - 1) {
                            isEdgeMaximum = true;
                            if (excludeEdgesNow) {
                                maxPossible = false;
                                continue block2;
                            }
                        }
                        if (v2 != v0) continue;
                        int n3 = offset2;
                        types[n3] = (byte)(types[n3] | 0x10);
                        xEqual += (double)x2;
                        yEqual += (double)y2;
                        zEqual += (double)z2;
                        ++nEqual;
                    }
                } while (++listI < listLen);
                if (sortingError) {
                    for (listI = 0; listI < listLen; ++listI) {
                        types[pList[listI]] = 0;
                    }
                } else {
                    int z;
                    int offset;
                    int resetMask = ~(maxPossible ? 2 : 18);
                    xEqual /= (double)nEqual;
                    yEqual /= (double)nEqual;
                    zEqual /= (double)nEqual;
                    double minDist2 = 1.0E20;
                    int nearestI = 0;
                    for (listI = 0; listI < listLen; ++listI) {
                        double dist2;
                        offset = pList[listI];
                        Point pp = this.iterator.indexToPoint(offset);
                        int x = pp.iCoords[0];
                        int y = pp.iCoords[1];
                        z = pp.iCoords[2];
                        int n4 = offset;
                        types[n4] = (byte)(types[n4] & resetMask);
                        int n5 = offset;
                        types[n5] = (byte)(types[n5] | 4);
                        if (!maxPossible) continue;
                        int n6 = offset;
                        types[n6] = (byte)(types[n6] | 8);
                        if ((types[offset] & 0x10) == 0 || !((dist2 = (xEqual - (double)x) * (xEqual - (double)x) + (yEqual - (double)y) * (yEqual - (double)y) + (zEqual - (double)z) * (zEqual - (double)z)) < minDist2)) continue;
                        minDist2 = dist2;
                        nearestI = listI;
                    }
                    if (!maxPossible) continue;
                    int n7 = offset = pList[nearestI];
                    types[n7] = (byte)(types[n7] | 0x20);
                    if (!displayOrCount || xyVector == null || excludeOnEdges && isEdgeMaximum) continue;
                    Point pp = this.iterator.indexToPoint(offset);
                    int x = pp.iCoords[0];
                    int y = pp.iCoords[1];
                    z = pp.iCoords[2];
                    xyVector.addElement(new int[]{x, y, z});
                }
            } while (sortingError);
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (displayOrCount && xyVector != null) {
            int npoints = xyVector.size();
            if (outputType == 3 && npoints > 0) {
                int[] xpoints = new int[npoints];
                int[] ypoints = new int[npoints];
                int[] zpoints = new int[npoints];
                for (int i = 0; i < npoints; ++i) {
                    int[] xy = (int[])xyVector.elementAt(i);
                    xpoints[i] = xy[0];
                    ypoints[i] = xy[1];
                    zpoints[i] = xy[2];
                }
                this.points = new int[][]{xpoints, ypoints, zpoints};
            } else if (outputType == 4) {
                Analyzer.resetCounter();
                ResultsTable rt = ResultsTable.getResultsTable();
                for (int i = 0; i < npoints; ++i) {
                    int[] xy = (int[])xyVector.elementAt(i);
                    rt.incrementCounter();
                    rt.addValue("X", (double)xy[0]);
                    rt.addValue("Y", (double)xy[1]);
                    rt.addValue("Z", (double)xy[2]);
                }
                rt.show("Results");
            } else if (outputType == 5) {
                // empty if block
            }
        }
    }
}

