/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.filter.EDM;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackStatistics;
import mosaic.utils.ArrayOps;
import mosaic.utils.ConvertArray;
import mosaic.utils.SysOps;
import mosaic.utils.math.Matrix;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;

public class ImgUtils {
    public static void ImgToYX2Darray(FloatProcessor aInputIp, float[][] aNewImgArray, float aNormalizationValue) {
        float[] pixels = (float[])aInputIp.getPixels();
        int w = aInputIp.getWidth();
        int h = aInputIp.getHeight();
        int arrayW = aNewImgArray[0].length;
        int arrayH = aNewImgArray.length;
        for (int y = 0; y < arrayH; ++y) {
            for (int x = 0; x < arrayW; ++x) {
                int yIdx = y;
                int xIdx = x;
                if (yIdx >= h) {
                    yIdx = h - 1;
                }
                if (xIdx >= w) {
                    xIdx = w - 1;
                }
                aNewImgArray[y][x] = pixels[xIdx + yIdx * w] / aNormalizationValue;
            }
        }
    }

    static void ImgToXY2Darray(FloatProcessor aInputIp, float[][] aNewImgArray, float aNormalizationValue) {
        float[] pixels = (float[])aInputIp.getPixels();
        int w = aInputIp.getWidth();
        int h = aInputIp.getHeight();
        int arrayW = aNewImgArray.length;
        int arrayH = aNewImgArray[0].length;
        for (int y = 0; y < arrayH; ++y) {
            for (int x = 0; x < arrayW; ++x) {
                int yIdx = y;
                int xIdx = x;
                if (yIdx >= h) {
                    yIdx = h - 1;
                }
                if (xIdx >= w) {
                    xIdx = w - 1;
                }
                aNewImgArray[x][y] = pixels[xIdx + yIdx * w] / aNormalizationValue;
            }
        }
    }

    public static void ImgToYX2Darray(FloatProcessor aInputIp, double[][] aNewImgArray, double aNormalizationValue) {
        float[] pixels = (float[])aInputIp.getPixels();
        int w = aInputIp.getWidth();
        int h = aInputIp.getHeight();
        int arrayW = aNewImgArray[0].length;
        int arrayH = aNewImgArray.length;
        for (int y = 0; y < arrayH; ++y) {
            for (int x = 0; x < arrayW; ++x) {
                int yIdx = y;
                int xIdx = x;
                if (yIdx >= h) {
                    yIdx = h - 1;
                }
                if (xIdx >= w) {
                    xIdx = w - 1;
                }
                aNewImgArray[y][x] = (double)pixels[xIdx + yIdx * w] / aNormalizationValue;
            }
        }
    }

    public static double[][][] ImgToZXYarray(ImagePlus aImage) {
        int ni = aImage.getWidth();
        int nj = aImage.getHeight();
        int nz = aImage.getNSlices();
        double[][][] imgArray = new double[nz][ni][nj];
        for (int z = 0; z < nz; ++z) {
            aImage.setSlice(z + 1);
            ImageProcessor ip = aImage.getProcessor();
            for (int i = 0; i < ni; ++i) {
                for (int j = 0; j < nj; ++j) {
                    imgArray[z][i][j] = ip.getPixelValue(i, j);
                }
            }
        }
        return imgArray;
    }

    public static boolean[][][] imgToZXYbinaryArray(ImagePlus aInputImage) {
        int ni = aInputImage.getWidth();
        int nj = aInputImage.getHeight();
        int nz = aInputImage.getNSlices();
        boolean[][][] cellmask = new boolean[nz][ni][nj];
        for (int z = 0; z < nz; ++z) {
            aInputImage.setSlice(z + 1);
            ImageProcessor ip = aInputImage.getProcessor();
            for (int i = 0; i < ni; ++i) {
                for (int j = 0; j < nj; ++j) {
                    cellmask[z][i][j] = ip.getPixelValue(i, j) != 0.0f;
                }
            }
        }
        return cellmask;
    }

    public static void YX2DarrayToImg(float[][] aImg, FloatProcessor aIp, float aNormalizationValue) {
        float[] pixels = (float[])aIp.getPixels();
        int w = aIp.getWidth();
        int h = aIp.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                pixels[x + y * w] = aImg[y][x] * aNormalizationValue;
            }
        }
    }

    static void XY2DarrayToImg(float[][] aImg, FloatProcessor aIp, float aNormalizationValue) {
        float[] pixels = (float[])aIp.getPixels();
        int w = aIp.getWidth();
        int h = aIp.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                pixels[x + y * w] = aImg[x][y] * aNormalizationValue;
            }
        }
    }

    public static void YX2DarrayToImg(double[][] aImg, FloatProcessor aIp, double aNormalizationValue) {
        float[] pixels = (float[])aIp.getPixels();
        int w = aIp.getWidth();
        int h = aIp.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                pixels[x + y * w] = (float)(aImg[y][x] * aNormalizationValue);
            }
        }
    }

    public static ImagePlus ZXYarrayToImg(double[][][] aImgArray, String aTitle) {
        int iWidth = aImgArray[0].length;
        int iHeigth = aImgArray[0][0].length;
        int iDepth = aImgArray.length;
        ImageStack stack = new ImageStack(iWidth, iHeigth);
        for (int z = 0; z < iDepth; ++z) {
            stack.addSlice("", (ImageProcessor)new FloatProcessor(ConvertArray.toFloat(aImgArray[z])));
        }
        ImagePlus img = new ImagePlus();
        img.setStack(stack);
        img.changes = false;
        img.setTitle(aTitle);
        return img;
    }

    public static ImagePlus ZXYarrayToImg(short[][][] aImgArray, String aTitle) {
        ImagePlus img = ImgUtils.ZXYarrayToImg(ConvertArray.toDouble(aImgArray), aTitle);
        img.setTitle(aTitle);
        return img;
    }

    static void imgResize(float[][] aInputImg, float[][] aOutputImg) {
        int w = aInputImg[0].length;
        int h = aInputImg.length;
        int arrayW = aOutputImg[0].length;
        int arrayH = aOutputImg.length;
        for (int y = 0; y < arrayH; ++y) {
            for (int x = 0; x < arrayW; ++x) {
                int yIdx = y;
                int xIdx = x;
                if (yIdx >= h) {
                    yIdx = h - 1;
                }
                if (xIdx >= w) {
                    xIdx = w - 1;
                }
                aOutputImg[y][x] = aInputImg[yIdx][xIdx];
            }
        }
    }

    public static void imgResize(double[][] aInputImg, double[][] aOutputImg) {
        int w = aInputImg[0].length;
        int h = aInputImg.length;
        int arrayW = aOutputImg[0].length;
        int arrayH = aOutputImg.length;
        for (int y = 0; y < arrayH; ++y) {
            for (int x = 0; x < arrayW; ++x) {
                int yIdx = y;
                int xIdx = x;
                if (yIdx >= h) {
                    yIdx = h - 1;
                }
                if (xIdx >= w) {
                    xIdx = w - 1;
                }
                aOutputImg[y][x] = aInputImg[yIdx][xIdx];
            }
        }
    }

    public static ImagePlus createNewEmptyImgPlus(ImagePlus aOrigIp, String aTitle, double aXscale, double aYscale, OutputType aType) {
        int nSlices = aOrigIp.getStackSize();
        int w = aOrigIp.getWidth();
        int h = aOrigIp.getHeight();
        ImagePlus copyIp = aOrigIp.createImagePlus();
        int newWidth = (int)aXscale * w;
        int newHeight = (int)aYscale * h;
        ImageStack origStack = aOrigIp.getStack();
        ImageStack copyStack = new ImageStack(newWidth, newHeight);
        for (int i = 1; i <= nSlices; ++i) {
            ImageProcessor ip2;
            ImageProcessor ip1 = origStack.getProcessor(i);
            String label = origStack.getSliceLabel(i);
            switch (aType) {
                case RGB: {
                    ip2 = new ColorProcessor(newWidth, newHeight);
                    break;
                }
                case FLOAT: {
                    ip2 = new FloatProcessor(newWidth, newHeight);
                    break;
                }
                default: {
                    ip2 = ip1.createProcessor(newWidth, newHeight);
                }
            }
            if (ip2 == null) continue;
            copyStack.addSlice(label, ip2);
        }
        copyIp.setStack(aTitle, copyStack);
        Calibration cal = copyIp.getCalibration();
        if (cal.scaled()) {
            cal.pixelWidth *= 1.0 / aXscale;
            cal.pixelHeight *= 1.0 / aYscale;
        }
        int[] dim = aOrigIp.getDimensions();
        copyIp.setDimensions(dim[2], dim[3], dim[4]);
        if (aOrigIp.isComposite() && (aType != OutputType.RGB || copyIp.getStackSize() <= 1)) {
            copyIp = new CompositeImage(copyIp, ((CompositeImage)aOrigIp).getMode());
            ((CompositeImage)copyIp).copyLuts(aOrigIp);
        }
        if (aOrigIp.isHyperStack()) {
            copyIp.setOpenAsHyperStack(true);
        }
        copyIp.changes = true;
        return copyIp;
    }

    public static <T extends RealType<T>> Img<T> createNewEmpty(Img<T> aImg) {
        int numDimensions = aImg.numDimensions();
        long[] dims = new long[numDimensions];
        aImg.dimensions(dims);
        return aImg.factory().create(dims, (Object)((RealType)aImg.firstElement()).copy());
    }

    public static ArrayOps.MinMax<Double> findMinMax(ImagePlus img) {
        int ni = img.getWidth();
        int nj = img.getHeight();
        int nz = img.getNSlices();
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int z = 0; z < nz; ++z) {
            img.setSlice(z + 1);
            ImageProcessor imp = img.getProcessor();
            for (int i = 0; i < ni; ++i) {
                for (int j = 0; j < nj; ++j) {
                    float value = imp.getPixelValue(i, j);
                    if ((double)value > max) {
                        max = value;
                    }
                    if (!((double)value < min)) continue;
                    min = value;
                }
            }
        }
        return new ArrayOps.MinMax<Double>(min, max);
    }

    public static ImagePlus extractFrameAsImage(ImagePlus aImage, int aFrame, int aChannel, boolean aMakeCopy) {
        int ni = aImage.getWidth();
        int nj = aImage.getHeight();
        int nz = aImage.getNSlices();
        ImageStack is = new ImageStack(ni, nj);
        for (int z = 1; z <= nz; ++z) {
            aImage.setPosition(aChannel, z, aFrame);
            ImageProcessor ip = aMakeCopy ? aImage.getProcessor().duplicate() : aImage.getProcessor();
            is.addSlice("", ip);
        }
        return new ImagePlus(aImage.getTitle(), is);
    }

    public static String getImageDirectory(ImagePlus aImage) {
        if (aImage == null) {
            return null;
        }
        if (aImage.getOriginalFileInfo() == null || aImage.getOriginalFileInfo().directory == "") {
            return null;
        }
        return aImage.getOriginalFileInfo().directory;
    }

    public static String getImageAbsolutePath(ImagePlus aImage, boolean aRemoveExtension) {
        FileInfo fi;
        if (aImage != null && (fi = aImage.getOriginalFileInfo()) != null) {
            if (fi.url != null && !fi.url.equals("")) {
                return fi.url;
            }
            if (fi.directory != null && fi.fileName != null) {
                String name = fi.directory + fi.fileName;
                if (aRemoveExtension) {
                    name = SysOps.removeExtension(name);
                }
                return name;
            }
        }
        return null;
    }

    public static String getImageAbsolutePath(ImagePlus aImage) {
        return ImgUtils.getImageAbsolutePath(aImage, false);
    }

    public static String getImageInfo(ImagePlus aImage) {
        return "Image title: [" + aImage.getTitle() + "] Path: [" + ImgUtils.getImageAbsolutePath(aImage) + "]  Type: " + (Object)((Object)Type.values()[aImage.getType()]) + " BitDepth: " + aImage.getBitDepth() + " Dims(x/y/z): " + aImage.getWidth() + "/" + aImage.getHeight() + "/" + aImage.getNSlices() + " NumOfFrames: " + aImage.getNFrames() + " NumOfChannels: " + aImage.getNChannels() + " StackSize: " + aImage.getStackSize();
    }

    public static <T extends RealType<T>> String getImageInfo(Img<T> img1) {
        String str = "Type: " + ((RealType)img1.firstElement()).getClass().getName();
        str = str + " BitDepth: " + ((RealType)img1.firstElement()).getBitsPerPixel();
        str = str + " Dims:";
        int numDimensions = img1.numDimensions();
        for (int i = 0; i < numDimensions; ++i) {
            str = str + img1.dimension(i) + (i == numDimensions - 1 ? "" : "/");
        }
        return str;
    }

    public static ImagePlus runDistanceTransform(ImagePlus aImage) {
        boolean tempBlackBackground = Prefs.blackBackground;
        Prefs.blackBackground = true;
        EDM filtEDM = new EDM();
        filtEDM.setup("Exact Euclidean Distance Transform (3D)", aImage);
        filtEDM.run(aImage.getProcessor());
        Prefs.blackBackground = tempBlackBackground;
        return aImage;
    }

    public static ImagePlus removeHoles(ImagePlus aImage) {
        IJ.run((ImagePlus)aImage, (String)"Invert", (String)"stack");
        boolean tempBlackbackground = Prefs.blackBackground;
        Prefs.blackBackground = false;
        IJ.run((ImagePlus)aImage, (String)"Fill Holes", (String)"stack");
        Prefs.blackBackground = tempBlackbackground;
        IJ.run((ImagePlus)aImage, (String)"Invert", (String)"stack");
        return aImage;
    }

    public static ImagePlus binarizeImage(ImagePlus aImage) {
        new ImageConverter(aImage).convertToGray8();
        byte[] pixels = (byte[])aImage.getProcessor().getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = pixels[i] == 0 ? 0 : -1;
        }
        return aImage;
    }

    public static ImagePlus matrixToImage(Matrix aImageMatrix, String aTitle) {
        double[][] result = aImageMatrix.getArrayYX();
        FloatProcessor fp = new FloatProcessor(result[0].length, result.length);
        ImgUtils.YX2DarrayToImg(result, fp, 1.0);
        return new ImagePlus(aTitle, (ImageProcessor)fp);
    }

    public static Matrix imageToMatrix(ImagePlus aIamge) {
        FloatProcessor fp = aIamge.getProcessor().convertToFloatProcessor();
        double[][] img = new double[aIamge.getHeight()][aIamge.getWidth()];
        ImgUtils.ImgToYX2Darray(fp, img, 1.0);
        return new Matrix(img);
    }

    public static ImageProcessor padImageProcessor(ImageProcessor aIp, int aPadSize) {
        int width = aIp.getWidth();
        int height = aIp.getHeight();
        int newWidth = width + 2 * aPadSize;
        int newHeight = height + 2 * aPadSize;
        ImageProcessor paddedIp = aIp.createProcessor(newWidth, newHeight);
        for (int x = 0; x < newWidth; ++x) {
            for (int y = 0; y < newHeight; ++y) {
                int xc = x - aPadSize;
                int yc = y - aPadSize;
                if (xc < 0) {
                    xc = 0;
                }
                if (xc >= width) {
                    xc = width - 1;
                }
                if (yc < 0) {
                    yc = 0;
                }
                if (yc >= height) {
                    yc = height - 1;
                }
                paddedIp.set(x, y, aIp.get(xc, yc));
            }
        }
        return paddedIp;
    }

    public static ImageProcessor cropImageProcessor(ImageProcessor aIp, int aCropSize) {
        aIp.setRoi(aCropSize, aCropSize, aIp.getWidth() - 2 * aCropSize, aIp.getHeight() - 2 * aCropSize);
        return aIp.crop();
    }

    public static ImageStack padImageStack3D(ImageStack aImageStack, int aPadSize) {
        int z;
        int width = aImageStack.getWidth();
        int height = aImageStack.getHeight();
        int depth = aImageStack.getSize();
        int newWidth = width + 2 * aPadSize;
        int newHeight = height + 2 * aPadSize;
        ImageStack paddedIs = new ImageStack(newWidth, newHeight);
        for (z = 0; z < aPadSize; ++z) {
            paddedIs.addSlice(ImgUtils.padImageProcessor(aImageStack.getProcessor(1), aPadSize));
        }
        for (z = 1; z <= depth; ++z) {
            paddedIs.addSlice(ImgUtils.padImageProcessor(aImageStack.getProcessor(z), aPadSize));
        }
        for (z = 0; z < aPadSize; ++z) {
            paddedIs.addSlice(ImgUtils.padImageProcessor(aImageStack.getProcessor(depth), aPadSize));
        }
        return paddedIs;
    }

    public static ImageStack cropImageStack3D(ImageStack aImageStack, int aCropSize) {
        int width = aImageStack.getWidth();
        int height = aImageStack.getHeight();
        int depth = aImageStack.getSize();
        int newWidth = width - 2 * aCropSize;
        int newHeight = height - 2 * aCropSize;
        int newDepth = depth - 2 * aCropSize;
        return aImageStack.crop(aCropSize, aCropSize, aCropSize, newWidth, newHeight, newDepth);
    }

    public static ImageStack padImageStack2D(ImageStack aImageStack, int aPadSize) {
        int width = aImageStack.getWidth();
        int height = aImageStack.getHeight();
        int depth = aImageStack.getSize();
        int newWidth = width + 2 * aPadSize;
        int newHeight = height + 2 * aPadSize;
        ImageStack paddedIs = new ImageStack(newWidth, newHeight);
        for (int z = 1; z <= depth; ++z) {
            paddedIs.addSlice(ImgUtils.padImageProcessor(aImageStack.getProcessor(z), aPadSize));
        }
        return paddedIs;
    }

    public static ImageStack cropImageStack2D(ImageStack aImageStack, int aCropSize) {
        int width = aImageStack.getWidth();
        int height = aImageStack.getHeight();
        int depth = aImageStack.getSize();
        int newWidth = width - 2 * aCropSize;
        int newHeight = height - 2 * aCropSize;
        return aImageStack.crop(aCropSize, aCropSize, 0, newWidth, newHeight, depth);
    }

    public static ImageStack pad(ImageStack aImageStack, int aPadSize, boolean aIs3D) {
        return aIs3D ? ImgUtils.padImageStack3D(aImageStack, aPadSize) : ImgUtils.padImageStack2D(aImageStack, aPadSize);
    }

    public static ImageStack crop(ImageStack aImageStack, int aPadSize, boolean aIs3D) {
        return aIs3D ? ImgUtils.cropImageStack3D(aImageStack, aPadSize) : ImgUtils.cropImageStack2D(aImageStack, aPadSize);
    }

    public static ImagePlus convertToNormalizedGloballyFloatType(ImagePlus aImage) {
        StackStatistics stackStats = new StackStatistics(aImage);
        double maximum = stackStats.max;
        double minimum = stackStats.min;
        double range = maximum - minimum;
        if (range == 0.0) {
            if (maximum != 0.0) {
                range = maximum;
                minimum = 0.0;
            } else {
                range = 1.0;
                minimum = 0.0;
            }
        }
        ImageStack stack = aImage.getStack();
        int size = aImage.getStackSize();
        ImageStack normalizedStack = new ImageStack(stack.getWidth(), stack.getHeight());
        for (int i = 1; i <= size; ++i) {
            ImageProcessor ip = stack.getProcessor(i).convertToFloat();
            FloatProcessor fp = (FloatProcessor)(aImage.getType() == 2 ? ip.duplicate() : ip);
            fp.subtract(minimum);
            fp.multiply(1.0 / range);
            normalizedStack.addSlice(stack.getSliceLabel(i), (ImageProcessor)fp);
        }
        ImagePlus normalizedImg = new ImagePlus("Normalized_" + aImage.getTitle(), normalizedStack);
        normalizedImg.setDimensions(aImage.getNChannels(), aImage.getNSlices(), aImage.getNFrames());
        return normalizedImg;
    }

    static enum Type {
        GRAY8,
        GRAY16,
        GRAY32,
        COLOR_256,
        COLOR_RGB;

    }

    public static enum OutputType {
        ORIGINAL,
        RGB,
        FLOAT;

    }
}

