/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.io.csv;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mosaic.utils.io.csv.CsvColumnConfig;
import mosaic.utils.io.csv.CsvMetaInfo;
import org.apache.log4j.Logger;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.comment.CommentMatcher;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CSV<E> {
    protected static final Logger logger = Logger.getLogger(CSV.class);
    private final Class<E> iClazz;
    private CsvPreference iCsvPreference;
    private final Vector<CsvMetaInfo> iMetaInfos;
    final Vector<CsvMetaInfo> iMetaInfosRead;

    public CSV(Class<E> aClazz) {
        this.iClazz = aClazz;
        this.iMetaInfos = new Vector();
        this.iMetaInfosRead = new Vector();
        this.setCsvPreference(',');
    }

    public void setMetaInformation(String aParameter, String aValue) {
        this.setMetaInformation(new CsvMetaInfo(aParameter, aValue));
    }

    public void setMetaInformation(CsvMetaInfo aMetaInfo) {
        String value = this.getMetaInformation(aMetaInfo.parameter);
        if (value != null) {
            logger.debug((Object)("MetaInfo " + aMetaInfo + " added, but same parameter with value [" + value + "] already exists!"));
        }
        this.iMetaInfos.add(aMetaInfo);
    }

    public String getMetaInformation(String parameter) {
        String value = this.getMetaInformation(this.iMetaInfos, parameter);
        if (value == null) {
            value = this.getMetaInformation(this.iMetaInfosRead, parameter);
        }
        return value;
    }

    public void removeMetaInformation(String parameter) {
        int i;
        for (i = 0; i < this.iMetaInfos.size(); ++i) {
            if (!this.iMetaInfos.get((int)i).parameter.equals(parameter)) continue;
            this.iMetaInfos.remove(i);
            break;
        }
        for (i = 0; i < this.iMetaInfosRead.size(); ++i) {
            if (!this.iMetaInfosRead.get((int)i).parameter.equals(parameter)) continue;
            this.iMetaInfosRead.remove(i);
            break;
        }
    }

    public void clearMetaInformation() {
        this.iMetaInfos.clear();
        this.iMetaInfosRead.clear();
    }

    public int setCSVPreferenceFromFile(String aCsvFilename) {
        int numOfColumns = 0;
        return numOfColumns;
    }

    public Vector<E> Read(String aCsvFilename) {
        return this.Read(aCsvFilename, null);
    }

    public Vector<E> Read(String aCsvFilename, CsvColumnConfig aOutputChoose) {
        return this.Read(aCsvFilename, aOutputChoose, false);
    }

    public Vector<E> Read(String aCsvFilename, CsvColumnConfig aOutputChoose, boolean aSkipHeader) {
        Vector out = new Vector();
        this.readData(aCsvFilename, out, aOutputChoose, aSkipHeader);
        return out;
    }

    public boolean Write(String aCsvFilename, List<E> aOutputData, CsvColumnConfig aOutputChoose, boolean aShouldAppend) {
        ArrayList<String> map = new ArrayList<String>();
        ArrayList<CellProcessor> cp = new ArrayList<CellProcessor>();
        boolean isErrorReported = false;
        for (int i = 0; i < aOutputChoose.fieldMapping.length; ++i) {
            if (aOutputChoose.fieldMapping[i] != null && !aOutputChoose.fieldMapping[i].equals("")) {
                map.add(aOutputChoose.fieldMapping[i]);
                cp.add(aOutputChoose.cellProcessors[i]);
                continue;
            }
            if (isErrorReported) continue;
            logger.error((Object)("Empty or null [" + aOutputChoose.fieldMapping[i] + "] field declared for file [" + aCsvFilename + "]!"));
            logger.error((Object)aOutputChoose);
            isErrorReported = true;
        }
        String[] mapString = map.toArray(new String[map.size()]);
        CellProcessor[] cel = cp.toArray(new CellProcessor[cp.size()]);
        CsvColumnConfig oc = new CsvColumnConfig(mapString, cel);
        return this.writeData(aCsvFilename, aOutputData, oc, aShouldAppend);
    }

    public void setDelimiter(char d) {
        this.setCsvPreference(d);
    }

    public boolean Stitch(String[] aInputFileNames, String aOutputFileName) {
        return this.Stitch(aInputFileNames, aOutputFileName, null);
    }

    boolean Stitch(String[] aInputFileNames, String aOutputFileName, CsvColumnConfig aOutputChoose) {
        if (aInputFileNames.length == 0) {
            return false;
        }
        Vector out = new Vector();
        CsvColumnConfig occ = this.readData(aInputFileNames[0], out, aOutputChoose, false);
        if (occ == null) {
            return false;
        }
        for (int i = 1; i < aInputFileNames.length; ++i) {
            this.readData(aInputFileNames[i], out, occ, false);
        }
        this.Write(aOutputFileName, out, occ, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean StitchAny(String[] aInputFileNames, String aOutputFileName) {
        if (aInputFileNames.length == 0) {
            return false;
        }
        try {
            CellProcessor[] processors = null;
            String[] map = null;
            ArrayList<List> allValues = new ArrayList<List>();
            for (int i = 0; i < aInputFileNames.length; ++i) {
                try (CsvListReader listReader = null;){
                    List value;
                    listReader = new CsvListReader((Reader)new FileReader(aInputFileNames[i]), this.iCsvPreference);
                    map = listReader.getHeader(true);
                    processors = new CellProcessor[map.length];
                    for (int p = 0; p < processors.length; ++p) {
                        processors[p] = new NotNull();
                    }
                    while ((value = listReader.read(processors)) != null) {
                        allValues.add(value);
                    }
                    continue;
                }
            }
            try (CsvListWriter listWriter = null;){
                listWriter = new CsvListWriter((Writer)new FileWriter(aOutputFileName), this.iCsvPreference);
                listWriter.writeHeader(map);
                for (CsvMetaInfo mi : this.iMetaInfos) {
                    listWriter.writeComment("%" + mi.parameter + ":" + mi.value);
                }
                for (CsvMetaInfo mi : this.iMetaInfosRead) {
                    listWriter.writeComment("%" + mi.parameter + ":" + mi.value);
                }
                for (List l : allValues) {
                    listWriter.write(l, processors);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private CsvColumnConfig readData(String aCsvFilename, Vector<E> aOutput, CsvColumnConfig aOutputChoose, boolean aSkipHeader) {
        return aOutputChoose;
    }

    private boolean writeData(String aCsvFilename, List<E> aOutputData, CsvColumnConfig aOutputChoose, boolean aShouldAppend) {
        if (aOutputData.size() == 0) {
            logger.info((Object)("Nothing to write! File: [" + aCsvFilename + "] not created."));
            return false;
        }
        return true;
    }

    String getMetaInformation(List<CsvMetaInfo> aContainer, String aParameter) {
        for (CsvMetaInfo mi : aContainer) {
            if (!mi.parameter.equals(aParameter)) continue;
            return mi.value;
        }
        return null;
    }

    private CsvColumnConfig generateOutputChoose(String[] aHeaderKeywords) {
        CellProcessor[] c = new CellProcessor[aHeaderKeywords.length];
        for (int i = 0; i < c.length; ++i) {
            try {
                aHeaderKeywords[i] = aHeaderKeywords[i].replace(" ", "_");
                c[i] = null;
                this.iClazz.getMethod("get" + aHeaderKeywords[i], new Class[0]);
                continue;
            }
            catch (NoSuchMethodException e) {
                logger.info((Object)("Method not found: [get" + aHeaderKeywords[i] + "], setting to default (ignore) setup. Class: " + this.iClazz.getName()));
                aHeaderKeywords[i] = null;
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        CsvColumnConfig occ = new CsvColumnConfig(aHeaderKeywords, c);
        logger.debug((Object)("Generated field mapping: " + occ));
        return occ;
    }

    private void setCsvPreference(char aDelimiter) {
        CsvPreference.Builder bld = new CsvPreference.Builder('\"', (int)aDelimiter, "\n");
        bld.skipComments((CommentMatcher)new CommentExtendedCSV());
        this.iCsvPreference = bld.build();
    }

    private class CommentExtendedCSV
    implements CommentMatcher {
        protected CommentExtendedCSV() {
        }

        public boolean isComment(String s) {
            if (s.startsWith("%")) {
                String[] pr = s.split(":");
                if (pr.length >= 2) {
                    String param = pr[0].substring(1);
                    String value = s.substring(pr[0].length() + 1, s.length()).trim();
                    CsvMetaInfo mi = new CsvMetaInfo(param, value);
                    String currentValue = CSV.this.getMetaInformation(CSV.this.iMetaInfosRead, mi.parameter);
                    if (currentValue != null) {
                        logger.debug((Object)("MetaInfo " + mi + " added, but same parameter with value [" + value + "] already exists!"));
                    }
                    CSV.this.iMetaInfosRead.add(mi);
                }
                return true;
            }
            return false;
        }
    }
}

