/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.io.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SshSession {
    private static final Logger logger = Logger.getLogger(SshSession.class);
    private static final int SSH_PORT = 22;
    private static final int CONNECTION_TIMEOUT_MS = 60000;
    private static final int CONNECTION_KEEP_ALIVE_MS = 2000;
    private JSch jsch;
    Session session;

    SshSession(String aHostAddress, String aUserName, String aPassword, String aKeyPath) throws JSchException {
        this.jsch = new JSch();
        this.session = this.createSession(aHostAddress, aUserName, aPassword, aKeyPath);
    }

    SshSession(Session aSession) throws JSchException {
        if (aSession == null) {
            throw new JSchException("Session cannot be null");
        }
        if (!aSession.isConnected()) {
            throw new JSchException("Provided session is down");
        }
        this.session = aSession;
    }

    public Session getSession() {
        return this.session;
    }

    public void close() {
        this.session.disconnect();
    }

    private Session createSession(String aHostAddress, String aUserName, String aPassword, String aKeyPath) throws JSchException {
        Session session;
        logger.info((Object)("Connecting to [" + aHostAddress + "] with username [" + aUserName + "] pass/key provided (yes/no): " + (aPassword != null ? "yes/" : "no/") + (aKeyPath != null ? "yes" : "no")));
        if (aPassword == null || aPassword.length() == 0) {
            logger.info((Object)"Trying to authenticate with auth key.");
            String keyPath = aKeyPath == null ? System.getProperty("user.home") + "/.ssh/id_rsa" : aKeyPath;
            this.jsch.addIdentity(keyPath);
            session = this.jsch.getSession(aUserName, aHostAddress, 22);
        } else {
            logger.info((Object)"Trying to authenticate with provided password.");
            session = this.jsch.getSession(aUserName, aHostAddress, 22);
            session.setPassword(aPassword);
        }
        session.setServerAliveInterval(2000);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.setTimeout(60000);
        session.connect();
        return session;
    }
}

