/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

import java.util.List;
import java.util.Set;
import mosaic.utils.math.Matrix;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultUndirectedWeightedGraph;
import org.jgrapht.graph.DefaultWeightedEdge;

public class GraphUtils {
    public static <V, E extends DefaultEdge> DefaultUndirectedWeightedGraph<V, DefaultWeightedEdge> simplifySimipleUndirectedGraph(DefaultUndirectedWeightedGraph<V, E> aGraph) {
        DefaultUndirectedWeightedGraph weightedGraph = new DefaultUndirectedWeightedGraph(DefaultWeightedEdge.class);
        for (Object v : aGraph.vertexSet()) {
            weightedGraph.addVertex(v);
        }
        for (DefaultEdge e : aGraph.edgeSet()) {
            DefaultWeightedEdge edge = (DefaultWeightedEdge)weightedGraph.addEdge(aGraph.getEdgeSource((Object)e), aGraph.getEdgeTarget((Object)e));
            weightedGraph.setEdgeWeight((Object)edge, aGraph.getEdgeWeight((Object)e));
        }
        boolean done = false;
        block2: while (!done) {
            done = true;
            for (Object v : weightedGraph.vertexSet()) {
                Object newVertexTarget;
                Set edges = weightedGraph.edgesOf(v);
                if (edges.size() != 2) continue;
                DefaultWeightedEdge[] e = edges.toArray(new DefaultWeightedEdge[0]);
                double weightOfEdge1 = weightedGraph.getEdgeWeight((Object)e[0]);
                Object sourceVertexOfEdge1 = weightedGraph.getEdgeSource((Object)e[0]);
                Object targetVertexOfEdge1 = weightedGraph.getEdgeTarget((Object)e[0]);
                double weightOfEdge2 = weightedGraph.getEdgeWeight((Object)e[1]);
                Object sourceVertexOfEdge2 = weightedGraph.getEdgeSource((Object)e[1]);
                Object targetVertexOfEdge2 = weightedGraph.getEdgeTarget((Object)e[1]);
                Object newVertexSource = sourceVertexOfEdge1.equals(v) ? targetVertexOfEdge1 : sourceVertexOfEdge1;
                Object object = newVertexTarget = sourceVertexOfEdge2.equals(v) ? targetVertexOfEdge2 : sourceVertexOfEdge2;
                if (weightedGraph.getEdge(newVertexSource, newVertexTarget) != null) continue;
                weightedGraph.removeVertex(v);
                DefaultWeightedEdge newEdge = (DefaultWeightedEdge)weightedGraph.addEdge(newVertexSource, newVertexTarget);
                weightedGraph.setEdgeWeight((Object)newEdge, weightOfEdge1 + weightOfEdge2);
                done = false;
                continue block2;
            }
        }
        return weightedGraph;
    }

    public static <V, E extends DefaultEdge> double getPathWeight(GraphPath<V, E> aPath) {
        double sum = 0.0;
        Graph graph = aPath.getGraph();
        for (DefaultEdge e : aPath.getEdgeList()) {
            sum += graph.getEdgeWeight((Object)e);
        }
        return sum;
    }

    public static DefaultUndirectedWeightedGraph<IntVertex, DefaultEdge> matrixToGraph(Matrix aMatrix, boolean aIs8connected) {
        List<List<Integer>> graphConnections = GraphUtils.findAllElementsOfObject(aMatrix, aIs8connected);
        DefaultUndirectedWeightedGraph graph = new DefaultUndirectedWeightedGraph(DefaultEdge.class);
        for (int i = 0; i < graphConnections.size(); ++i) {
            int sourceVertexId = graphConnections.get(i).get(0);
            IntVertex v = new IntVertex(sourceVertexId);
            graph.addVertex((Object)v);
            for (int z = 1; z < graphConnections.get(i).size(); ++z) {
                int targetVertexId = graphConnections.get(i).get(z);
                IntVertex vz = new IntVertex(targetVertexId);
                graph.addVertex((Object)vz);
                graph.addEdge((Object)v, (Object)vz);
            }
        }
        return graph;
    }

    /*
     * Exception decompiling
     */
    private static List<List<Integer>> findAllElementsOfObject(Matrix aMatrix, boolean aIs8connected) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[DOLOOP]], but top level block is 4[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class IntVertex {
        private int iLabel;

        public IntVertex(int aNum) {
            this.iLabel = aNum;
        }

        public int getLabel() {
            return this.iLabel;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.iLabel;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntVertex other = (IntVertex)obj;
            return this.iLabel == other.iLabel;
        }

        public String toString() {
            return Integer.toString(this.iLabel);
        }
    }

    public static class Vertex<VertexType> {
        private VertexType iLabel;

        public Vertex(VertexType aLabel) {
            this.iLabel = aLabel;
        }

        public VertexType getLabel() {
            return this.iLabel;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.iLabel == null ? 0 : this.iLabel.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Vertex other = (Vertex)obj;
            return !(this.iLabel == null ? other.iLabel != null : !this.iLabel.equals(other.iLabel));
        }

        public String toString() {
            return this.iLabel.toString();
        }
    }
}

