/*
 * Decompiled with CFR 0.152.
 */
package mosaic.utils.math;

import java.util.ArrayList;
import org.scijava.vecmath.Point3d;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.KDTree;

public class NearestNeighborTree {
    private KDTree iTree;
    private Instances iBasePoints;

    public NearestNeighborTree(Point3d[] aPoints) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(3);
        attributes.add(new Attribute("x"));
        attributes.add(new Attribute("y"));
        attributes.add(new Attribute("z"));
        this.iBasePoints = new Instances("Y", attributes, 0);
        for (int i = 0; i < aPoints.length; ++i) {
            double[] coordinates = new double[3];
            aPoints[i].get(coordinates);
            DenseInstance inst = new DenseInstance(1.0, coordinates);
            inst.setDataset(this.iBasePoints);
            this.iBasePoints.add((Instance)inst);
        }
        try {
            this.iTree = new KDTree();
            this.iTree.setInstances(this.iBasePoints);
            EuclideanDistance df = (EuclideanDistance)this.iTree.getDistanceFunction();
            df.setDontNormalize(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double[] getDistancesToNearestNeighbors(Point3d[] aPoints) {
        double[] distances = new double[aPoints.length];
        for (int i = 0; i < aPoints.length; ++i) {
            distances[i] = this.getDistanceToNearestNeighbor(aPoints[i]);
        }
        return distances;
    }

    public double getDistanceToNearestNeighbor(Point3d aPoint) {
        double[] coordinates = new double[3];
        aPoint.get(coordinates);
        DenseInstance inst = new DenseInstance(1.0, coordinates);
        inst.setDataset(this.iBasePoints);
        double distance = Double.MAX_VALUE;
        try {
            this.iTree.nearestNeighbour((Instance)inst);
            distance = this.iTree.getDistances()[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return distance;
    }
}

