/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.GUI;

import ij.gui.GenericDialog;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import mosaic.bregman.GUI.GenericGUI;
import mosaic.bregman.GUI.RScriptWindow;
import mosaic.bregman.Parameters;

class VisualizationGUI {
    VisualizationGUI() {
    }

    public static int getParameters(Parameters aParameters) {
        GenericDialog gd = new GenericDialog("Visualization and output options");
        gd.setInsets(-10, 0, 3);
        Font bf = new Font(null, 1, 12);
        gd.addMessage("Visualization and output", bf);
        String[] sgroup2 = new String[]{"Intermediate_steps", "Colored_objects", "Objects_intensities", "Labeled_objects", "Outlines_overlay", "Soft_Mask", "Save_objects_characteristics"};
        boolean[] bgroup2 = new boolean[]{aParameters.livedisplay, aParameters.dispcolors, aParameters.dispint, aParameters.displabels, aParameters.dispoutline, aParameters.dispSoftMask, aParameters.save_images};
        gd.addCheckboxGroup(4, 2, sgroup2, bgroup2);
        gd.addMessage("    R script data analysis settings", bf);
        gd.addNumericField("Number of conditions", (double)aParameters.nbconditions, 0);
        Panel p2 = new Panel();
        GenericGUI.addButton(p2, "Set condition names and number of images per condition", new RScriptListener(gd, 0, 0, aParameters));
        gd.addPanel(p2);
        gd.centerDialog(false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return -1;
        }
        aParameters.livedisplay = gd.getNextBoolean();
        aParameters.dispcolors = gd.getNextBoolean();
        aParameters.dispint = gd.getNextBoolean();
        aParameters.displabels = gd.getNextBoolean();
        aParameters.dispoutline = gd.getNextBoolean();
        aParameters.dispSoftMask = gd.getNextBoolean();
        aParameters.save_images = gd.getNextBoolean();
        aParameters.nbconditions = (int)gd.getNextNumber();
        return 0;
    }

    private static class RScriptListener
    implements ActionListener {
        private final GenericDialog gd;
        private final int posx;
        private final int posy;
        private final Parameters iParameters;

        protected RScriptListener(GenericDialog gd, int ParentPosx, int ParentPosy, Parameters aParameters) {
            this.gd = gd;
            this.posx = ParentPosx;
            this.posy = ParentPosy;
            this.iParameters = aParameters;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int nbgroups = new Integer(((TextField)this.gd.getNumericFields().elementAt(0)).getText());
            if (nbgroups > 1) {
                int i;
                this.iParameters.nbimages = new int[nbgroups];
                for (i = 0; i < nbgroups; ++i) {
                    this.iParameters.nbimages[i] = 1;
                }
                this.iParameters.groupnames = new String[nbgroups];
                for (i = 0; i < nbgroups; ++i) {
                    this.iParameters.groupnames[i] = "Condition " + (i + 1) + " name";
                }
                this.iParameters.nbconditions = nbgroups;
            }
            RScriptWindow.getParameters(nbgroups, this.posx, this.posy, this.iParameters);
        }
    }
}

