/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman;

import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import mosaic.bregman.Mask;
import mosaic.utils.ImgUtils;

class SamplePearsonCorrelationCoefficient {
    private final int iWidth;
    private final int iHeight;
    private final int iDepth;
    private final double[][][] iImageA;
    private boolean[][][] iMaskA;
    private final double[][][] iImageB;
    private boolean[][][] iMaskB;

    public SamplePearsonCorrelationCoefficient(ImagePlus aImgA, ImagePlus aImgB, boolean aMaskImgA, double aMaskThresholdA, boolean aMaskImgB, double aMaskThresholdB) {
        if (aImgA.getWidth() != aImgB.getWidth() || aImgA.getHeight() != aImgB.getHeight() || aImgA.getNSlices() != aImgB.getNSlices() || aImgA.getBitDepth() != aImgB.getBitDepth()) {
            IJ.error((String)"ImageColocalizer expects both images to have the same size and depth");
            throw new RuntimeException();
        }
        this.iWidth = aImgA.getWidth();
        this.iHeight = aImgA.getHeight();
        this.iDepth = aImgA.getNSlices();
        this.iImageA = new double[this.iDepth][this.iWidth][this.iHeight];
        double maxA = this.initImageAndGetMax(aImgA, this.iImageA);
        double tx = aMaskImgA ? aMaskThresholdA * maxA : -1.0;
        this.iMaskA = ImgUtils.imgToZXYbinaryArray(Mask.createBinaryCellMask(aImgA, "Channel1", tx));
        this.iImageB = new double[this.iDepth][this.iWidth][this.iHeight];
        double maxB = this.initImageAndGetMax(aImgB, this.iImageB);
        double ty = aMaskImgB ? aMaskThresholdB * maxB : -1.0;
        this.iMaskB = ImgUtils.imgToZXYbinaryArray(Mask.createBinaryCellMask(aImgB, "Channel2", ty));
    }

    private double initImageAndGetMax(ImagePlus aImage, double[][][] aImageOutputArray) {
        double max = 0.0;
        for (int z = 0; z < this.iDepth; ++z) {
            aImage.setSlice(z + 1);
            ImageProcessor imp = aImage.getProcessor();
            for (int i = 0; i < this.iWidth; ++i) {
                for (int j = 0; j < this.iHeight; ++j) {
                    float value = imp.getPixelValue(i, j);
                    aImageOutputArray[z][i][j] = value;
                    if (!((double)value > max)) continue;
                    max = value;
                }
            }
        }
        return max;
    }

    public double[] run() {
        return new double[]{this.calculateCoefficient(this.iImageA, this.iImageB, this.iMaskA, this.iMaskB, 0, 0, false), this.calculateCoefficient(this.iImageA, this.iImageB, this.iMaskA, this.iMaskB, 0, 0, true)};
    }

    private double calculateCoefficient(double[][][] aA, double[][][] aB, boolean[][][] aMaskA, boolean[][][] aMaskB, int aThresholdA, int aThresholdB, boolean aUseMask) {
        double sumA = 0.0;
        double sumB = 0.0;
        for (int z = 0; z < this.iDepth; ++z) {
            for (int i = 0; i < this.iWidth; ++i) {
                for (int j = 0; j < this.iHeight; ++j) {
                    if (!this.checkCondition(aA, aB, aMaskA, aMaskB, aThresholdA, aThresholdB, aUseMask, z, i, j)) continue;
                    sumA += aA[z][i][j];
                    sumB += aB[z][i][j];
                }
            }
        }
        int count = this.iDepth * this.iWidth * this.iHeight;
        double Aarraymean = sumA / (double)count;
        double Barraymean = sumB / (double)count;
        double num = 0.0;
        double denA = 0.0;
        double denB = 0.0;
        for (int z = 0; z < this.iDepth; ++z) {
            for (int i = 0; i < this.iWidth; ++i) {
                for (int j = 0; j < this.iHeight; ++j) {
                    if (!this.checkCondition(aA, aB, aMaskA, aMaskB, aThresholdA, aThresholdB, aUseMask, z, i, j)) continue;
                    num += (aA[z][i][j] - Aarraymean) * (aB[z][i][j] - Barraymean);
                    denA += Math.pow(aA[z][i][j] - Aarraymean, 2.0);
                    denB += Math.pow(aB[z][i][j] - Barraymean, 2.0);
                }
            }
        }
        return num / Math.sqrt(denA * denB);
    }

    private boolean checkCondition(double[][][] aA, double[][][] aB, boolean[][][] aMaskA, boolean[][][] aMaskB, int aThresholdA, int aThresholdB, boolean aUseMask, int z, int i, int j) {
        boolean bothMaskSet = aMaskB[z][i][j] && aMaskA[z][i][j];
        boolean bothArraysSet = aA[z][i][j] >= (double)aThresholdA && aB[z][i][j] >= (double)aThresholdB;
        boolean checkCondition = bothArraysSet && (!aUseMask || bothMaskSet);
        return checkCondition;
    }
}

