/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.RGBStackMerge;
import ij.plugin.Resizer;
import ij.plugin.filter.BackgroundSubtracter;
import ij.process.BinaryProcessor;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import mosaic.bregman.ColocalizationAnalysis;
import mosaic.bregman.Files;
import mosaic.bregman.Mask;
import mosaic.bregman.Parameters;
import mosaic.bregman.SamplePearsonCorrelationCoefficient;
import mosaic.bregman.output.ImageColoc;
import mosaic.bregman.output.ImageData;
import mosaic.bregman.output.ObjectsColoc;
import mosaic.bregman.output.ObjectsData;
import mosaic.bregman.segmentation.Pix;
import mosaic.bregman.segmentation.Region;
import mosaic.bregman.segmentation.SegmentationParameters;
import mosaic.bregman.segmentation.SquasshSegmentation;
import mosaic.core.detection.Particle;
import mosaic.core.imageUtils.MaskOnSpaceMapper;
import mosaic.core.imageUtils.Point;
import mosaic.core.imageUtils.masks.BallMask;
import mosaic.core.utils.MosaicUtils;
import mosaic.utils.ArrayOps;
import mosaic.utils.ImgUtils;
import mosaic.utils.SysOps;
import mosaic.utils.io.csv.CSV;
import mosaic.utils.io.csv.CsvColumnConfig;
import org.apache.log4j.Logger;

public class SquasshLauncher {
    private static final Logger logger = Logger.getLogger(SquasshLauncher.class);
    private final double iGlobalNormalizationMin;
    private final double iGlobalNormalizationMax;
    private final Parameters iParameters;
    private int ni;
    private int nj;
    private int nz;
    private int iNumOfChannels = -1;
    private int iOutputImgScale = 1;
    private ImagePlus[] iInputImages;
    private double[][][][] iNormalizedImages;
    private List<List<Region>> iRegionsList;
    private short[][][][] iLabeledRegions;
    private double[][][][] iSoftMasks;
    private ImagePlus[] iOutSoftMasks;
    private ImagePlus[] iOutOutlines;
    private ImagePlus[] iOutIntensities;
    private int iMaxNumberOfRegionsFound = 0;
    private ImagePlus[] iOutLabeledRegionsColor;
    private ImagePlus[] iOutLabeledRegionsGray;
    private ImagePlus[] iOutColoc;
    private List<ColocalizationAnalysis.ChannelPair> iAnalysisPairs;
    private Set<Files.FileInfo> iSavedFilesInfo = new LinkedHashSet<Files.FileInfo>();

    public SquasshLauncher(ImagePlus aImage, Parameters aParameters, String aOutputDir, double aNormalizationMin, double aNormalizationMax, List<ColocalizationAnalysis.ChannelPair> aAnalysisPairs) {
        this.iParameters = aParameters;
        this.iGlobalNormalizationMin = aNormalizationMin;
        this.iGlobalNormalizationMax = aNormalizationMax;
        if (aImage == null) {
            IJ.error((String)"No image to process");
            return;
        }
        if (aImage.getType() == 4) {
            IJ.error((String)"This is a color image and is not supported, convert into 8-bit , 16-bit or float");
            return;
        }
        String title = aImage.getTitle();
        this.ni = aImage.getWidth();
        this.nj = aImage.getHeight();
        this.nz = aImage.getNSlices();
        int numOfFrames = aImage.getNFrames();
        int numOfChannels = aImage.getNChannels();
        logger.debug((Object)("Segmenting Image: [" + title + "] Dims(x/y/z): " + this.ni + "/" + this.nj + "/" + this.nz + " NumOfFrames: " + numOfFrames + " NumOfChannels: " + numOfChannels));
        this.iNumOfChannels = numOfChannels;
        this.iInputImages = new ImagePlus[this.iNumOfChannels];
        this.iNormalizedImages = new double[this.iNumOfChannels][][][];
        this.iRegionsList = new ArrayList<List<Region>>(this.iNumOfChannels);
        for (int i = 0; i < this.iNumOfChannels; ++i) {
            this.iRegionsList.add(null);
        }
        this.iLabeledRegions = new short[this.iNumOfChannels][][][];
        this.iSoftMasks = new double[this.iNumOfChannels][][][];
        this.iOutSoftMasks = new ImagePlus[this.iNumOfChannels];
        this.iOutOutlines = new ImagePlus[this.iNumOfChannels];
        this.iOutIntensities = new ImagePlus[this.iNumOfChannels];
        this.iOutLabeledRegionsColor = new ImagePlus[this.iNumOfChannels];
        this.iOutLabeledRegionsGray = new ImagePlus[this.iNumOfChannels];
        this.iAnalysisPairs = this.computeValidChannelsPairsForImage(aAnalysisPairs, this.iNumOfChannels);
        this.iOutColoc = new ImagePlus[this.iAnalysisPairs.size()];
        String outFileName = SysOps.removeExtension(title);
        for (int frame = 1; frame <= numOfFrames; ++frame) {
            aImage.setPosition(aImage.getChannel(), aImage.getSlice(), frame);
            this.segmentFrame(aImage, frame, title);
            this.displayAndUpdateImages(outFileName);
            if (!this.iParameters.save_images) continue;
            this.writeImageDataCsv(aOutputDir, title, outFileName, frame - 1);
            this.writeObjectDataCsv(aOutputDir, title, outFileName, frame - 1);
            Mask mask = new Mask(this.iGlobalNormalizationMin, this.iGlobalNormalizationMax);
            for (int i = 0; i < this.iNumOfChannels; ++i) {
                if (i == 0 && this.iParameters.usecellmaskX) {
                    mask.generateMasks(i, this.iInputImages[i], this.iParameters.thresholdcellmask);
                    continue;
                }
                if (i != 1 || !this.iParameters.usecellmaskY) continue;
                mask.generateMasks(i, this.iInputImages[i], this.iParameters.thresholdcellmasky);
            }
            List<List<Region>> maskedRegionList = mask.applyMask(this.iRegionsList, this.iOutputImgScale, this.nz, this.ni, this.nj);
            ColocalizationAnalysis ca = new ColocalizationAnalysis(this.nz > 1 ? this.iOutputImgScale : 1, this.iOutputImgScale, this.iOutputImgScale);
            Map<ColocalizationAnalysis.ChannelPair, ColocalizationAnalysis.ColocResult> allColocs = ca.calculateAll(this.iAnalysisPairs, maskedRegionList, this.iLabeledRegions, this.iNormalizedImages);
            this.writeImageColoc(aOutputDir, title, outFileName, frame - 1, allColocs);
            this.writeObjectsColocCsv(aOutputDir, title, outFileName, frame - 1, allColocs);
        }
        if (this.iParameters.save_images) {
            this.saveAllImages(aOutputDir);
        }
        logger.info((Object)"Saved files:");
        for (Files.FileInfo f : this.iSavedFilesInfo) {
            logger.info((Object)("            " + f));
        }
    }

    public Set<Files.FileInfo> getSavedFiles() {
        return this.iSavedFilesInfo;
    }

    public List<ColocalizationAnalysis.ChannelPair> getChannelPairs() {
        return this.iAnalysisPairs;
    }

    private void addSavedFile(Files.FileType aFI, String aFileName) {
        this.iSavedFilesInfo.add(new Files.FileInfo(aFI, SysOps.removeRedundantSeparators(aFileName)));
    }

    private List<ColocalizationAnalysis.ChannelPair> computeValidChannelsPairsForImage(List<ColocalizationAnalysis.ChannelPair> aAnalysisPairs, int aNumOfChannels) {
        ArrayList<ColocalizationAnalysis.ChannelPair> iAnalysisPairs = new ArrayList<ColocalizationAnalysis.ChannelPair>();
        if (aAnalysisPairs != null) {
            iAnalysisPairs.addAll(aAnalysisPairs);
        } else {
            for (int c1 = 0; c1 < aNumOfChannels; ++c1) {
                for (int c2 = c1 + 1; c2 < aNumOfChannels; ++c2) {
                    iAnalysisPairs.add(new ColocalizationAnalysis.ChannelPair(c1, c2));
                    iAnalysisPairs.add(new ColocalizationAnalysis.ChannelPair(c2, c1));
                }
            }
        }
        Iterator iterator = iAnalysisPairs.iterator();
        while (iterator.hasNext()) {
            ColocalizationAnalysis.ChannelPair cp = (ColocalizationAnalysis.ChannelPair)iterator.next();
            if (cp.ch1 < aNumOfChannels && cp.ch2 < aNumOfChannels) continue;
            iterator.remove();
        }
        return iAnalysisPairs;
    }

    private void displayAndUpdateImages(String aTitle) {
        int factor = this.iOutputImgScale;
        int fz = this.nz > 1 ? factor : 1;
        for (int channel = 0; channel < this.iNumOfChannels; ++channel) {
            ImagePlus img;
            if (this.iParameters.dispoutline) {
                img = this.generateOutlineOverlay(this.iLabeledRegions[channel], this.iNormalizedImages[channel]);
                this.updateImages(channel, img, Files.createTitleWithExt(Files.FileType.Outline, aTitle, channel + 1), this.iParameters.dispoutline, this.iOutOutlines);
            }
            if (this.iParameters.dispint) {
                img = this.generateIntensitiesImg(this.iRegionsList.get(channel), this.nz * fz, this.ni * factor, this.nj * factor);
                this.updateImages(channel, img, Files.createTitleWithExt(Files.FileType.Intensity, aTitle, channel + 1), this.iParameters.dispint, this.iOutIntensities);
            }
            if (this.iParameters.displabels || this.iParameters.dispcolors) {
                this.iMaxNumberOfRegionsFound = this.iMaxNumberOfRegionsFound < this.iRegionsList.get(channel).size() ? this.iRegionsList.get(channel).size() : this.iMaxNumberOfRegionsFound;
                img = this.generateRegionImg(this.iLabeledRegions[channel], this.iMaxNumberOfRegionsFound, "");
                this.updateImages(channel, img, Files.createTitleWithExt(Files.FileType.Segmentation, aTitle, channel + 1), this.iParameters.displabels, this.iOutLabeledRegionsColor);
                if (this.iParameters.dispcolors) {
                    ImagePlus imgGray = this.generateLabelsGray(img);
                    this.updateImages(channel, imgGray, Files.createTitleWithExt(Files.FileType.Mask, aTitle, channel + 1), this.iParameters.dispcolors, this.iOutLabeledRegionsGray);
                }
            }
            if (!this.iParameters.dispSoftMask) continue;
            img = ImgUtils.ZXYarrayToImg(this.iSoftMasks[channel], "Mask" + (channel == 0 ? "X" : "Y"));
            this.updateImages(channel, img, Files.createTitleWithExt(Files.FileType.SoftMask, aTitle, channel + 1), this.iParameters.dispSoftMask, this.iOutSoftMasks);
        }
        HashSet<ColocalizationAnalysis.ChannelPair> processedChannels = new HashSet<ColocalizationAnalysis.ChannelPair>();
        for (int i = 0; i < this.iAnalysisPairs.size(); ++i) {
            ColocalizationAnalysis.ChannelPair cp = this.iAnalysisPairs.get(i);
            if (!processedChannels.add(cp)) continue;
            processedChannels.add(new ColocalizationAnalysis.ChannelPair(cp.ch2, cp.ch1));
            ImagePlus img = this.generateColocImage(cp);
            this.updateImages(i, img, Files.createTitleWithExt(Files.FileType.Colocalization, aTitle + "_ch_" + cp.ch1 + "_" + cp.ch2), true, this.iOutColoc);
        }
    }

    private void saveAllImages(String aOutputPath) {
        String savePath = aOutputPath + File.separator;
        for (int i = 0; i < this.iNumOfChannels; ++i) {
            String fileName;
            if (this.iOutOutlines[i] != null) {
                fileName = savePath + this.iOutOutlines[i].getTitle();
                IJ.save((ImagePlus)this.iOutOutlines[i], (String)fileName);
                this.addSavedFile(Files.FileType.Outline, fileName);
            }
            if (this.iOutIntensities[i] != null) {
                fileName = savePath + this.iOutIntensities[i].getTitle();
                IJ.save((ImagePlus)this.iOutIntensities[i], (String)fileName);
                this.addSavedFile(Files.FileType.Intensity, fileName);
            }
            if (this.iOutLabeledRegionsColor[i] != null) {
                fileName = savePath + this.iOutLabeledRegionsColor[i].getTitle();
                IJ.save((ImagePlus)this.iOutLabeledRegionsColor[i], (String)fileName);
                this.addSavedFile(Files.FileType.Segmentation, fileName);
            }
            if (this.iOutLabeledRegionsGray[i] != null) {
                fileName = savePath + this.iOutLabeledRegionsGray[i].getTitle();
                IJ.save((ImagePlus)this.iOutLabeledRegionsGray[i], (String)fileName);
                this.addSavedFile(Files.FileType.Mask, fileName);
            }
            if (this.iOutSoftMasks[i] == null) continue;
            fileName = savePath + this.iOutSoftMasks[i].getTitle();
            IJ.save((ImagePlus)this.iOutSoftMasks[i], (String)fileName);
            this.addSavedFile(Files.FileType.SoftMask, fileName);
        }
        for (ImagePlus ip : this.iOutColoc) {
            if (ip == null) continue;
            String fileName = savePath + ip.getTitle();
            IJ.save((ImagePlus)ip, (String)fileName);
            this.addSavedFile(Files.FileType.Colocalization, fileName);
        }
    }

    private void segmentFrame(ImagePlus aImage, int aCurrentFrame, String aTitle) {
        for (int channel = 0; channel < this.iNumOfChannels; ++channel) {
            logger.debug((Object)("------------------- Segmentation of [" + aTitle + "] channel: " + channel + ", frame: " + aCurrentFrame));
            this.iInputImages[channel] = ImgUtils.extractFrameAsImage(aImage, aCurrentFrame, channel + 1, true);
            this.iNormalizedImages[channel] = ImgUtils.ImgToZXYarray(this.iInputImages[channel]);
            ArrayOps.normalize(this.iNormalizedImages[channel]);
            double[][][] mask = this.iParameters.patches_from_file != null ? this.generateMaskFromPatches(this.iParameters.patches_from_file, this.nz, this.ni, this.nj, aCurrentFrame) : (double[][][])null;
            this.segmentChannel(channel, mask);
            logger.debug((Object)"------------------- End of Segmentation ---------------------------");
        }
    }

    private ImagePlus generateColocImage(ColocalizationAnalysis.ChannelPair aChannelPair) {
        int factor2 = this.iOutputImgScale;
        int fz2 = this.nz > 1 ? factor2 : 1;
        return this.generateColocImg(this.iRegionsList.get(aChannelPair.ch1), this.iRegionsList.get(aChannelPair.ch2), this.ni * factor2, this.nj * factor2, this.nz * fz2);
    }

    private ImagePlus generateOutlineOverlay(short[][][] regions, double[][][] aImage) {
        ImagePlus regionsOutlines = this.generateRegionOutlinesImg(regions);
        ImagePlus image = this.generateImage(aImage);
        int dz = regions.length;
        int di = regions[0].length;
        int dj = regions[0][0].length;
        ImagePlus scaledImg = this.scaleImage(image, dz, di, dj);
        return RGBStackMerge.mergeChannels((ImagePlus[])new ImagePlus[]{regionsOutlines, scaledImg}, (boolean)false);
    }

    private ImagePlus generateLabelsGray(ImagePlus aImage) {
        ImagePlus img = aImage.duplicate();
        IJ.run((ImagePlus)img, (String)"Grays", (String)"");
        img.resetDisplayRange();
        return img;
    }

    private void updateImages(int channel, ImagePlus img, String title, boolean show, ImagePlus[] imgs) {
        if (imgs[channel] != null) {
            MosaicUtils.MergeFrames(imgs[channel], img);
        } else {
            imgs[channel] = img;
            imgs[channel].setTitle(title);
        }
        if (show) {
            imgs[channel].setStack(imgs[channel].getStack());
            imgs[channel].show();
        }
    }

    private void segmentChannel(int channel, double[][][] aMask) {
        ImagePlus img = this.iInputImages[channel];
        if (this.iParameters.removebackground) {
            for (int z = 0; z < this.nz; ++z) {
                img.setSlice(z + 1);
                BackgroundSubtracter bs = new BackgroundSubtracter();
                bs.rollingBallBackground(img.getProcessor(), (double)this.iParameters.size_rollingball, false, false, false, true, true);
            }
        }
        double[][][] image = ImgUtils.ImgToZXYarray(img);
        double min = this.iParameters.removebackground ? 0.0 : this.iGlobalNormalizationMin;
        double max = this.iGlobalNormalizationMax;
        logger.info((Object)("Global min/max: " + min + "/" + max));
        if (this.iGlobalNormalizationMax == 0.0) {
            ArrayOps.MinMax<Double> mm = ImgUtils.findMinMax(img);
            min = mm.getMin();
            max = mm.getMax();
            logger.info((Object)("Global min/max from image: " + min + "/" + max));
        }
        double minIntensity = channel == 0 ? this.iParameters.min_intensity : this.iParameters.min_intensityY;
        int tempChannel = channel;
        if (channel > 1) {
            channel = 1;
        }
        SegmentationParameters sp = new SegmentationParameters(this.iParameters.nthreads, this.iParameters.subpixel ? (this.nz > 1 ? 2 : 4) : 1, this.iParameters.lreg_[channel], minIntensity, this.iParameters.exclude_z_edges, SegmentationParameters.IntensityMode.values()[this.iParameters.mode_intensity], SegmentationParameters.NoiseModel.values()[this.iParameters.noise_model], this.iParameters.sigma_gaussian, this.iParameters.sigma_gaussian / this.iParameters.zcorrec, this.iParameters.min_region_filter_intensities, this.iParameters.min_region_filter_size);
        SquasshSegmentation rg = new SquasshSegmentation(image, sp, min, max);
        if (aMask == null) {
            rg.run();
        } else {
            rg.runWithProvidedMask(aMask);
        }
        channel = tempChannel;
        this.iOutputImgScale = rg.iLabeledRegions[0].length / this.ni;
        this.iLabeledRegions[channel] = rg.iLabeledRegions;
        this.iRegionsList.set(channel, rg.iRegionsList);
        logger.debug((Object)("------------------- Found " + rg.iRegionsList.size() + " object(s) in channel " + channel));
        this.iSoftMasks[channel] = rg.iSoftMask;
        ImagePlus maskImg = this.generateMaskImg(rg.iAllMasks);
        if (maskImg != null) {
            maskImg.setTitle("Mask Evol");
            maskImg.show();
        }
    }

    private double[][][] generateMaskFromPatches(String aFileName, int nz, int ni, int nj, int aFrame) {
        CSV<Particle> csv = new CSV<Particle>(Particle.class);
        csv.setCSVPreferenceFromFile(aFileName);
        Vector<Particle> pt = csv.Read(aFileName, new CsvColumnConfig(Particle.ParticleDetection_map, Particle.ParticleDetectionCellProcessor));
        Vector<Particle> pt_f = this.getPart(pt, aFrame - 1);
        double[][][] mask = new double[nz][ni][nj];
        this.drawParticles(mask, pt_f, 3);
        return mask;
    }

    private Vector<Particle> getPart(Vector<Particle> part, int frame) {
        Vector<Particle> pp = new Vector<Particle>();
        for (Particle p : part) {
            if (p.getFrame() != frame) continue;
            pp.add(p);
        }
        return pp;
    }

    private void drawParticles(double[][][] aOutputMask, Vector<Particle> aParticles, int aRadius) {
        int[] xyzDims = new int[]{aOutputMask[0].length, aOutputMask[0][0].length, aOutputMask.length};
        BallMask cm = new BallMask(aRadius, 3);
        MaskOnSpaceMapper ballIter = new MaskOnSpaceMapper(cm, xyzDims);
        for (Particle particle : aParticles) {
            ballIter.setMiddlePoint(new Point((int)particle.iX, (int)particle.iY, (int)particle.iZ));
            while (ballIter.hasNext()) {
                Point p = ballIter.nextPoint();
                int x = p.iCoords[0];
                int y = p.iCoords[1];
                int z = p.iCoords[2];
                aOutputMask[z][x][y] = 1.0;
            }
        }
    }

    private double meanSurface(List<Region> aRegionsList) {
        double totalPerimeter = 0.0;
        for (Region r : aRegionsList) {
            totalPerimeter += r.perimeter;
        }
        return totalPerimeter / (double)aRegionsList.size();
    }

    private double meanSize(List<Region> aRegionsList) {
        double totalSize = 0.0;
        for (Region r : aRegionsList) {
            totalSize += (double)r.iPixels.size();
        }
        return totalSize / (double)aRegionsList.size() / Math.pow(this.iOutputImgScale, 2.0);
    }

    private double meanLength(List<Region> aRegionsList) {
        double totalLength = 0.0;
        for (Region r : aRegionsList) {
            totalLength += r.length;
        }
        return totalLength / (double)aRegionsList.size();
    }

    private double round(double y, int z) {
        double factor = Math.pow(10.0, z);
        y *= factor;
        y = (int)y;
        return y /= factor;
    }

    private ImagePlus generateColocImg(List<Region> aRegionsListA, List<Region> aRegionsListB, int iWidth, int iHeigth, int iDepth) {
        int[][] imagecolor = new int[iDepth][iWidth * iHeigth];
        this.setRgb(imagecolor, aRegionsListA, 1, iWidth);
        this.setRgb(imagecolor, aRegionsListB, 2, iWidth);
        ImageStack is = new ImageStack(iWidth, iHeigth);
        for (int z = 0; z < iDepth; ++z) {
            ColorProcessor colorProc = new ColorProcessor(iWidth, iHeigth, imagecolor[z]);
            is.addSlice((ImageProcessor)colorProc);
        }
        ImagePlus result = new ImagePlus("Colocalization", is);
        result.setDimensions(1, iDepth, 1);
        return result;
    }

    private void setRgb(int[][] pixels, List<Region> aRegions, int aColor, int aWidth) {
        int shift = 8 * aColor;
        for (Region r : aRegions) {
            for (Pix p : r.iPixels) {
                pixels[p.pz][p.px + p.py * aWidth] = pixels[p.pz][p.px + p.py * aWidth] | 255 << shift;
            }
        }
    }

    private ImagePlus generateMaskImg(List<float[][][]> aAllMasks) {
        if (aAllMasks.size() == 0) {
            return null;
        }
        float[][][] firstImg = aAllMasks.get(0);
        int iWidth = firstImg[0].length;
        int iHeigth = firstImg[0][0].length;
        int iDepth = firstImg.length;
        ImageStack stack = new ImageStack(iWidth, iHeigth);
        for (float[][][] img : aAllMasks) {
            for (int z = 0; z < iDepth; ++z) {
                stack.addSlice("", (ImageProcessor)new FloatProcessor(img[z]));
            }
        }
        ImagePlus img = new ImagePlus();
        img.setStack(stack);
        img.changes = false;
        img.setDimensions(1, iDepth, aAllMasks.size());
        return img;
    }

    private ImagePlus generateRegionImg(short[][][] aLabeledRegions, int aMaxRegionNumber, String aTitle) {
        int depth = aLabeledRegions.length;
        int width = aLabeledRegions[0].length;
        int height = aLabeledRegions[0][0].length;
        boolean minPixelValue = false;
        int maxPixelValue = Math.max(aMaxRegionNumber, 255);
        ImageStack is = new ImageStack(width, height);
        for (int z = 0; z < depth; ++z) {
            short[] pixels = new short[width * height];
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    pixels[j * width + i] = aLabeledRegions[z][i][j];
                }
            }
            ShortProcessor sp = new ShortProcessor(width, height, pixels, null);
            sp.setMinAndMax(0.0, (double)maxPixelValue);
            is.addSlice("", (ImageProcessor)sp);
        }
        is.setColorModel((ColorModel)this.generateColorModel(aMaxRegionNumber));
        return new ImagePlus(aTitle, is);
    }

    private IndexColorModel generateColorModel(int aNumOfColors) {
        int i;
        int numOfColors = aNumOfColors > 255 ? 255 : aNumOfColors;
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (i = 0; i < 256; ++i) {
            b[i] = -1;
            g[i] = -1;
            r[i] = -1;
        }
        b[0] = 0;
        g[0] = 0;
        r[0] = 0;
        for (i = 1; i <= numOfColors; ++i) {
            Color c = Color.getHSBColor((float)(i - 1) / (float)numOfColors, 1.0f, 1.0f);
            r[i] = (byte)c.getRed();
            g[i] = (byte)c.getGreen();
            b[i] = (byte)c.getBlue();
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    private ImagePlus generateImage(double[][][] image) {
        int nz = image.length;
        int ni = image[0].length;
        int nj = image[0][0].length;
        ImageStack is = new ImageStack(ni, nj);
        for (int z = 0; z < nz; ++z) {
            byte[] pixels = new byte[ni * nj];
            for (int i = 0; i < ni; ++i) {
                for (int j = 0; j < nj; ++j) {
                    pixels[j * ni + i] = (byte)(255.0 * image[z][i][j]);
                }
            }
            ByteProcessor bp = new ByteProcessor(ni, nj, pixels);
            is.addSlice("", (ImageProcessor)bp);
        }
        return new ImagePlus("Image", is);
    }

    private ImagePlus scaleImage(ImagePlus aInputImg, int aNewZ, int aNewX, int aNewY) {
        ImagePlus outputImg = new Resizer().zScale(aInputImg, aNewZ, 0);
        ImageStack imgS2 = new ImageStack(aNewX, aNewY);
        for (int z = 0; z < aNewZ; ++z) {
            outputImg.setSliceWithoutUpdate(z + 1);
            outputImg.getProcessor().setInterpolationMethod(0);
            imgS2.addSlice("", outputImg.getProcessor().resize(aNewX, aNewY, false));
        }
        outputImg.setStack(imgS2);
        return outputImg;
    }

    private ImagePlus generateRegionOutlinesImg(short[][][] aLabeledRegions) {
        int dz = aLabeledRegions.length;
        int di = aLabeledRegions[0].length;
        int dj = aLabeledRegions[0][0].length;
        ImageStack is = new ImageStack(di, dj);
        for (int z = 0; z < dz; ++z) {
            byte[] mask_bytes = new byte[di * dj];
            for (int i = 0; i < di; ++i) {
                for (int j = 0; j < dj; ++j) {
                    if (aLabeledRegions[z][i][j] != 0) continue;
                    mask_bytes[j * di + i] = -1;
                }
            }
            ByteProcessor bp = new ByteProcessor(di, dj, mask_bytes);
            BinaryProcessor bip = new BinaryProcessor(bp);
            bip.outline();
            bip.invert();
            is.addSlice("", (ImageProcessor)bp);
        }
        return new ImagePlus("regionsOutlines", is);
    }

    private ImagePlus generateIntensitiesImg(List<Region> aRegions, int aDepth, int aWidth, int aHeight) {
        short[][] pixels = new short[aDepth][aWidth * aHeight];
        for (Region r : aRegions) {
            for (Pix p : r.iPixels) {
                pixels[p.pz][p.px + p.py * aWidth] = (short)r.intensity;
            }
        }
        ImageStack is = new ImageStack(aWidth, aHeight);
        for (int z = 0; z < aDepth; ++z) {
            ShortProcessor sp = new ShortProcessor(aWidth, aHeight, pixels[z], null);
            is.addSlice("", (ImageProcessor)sp);
        }
        return new ImagePlus("Intensities", is);
    }

    List<ObjectsData> getObjectsData(List<Region> regions, String aFile, int frame, int channel) {
        ArrayList<ObjectsData> res = new ArrayList<ObjectsData>();
        for (Region r : regions) {
            ObjectsData id = new ObjectsData(aFile, frame, channel, r.iLabel, r.getcx(), r.getcy(), r.getcz(), (float)this.round(r.getrsize(), 3), r.getperimeter(), r.getlength(), r.getintensity());
            res.add(id);
        }
        return res;
    }

    private void writeObjectDataCsv(String aOutputPath, String aTitle, String aOutFileName, int aCurrentFrame) {
        String outFileName = aOutputPath + Files.createTitleWithExt(Files.FileType.ObjectsData, aOutFileName);
        CSV<ObjectsData> csv = new CSV<ObjectsData>(ObjectsData.class);
        csv.setDelimiter(';');
        csv.setMetaInformation("background", aOutputPath + aTitle);
        for (int ch = 0; ch < this.iNumOfChannels; ++ch) {
            boolean shouldAppend;
            boolean bl = shouldAppend = aCurrentFrame != 0 || ch != 0;
            if (!csv.Write(outFileName, this.getObjectsData(this.iRegionsList.get(ch), aTitle, aCurrentFrame, ch), ObjectsData.ColumnConfig, shouldAppend)) continue;
            this.addSavedFile(Files.FileType.ObjectsData, outFileName);
        }
    }

    List<ObjectsColoc> getObjectsColoc(String aFile, int frame, int channel, int channelColoc, Map<Integer, ColocalizationAnalysis.RegionColoc> regionsColoc) {
        ArrayList<ObjectsColoc> res = new ArrayList<ObjectsColoc>();
        for (Integer label : regionsColoc.keySet()) {
            ColocalizationAnalysis.RegionColoc regionColoc = regionsColoc.get(label);
            ObjectsColoc id = new ObjectsColoc(aFile, frame, channel, label, channelColoc, regionColoc.overlapFactor, regionColoc.colocObjectsAverageArea, regionColoc.colocObjectsAverageIntensity, regionColoc.colocObjectIntensity, regionColoc.singleRegionColoc);
            res.add(id);
        }
        return res;
    }

    private void writeObjectsColocCsv(String aOutputPath, String aTitle, String aOutFileName, int aCurrentFrame, Map<ColocalizationAnalysis.ChannelPair, ColocalizationAnalysis.ColocResult> allColocs) {
        String outFileName = aOutputPath + Files.createTitleWithExt(Files.FileType.ObjectsColoc, aOutFileName);
        CSV<ObjectsColoc> csv = new CSV<ObjectsColoc>(ObjectsColoc.class);
        csv.setDelimiter(';');
        csv.setMetaInformation("background", aOutputPath + aTitle);
        boolean shouldAppend = aCurrentFrame != 0;
        for (ColocalizationAnalysis.ChannelPair cp : this.iAnalysisPairs) {
            Map<Integer, ColocalizationAnalysis.RegionColoc> regionsColoc = allColocs.get((Object)cp).regionsColoc;
            if (!csv.Write(outFileName, this.getObjectsColoc(aTitle, aCurrentFrame, cp.ch1, cp.ch2, regionsColoc), ObjectsColoc.ColumnConfig, shouldAppend)) continue;
            this.addSavedFile(Files.FileType.ObjectsColoc, outFileName);
            shouldAppend = true;
        }
    }

    List<ImageColoc> getImageColoc(ColocalizationAnalysis.ChannelColoc aColoc, double[] aPearson, String aFile, int frame, int channel1, int channel2) {
        ArrayList<ImageColoc> res = new ArrayList<ImageColoc>();
        ImageColoc id = new ImageColoc(aFile, frame, channel1, channel2, this.round(aColoc.colocSignal, 4), this.round(aColoc.colocSize, 4), this.round(aColoc.colocNumber, 4), this.round(aColoc.coloc, 4), this.round(aPearson[0], 4), this.round(aPearson[1], 4));
        res.add(id);
        return res;
    }

    private void writeImageColoc(String aOutputPath, String aTitle, String aOutFileName, int aCurrentFrame, Map<ColocalizationAnalysis.ChannelPair, ColocalizationAnalysis.ColocResult> allColocs) {
        String outFileName = aOutputPath + Files.createTitleWithExt(Files.FileType.ImageColoc, aOutFileName);
        CSV<ImageColoc> csv = new CSV<ImageColoc>(ImageColoc.class);
        csv.setDelimiter(';');
        csv.setMetaInformation("background", aOutputPath + aTitle);
        boolean shouldAppend = aCurrentFrame != 0;
        for (ColocalizationAnalysis.ChannelPair cp : this.iAnalysisPairs) {
            ColocalizationAnalysis.ChannelColoc resAB = allColocs.get((Object)cp).channelColoc;
            double[] pearsonResult = new SamplePearsonCorrelationCoefficient(this.iInputImages[cp.ch1], this.iInputImages[cp.ch2], this.iParameters.usecellmaskX, this.iParameters.thresholdcellmask, this.iParameters.usecellmaskY, this.iParameters.thresholdcellmasky).run();
            if (!csv.Write(outFileName, this.getImageColoc(resAB, pearsonResult, aTitle, aCurrentFrame, cp.ch1, cp.ch2), ImageColoc.ColumnConfig, shouldAppend)) continue;
            shouldAppend = true;
            this.addSavedFile(Files.FileType.ImageColoc, outFileName);
        }
    }

    List<ImageData> getImagesData(List<Region> regions, String aFile, int frame, int channel) {
        ArrayList<ImageData> res = new ArrayList<ImageData>();
        ImageData id = new ImageData(aFile, frame, channel, regions.size(), this.round(this.meanSize(regions), 4), this.round(this.meanSurface(regions), 4), this.round(this.meanLength(regions), 4));
        res.add(id);
        return res;
    }

    private void writeImageDataCsv(String aOutputPath, String aTitle, String aOutFileName, int aCurrentFrame) {
        String outFileName = aOutputPath + Files.createTitleWithExt(Files.FileType.ImagesData, aOutFileName);
        CSV<ImageData> csv = new CSV<ImageData>(ImageData.class);
        csv.setDelimiter(';');
        csv.setMetaInformation("background", aOutputPath + aTitle);
        for (int ch = 0; ch < this.iNumOfChannels; ++ch) {
            boolean shouldAppend;
            boolean bl = shouldAppend = aCurrentFrame != 0 || ch != 0;
            if (!csv.Write(outFileName, this.getImagesData(this.iRegionsList.get(ch), aTitle, aCurrentFrame, ch), ImageData.ColumnConfig, shouldAppend)) continue;
            this.addSavedFile(Files.FileType.ImagesData, outFileName);
        }
    }
}

