/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.segmentation;

import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.Resizer;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import mosaic.bregman.segmentation.FindConnectedRegions;
import mosaic.bregman.segmentation.Pix;
import mosaic.bregman.segmentation.Region;
import mosaic.bregman.segmentation.RegionStatisticsSolver;
import mosaic.bregman.segmentation.SegmentationParameters;
import mosaic.bregman.segmentation.SegmentationTools;
import mosaic.bregman.solver.ASplitBregmanSolver;
import mosaic.bregman.solver.SolverParameters;
import mosaic.core.psf.psf;
import mosaic.utils.ArrayOps;
import net.imglib2.type.numeric.real.DoubleType;
import org.apache.log4j.Logger;
import weka.clusterers.SimpleKMeans;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

class AnalysePatch {
    private static final Logger logger = Logger.getLogger(AnalysePatch.class);
    private final int iSizeOrigX;
    private final int iSizeOrigY;
    private final int iSizeOrigZ;
    private int iOffsetOrigX;
    private int iOffsetOrigY;
    private int iOffsetOrigZ;
    private int iInterpolationXY;
    private int iInterpolationZ;
    private int iOversamplingXY;
    private int iOversamplingZ;
    private int iOverInterXY;
    private int iOverInterZ;
    private int iSizeOverX;
    private int iSizeOverY;
    private int iSizeOverZ;
    private int iSizeOverInterX;
    private int iSizeOverInterY;
    private int iSizeOverInterZ;
    private final Region iInputRegion;
    private final SegmentationParameters iParameters;
    private final psf<DoubleType> iPsf;
    private final SegmentationTools iLocalTools;
    private final double iRegulariztionPatch;
    private final double[][][] iRegionMask;
    private final double[][][] iPatch;
    private final double[][][] w3kpatch;
    private double[][][] result;
    private final double iMinObjectIntensity;
    private final double iIntensityMin;
    private final double iIntensityMax;
    private final double iNormalizedMinObjectIntensity;
    private double iRescaledMinIntensityAll;
    private double cin;
    private double cout_front;
    private double cout;
    private final double[] betaMleIntensities = new double[2];
    private final double[][][] temp1;
    private final double[][][] temp2;
    private final double[][][] temp3;

    AnalysePatch(double[][][] aInputImage, Region aInputRegion, SegmentationParameters aParameters, int aOversampling, double[][][] w3kbest, double aRegularization, double aMinObjectIntensity, psf<DoubleType> aPsf) {
        this.iSizeOrigX = aInputImage[0].length;
        this.iSizeOrigY = aInputImage[0][0].length;
        this.iSizeOrigZ = aInputImage.length;
        this.iInputRegion = aInputRegion;
        this.iParameters = aParameters;
        this.iPsf = aPsf;
        this.computePatchGeometry(this.iInputRegion, aOversampling, this.iParameters.interpolation);
        this.iLocalTools = new SegmentationTools(this.iSizeOverX, this.iSizeOverY, this.iSizeOverZ);
        this.iRegionMask = this.generateMask(this.iInputRegion.rvoronoi, true);
        this.iPatch = this.generateFromPatchArea(aInputImage, this.iRegionMask, this.iOversamplingXY, this.iOversamplingZ, this.iOffsetOrigX, this.iOffsetOrigY, this.iOffsetOrigZ);
        this.w3kpatch = this.generateFromPatchArea(w3kbest, this.iRegionMask, this.iOversamplingXY, this.iOversamplingZ, this.iOffsetOrigX, this.iOffsetOrigY, this.iOffsetOrigZ);
        this.result = new double[this.iSizeOverZ][this.iSizeOverX][this.iSizeOverY];
        this.iRegulariztionPatch = aRegularization * (double)this.iOversamplingXY;
        this.iMinObjectIntensity = aMinObjectIntensity;
        this.temp1 = new double[this.iSizeOverZ][this.iSizeOverX][this.iSizeOverY];
        this.temp2 = new double[this.iSizeOverZ][this.iSizeOverX][this.iSizeOverY];
        this.temp3 = new double[this.iSizeOverZ][this.iSizeOverX][this.iSizeOverY];
        double[][][] mask = this.generateMask(this.iInputRegion, false);
        ArrayOps.MinMax<Double> minMax = ArrayOps.normalize(this.iPatch);
        this.iIntensityMin = minMax.getMin();
        this.iIntensityMax = minMax.getMax();
        this.iNormalizedMinObjectIntensity = (this.iMinObjectIntensity - this.iIntensityMin) / (this.iIntensityMax - this.iIntensityMin);
        logger.debug((Object)("iNormalizedMinObjectIntensity = " + this.iNormalizedMinObjectIntensity + " iMinObjectIntensity = " + this.iMinObjectIntensity + " patchMin = " + minMax.getMin() + " patchMax = " + minMax.getMax()));
        this.iRescaledMinIntensityAll = this.iMinObjectIntensity / 0.99;
        this.cout = 0.0;
        this.cin = 1.0;
        if (this.iParameters.intensityMode == SegmentationParameters.IntensityMode.AUTOMATIC) {
            this.estimateIntensity(this.w3kpatch);
        } else if (this.iParameters.intensityMode == SegmentationParameters.IntensityMode.LOW) {
            this.estimateIntensityRSS(mask);
        } else if (this.iParameters.intensityMode == SegmentationParameters.IntensityMode.MEDIUM) {
            this.estimateIntensityClustering(this.iPatch, 4, false);
        }
        this.betaMleIntensities[0] = Math.max(this.cout, 0.0);
        this.betaMleIntensities[1] = Math.max(0.75 * this.iNormalizedMinObjectIntensity, this.cin);
        if (this.iParameters.intensityMode == SegmentationParameters.IntensityMode.HIGH) {
            ArrayOps.normalize(this.w3kpatch);
            this.betaMleIntensities[0] = this.iParameters.defaultBetaMleOut;
            this.betaMleIntensities[1] = 1.0;
        }
        this.iRescaledMinIntensityAll = Math.max(0.0, (this.iNormalizedMinObjectIntensity - this.cout) / (this.cin - this.cout));
        logger.debug((Object)("Photometry for region " + this.iInputRegion.iLabel + ": out=" + this.cout + ", outFront=" + this.cout_front + ", cin=" + this.cin + ", NormalizedMinObjectIntensity=" + this.iNormalizedMinObjectIntensity));
    }

    ArrayList<Region> calculateRegions() {
        if (Math.abs(this.betaMleIntensities[0] - this.betaMleIntensities[1]) > 2.0) {
            this.betaMleIntensities[0] = this.iParameters.defaultBetaMleOut;
            this.iParameters.getClass();
            this.betaMleIntensities[1] = 1.0;
        }
        SolverParameters solverParams = new SolverParameters(this.iParameters.numOfThreads, SolverParameters.NoiseModel.valueOf(this.iParameters.noiseModel.name()), this.betaMleIntensities[1], this.betaMleIntensities[0], this.iRegulariztionPatch);
        ASplitBregmanSolver solver = ASplitBregmanSolver.create(solverParams, this.iPatch, this.w3kpatch, this.iPsf);
        int numOfIterations = 101;
        boolean isDone = false;
        for (int iteration = 0; iteration < 101 && !isDone; ++iteration) {
            boolean lastIteration = iteration == 100;
            isDone = solver.performIteration(lastIteration);
            if (iteration % 10 == 0) {
                logger.debug((Object)("Iteration: " + iteration));
            }
            if (this.iParameters.intensityMode != SegmentationParameters.IntensityMode.AUTOMATIC || iteration != 40 && iteration != 70) continue;
            this.estimateIntensity(solver.w3k);
            solver.betaMle[0] = Math.max(0.0, this.cout);
            solver.betaMle[1] = Math.max(0.75 * this.iNormalizedMinObjectIntensity, this.cin);
            solver.init();
            this.iParameters.getClass();
        }
        solver.postprocess();
        this.cin = solver.getBetaMleIn();
        double threshold = 0.0;
        if (this.iParameters.intensityMode == SegmentationParameters.IntensityMode.HIGH) {
            this.estimateIntensityClustering(solver.w3kbest, 3, true);
            threshold = this.cin - 0.04;
        } else {
            double minThreshold = this.iParameters.intensityMode == SegmentationParameters.IntensityMode.MEDIUM ? 0.25 : this.iRescaledMinIntensityAll * 0.96;
            threshold = this.findBestThreshold(solver.w3kbest, minThreshold);
        }
        logger.debug((Object)("Best found threshold: " + threshold + " in region: " + this.iInputRegion.iLabel));
        if (this.iInterpolationXY == 1) {
            this.generateThresholdedObject(solver.w3kbest, threshold);
        } else {
            this.result = this.createInterpolatedObject(solver.w3kbest, threshold);
        }
        return this.generateRegions();
    }

    private void estimateIntensity(double[][][] w3kbest) {
        double bestEnergy = Double.MAX_VALUE;
        double cinbest = this.cin;
        double coutbest = this.cout;
        for (double thr = 0.95; thr > this.iRescaledMinIntensityAll * 0.96; thr -= 0.02) {
            if (!this.generateThresholdedObject(w3kbest, thr)) continue;
            this.estimateIntensityRSS(this.result);
            this.iParameters.getClass();
            double tempEnergy = this.iLocalTools.computeEnergyPSF_weighted(this.temp1, this.result, this.temp2, this.temp3, this.iRegionMask, 1.0, this.iRegulariztionPatch, this.iPsf, this.cout, this.cin, this.iPatch, this.iParameters.noiseModel);
            if (!(tempEnergy < bestEnergy)) continue;
            bestEnergy = tempEnergy;
            cinbest = this.cin;
            coutbest = this.cout;
        }
        this.cin = cinbest;
        this.cout_front = this.cout = coutbest;
        this.iRescaledMinIntensityAll = Math.max(0.0, (this.iNormalizedMinObjectIntensity - this.cout) / (this.cin - this.cout));
        this.iParameters.getClass();
    }

    private double findBestThreshold(double[][][] w3kbest, double aMinThreshold) {
        double bestEenergy = Double.MAX_VALUE;
        double bestThreshold = 0.75;
        for (double currentThr = 1.0; currentThr > aMinThreshold; currentThr -= 0.02) {
            if (!this.generateThresholdedObject(w3kbest, currentThr)) continue;
            this.iParameters.getClass();
            double tempEnergy = this.iLocalTools.computeEnergyPSF_weighted(this.temp1, this.result, this.temp2, this.temp3, this.iRegionMask, 1.0, this.iRegulariztionPatch, this.iPsf, this.cout_front, this.cin, this.iPatch, this.iParameters.noiseModel);
            if (!(tempEnergy < bestEenergy)) continue;
            bestEenergy = tempEnergy;
            bestThreshold = currentThr;
        }
        return bestThreshold;
    }

    private boolean generateThresholdedObject(double[][][] w3kbest, double aThreshold) {
        boolean objectFound = false;
        boolean borderAttained = false;
        for (int z = 0; z < this.iSizeOverZ; ++z) {
            for (int i = 0; i < this.iSizeOverX; ++i) {
                for (int j = 0; j < this.iSizeOverY; ++j) {
                    if (w3kbest[z][i][j] > aThreshold && this.iRegionMask[z][i][j] == 1.0) {
                        this.result[z][i][j] = 1.0;
                        objectFound = true;
                        if (this.iSizeOverZ > 1 || !(i == 0 && this.iOffsetOrigX != 0 || i == this.iSizeOverX - 1 && this.iOffsetOrigX + this.iSizeOverX / this.iOversamplingXY != this.iSizeOrigX || j == 0 && this.iOffsetOrigY != 0) && (j != this.iSizeOverY - 1 || this.iOffsetOrigY + this.iSizeOverY / this.iOversamplingXY == this.iSizeOrigY)) continue;
                        borderAttained = true;
                        continue;
                    }
                    this.result[z][i][j] = 0.0;
                }
            }
        }
        return objectFound && !borderAttained;
    }

    private void computePatchGeometry(Region aInputRegion, int aOversampling, int aInterpolation) {
        Pix[] mm = aInputRegion.getMinMaxCoordinates();
        Pix min = mm[0];
        Pix max = mm[1];
        int xmin = min.px;
        int ymin = min.py;
        int zmin = min.pz;
        int xmax = max.px;
        int ymax = max.py;
        int zmax = max.pz;
        int aMarginXY = 6;
        int aMarginZ = 1;
        int[] sz_psf = this.iPsf.getSuggestedImageSize();
        if (sz_psf[0] > aMarginXY) {
            aMarginXY = sz_psf[0];
        }
        if (sz_psf[1] > aMarginXY) {
            aMarginXY = sz_psf[1];
        }
        if (sz_psf.length > 2 && sz_psf[2] > aMarginZ) {
            aMarginZ = sz_psf[2];
        }
        xmin = Math.max(0, xmin - aMarginXY);
        xmax = Math.min(this.iSizeOrigX, xmax + aMarginXY + 1);
        ymin = Math.max(0, ymin - aMarginXY);
        ymax = Math.min(this.iSizeOrigY, ymax + aMarginXY + 1);
        zmin = Math.max(0, zmin - aMarginZ);
        zmax = Math.min(this.iSizeOrigZ, zmax + aMarginZ + 1);
        this.iOffsetOrigX = xmin;
        this.iOffsetOrigY = ymin;
        this.iOffsetOrigZ = zmin;
        this.iOversamplingXY = aOversampling;
        this.iInterpolationXY = aInterpolation;
        if (this.iSizeOrigZ == 1) {
            this.iOversamplingZ = 1;
            this.iInterpolationZ = 1;
        } else {
            this.iOversamplingZ = aOversampling;
            this.iInterpolationZ = aInterpolation;
        }
        this.iOverInterXY = this.iOversamplingXY * this.iInterpolationXY;
        this.iOverInterZ = this.iOversamplingZ * this.iInterpolationZ;
        this.iSizeOverX = (xmax - xmin) * this.iOversamplingXY;
        this.iSizeOverY = (ymax - ymin) * this.iOversamplingXY;
        this.iSizeOverZ = (zmax - zmin) * this.iOversamplingZ;
        this.iSizeOverInterX = this.iSizeOverX * this.iInterpolationXY;
        this.iSizeOverInterY = this.iSizeOverY * this.iInterpolationXY;
        this.iSizeOverInterZ = this.iSizeOverZ * this.iInterpolationZ;
    }

    private double[][][] generateFromPatchArea(double[][][] aSourceImage, double[][][] aWeights, int aOversamplingXY, int aOversamplingZ, int aOffsetX, int aOffsetY, int aOffsetZ) {
        double[][][] result = new double[this.iSizeOverZ][this.iSizeOverX][this.iSizeOverY];
        for (int z = 0; z < this.iSizeOverZ; ++z) {
            for (int i = 0; i < this.iSizeOverX; ++i) {
                for (int j = 0; j < this.iSizeOverY; ++j) {
                    result[z][i][j] = aWeights[z][i][j] * aSourceImage[z / aOversamplingZ + aOffsetZ][i / aOversamplingXY + aOffsetX][j / aOversamplingXY + aOffsetY];
                }
            }
        }
        return result;
    }

    private double[][][] generateMask(Region aRegion, boolean aCheckBoundaries) {
        double[][][] mask = new double[this.iSizeOverZ][this.iSizeOverX][this.iSizeOverY];
        for (Pix p : aRegion.iPixels) {
            int rz = this.iOversamplingXY * (p.pz - this.iOffsetOrigZ);
            int rx = this.iOversamplingXY * (p.px - this.iOffsetOrigX);
            int ry = this.iOversamplingXY * (p.py - this.iOffsetOrigY);
            if (aCheckBoundaries && (rz < 0 || rz + this.iOversamplingZ > this.iSizeOverZ || rx < 0 || rx + this.iOversamplingXY > this.iSizeOverX || ry < 0 || ry + this.iOversamplingXY > this.iSizeOverY)) continue;
            for (int z = rz; z < rz + this.iOversamplingZ; ++z) {
                for (int i = rx; i < rx + this.iOversamplingXY; ++i) {
                    for (int j = ry; j < ry + this.iOversamplingXY; ++j) {
                        mask[z][i][j] = 1.0;
                    }
                }
            }
        }
        return mask;
    }

    private ArrayList<Region> generateRegions() {
        ImageStack is = new ImageStack(this.iSizeOverInterX, this.iSizeOverInterY);
        for (int z = 0; z < this.iSizeOverInterZ; ++z) {
            byte[] pixels = new byte[this.iSizeOverInterX * this.iSizeOverInterY];
            for (int i = 0; i < this.iSizeOverInterX; ++i) {
                for (int j = 0; j < this.iSizeOverInterY; ++j) {
                    pixels[j * this.iSizeOverInterX + i] = this.result[z][i][j] >= 1.0 ? (byte)this.result[z][i][j] : (byte)0;
                }
            }
            ByteProcessor bp = new ByteProcessor(this.iSizeOverInterX, this.iSizeOverInterY, pixels);
            is.addSlice("", (ImageProcessor)bp);
        }
        ImagePlus img = new ImagePlus("8-bit result", is);
        FindConnectedRegions fcr = new FindConnectedRegions(img);
        fcr.run(this.iSizeOverInterX * this.iSizeOverInterY * this.iSizeOverInterZ, 0 * this.iOverInterXY, 0.5f, this.iParameters.excludeEdgesZ, this.iOversamplingXY, this.iInterpolationXY);
        ArrayList<Region> foundRegions = fcr.getFoundRegions();
        for (Region r : foundRegions) {
            for (Pix p : r.iPixels) {
                p.pz += this.iOffsetOrigZ * this.iOverInterZ;
                p.px += this.iOffsetOrigX * this.iOverInterXY;
                p.py += this.iOffsetOrigY * this.iOverInterXY;
            }
        }
        return foundRegions;
    }

    private double[][][] createInterpolatedObject(double[][][] aInputData, double aThreshold) {
        ImageStack imgStack = new ImageStack(this.iSizeOverX, this.iSizeOverY);
        for (int z = 0; z < this.iSizeOverZ; ++z) {
            float[] pixels = new float[this.iSizeOverX * this.iSizeOverY];
            for (int i = 0; i < this.iSizeOverX; ++i) {
                for (int j = 0; j < this.iSizeOverY; ++j) {
                    pixels[j * this.iSizeOverX + i] = (float)aInputData[z][i][j];
                }
            }
            FloatProcessor fp = new FloatProcessor(this.iSizeOverX, this.iSizeOverY, pixels);
            imgStack.addSlice("", (ImageProcessor)fp);
        }
        ImagePlus interpolatedImg = new ImagePlus("Object x", imgStack);
        if (this.iSizeOverInterZ != this.iSizeOverZ) {
            interpolatedImg = new Resizer().zScale(interpolatedImg, this.iSizeOverInterZ, 1);
        }
        ImageStack imgStackInter = new ImageStack(this.iSizeOverInterX, this.iSizeOverInterY);
        for (int z = 0; z < this.iSizeOverInterZ; ++z) {
            interpolatedImg.setSliceWithoutUpdate(z + 1);
            interpolatedImg.getProcessor().setInterpolationMethod(1);
            imgStackInter.addSlice("", interpolatedImg.getProcessor().resize(this.iSizeOverInterX, this.iSizeOverInterY, true));
        }
        interpolatedImg.setStack(imgStackInter);
        double[][][] interpolatedResult = new double[this.iSizeOverInterZ][this.iSizeOverInterX][this.iSizeOverInterY];
        for (int z = 0; z < this.iSizeOverInterZ; ++z) {
            interpolatedImg.setSlice(z + 1);
            ImageProcessor imp = interpolatedImg.getProcessor();
            for (int i = 0; i < this.iSizeOverInterX; ++i) {
                for (int j = 0; j < this.iSizeOverInterY; ++j) {
                    interpolatedResult[z][i][j] = (double)imp.getPixelValue(i, j) > aThreshold && this.iRegionMask[z / this.iInterpolationZ][i / this.iInterpolationXY][j / this.iInterpolationXY] == 1.0 ? 1.0 : 0.0;
                }
            }
        }
        return interpolatedResult;
    }

    private void estimateIntensityRSS(double[][][] mask) {
        SegmentationTools.normalizeAndConvolveMask(this.temp3, mask, this.iPsf, this.temp1, this.temp2);
        double d = this.iParameters.defaultBetaMleOut;
        this.iParameters.getClass();
        RegionStatisticsSolver RSS = new RegionStatisticsSolver(this.temp1, this.temp2, this.iPatch, this.iRegionMask, 10, d, 1.0);
        RSS.eval(this.temp3);
        this.cout_front = this.cout = RSS.betaMLEout;
        this.cin = RSS.betaMLEin;
    }

    void estimateIntensityClustering(double[][][] aValues, int aNumOfClasters, boolean aUpdateCout) {
        SimpleKMeans kmeans = new SimpleKMeans();
        ArrayList<Attribute> attr = new ArrayList<Attribute>();
        attr.add(new Attribute("pixelValue"));
        Instances inst = new Instances("DataPoints", attr, 0);
        HashSet<Double> distinctPixelValues = new HashSet<Double>();
        for (int z = 0; z < this.iSizeOverZ; ++z) {
            for (int i = 0; i < this.iSizeOverX; ++i) {
                for (int j = 0; j < this.iSizeOverY; ++j) {
                    if (this.iRegionMask[z][i][j] != 1.0) continue;
                    double value = aValues[z][i][j];
                    distinctPixelValues.add(value);
                    DenseInstance iw = new DenseInstance(1.0, new double[]{value});
                    iw.setDataset(inst);
                    inst.add((Instance)iw);
                }
            }
        }
        logger.debug((Object)("Data size = " + inst.size() + ", number of distinct values in data set = " + distinctPixelValues.size()));
        if (inst.size() >= aNumOfClasters && distinctPixelValues.size() >= aNumOfClasters) {
            logger.debug((Object)"Running KMeans");
            try {
                kmeans.setNumClusters(aNumOfClasters);
                kmeans.setMaxIterations(100);
                kmeans.buildClusterer(inst);
                Instances centroids = kmeans.getClusterCentroids();
                int numOfClustersFound = kmeans.numberOfClusters();
                double[] levels = new double[numOfClustersFound];
                for (int i = 0; i < numOfClustersFound; ++i) {
                    levels[i] = centroids.instance(i).value(0);
                }
                Arrays.sort(levels);
                int inIndex = Math.min(2, numOfClustersFound - 1);
                this.cin = Math.max(this.iNormalizedMinObjectIntensity, levels[inIndex]);
                int outFrontIndex = Math.max(inIndex - 1, 0);
                this.cout_front = levels[outFrontIndex];
                this.cout = aUpdateCout ? this.cout_front : levels[0];
                logger.debug((Object)("Region: " + this.iInputRegion.iLabel + ", Cluster levels: " + Arrays.toString(levels)));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Something went wrong with clustering...");
            }
        } else {
            logger.debug((Object)"Data set too small or with not enough number of distinct values. Setting default values.");
            this.cin = 1.0;
            this.cout_front = this.iParameters.defaultBetaMleOut;
            this.cout = this.iParameters.defaultBetaMleOut;
        }
    }
}

