/*
 * Decompiled with CFR 0.152.
 */
package mosaic.bregman.segmentation;

import mosaic.utils.Debug;

public class SegmentationParameters {
    final boolean debug = false;
    final double lambdaData = 1.0;
    final double defaultBetaMleIn = 1.0;
    final double defaultBetaMleOut = 3.0E-4;
    final int numOfThreads;
    final int interpolation;
    final double lambdaRegularization;
    final double minObjectIntensity;
    final boolean excludeEdgesZ;
    final IntensityMode intensityMode;
    final NoiseModel noiseModel;
    final double sigmaGaussianXY;
    final double sigmaGaussianZ;
    final double minRegionIntensity;
    final int minRegionSize;

    public SegmentationParameters(int aNumOfThreads, int aInterpolation, double aRegularization, double aMinObjectIntensity, boolean aExcludeZedges, IntensityMode aIntensityMode, NoiseModel aNoiseModel, double aSigmaGaussianXY, double aSigmaGaussianZ, double aMinRegionIntensity, int aMinRegionSize) {
        this.numOfThreads = aNumOfThreads;
        this.interpolation = aInterpolation;
        this.lambdaRegularization = aRegularization;
        this.minObjectIntensity = aMinObjectIntensity;
        this.excludeEdgesZ = aExcludeZedges;
        this.intensityMode = aIntensityMode;
        this.noiseModel = aNoiseModel;
        this.sigmaGaussianXY = aSigmaGaussianXY;
        this.sigmaGaussianZ = aSigmaGaussianZ;
        this.minRegionIntensity = aMinRegionIntensity;
        this.minRegionSize = aMinRegionSize;
    }

    public String toString() {
        return Debug.getJsonString(this);
    }

    public static enum IntensityMode {
        AUTOMATIC,
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum NoiseModel {
        POISSON,
        GAUSS;

    }
}

