/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.cluster;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import mosaic.core.cluster.ShellProcessOutput;
import mosaic.core.utils.ShellCommand;

public class DataCompression {
    private int selC = -1;
    private final Vector<Algorithm> al = new Vector();

    public DataCompression() {
        this.al.add(new Algorithm("SZIP", "7za --help", "7-Zip", "7za a -t7z # *", "yes | 7za e *"));
        this.al.add(new Algorithm("TAR", "tar --version", "tar (GNU tar)", "tar -j -cvf # * ", "tar -xvf * "));
        this.al.add(new Algorithm("ZIP", "zip --version", "This is Zip", "zip # * ; mv #.zip #", "unzip  *"));
    }

    public void selectCompressor() {
        for (int i = 0; i < this.al.size(); ++i) {
            String out = null;
            try {
                out = ShellCommand.exeCmdString(this.al.get((int)i).cmd);
            }
            catch (IOException e) {
                e.printStackTrace();
                out = new String();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                out = new String();
            }
            if (out == null || !out.contains(this.al.get((int)i).finger_print)) continue;
            this.selC = i;
            return;
        }
    }

    public boolean nextCompressor() {
        if (this.selC >= this.al.size()) {
            return false;
        }
        ++this.selC;
        return true;
    }

    public Algorithm getCompressor() {
        if (this.selC == -1 || this.selC >= this.al.size()) {
            return null;
        }
        return this.al.get(this.selC);
    }

    public boolean Compress(File start_dir, File[] fs, File file_a, ShellProcessOutput out) {
        if (this.selC == -1) {
            return false;
        }
        String o = new String();
        for (int i = 0; i < fs.length; ++i) {
            o = o + fs[i].getPath() + " ";
        }
        try {
            ShellCommand.exeCmd(this.al.get((int)this.selC).compress_command.replace("#", file_a.getAbsolutePath()).replace("*", o) + " ; echo \"COMPRESSION END\"; \n", start_dir, null, out);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean unCompress(File file_a, File work_dir) {
        try {
            ShellCommand.exeCmd(this.al.get((int)this.selC).uncompress_command.replace("*", file_a.getAbsolutePath()), work_dir, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String unCompressCommand(File file_a) {
        if (this.selC == -1) {
            return null;
        }
        return this.al.get((int)this.selC).uncompress_command.replace("*", file_a.getAbsolutePath());
    }

    public String compressCommand(File[] fs, File file_a) {
        if (this.selC == -1) {
            return null;
        }
        String o = new String();
        for (int i = 0; i < fs.length; ++i) {
            o = o + fs[i].getPath() + " ";
        }
        return this.al.get((int)this.selC).compress_command.replace("#", file_a.getAbsolutePath()).replace("*", o);
    }

    public Vector<Algorithm> getCompressorList() {
        return this.al;
    }

    public class Algorithm {
        public final String name;
        protected final String cmd;
        protected final String finger_print;
        protected final String compress_command;
        protected final String uncompress_command;

        protected Algorithm(String name_, String cmd_, String finger_print_, String cc, String uc) {
            this.name = name_;
            this.cmd = cmd_;
            this.finger_print = finger_print_;
            this.compress_command = cc;
            this.uncompress_command = uc;
        }
    }
}

