/*
 * Decompiled with CFR 0.152.
 */
package mosaic.core.cluster;

import ij.IJ;
import java.io.File;
import java.util.Vector;
import mosaic.core.cluster.ClusterProfile;
import mosaic.core.cluster.DataCompression;
import mosaic.core.cluster.GeneralProfile;
import mosaic.core.cluster.LSFBatch;
import mosaic.core.cluster.QueueProfile;
import mosaic.utils.io.csv.CSV;
import mosaic.utils.io.csv.CsvColumnConfig;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ift.CellProcessor;

public class FileClusterProfile
extends GeneralProfile {
    private final CSV<QueueProfile> csv = new CSV<QueueProfile>(QueueProfile.class);
    private final CsvColumnConfig occ = new CsvColumnConfig(new String[]{"queue", "hardware", "limit"}, new CellProcessor[]{null, null, new ParseDouble()});

    public FileClusterProfile(File filename) {
        this.occ.fieldMapping = new String[]{"queue", "hardware", "limit"};
        this.occ.cellProcessors = new CellProcessor[]{null, null, new ParseDouble()};
        if (filename != null) {
            Vector<QueueProfile> cp = this.csv.Read(filename.getAbsolutePath(), this.occ);
            for (int i = 0; i < cp.size(); ++i) {
                if (cp.get((int)i).hardware.equals("CPU")) {
                    this.setAcc(ClusterProfile.hw.CPU);
                } else if (cp.get((int)i).hardware.equals("GPU")) {
                    this.setAcc(ClusterProfile.hw.GPU);
                }
                this.setQueue(cp.get((int)i).limit, cp.get((int)i).queue);
            }
            String batch = this.csv.getMetaInformation("batch");
            if (batch != null && batch.equals("LSF")) {
                this.setBatchSystem(new LSFBatch(this));
            } else {
                IJ.error((String)"Error", (String)(batch + " batch system is not supported"));
            }
        }
        this.setAcc(ClusterProfile.hw.CPU);
    }

    @Override
    public String getProfileName() {
        return this.csv.getMetaInformation("profile");
    }

    @Override
    public void setProfileName(String ProfileName_) {
        this.csv.setMetaInformation("profile", ProfileName_);
    }

    @Override
    public String getAccessAddress() {
        return this.csv.getMetaInformation("address");
    }

    @Override
    public void setAccessAddress(String addr) {
        this.csv.setMetaInformation("address", addr);
    }

    public String getRunningDirRaw() {
        return this.csv.getMetaInformation("run_dir");
    }

    @Override
    public String getRunningDir() {
        String meta = this.csv.getMetaInformation("run_dir");
        if (meta.replace("*", this.getUsername()) == null) {
            return this.csv.getMetaInformation("run_dir") + File.separator;
        }
        return meta.replace("*", this.getUsername()) + File.separator;
    }

    @Override
    public void setRunningDir(String RunningDir_) {
        this.csv.setMetaInformation("run_dir", RunningDir_);
    }

    @Override
    public String getImageJCommand() {
        return "fiji";
    }

    @Override
    public void setImageJCommand(String ImageJCommand_) {
    }

    @Override
    public boolean hasCompressor(DataCompression.Algorithm a) {
        if (a == null) {
            return true;
        }
        String cp_name = a.name;
        String has_cp = this.csv.getMetaInformation(cp_name);
        if (has_cp == null) {
            return false;
        }
        return has_cp.equals("true");
    }

    public void writeConfigFile(File CsvFilename) {
        Vector<QueueProfile> vq = new Vector<QueueProfile>();
        for (ClusterProfile.hw Acc : ClusterProfile.hw.values()) {
            QueueProfile[] q = this.getQueues(Acc);
            for (int i = 0; i < q.length; ++i) {
                vq.add(q[i]);
            }
        }
        this.csv.Write(CsvFilename.getAbsolutePath(), vq, this.occ, false);
    }

    public void setBatchSystemString(String bc) {
        this.csv.setMetaInformation("batch", bc);
    }

    public void setCompressorString(String bc) {
        this.csv.setMetaInformation(bc, "true");
    }

    public void removeCompressorString(String cp) {
        this.csv.removeMetaInformation(cp);
    }

    public boolean isActiveCompressorString(String cp) {
        String s = this.csv.getMetaInformation(cp);
        if (s == null) {
            return false;
        }
        return s.equals("true");
    }
}

